/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix;

import com.spatial4j.core.exception.UnsupportedSpatialOperation;
import com.spatial4j.core.query.SpatialArgs;
import com.spatial4j.core.query.SpatialOperation;
import com.spatial4j.core.shape.Shape;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.spatial.SimpleSpatialFieldInfo;
import org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.Node;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;

public class TermQueryPrefixTreeStrategy
extends PrefixTreeStrategy {
    public TermQueryPrefixTreeStrategy(SpatialPrefixTree grid) {
        super(grid);
    }

    @Override
    public Filter makeFilter(SpatialArgs args, SimpleSpatialFieldInfo fieldInfo) {
        return new QueryWrapperFilter(this.makeQuery(args, fieldInfo));
    }

    @Override
    public Query makeQuery(SpatialArgs args, SimpleSpatialFieldInfo fieldInfo) {
        if (args.getOperation() != SpatialOperation.Intersects && args.getOperation() != SpatialOperation.IsWithin && args.getOperation() != SpatialOperation.Overlaps) {
            throw new UnsupportedSpatialOperation(args.getOperation());
        }
        Shape qshape = args.getShape();
        int detailLevel = this.grid.getMaxLevelForPrecision(qshape, args.getDistPrecision());
        List<Node> cells = this.grid.getNodes(qshape, detailLevel, false);
        BooleanQuery booleanQuery = new BooleanQuery();
        for (Node cell : cells) {
            booleanQuery.add((Query)new TermQuery(new Term(fieldInfo.getFieldName(), cell.getTokenString())), BooleanClause.Occur.SHOULD);
        }
        return booleanQuery;
    }
}

