/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix;

import com.spatial4j.core.exception.UnsupportedSpatialOperation;
import com.spatial4j.core.query.SpatialArgs;
import com.spatial4j.core.query.SpatialOperation;
import com.spatial4j.core.shape.Shape;
import org.apache.lucene.queries.function.FunctionQuery;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.SimpleSpatialFieldInfo;
import org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeFilter;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;

public class RecursivePrefixTreeStrategy
extends PrefixTreeStrategy {
    private int prefixGridScanLevel;

    public RecursivePrefixTreeStrategy(SpatialPrefixTree grid) {
        super(grid);
        this.prefixGridScanLevel = grid.getMaxLevels() - 4;
    }

    public void setPrefixGridScanLevel(int prefixGridScanLevel) {
        this.prefixGridScanLevel = prefixGridScanLevel;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(prefixGridScanLevel:" + this.prefixGridScanLevel + ",SPG:(" + this.grid + "))";
    }

    @Override
    public Query makeQuery(SpatialArgs args, SimpleSpatialFieldInfo fieldInfo) {
        Filter f = this.makeFilter(args, fieldInfo);
        ValueSource vs = this.makeValueSource(args, fieldInfo);
        return new FilteredQuery((Query)new FunctionQuery(vs), f);
    }

    @Override
    public Filter makeFilter(SpatialArgs args, SimpleSpatialFieldInfo fieldInfo) {
        SpatialOperation op = args.getOperation();
        if (!SpatialOperation.is((SpatialOperation)op, (SpatialOperation[])new SpatialOperation[]{SpatialOperation.IsWithin, SpatialOperation.Intersects, SpatialOperation.BBoxWithin})) {
            throw new UnsupportedSpatialOperation(op);
        }
        Shape qshape = args.getShape();
        int detailLevel = this.grid.getMaxLevelForPrecision(qshape, args.getDistPrecision());
        return new RecursivePrefixTreeFilter(fieldInfo.getFieldName(), this.grid, qshape, this.prefixGridScanLevel, detailLevel);
    }
}

