/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

class PrefixCellsTokenizer
extends Tokenizer {
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);

    public PrefixCellsTokenizer(Reader input) {
        super(input);
    }

    public final boolean incrementToken() throws IOException {
        char c;
        this.clearAttributes();
        int length = 0;
        char[] buffer = this.termAtt.buffer();
        while ((c = (char)this.input.read()) >= '\u0000') {
            if (c == 'a' || c == 'A') {
                buffer[length++] = 65;
                continue;
            }
            if (c == 'b' || c == 'B') {
                buffer[length++] = 66;
                continue;
            }
            if (c == 'c' || c == 'C') {
                buffer[length++] = 67;
                continue;
            }
            if (c == 'd' || c == 'D') {
                buffer[length++] = 68;
                continue;
            }
            if (c == '*') {
                buffer[length++] = 42;
                continue;
            }
            if (c == '+') {
                buffer[length++] = 43;
                continue;
            }
            if (length <= 0) continue;
            break;
        }
        this.termAtt.setLength(length);
        return length > 0;
    }

    public final void end() {
    }

    public void reset(Reader input) throws IOException {
        super.reset(input);
    }
}

