/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.bkdtree;

import org.apache.lucene.bkdtree.HeapLatLonReader;
import org.apache.lucene.bkdtree.LatLonReader;
import org.apache.lucene.bkdtree.LatLonWriter;

final class HeapLatLonWriter
implements LatLonWriter {
    final int[] latEncs;
    final int[] lonEncs;
    final int[] docIDs;
    final long[] ords;
    private int nextWrite;
    private boolean closed;

    public HeapLatLonWriter(int count) {
        this.latEncs = new int[count];
        this.lonEncs = new int[count];
        this.docIDs = new int[count];
        this.ords = new long[count];
    }

    @Override
    public void append(int latEnc, int lonEnc, long ord, int docID) {
        this.latEncs[this.nextWrite] = latEnc;
        this.lonEncs[this.nextWrite] = lonEnc;
        this.ords[this.nextWrite] = ord;
        this.docIDs[this.nextWrite] = docID;
        ++this.nextWrite;
    }

    @Override
    public LatLonReader getReader(long start) {
        assert (this.closed);
        return new HeapLatLonReader(this.latEncs, this.lonEncs, this.ords, this.docIDs, (int)start, this.latEncs.length);
    }

    @Override
    public void close() {
        this.closed = true;
        if (this.nextWrite != this.latEncs.length) {
            throw new IllegalStateException("only wrote " + this.nextWrite + " values, but expected " + this.latEncs.length);
        }
    }

    @Override
    public void destroy() {
    }

    public String toString() {
        return "HeapLatLonWriter(count=" + this.latEncs.length + ")";
    }
}

