/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index.memory;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FieldsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Norm;
import org.apache.lucene.index.OrdTermState;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.index.memory.MemoryIndexNormDocValues;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;

public class MemoryIndex {
    private final HashMap<String, Info> fields = new HashMap();
    private transient Map.Entry<String, Info>[] sortedFields;
    private final int stride;
    private static final float docBoost = 1.0f;
    private static final boolean DEBUG = false;
    private HashMap<String, FieldInfo> fieldInfos = new HashMap();
    private static final Comparator<Object> termComparator = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Map.Entry) {
                o1 = ((Map.Entry)o1).getKey();
            }
            if (o2 instanceof Map.Entry) {
                o2 = ((Map.Entry)o2).getKey();
            }
            if (o1 == o2) {
                return 0;
            }
            return ((Comparable)o1).compareTo((Comparable)o2);
        }
    };

    public MemoryIndex() {
        this(false);
    }

    protected MemoryIndex(boolean storeOffsets) {
        this.stride = storeOffsets ? 3 : 1;
    }

    public void addField(String fieldName, String text, Analyzer analyzer) {
        TokenStream stream;
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("text must not be null");
        }
        if (analyzer == null) {
            throw new IllegalArgumentException("analyzer must not be null");
        }
        try {
            stream = analyzer.tokenStream(fieldName, (Reader)new StringReader(text));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.addField(fieldName, stream);
    }

    public <T> TokenStream keywordTokenStream(final Collection<T> keywords) {
        if (keywords == null) {
            throw new IllegalArgumentException("keywords must not be null");
        }
        return new TokenStream(){
            private Iterator<T> iter;
            private int start;
            private final CharTermAttribute termAtt;
            private final OffsetAttribute offsetAtt;
            {
                this.iter = keywords.iterator();
                this.start = 0;
                this.termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
                this.offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
            }

            public boolean incrementToken() {
                if (!this.iter.hasNext()) {
                    return false;
                }
                Object obj = this.iter.next();
                if (obj == null) {
                    throw new IllegalArgumentException("keyword must not be null");
                }
                String term = obj.toString();
                this.clearAttributes();
                this.termAtt.setEmpty().append(term);
                this.offsetAtt.setOffset(this.start, this.start + this.termAtt.length());
                this.start += term.length() + 1;
                return true;
            }
        };
    }

    public void addField(String fieldName, TokenStream stream) {
        this.addField(fieldName, stream, 1.0f);
    }

    public void addField(String fieldName, TokenStream stream, float boost) {
        try {
            if (fieldName == null) {
                throw new IllegalArgumentException("fieldName must not be null");
            }
            if (stream == null) {
                throw new IllegalArgumentException("token stream must not be null");
            }
            if (boost <= 0.0f) {
                throw new IllegalArgumentException("boost factor must be greater than 0.0");
            }
            if (this.fields.get(fieldName) != null) {
                throw new IllegalArgumentException("field must not be added more than once");
            }
            HashMap<BytesRef, ArrayIntList> terms = new HashMap<BytesRef, ArrayIntList>();
            int numTokens = 0;
            int numOverlapTokens = 0;
            int pos = -1;
            if (!this.fieldInfos.containsKey(fieldName)) {
                this.fieldInfos.put(fieldName, new FieldInfo(fieldName, true, this.fieldInfos.size(), false, false, false, FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS, null, null, null));
            }
            TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)stream.getAttribute(TermToBytesRefAttribute.class);
            PositionIncrementAttribute posIncrAttribute = (PositionIncrementAttribute)stream.addAttribute(PositionIncrementAttribute.class);
            OffsetAttribute offsetAtt = (OffsetAttribute)stream.addAttribute(OffsetAttribute.class);
            BytesRef ref = termAtt.getBytesRef();
            stream.reset();
            while (stream.incrementToken()) {
                termAtt.fillBytesRef();
                if (ref.length == 0) continue;
                ++numTokens;
                int posIncr = posIncrAttribute.getPositionIncrement();
                if (posIncr == 0) {
                    ++numOverlapTokens;
                }
                pos += posIncr;
                ArrayIntList positions = terms.get(ref);
                if (positions == null) {
                    positions = new ArrayIntList(this.stride);
                    terms.put(BytesRef.deepCopyOf((BytesRef)ref), positions);
                }
                if (this.stride == 1) {
                    positions.add(pos);
                    continue;
                }
                positions.add(pos, offsetAtt.startOffset(), offsetAtt.endOffset());
            }
            stream.end();
            if (numTokens > 0) {
                this.fields.put(fieldName, new Info(terms, numTokens, numOverlapTokens, boost *= 1.0f));
                this.sortedFields = null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    public IndexSearcher createSearcher() {
        MemoryIndexReader reader = new MemoryIndexReader();
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        reader.setSearcher(searcher);
        return searcher;
    }

    public float search(Query query) {
        if (query == null) {
            throw new IllegalArgumentException("query must not be null");
        }
        IndexSearcher searcher = this.createSearcher();
        try {
            float score;
            final float[] scores = new float[1];
            searcher.search(query, new Collector(){
                private Scorer scorer;

                public void collect(int doc) throws IOException {
                    scores[0] = this.scorer.score();
                }

                public void setScorer(Scorer scorer) throws IOException {
                    this.scorer = scorer;
                }

                public boolean acceptsDocsOutOfOrder() {
                    return true;
                }

                public void setNextReader(AtomicReaderContext context) {
                }
            });
            float f = score = scores[0];
            return f;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long getMemorySize() {
        return RamUsageEstimator.sizeOf((Object)this);
    }

    private int numPositions(ArrayIntList positions) {
        return positions.size() / this.stride;
    }

    private void sortFields() {
        if (this.sortedFields == null) {
            this.sortedFields = MemoryIndex.sort(this.fields);
        }
    }

    private static <K, V> Map.Entry<K, V>[] sort(HashMap<K, V> map) {
        int size = map.size();
        Object[] entries = new Map.Entry[size];
        Iterator<Map.Entry<K, V>> iter = map.entrySet().iterator();
        for (int i = 0; i < size; ++i) {
            entries[i] = iter.next();
        }
        if (size > 1) {
            ArrayUtil.quickSort((Object[])entries, termComparator);
        }
        return entries;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(256);
        this.sortFields();
        int sumPositions = 0;
        int sumTerms = 0;
        for (int i = 0; i < this.sortedFields.length; ++i) {
            Map.Entry<String, Info> entry = this.sortedFields[i];
            String fieldName = entry.getKey();
            Info info = entry.getValue();
            info.sortTerms();
            result.append(fieldName + ":\n");
            int numPositions = 0;
            for (int j = 0; j < info.sortedTerms.length; ++j) {
                Map.Entry e = info.sortedTerms[j];
                BytesRef term = (BytesRef)e.getKey();
                ArrayIntList positions = (ArrayIntList)e.getValue();
                result.append("\t'" + term + "':" + this.numPositions(positions) + ":");
                result.append(positions.toString(this.stride));
                result.append("\n");
                numPositions += this.numPositions(positions);
            }
            result.append("\tterms=" + info.sortedTerms.length);
            result.append(", positions=" + numPositions);
            result.append(", memory=" + RamUsageEstimator.humanReadableUnits((long)RamUsageEstimator.sizeOf((Object)info)));
            result.append("\n");
            sumPositions += numPositions;
            sumTerms += info.sortedTerms.length;
        }
        result.append("\nfields=" + this.sortedFields.length);
        result.append(", terms=" + sumTerms);
        result.append(", positions=" + sumPositions);
        result.append(", memory=" + RamUsageEstimator.humanReadableUnits((long)this.getMemorySize()));
        return result.toString();
    }

    private final class MemoryIndexReader
    extends AtomicReader {
        private IndexSearcher searcher;
        private DocValues cachedNormValues;
        private String cachedFieldName;
        private Similarity cachedSimilarity;

        private MemoryIndexReader() {
        }

        private Info getInfo(String fieldName) {
            return (Info)MemoryIndex.this.fields.get(fieldName);
        }

        private Info getInfo(int pos) {
            return (Info)MemoryIndex.this.sortedFields[pos].getValue();
        }

        public Bits getLiveDocs() {
            return null;
        }

        public FieldInfos getFieldInfos() {
            return new FieldInfos(MemoryIndex.this.fieldInfos.values().toArray(new FieldInfo[MemoryIndex.this.fieldInfos.size()]));
        }

        public Fields fields() {
            MemoryIndex.this.sortFields();
            return new MemoryFields();
        }

        public Fields getTermVectors(int docID) {
            if (docID == 0) {
                return this.fields();
            }
            return null;
        }

        private Similarity getSimilarity() {
            if (this.searcher != null) {
                return this.searcher.getSimilarity();
            }
            return IndexSearcher.getDefaultSimilarity();
        }

        private void setSearcher(IndexSearcher searcher) {
            this.searcher = searcher;
        }

        public int numDocs() {
            return MemoryIndex.this.fields.size() > 0 ? 1 : 0;
        }

        public int maxDoc() {
            return 1;
        }

        public void document(int docID, StoredFieldVisitor visitor) {
        }

        public boolean hasDeletions() {
            return false;
        }

        protected void doClose() {
        }

        public DocValues docValues(String field) throws IOException {
            return null;
        }

        public DocValues normValues(String field) throws IOException {
            DocValues norms = this.cachedNormValues;
            Similarity sim = this.getSimilarity();
            if (!field.equals(this.cachedFieldName) || sim != this.cachedSimilarity) {
                Info info = this.getInfo(field);
                int numTokens = info != null ? info.numTokens : 0;
                int numOverlapTokens = info != null ? info.numOverlapTokens : 0;
                float boost = info != null ? info.getBoost() : 1.0f;
                FieldInvertState invertState = new FieldInvertState(field, 0, numTokens, numOverlapTokens, 0, boost);
                Norm norm = new Norm();
                sim.computeNorm(invertState, norm);
                MemoryIndexNormDocValues.SingleValueSource singleByteSource = new MemoryIndexNormDocValues.SingleValueSource(norm);
                this.cachedNormValues = norms = new MemoryIndexNormDocValues(singleByteSource);
                this.cachedFieldName = field;
                this.cachedSimilarity = sim;
            }
            return norms;
        }

        private class MemoryDocsAndPositionsEnum
        extends DocsAndPositionsEnum {
            private ArrayIntList positions;
            private int posUpto;
            private boolean hasNext;
            private Bits liveDocs;
            private int doc = -1;

            private MemoryDocsAndPositionsEnum() {
            }

            public DocsAndPositionsEnum reset(Bits liveDocs, ArrayIntList positions) {
                this.liveDocs = liveDocs;
                this.positions = positions;
                this.posUpto = 0;
                this.hasNext = true;
                this.doc = -1;
                return this;
            }

            public int docID() {
                return this.doc;
            }

            public int nextDoc() {
                if (this.hasNext && (this.liveDocs == null || this.liveDocs.get(0))) {
                    this.hasNext = false;
                    this.doc = 0;
                    return 0;
                }
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }

            public int advance(int target) {
                return this.nextDoc();
            }

            public int freq() throws IOException {
                return this.positions.size() / MemoryIndex.this.stride;
            }

            public int nextPosition() {
                return this.positions.get(this.posUpto++ * MemoryIndex.this.stride);
            }

            public int startOffset() {
                return MemoryIndex.this.stride == 1 ? -1 : this.positions.get((this.posUpto - 1) * MemoryIndex.this.stride + 1);
            }

            public int endOffset() {
                return MemoryIndex.this.stride == 1 ? -1 : this.positions.get((this.posUpto - 1) * MemoryIndex.this.stride + 2);
            }

            public boolean hasPayload() {
                return false;
            }

            public BytesRef getPayload() {
                return null;
            }
        }

        private class MemoryDocsEnum
        extends DocsEnum {
            private ArrayIntList positions;
            private boolean hasNext;
            private Bits liveDocs;
            private int doc = -1;

            private MemoryDocsEnum() {
            }

            public DocsEnum reset(Bits liveDocs, ArrayIntList positions) {
                this.liveDocs = liveDocs;
                this.positions = positions;
                this.hasNext = true;
                this.doc = -1;
                return this;
            }

            public int docID() {
                return this.doc;
            }

            public int nextDoc() {
                if (this.hasNext && (this.liveDocs == null || this.liveDocs.get(0))) {
                    this.hasNext = false;
                    this.doc = 0;
                    return 0;
                }
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }

            public int advance(int target) {
                return this.nextDoc();
            }

            public int freq() throws IOException {
                return this.positions.size();
            }
        }

        private class MemoryTermsEnum
        extends TermsEnum {
            private final Info info;
            private final BytesRef br = new BytesRef();
            int termUpto = -1;

            public MemoryTermsEnum(Info info) {
                this.info = info;
                info.sortTerms();
            }

            public boolean seekExact(BytesRef text, boolean useCache) {
                this.termUpto = Arrays.binarySearch(this.info.sortedTerms, text, termComparator);
                if (this.termUpto >= 0) {
                    this.br.copyBytes((BytesRef)this.info.sortedTerms[this.termUpto].getKey());
                    return true;
                }
                return false;
            }

            public TermsEnum.SeekStatus seekCeil(BytesRef text, boolean useCache) {
                this.termUpto = Arrays.binarySearch(this.info.sortedTerms, text, termComparator);
                if (this.termUpto < 0) {
                    this.termUpto = -this.termUpto - 1;
                    if (this.termUpto >= this.info.sortedTerms.length) {
                        return TermsEnum.SeekStatus.END;
                    }
                    this.br.copyBytes((BytesRef)this.info.sortedTerms[this.termUpto].getKey());
                    return TermsEnum.SeekStatus.NOT_FOUND;
                }
                this.br.copyBytes((BytesRef)this.info.sortedTerms[this.termUpto].getKey());
                return TermsEnum.SeekStatus.FOUND;
            }

            public void seekExact(long ord) {
                assert (ord < (long)this.info.sortedTerms.length);
                this.termUpto = (int)ord;
            }

            public BytesRef next() {
                ++this.termUpto;
                if (this.termUpto >= this.info.sortedTerms.length) {
                    return null;
                }
                this.br.copyBytes((BytesRef)this.info.sortedTerms[this.termUpto].getKey());
                return this.br;
            }

            public BytesRef term() {
                return this.br;
            }

            public long ord() {
                return this.termUpto;
            }

            public int docFreq() {
                return 1;
            }

            public long totalTermFreq() {
                return ((ArrayIntList)this.info.sortedTerms[this.termUpto].getValue()).size();
            }

            public DocsEnum docs(Bits liveDocs, DocsEnum reuse, boolean needsFreqs) {
                if (reuse == null || !(reuse instanceof MemoryDocsEnum)) {
                    reuse = new MemoryDocsEnum();
                }
                return ((MemoryDocsEnum)reuse).reset(liveDocs, (ArrayIntList)this.info.sortedTerms[this.termUpto].getValue());
            }

            public DocsAndPositionsEnum docsAndPositions(Bits liveDocs, DocsAndPositionsEnum reuse, boolean needsOffsets) {
                if (needsOffsets) {
                    return null;
                }
                if (reuse == null || !(reuse instanceof MemoryDocsAndPositionsEnum)) {
                    reuse = new MemoryDocsAndPositionsEnum();
                }
                return ((MemoryDocsAndPositionsEnum)reuse).reset(liveDocs, (ArrayIntList)this.info.sortedTerms[this.termUpto].getValue());
            }

            public Comparator<BytesRef> getComparator() {
                return BytesRef.getUTF8SortedAsUnicodeComparator();
            }

            public void seekExact(BytesRef term, TermState state) throws IOException {
                assert (state != null);
                this.seekExact(((OrdTermState)state).ord);
            }

            public TermState termState() throws IOException {
                OrdTermState ts = new OrdTermState();
                ts.ord = this.termUpto;
                return ts;
            }
        }

        private class MemoryFields
        extends Fields {
            private MemoryFields() {
            }

            public FieldsEnum iterator() {
                return new FieldsEnum(){
                    int upto = -1;

                    public String next() {
                        ++this.upto;
                        if (this.upto >= MemoryIndex.this.sortedFields.length) {
                            return null;
                        }
                        return (String)MemoryIndex.this.sortedFields[this.upto].getKey();
                    }

                    public Terms terms() {
                        return MemoryFields.this.terms((String)MemoryIndex.this.sortedFields[this.upto].getKey());
                    }
                };
            }

            public Terms terms(String field) {
                int i = Arrays.binarySearch(MemoryIndex.this.sortedFields, field, termComparator);
                if (i < 0) {
                    return null;
                }
                final Info info = MemoryIndexReader.this.getInfo(i);
                info.sortTerms();
                return new Terms(){

                    public TermsEnum iterator(TermsEnum reuse) {
                        return new MemoryTermsEnum(info);
                    }

                    public Comparator<BytesRef> getComparator() {
                        return BytesRef.getUTF8SortedAsUnicodeComparator();
                    }

                    public long size() {
                        return info.sortedTerms.length;
                    }

                    public long getSumTotalTermFreq() {
                        return info.getSumTotalTermFreq();
                    }

                    public long getSumDocFreq() throws IOException {
                        return info.sortedTerms.length;
                    }

                    public int getDocCount() throws IOException {
                        return info.sortedTerms.length > 0 ? 1 : 0;
                    }
                };
            }

            public int size() {
                return MemoryIndex.this.sortedFields.length;
            }
        }
    }

    private static final class ArrayIntList {
        private int[] elements;
        private int size = 0;

        public ArrayIntList(int initialCapacity) {
            this.elements = new int[initialCapacity];
        }

        public void add(int elem) {
            if (this.size == this.elements.length) {
                this.ensureCapacity(this.size + 1);
            }
            this.elements[this.size++] = elem;
        }

        public void add(int pos, int start, int end) {
            if (this.size + 3 > this.elements.length) {
                this.ensureCapacity(this.size + 3);
            }
            this.elements[this.size] = pos;
            this.elements[this.size + 1] = start;
            this.elements[this.size + 2] = end;
            this.size += 3;
        }

        public int get(int index) {
            if (index >= this.size) {
                this.throwIndex(index);
            }
            return this.elements[index];
        }

        public int size() {
            return this.size;
        }

        private void ensureCapacity(int minCapacity) {
            int newCapacity = Math.max(minCapacity, this.elements.length * 3 / 2 + 1);
            int[] newElements = new int[newCapacity];
            System.arraycopy(this.elements, 0, newElements, 0, this.size);
            this.elements = newElements;
        }

        private void throwIndex(int index) {
            throw new IndexOutOfBoundsException("index: " + index + ", size: " + this.size);
        }

        public String toString(int stride) {
            int s = this.size() / stride;
            int len = Math.min(10, s);
            StringBuilder buf = new StringBuilder(4 * len);
            buf.append("[");
            for (int i = 0; i < len; ++i) {
                buf.append(this.get(i * stride));
                if (i >= len - 1) continue;
                buf.append(", ");
            }
            if (len != s) {
                buf.append(", ...");
            }
            buf.append("]");
            return buf.toString();
        }
    }

    private static final class Info {
        private final HashMap<BytesRef, ArrayIntList> terms;
        private transient Map.Entry<BytesRef, ArrayIntList>[] sortedTerms;
        private final int numTokens;
        private final int numOverlapTokens;
        private final float boost;
        private final long sumTotalTermFreq;

        public Info(HashMap<BytesRef, ArrayIntList> terms, int numTokens, int numOverlapTokens, float boost) {
            this.terms = terms;
            this.numTokens = numTokens;
            this.numOverlapTokens = numOverlapTokens;
            this.boost = boost;
            long sum = 0L;
            for (Map.Entry<BytesRef, ArrayIntList> ent : terms.entrySet()) {
                sum += (long)ent.getValue().size();
            }
            this.sumTotalTermFreq = sum;
        }

        public long getSumTotalTermFreq() {
            return this.sumTotalTermFreq;
        }

        public void sortTerms() {
            if (this.sortedTerms == null) {
                this.sortedTerms = MemoryIndex.sort(this.terms);
            }
        }

        public float getBoost() {
            return this.boost;
        }
    }
}

