/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitSet;

public class ToParentBlockJoinQuery
extends Query {
    private final BitSetProducer parentsFilter;
    private final Query childQuery;
    private final Query origChildQuery;
    private final ScoreMode scoreMode;

    public ToParentBlockJoinQuery(Query childQuery, BitSetProducer parentsFilter, ScoreMode scoreMode) {
        this.origChildQuery = childQuery;
        this.childQuery = childQuery;
        this.parentsFilter = parentsFilter;
        this.scoreMode = scoreMode;
    }

    private ToParentBlockJoinQuery(Query origChildQuery, Query childQuery, BitSetProducer parentsFilter, ScoreMode scoreMode) {
        this.origChildQuery = origChildQuery;
        this.childQuery = childQuery;
        this.parentsFilter = parentsFilter;
        this.scoreMode = scoreMode;
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new BlockJoinWeight(this, this.childQuery.createWeight(searcher, needsScores), this.parentsFilter, needsScores ? this.scoreMode : ScoreMode.None);
    }

    public Query getChildQuery() {
        return this.childQuery;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query childRewrite = this.childQuery.rewrite(reader);
        if (childRewrite != this.childQuery) {
            return new ToParentBlockJoinQuery(this.origChildQuery, childRewrite, this.parentsFilter, this.scoreMode);
        }
        return super.rewrite(reader);
    }

    public String toString(String field) {
        return "ToParentBlockJoinQuery (" + this.childQuery.toString() + ")";
    }

    public boolean equals(Object _other) {
        if (_other instanceof ToParentBlockJoinQuery) {
            ToParentBlockJoinQuery other = (ToParentBlockJoinQuery)((Object)_other);
            return this.origChildQuery.equals((Object)other.origChildQuery) && this.parentsFilter.equals(other.parentsFilter) && this.scoreMode == other.scoreMode && super.equals((Object)other);
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int hash = super.hashCode();
        hash = 31 * hash + this.origChildQuery.hashCode();
        hash = 31 * hash + this.scoreMode.hashCode();
        hash = 31 * hash + this.parentsFilter.hashCode();
        return hash;
    }

    static class BlockJoinScorer
    extends ChildrenMatchesScorer {
        private final Scorer childScorer;
        private final BitSet parentBits;
        private final ScoreMode scoreMode;
        private int parentDoc = -1;
        private int prevParentDoc;
        private float parentScore;
        private int parentFreq;
        private int nextChildDoc;
        private int[] pendingChildDocs;
        private float[] pendingChildScores;
        private int childDocUpto;

        public BlockJoinScorer(Weight weight, Scorer childScorer, BitSet parentBits, int firstChildDoc, ScoreMode scoreMode) {
            super(weight);
            this.parentBits = parentBits;
            this.childScorer = childScorer;
            this.scoreMode = scoreMode;
            this.nextChildDoc = firstChildDoc;
        }

        public Collection<Scorer.ChildScorer> getChildren() {
            return Collections.singleton(new Scorer.ChildScorer(this.childScorer, "BLOCK_JOIN"));
        }

        @Override
        public int getChildCount() {
            return this.childDocUpto;
        }

        int getParentDoc() {
            return this.parentDoc;
        }

        @Override
        public int[] swapChildDocs(int[] other) {
            int[] ret = this.pendingChildDocs;
            this.pendingChildDocs = other == null ? new int[5] : other;
            return ret;
        }

        float[] swapChildScores(float[] other) {
            if (this.scoreMode == ScoreMode.None) {
                throw new IllegalStateException("ScoreMode is None; you must pass trackScores=false to ToParentBlockJoinCollector");
            }
            float[] ret = this.pendingChildScores;
            this.pendingChildScores = other == null ? new float[5] : other;
            return ret;
        }

        public DocIdSetIterator iterator() {
            return new DocIdSetIterator(){
                final DocIdSetIterator childIt;
                {
                    this.childIt = childScorer.iterator();
                }

                public int nextDoc() throws IOException {
                    if (nextChildDoc == Integer.MAX_VALUE) {
                        return parentDoc = Integer.MAX_VALUE;
                    }
                    parentDoc = parentBits.nextSetBit(nextChildDoc);
                    if (nextChildDoc == parentDoc) {
                        throw new IllegalStateException("child query must only match non-parent docs, but parent docID=" + nextChildDoc + " matched childScorer=" + childScorer.getClass());
                    }
                    assert (parentDoc != Integer.MAX_VALUE);
                    float totalScore = 0.0f;
                    float maxScore = Float.NEGATIVE_INFINITY;
                    float minScore = Float.POSITIVE_INFINITY;
                    childDocUpto = 0;
                    parentFreq = 0;
                    do {
                        if (pendingChildDocs != null && pendingChildDocs.length == childDocUpto) {
                            BlockJoinScorer.access$602(this, ArrayUtil.grow((int[])pendingChildDocs));
                        }
                        if (pendingChildScores != null && scoreMode != ScoreMode.None && pendingChildScores.length == childDocUpto) {
                            BlockJoinScorer.access$702(this, ArrayUtil.grow((float[])pendingChildScores));
                        }
                        if (pendingChildDocs != null) {
                            ((BlockJoinScorer)this).pendingChildDocs[((BlockJoinScorer)this).childDocUpto] = nextChildDoc;
                        }
                        if (scoreMode != ScoreMode.None) {
                            float childScore = childScorer.score();
                            int childFreq = childScorer.freq();
                            if (pendingChildScores != null) {
                                ((BlockJoinScorer)this).pendingChildScores[((BlockJoinScorer)this).childDocUpto] = childScore;
                            }
                            maxScore = Math.max(childScore, maxScore);
                            minScore = Math.min(childScore, minScore);
                            totalScore += childScore;
                            parentFreq = parentFreq + childFreq;
                        }
                        childDocUpto++;
                        nextChildDoc = this.childIt.nextDoc();
                    } while (nextChildDoc < parentDoc);
                    if (nextChildDoc == parentDoc) {
                        throw new IllegalStateException("child query must only match non-parent docs, but parent docID=" + nextChildDoc + " matched childScorer=" + childScorer.getClass());
                    }
                    switch (scoreMode) {
                        case Avg: {
                            parentScore = totalScore / (float)childDocUpto;
                            break;
                        }
                        case Max: {
                            parentScore = maxScore;
                            break;
                        }
                        case Min: {
                            parentScore = minScore;
                            break;
                        }
                        case Total: {
                            parentScore = totalScore;
                            break;
                        }
                    }
                    return parentDoc;
                }

                public int advance(int parentTarget) throws IOException {
                    if (parentTarget == Integer.MAX_VALUE) {
                        return parentDoc = Integer.MAX_VALUE;
                    }
                    if (parentTarget == 0) {
                        return this.nextDoc();
                    }
                    prevParentDoc = parentBits.prevSetBit(parentTarget - 1);
                    assert (prevParentDoc >= parentDoc);
                    if (prevParentDoc > nextChildDoc) {
                        nextChildDoc = this.childIt.advance(prevParentDoc);
                    }
                    if (nextChildDoc == prevParentDoc) {
                        throw new IllegalStateException("child query must only match non-parent docs, but parent docID=" + nextChildDoc + " matched childScorer=" + childScorer.getClass());
                    }
                    int nd = this.nextDoc();
                    return nd;
                }

                public int docID() {
                    return parentDoc;
                }

                public long cost() {
                    return this.childIt.cost();
                }
            };
        }

        public int docID() {
            return this.parentDoc;
        }

        public float score() throws IOException {
            return this.parentScore;
        }

        public int freq() {
            return this.parentFreq;
        }

        public Explanation explain(int docBase) throws IOException {
            int start = docBase + this.prevParentDoc + 1;
            int end = docBase + this.parentDoc - 1;
            return Explanation.match((float)this.score(), (String)String.format(Locale.ROOT, "Score based on child doc range from %d to %d", start, end), (Explanation[])new Explanation[0]);
        }

        @Override
        public void trackPendingChildHits() {
            this.pendingChildDocs = new int[5];
            if (this.scoreMode != ScoreMode.None) {
                this.pendingChildScores = new float[5];
            }
        }

        static /* synthetic */ int[] access$602(BlockJoinScorer x0, int[] x1) {
            x0.pendingChildDocs = x1;
            return x1;
        }

        static /* synthetic */ float[] access$702(BlockJoinScorer x0, float[] x1) {
            x0.pendingChildScores = x1;
            return x1;
        }
    }

    public static abstract class ChildrenMatchesScorer
    extends Scorer {
        protected ChildrenMatchesScorer(Weight weight) {
            super(weight);
        }

        public abstract void trackPendingChildHits();

        public abstract int getChildCount();

        public abstract int[] swapChildDocs(int[] var1);
    }

    private static class BlockJoinWeight
    extends Weight {
        private final Weight childWeight;
        private final BitSetProducer parentsFilter;
        private final ScoreMode scoreMode;

        public BlockJoinWeight(Query joinQuery, Weight childWeight, BitSetProducer parentsFilter, ScoreMode scoreMode) {
            super(joinQuery);
            this.childWeight = childWeight;
            this.parentsFilter = parentsFilter;
            this.scoreMode = scoreMode;
        }

        public void extractTerms(Set<Term> terms) {
            this.childWeight.extractTerms(terms);
        }

        public float getValueForNormalization() throws IOException {
            return this.childWeight.getValueForNormalization();
        }

        public void normalize(float norm, float boost) {
            this.childWeight.normalize(norm, boost);
        }

        public Scorer scorer(LeafReaderContext readerContext) throws IOException {
            Scorer childScorer = this.childWeight.scorer(readerContext);
            if (childScorer == null) {
                return null;
            }
            int firstChildDoc = childScorer.iterator().nextDoc();
            if (firstChildDoc == Integer.MAX_VALUE) {
                return null;
            }
            BitSet parents = this.parentsFilter.getBitSet(readerContext);
            if (parents == null) {
                return null;
            }
            return new BlockJoinScorer(this, childScorer, parents, firstChildDoc, this.scoreMode);
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            BlockJoinScorer scorer = (BlockJoinScorer)this.scorer(context);
            if (scorer != null && scorer.iterator().advance(doc) == doc) {
                return scorer.explain(context.docBase);
            }
            return Explanation.noMatch((String)"Not a match", (Explanation[])new Explanation[0]);
        }
    }
}

