/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping.dv;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.grouping.AbstractFirstPassGroupingCollector;
import org.apache.lucene.util.BytesRef;

public abstract class DVFirstPassGroupingCollector<GROUP_VALUE_TYPE>
extends AbstractFirstPassGroupingCollector<GROUP_VALUE_TYPE> {
    final String groupField;
    final boolean diskResident;
    final DocValues.Type valueType;

    public static <T> DVFirstPassGroupingCollector<T> create(Sort groupSort, int topNGroups, String groupField, DocValues.Type type, boolean diskResident) throws IOException {
        switch (type) {
            case VAR_INTS: 
            case FIXED_INTS_8: 
            case FIXED_INTS_16: 
            case FIXED_INTS_32: 
            case FIXED_INTS_64: {
                return new Lng(groupSort, topNGroups, groupField, diskResident, type);
            }
            case FLOAT_32: 
            case FLOAT_64: {
                return new Dbl(groupSort, topNGroups, groupField, diskResident, type);
            }
            case BYTES_FIXED_STRAIGHT: 
            case BYTES_FIXED_DEREF: 
            case BYTES_VAR_STRAIGHT: 
            case BYTES_VAR_DEREF: {
                return new BR(groupSort, topNGroups, groupField, diskResident, type);
            }
            case BYTES_VAR_SORTED: 
            case BYTES_FIXED_SORTED: {
                return new SortedBR(groupSort, topNGroups, groupField, diskResident, type);
            }
        }
        throw new IllegalArgumentException(String.format("ValueType %s not supported", type));
    }

    DVFirstPassGroupingCollector(Sort groupSort, int topNGroups, String groupField, boolean diskResident, DocValues.Type valueType) throws IOException {
        super(groupSort, topNGroups);
        this.groupField = groupField;
        this.diskResident = diskResident;
        this.valueType = valueType;
    }

    @Override
    public void setNextReader(AtomicReaderContext readerContext) throws IOException {
        super.setNextReader(readerContext);
        DocValues dv = readerContext.reader().docValues(this.groupField);
        DocValues.Source dvSource = dv != null ? (this.diskResident ? dv.getDirectSource() : dv.getSource()) : this.getDefaultSource(readerContext);
        this.setDocValuesSources(dvSource);
    }

    protected abstract void setDocValuesSources(DocValues.Source var1);

    protected DocValues.Source getDefaultSource(AtomicReaderContext readerContext) {
        return DocValues.getDefaultSource((DocValues.Type)this.valueType);
    }

    static class SortedBR
    extends DVFirstPassGroupingCollector<BytesRef> {
        private DocValues.SortedSource sortedSource;
        private final BytesRef spare = new BytesRef();

        SortedBR(Sort groupSort, int topNGroups, String groupField, boolean diskResident, DocValues.Type type) throws IOException {
            super(groupSort, topNGroups, groupField, diskResident, type);
        }

        @Override
        protected BytesRef getDocGroupValue(int doc) {
            return this.sortedSource.getBytes(doc, this.spare);
        }

        @Override
        protected BytesRef copyDocGroupValue(BytesRef groupValue, BytesRef reuse) {
            if (reuse != null) {
                reuse.copyBytes(groupValue);
                return reuse;
            }
            return BytesRef.deepCopyOf((BytesRef)groupValue);
        }

        @Override
        protected void setDocValuesSources(DocValues.Source source) {
            this.sortedSource = source.asSortedSource();
        }

        @Override
        protected DocValues.Source getDefaultSource(AtomicReaderContext readerContext) {
            return DocValues.getDefaultSortedSource((DocValues.Type)this.valueType, (int)readerContext.reader().maxDoc());
        }
    }

    static class BR
    extends DVFirstPassGroupingCollector<BytesRef> {
        private DocValues.Source source;
        private final BytesRef spare = new BytesRef();

        BR(Sort groupSort, int topNGroups, String groupField, boolean diskResident, DocValues.Type type) throws IOException {
            super(groupSort, topNGroups, groupField, diskResident, type);
        }

        @Override
        protected BytesRef getDocGroupValue(int doc) {
            return this.source.getBytes(doc, this.spare);
        }

        @Override
        protected BytesRef copyDocGroupValue(BytesRef groupValue, BytesRef reuse) {
            if (reuse != null) {
                reuse.copyBytes(groupValue);
                return reuse;
            }
            return BytesRef.deepCopyOf((BytesRef)groupValue);
        }

        @Override
        protected void setDocValuesSources(DocValues.Source source) {
            this.source = source;
        }
    }

    static class Dbl
    extends DVFirstPassGroupingCollector<Double> {
        private DocValues.Source source;

        Dbl(Sort groupSort, int topNGroups, String groupField, boolean diskResident, DocValues.Type type) throws IOException {
            super(groupSort, topNGroups, groupField, diskResident, type);
        }

        @Override
        protected Double getDocGroupValue(int doc) {
            return this.source.getFloat(doc);
        }

        @Override
        protected Double copyDocGroupValue(Double groupValue, Double reuse) {
            return groupValue;
        }

        @Override
        protected void setDocValuesSources(DocValues.Source source) {
            this.source = source;
        }
    }

    static class Lng
    extends DVFirstPassGroupingCollector<Long> {
        private DocValues.Source source;

        Lng(Sort groupSort, int topNGroups, String groupField, boolean diskResident, DocValues.Type type) throws IOException {
            super(groupSort, topNGroups, groupField, diskResident, type);
        }

        @Override
        protected Long getDocGroupValue(int doc) {
            return this.source.getInt(doc);
        }

        @Override
        protected Long copyDocGroupValue(Long groupValue, Long reuse) {
            return groupValue;
        }

        @Override
        protected void setDocValuesSources(DocValues.Source source) {
            this.source = source;
        }
    }
}

