/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.encoding;

import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.util.encoding.FourFlagsIntDecoder;

public class NOnesIntDecoder
extends FourFlagsIntDecoder {
    private int n;
    private int onesCounter;

    public NOnesIntDecoder(int n) {
        this.n = n;
    }

    public long decode() throws IOException {
        if (this.onesCounter > 0) {
            --this.onesCounter;
            return 1L;
        }
        long decode = super.decode();
        if (decode == 1L) {
            return 1L;
        }
        if (decode == 2L) {
            this.onesCounter = this.n - 1;
            return 1L;
        }
        if (decode == 3L) {
            return 2L;
        }
        return decode == 0x100000000L ? 0x100000000L : decode - 1L;
    }

    public void reInit(InputStream in) {
        super.reInit(in);
        this.onesCounter = 0;
    }

    public String toString() {
        return "NOnes (" + this.n + ") (" + super.toString() + ")";
    }
}

