/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search.params;

import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.aggregator.Aggregator;
import org.apache.lucene.facet.search.aggregator.ScoringAggregator;
import org.apache.lucene.facet.search.params.FacetRequest;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.IndexReader;

public class ScoreFacetRequest
extends FacetRequest {
    public ScoreFacetRequest(CategoryPath path, int num) {
        super(path, num);
    }

    public Aggregator createAggregator(boolean useComplements, FacetArrays arrays, IndexReader reader, TaxonomyReader taxonomy) {
        assert (!useComplements) : "complements are not supported by this FacetRequest";
        return new ScoringAggregator(arrays.getFloatArray());
    }

    public double getValueOf(FacetArrays arrays, int ordinal) {
        return arrays.getFloatArray()[ordinal];
    }

    public boolean supportsComplements() {
        return false;
    }

    public boolean requireDocumentScore() {
        return true;
    }
}

