/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.index.DocValuesFieldUpdates;
import org.apache.lucene.index.DocValuesUpdate;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.InPlaceMergeSorter;
import org.apache.lucene.util.packed.PackedInts;
import org.apache.lucene.util.packed.PagedGrowableWriter;
import org.apache.lucene.util.packed.PagedMutable;

class NumericDocValuesFieldUpdates
extends DocValuesFieldUpdates {
    private FixedBitSet docsWithField = new FixedBitSet(64);
    private PagedMutable docs;
    private PagedGrowableWriter values;
    private int size;

    public NumericDocValuesFieldUpdates(String field, int maxDoc) {
        super(field, DocValuesFieldUpdates.Type.NUMERIC);
        this.docs = new PagedMutable(1L, 1024, PackedInts.bitsRequired(maxDoc - 1), 0.0f);
        this.values = new PagedGrowableWriter(1L, 1024, 1, 0.5f);
        this.size = 0;
    }

    @Override
    public void add(int doc, Object value) {
        if (this.size == Integer.MAX_VALUE) {
            throw new IllegalStateException("cannot support more than Integer.MAX_VALUE doc/value entries");
        }
        Long val = (Long)value;
        if (val == null) {
            val = DocValuesUpdate.NumericDocValuesUpdate.MISSING;
        }
        if (this.docs.size() == (long)this.size) {
            this.docs = (PagedMutable)this.docs.grow(this.size + 1);
            this.values = (PagedGrowableWriter)this.values.grow(this.size + 1);
            this.docsWithField = FixedBitSet.ensureCapacity(this.docsWithField, (int)this.docs.size());
        }
        if (val != DocValuesUpdate.NumericDocValuesUpdate.MISSING) {
            this.docsWithField.set(this.size);
        }
        this.docs.set(this.size, doc);
        this.values.set(this.size, val);
        ++this.size;
    }

    @Override
    public Iterator iterator() {
        final PagedMutable docs = this.docs;
        final PagedGrowableWriter values = this.values;
        final FixedBitSet docsWithField = this.docsWithField;
        new InPlaceMergeSorter(){

            @Override
            protected void swap(int i, int j) {
                long tmpDoc = docs.get(j);
                docs.set(j, docs.get(i));
                docs.set(i, tmpDoc);
                long tmpVal = values.get(j);
                values.set(j, values.get(i));
                values.set(i, tmpVal);
                boolean tmpBool = docsWithField.get(j);
                if (docsWithField.get(i)) {
                    docsWithField.set(j);
                } else {
                    docsWithField.clear(j);
                }
                if (tmpBool) {
                    docsWithField.set(i);
                } else {
                    docsWithField.clear(i);
                }
            }

            @Override
            protected int compare(int i, int j) {
                int y;
                int x = (int)docs.get(i);
                return x < (y = (int)docs.get(j)) ? -1 : (x == y ? 0 : 1);
            }
        }.sort(0, this.size);
        return new Iterator(this.size, values, docsWithField, docs);
    }

    @Override
    public void merge(DocValuesFieldUpdates other) {
        assert (other instanceof NumericDocValuesFieldUpdates);
        NumericDocValuesFieldUpdates otherUpdates = (NumericDocValuesFieldUpdates)other;
        if (this.size + otherUpdates.size > Integer.MAX_VALUE) {
            throw new IllegalStateException("cannot support more than Integer.MAX_VALUE doc/value entries; size=" + this.size + " other.size=" + otherUpdates.size);
        }
        this.docs = (PagedMutable)this.docs.grow(this.size + otherUpdates.size);
        this.values = (PagedGrowableWriter)this.values.grow(this.size + otherUpdates.size);
        this.docsWithField = FixedBitSet.ensureCapacity(this.docsWithField, (int)this.docs.size());
        for (int i = 0; i < otherUpdates.size; ++i) {
            int doc = (int)otherUpdates.docs.get(i);
            if (otherUpdates.docsWithField.get(i)) {
                this.docsWithField.set(this.size);
            }
            this.docs.set(this.size, doc);
            this.values.set(this.size, otherUpdates.values.get(i));
            ++this.size;
        }
    }

    @Override
    public boolean any() {
        return this.size > 0;
    }

    static final class Iterator
    extends DocValuesFieldUpdates.Iterator {
        private final int size;
        private final PagedGrowableWriter values;
        private final FixedBitSet docsWithField;
        private final PagedMutable docs;
        private long idx = 0L;
        private int doc = -1;
        private Long value = null;

        Iterator(int size, PagedGrowableWriter values, FixedBitSet docsWithField, PagedMutable docs) {
            this.size = size;
            this.values = values;
            this.docsWithField = docsWithField;
            this.docs = docs;
        }

        @Override
        Long value() {
            return this.value;
        }

        @Override
        int nextDoc() {
            if (this.idx >= (long)this.size) {
                this.value = null;
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.doc = (int)this.docs.get(this.idx);
            ++this.idx;
            while (this.idx < (long)this.size && this.docs.get(this.idx) == (long)this.doc) {
                ++this.idx;
            }
            this.value = !this.docsWithField.get((int)(this.idx - 1L)) ? null : Long.valueOf(this.values.get(this.idx - 1L));
            return this.doc;
        }

        @Override
        int doc() {
            return this.doc;
        }

        @Override
        void reset() {
            this.doc = -1;
            this.value = null;
            this.idx = 0L;
        }
    }
}

