/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.EOFException;
import java.io.IOException;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.packed.BulkOperation;
import org.apache.lucene.util.packed.PackedInts;

final class PackedWriter
extends PackedInts.Writer {
    boolean finished;
    final PackedInts.Format format;
    final BulkOperation bulkOperation;
    final long[] nextBlocks;
    final long[] nextValues;
    final int iterations;
    int off;
    int written;

    PackedWriter(PackedInts.Format format, DataOutput out, int valueCount, int bitsPerValue, int mem) throws IOException {
        super(out, valueCount, bitsPerValue);
        this.format = format;
        this.bulkOperation = BulkOperation.of(format, bitsPerValue);
        this.iterations = this.bulkOperation.computeIterations(valueCount, mem);
        this.nextBlocks = new long[this.iterations * this.bulkOperation.blocks()];
        this.nextValues = new long[this.iterations * this.bulkOperation.values()];
        this.off = 0;
        this.written = 0;
        this.finished = false;
    }

    @Override
    protected PackedInts.Format getFormat() {
        return this.format;
    }

    @Override
    public void add(long v) throws IOException {
        assert (v >= 0L && v <= PackedInts.maxValue(this.bitsPerValue));
        assert (!this.finished);
        if (this.valueCount != -1 && this.written >= this.valueCount) {
            throw new EOFException("Writing past end of stream");
        }
        this.nextValues[this.off++] = v;
        if (this.off == this.nextValues.length) {
            this.flush(this.nextValues.length);
            this.off = 0;
        }
        ++this.written;
    }

    @Override
    public void finish() throws IOException {
        assert (!this.finished);
        if (this.valueCount != -1) {
            while (this.written < this.valueCount) {
                this.add(0L);
            }
        }
        this.flush(this.off);
        this.finished = true;
    }

    private void flush(int nvalues) throws IOException {
        this.bulkOperation.set(this.nextBlocks, 0, this.nextValues, 0, this.iterations);
        int blocks = this.format.nblocks(this.bitsPerValue, nvalues);
        for (int i = 0; i < blocks; ++i) {
            this.out.writeLong(this.nextBlocks[i]);
        }
        this.off = 0;
    }

    @Override
    public int ord() {
        return this.written - 1;
    }
}

