/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.EOFException;
import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.LongsRef;
import org.apache.lucene.util.packed.BulkOperation;
import org.apache.lucene.util.packed.PackedInts;

final class PackedReaderIterator
extends PackedInts.ReaderIteratorImpl {
    final PackedInts.Format format;
    final BulkOperation bulkOperation;
    final long[] nextBlocks;
    final LongsRef nextValues;
    final int iterations;
    int position;

    PackedReaderIterator(PackedInts.Format format, int valueCount, int bitsPerValue, DataInput in, int mem) {
        super(valueCount, bitsPerValue, in);
        this.format = format;
        this.bulkOperation = BulkOperation.of(format, bitsPerValue);
        this.iterations = this.bulkOperation.computeIterations(valueCount, mem);
        assert (this.iterations > 0);
        this.nextBlocks = new long[this.iterations * this.bulkOperation.blocks()];
        this.nextValues = new LongsRef(new long[this.iterations * this.bulkOperation.values()], 0, 0);
        assert (this.iterations * this.bulkOperation.values() == this.nextValues.longs.length);
        assert (this.iterations * this.bulkOperation.blocks() == this.nextBlocks.length);
        this.nextValues.offset = this.nextValues.longs.length;
        this.position = -1;
    }

    @Override
    public LongsRef next(int count) throws IOException {
        assert (this.nextValues.length >= 0);
        assert (count > 0);
        assert (this.nextValues.offset + this.nextValues.length <= this.nextValues.longs.length);
        this.nextValues.offset += this.nextValues.length;
        int remaining = this.valueCount - this.position - 1;
        if (remaining <= 0) {
            throw new EOFException();
        }
        count = Math.min(remaining, count);
        if (this.nextValues.offset == this.nextValues.longs.length) {
            int i;
            int remainingBlocks = this.format.nblocks(this.bitsPerValue, remaining);
            int blocksToRead = Math.min(remainingBlocks, this.nextBlocks.length);
            for (i = 0; i < blocksToRead; ++i) {
                this.nextBlocks[i] = this.in.readLong();
            }
            for (i = blocksToRead; i < this.nextBlocks.length; ++i) {
                this.nextBlocks[i] = 0L;
            }
            this.bulkOperation.get(this.nextBlocks, 0, this.nextValues.longs, 0, this.iterations);
            this.nextValues.offset = 0;
        }
        this.nextValues.length = Math.min(this.nextValues.longs.length - this.nextValues.offset, count);
        this.position += this.nextValues.length;
        return this.nextValues;
    }

    @Override
    public int ord() {
        return this.position;
    }
}

