/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.util.EnumMap;
import org.apache.lucene.util.packed.PackedInts;

abstract class BulkOperation {
    static final EnumMap<PackedInts.Format, BulkOperation[]> BULK_OPERATIONS = new EnumMap(PackedInts.Format.class);

    BulkOperation() {
    }

    public static BulkOperation of(PackedInts.Format format, int bitsPerValue) {
        assert (bitsPerValue > 0 && bitsPerValue <= 64);
        BulkOperation[] ops = BULK_OPERATIONS.get((Object)format);
        if (ops == null || ops[bitsPerValue] == null) {
            throw new IllegalArgumentException("format: " + (Object)((Object)format) + ", bitsPerValue: " + bitsPerValue);
        }
        return ops[bitsPerValue];
    }

    public final int computeIterations(int valueCount, int ramBudget) {
        int iterations = (ramBudget >>> 3) / (this.blocks() + this.values());
        if (iterations == 0) {
            return 1;
        }
        if ((iterations - 1) * this.blocks() >= valueCount) {
            return (int)Math.ceil((double)valueCount / (double)this.values());
        }
        return iterations;
    }

    public abstract int blocks();

    public abstract int values();

    public abstract void get(long[] var1, int var2, long[] var3, int var4, int var5);

    public abstract void set(long[] var1, int var2, long[] var3, int var4, int var5);

    static {
        BULK_OPERATIONS.put(PackedInts.Format.PACKED, new BulkOperation[65]);
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[1] = new Packed64BulkOperation1();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[2] = new Packed64BulkOperation2();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[3] = new Packed64BulkOperation3();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[4] = new Packed64BulkOperation4();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[5] = new Packed64BulkOperation5();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[6] = new Packed64BulkOperation6();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[7] = new Packed64BulkOperation7();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[8] = new Packed64BulkOperation8();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[9] = new Packed64BulkOperation9();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[10] = new Packed64BulkOperation10();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[11] = new Packed64BulkOperation11();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[12] = new Packed64BulkOperation12();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[13] = new Packed64BulkOperation13();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[14] = new Packed64BulkOperation14();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[15] = new Packed64BulkOperation15();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[16] = new Packed64BulkOperation16();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[17] = new Packed64BulkOperation17();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[18] = new Packed64BulkOperation18();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[19] = new Packed64BulkOperation19();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[20] = new Packed64BulkOperation20();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[21] = new Packed64BulkOperation21();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[22] = new Packed64BulkOperation22();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[23] = new Packed64BulkOperation23();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[24] = new Packed64BulkOperation24();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[25] = new Packed64BulkOperation25();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[26] = new Packed64BulkOperation26();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[27] = new Packed64BulkOperation27();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[28] = new Packed64BulkOperation28();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[29] = new Packed64BulkOperation29();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[30] = new Packed64BulkOperation30();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[31] = new Packed64BulkOperation31();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[32] = new Packed64BulkOperation32();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[33] = new Packed64BulkOperation33();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[34] = new Packed64BulkOperation34();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[35] = new Packed64BulkOperation35();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[36] = new Packed64BulkOperation36();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[37] = new Packed64BulkOperation37();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[38] = new Packed64BulkOperation38();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[39] = new Packed64BulkOperation39();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[40] = new Packed64BulkOperation40();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[41] = new Packed64BulkOperation41();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[42] = new Packed64BulkOperation42();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[43] = new Packed64BulkOperation43();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[44] = new Packed64BulkOperation44();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[45] = new Packed64BulkOperation45();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[46] = new Packed64BulkOperation46();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[47] = new Packed64BulkOperation47();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[48] = new Packed64BulkOperation48();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[49] = new Packed64BulkOperation49();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[50] = new Packed64BulkOperation50();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[51] = new Packed64BulkOperation51();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[52] = new Packed64BulkOperation52();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[53] = new Packed64BulkOperation53();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[54] = new Packed64BulkOperation54();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[55] = new Packed64BulkOperation55();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[56] = new Packed64BulkOperation56();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[57] = new Packed64BulkOperation57();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[58] = new Packed64BulkOperation58();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[59] = new Packed64BulkOperation59();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[60] = new Packed64BulkOperation60();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[61] = new Packed64BulkOperation61();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[62] = new Packed64BulkOperation62();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[63] = new Packed64BulkOperation63();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED))[64] = new Packed64BulkOperation64();
        BULK_OPERATIONS.put(PackedInts.Format.PACKED_SINGLE_BLOCK, new BulkOperation[65]);
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED_SINGLE_BLOCK))[1] = new Packed64SingleBlockBulkOperation1();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED_SINGLE_BLOCK))[2] = new Packed64SingleBlockBulkOperation2();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED_SINGLE_BLOCK))[3] = new Packed64SingleBlockBulkOperation3();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED_SINGLE_BLOCK))[4] = new Packed64SingleBlockBulkOperation4();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED_SINGLE_BLOCK))[5] = new Packed64SingleBlockBulkOperation5();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED_SINGLE_BLOCK))[6] = new Packed64SingleBlockBulkOperation6();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED_SINGLE_BLOCK))[7] = new Packed64SingleBlockBulkOperation7();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED_SINGLE_BLOCK))[8] = new Packed64SingleBlockBulkOperation8();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED_SINGLE_BLOCK))[9] = new Packed64SingleBlockBulkOperation9();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED_SINGLE_BLOCK))[10] = new Packed64SingleBlockBulkOperation10();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED_SINGLE_BLOCK))[12] = new Packed64SingleBlockBulkOperation12();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED_SINGLE_BLOCK))[16] = new Packed64SingleBlockBulkOperation16();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED_SINGLE_BLOCK))[21] = new Packed64SingleBlockBulkOperation21();
        BulkOperation.BULK_OPERATIONS.get((Object)((Object)PackedInts.Format.PACKED_SINGLE_BLOCK))[32] = new Packed64SingleBlockBulkOperation32();
    }

    static final class Packed64SingleBlockBulkOperation32
    extends BulkOperation {
        Packed64SingleBlockBulkOperation32() {
        }

        @Override
        public int blocks() {
            return 1;
        }

        @Override
        public int values() {
            return 2;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block = blocks[bi++];
                values[vi++] = block & 0xFFFFFFFFL;
                values[vi++] = block >>> 32;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] | values[vi++] << 32;
            }
        }
    }

    static final class Packed64SingleBlockBulkOperation21
    extends BulkOperation {
        Packed64SingleBlockBulkOperation21() {
        }

        @Override
        public int blocks() {
            return 1;
        }

        @Override
        public int values() {
            return 3;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block = blocks[bi++];
                values[vi++] = block & 0x1FFFFFL;
                values[vi++] = block >>> 21 & 0x1FFFFFL;
                values[vi++] = block >>> 42;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] | values[vi++] << 21 | values[vi++] << 42;
            }
        }
    }

    static final class Packed64SingleBlockBulkOperation16
    extends BulkOperation {
        Packed64SingleBlockBulkOperation16() {
        }

        @Override
        public int blocks() {
            return 1;
        }

        @Override
        public int values() {
            return 4;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block = blocks[bi++];
                values[vi++] = block & 0xFFFFL;
                values[vi++] = block >>> 16 & 0xFFFFL;
                values[vi++] = block >>> 32 & 0xFFFFL;
                values[vi++] = block >>> 48;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] | values[vi++] << 16 | values[vi++] << 32 | values[vi++] << 48;
            }
        }
    }

    static final class Packed64SingleBlockBulkOperation12
    extends BulkOperation {
        Packed64SingleBlockBulkOperation12() {
        }

        @Override
        public int blocks() {
            return 1;
        }

        @Override
        public int values() {
            return 5;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block = blocks[bi++];
                values[vi++] = block & 0xFFFL;
                values[vi++] = block >>> 12 & 0xFFFL;
                values[vi++] = block >>> 24 & 0xFFFL;
                values[vi++] = block >>> 36 & 0xFFFL;
                values[vi++] = block >>> 48;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] | values[vi++] << 12 | values[vi++] << 24 | values[vi++] << 36 | values[vi++] << 48;
            }
        }
    }

    static final class Packed64SingleBlockBulkOperation10
    extends BulkOperation {
        Packed64SingleBlockBulkOperation10() {
        }

        @Override
        public int blocks() {
            return 1;
        }

        @Override
        public int values() {
            return 6;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block = blocks[bi++];
                values[vi++] = block & 0x3FFL;
                values[vi++] = block >>> 10 & 0x3FFL;
                values[vi++] = block >>> 20 & 0x3FFL;
                values[vi++] = block >>> 30 & 0x3FFL;
                values[vi++] = block >>> 40 & 0x3FFL;
                values[vi++] = block >>> 50;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] | values[vi++] << 10 | values[vi++] << 20 | values[vi++] << 30 | values[vi++] << 40 | values[vi++] << 50;
            }
        }
    }

    static final class Packed64SingleBlockBulkOperation9
    extends BulkOperation {
        Packed64SingleBlockBulkOperation9() {
        }

        @Override
        public int blocks() {
            return 1;
        }

        @Override
        public int values() {
            return 7;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block = blocks[bi++];
                values[vi++] = block & 0x1FFL;
                values[vi++] = block >>> 9 & 0x1FFL;
                values[vi++] = block >>> 18 & 0x1FFL;
                values[vi++] = block >>> 27 & 0x1FFL;
                values[vi++] = block >>> 36 & 0x1FFL;
                values[vi++] = block >>> 45 & 0x1FFL;
                values[vi++] = block >>> 54;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] | values[vi++] << 9 | values[vi++] << 18 | values[vi++] << 27 | values[vi++] << 36 | values[vi++] << 45 | values[vi++] << 54;
            }
        }
    }

    static final class Packed64SingleBlockBulkOperation8
    extends BulkOperation {
        Packed64SingleBlockBulkOperation8() {
        }

        @Override
        public int blocks() {
            return 1;
        }

        @Override
        public int values() {
            return 8;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block = blocks[bi++];
                values[vi++] = block & 0xFFL;
                values[vi++] = block >>> 8 & 0xFFL;
                values[vi++] = block >>> 16 & 0xFFL;
                values[vi++] = block >>> 24 & 0xFFL;
                values[vi++] = block >>> 32 & 0xFFL;
                values[vi++] = block >>> 40 & 0xFFL;
                values[vi++] = block >>> 48 & 0xFFL;
                values[vi++] = block >>> 56;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] | values[vi++] << 8 | values[vi++] << 16 | values[vi++] << 24 | values[vi++] << 32 | values[vi++] << 40 | values[vi++] << 48 | values[vi++] << 56;
            }
        }
    }

    static final class Packed64SingleBlockBulkOperation7
    extends BulkOperation {
        Packed64SingleBlockBulkOperation7() {
        }

        @Override
        public int blocks() {
            return 1;
        }

        @Override
        public int values() {
            return 9;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block = blocks[bi++];
                values[vi++] = block & 0x7FL;
                values[vi++] = block >>> 7 & 0x7FL;
                values[vi++] = block >>> 14 & 0x7FL;
                values[vi++] = block >>> 21 & 0x7FL;
                values[vi++] = block >>> 28 & 0x7FL;
                values[vi++] = block >>> 35 & 0x7FL;
                values[vi++] = block >>> 42 & 0x7FL;
                values[vi++] = block >>> 49 & 0x7FL;
                values[vi++] = block >>> 56;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] | values[vi++] << 7 | values[vi++] << 14 | values[vi++] << 21 | values[vi++] << 28 | values[vi++] << 35 | values[vi++] << 42 | values[vi++] << 49 | values[vi++] << 56;
            }
        }
    }

    static final class Packed64SingleBlockBulkOperation6
    extends BulkOperation {
        Packed64SingleBlockBulkOperation6() {
        }

        @Override
        public int blocks() {
            return 1;
        }

        @Override
        public int values() {
            return 10;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block = blocks[bi++];
                values[vi++] = block & 0x3FL;
                values[vi++] = block >>> 6 & 0x3FL;
                values[vi++] = block >>> 12 & 0x3FL;
                values[vi++] = block >>> 18 & 0x3FL;
                values[vi++] = block >>> 24 & 0x3FL;
                values[vi++] = block >>> 30 & 0x3FL;
                values[vi++] = block >>> 36 & 0x3FL;
                values[vi++] = block >>> 42 & 0x3FL;
                values[vi++] = block >>> 48 & 0x3FL;
                values[vi++] = block >>> 54;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] | values[vi++] << 6 | values[vi++] << 12 | values[vi++] << 18 | values[vi++] << 24 | values[vi++] << 30 | values[vi++] << 36 | values[vi++] << 42 | values[vi++] << 48 | values[vi++] << 54;
            }
        }
    }

    static final class Packed64SingleBlockBulkOperation5
    extends BulkOperation {
        Packed64SingleBlockBulkOperation5() {
        }

        @Override
        public int blocks() {
            return 1;
        }

        @Override
        public int values() {
            return 12;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block = blocks[bi++];
                values[vi++] = block & 0x1FL;
                values[vi++] = block >>> 5 & 0x1FL;
                values[vi++] = block >>> 10 & 0x1FL;
                values[vi++] = block >>> 15 & 0x1FL;
                values[vi++] = block >>> 20 & 0x1FL;
                values[vi++] = block >>> 25 & 0x1FL;
                values[vi++] = block >>> 30 & 0x1FL;
                values[vi++] = block >>> 35 & 0x1FL;
                values[vi++] = block >>> 40 & 0x1FL;
                values[vi++] = block >>> 45 & 0x1FL;
                values[vi++] = block >>> 50 & 0x1FL;
                values[vi++] = block >>> 55;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] | values[vi++] << 5 | values[vi++] << 10 | values[vi++] << 15 | values[vi++] << 20 | values[vi++] << 25 | values[vi++] << 30 | values[vi++] << 35 | values[vi++] << 40 | values[vi++] << 45 | values[vi++] << 50 | values[vi++] << 55;
            }
        }
    }

    static final class Packed64SingleBlockBulkOperation4
    extends BulkOperation {
        Packed64SingleBlockBulkOperation4() {
        }

        @Override
        public int blocks() {
            return 1;
        }

        @Override
        public int values() {
            return 16;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block = blocks[bi++];
                values[vi++] = block & 0xFL;
                values[vi++] = block >>> 4 & 0xFL;
                values[vi++] = block >>> 8 & 0xFL;
                values[vi++] = block >>> 12 & 0xFL;
                values[vi++] = block >>> 16 & 0xFL;
                values[vi++] = block >>> 20 & 0xFL;
                values[vi++] = block >>> 24 & 0xFL;
                values[vi++] = block >>> 28 & 0xFL;
                values[vi++] = block >>> 32 & 0xFL;
                values[vi++] = block >>> 36 & 0xFL;
                values[vi++] = block >>> 40 & 0xFL;
                values[vi++] = block >>> 44 & 0xFL;
                values[vi++] = block >>> 48 & 0xFL;
                values[vi++] = block >>> 52 & 0xFL;
                values[vi++] = block >>> 56 & 0xFL;
                values[vi++] = block >>> 60;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] | values[vi++] << 4 | values[vi++] << 8 | values[vi++] << 12 | values[vi++] << 16 | values[vi++] << 20 | values[vi++] << 24 | values[vi++] << 28 | values[vi++] << 32 | values[vi++] << 36 | values[vi++] << 40 | values[vi++] << 44 | values[vi++] << 48 | values[vi++] << 52 | values[vi++] << 56 | values[vi++] << 60;
            }
        }
    }

    static final class Packed64SingleBlockBulkOperation3
    extends BulkOperation {
        Packed64SingleBlockBulkOperation3() {
        }

        @Override
        public int blocks() {
            return 1;
        }

        @Override
        public int values() {
            return 21;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block = blocks[bi++];
                values[vi++] = block & 7L;
                values[vi++] = block >>> 3 & 7L;
                values[vi++] = block >>> 6 & 7L;
                values[vi++] = block >>> 9 & 7L;
                values[vi++] = block >>> 12 & 7L;
                values[vi++] = block >>> 15 & 7L;
                values[vi++] = block >>> 18 & 7L;
                values[vi++] = block >>> 21 & 7L;
                values[vi++] = block >>> 24 & 7L;
                values[vi++] = block >>> 27 & 7L;
                values[vi++] = block >>> 30 & 7L;
                values[vi++] = block >>> 33 & 7L;
                values[vi++] = block >>> 36 & 7L;
                values[vi++] = block >>> 39 & 7L;
                values[vi++] = block >>> 42 & 7L;
                values[vi++] = block >>> 45 & 7L;
                values[vi++] = block >>> 48 & 7L;
                values[vi++] = block >>> 51 & 7L;
                values[vi++] = block >>> 54 & 7L;
                values[vi++] = block >>> 57 & 7L;
                values[vi++] = block >>> 60;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] | values[vi++] << 3 | values[vi++] << 6 | values[vi++] << 9 | values[vi++] << 12 | values[vi++] << 15 | values[vi++] << 18 | values[vi++] << 21 | values[vi++] << 24 | values[vi++] << 27 | values[vi++] << 30 | values[vi++] << 33 | values[vi++] << 36 | values[vi++] << 39 | values[vi++] << 42 | values[vi++] << 45 | values[vi++] << 48 | values[vi++] << 51 | values[vi++] << 54 | values[vi++] << 57 | values[vi++] << 60;
            }
        }
    }

    static final class Packed64SingleBlockBulkOperation2
    extends BulkOperation {
        Packed64SingleBlockBulkOperation2() {
        }

        @Override
        public int blocks() {
            return 1;
        }

        @Override
        public int values() {
            return 32;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block = blocks[bi++];
                values[vi++] = block & 3L;
                values[vi++] = block >>> 2 & 3L;
                values[vi++] = block >>> 4 & 3L;
                values[vi++] = block >>> 6 & 3L;
                values[vi++] = block >>> 8 & 3L;
                values[vi++] = block >>> 10 & 3L;
                values[vi++] = block >>> 12 & 3L;
                values[vi++] = block >>> 14 & 3L;
                values[vi++] = block >>> 16 & 3L;
                values[vi++] = block >>> 18 & 3L;
                values[vi++] = block >>> 20 & 3L;
                values[vi++] = block >>> 22 & 3L;
                values[vi++] = block >>> 24 & 3L;
                values[vi++] = block >>> 26 & 3L;
                values[vi++] = block >>> 28 & 3L;
                values[vi++] = block >>> 30 & 3L;
                values[vi++] = block >>> 32 & 3L;
                values[vi++] = block >>> 34 & 3L;
                values[vi++] = block >>> 36 & 3L;
                values[vi++] = block >>> 38 & 3L;
                values[vi++] = block >>> 40 & 3L;
                values[vi++] = block >>> 42 & 3L;
                values[vi++] = block >>> 44 & 3L;
                values[vi++] = block >>> 46 & 3L;
                values[vi++] = block >>> 48 & 3L;
                values[vi++] = block >>> 50 & 3L;
                values[vi++] = block >>> 52 & 3L;
                values[vi++] = block >>> 54 & 3L;
                values[vi++] = block >>> 56 & 3L;
                values[vi++] = block >>> 58 & 3L;
                values[vi++] = block >>> 60 & 3L;
                values[vi++] = block >>> 62;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] | values[vi++] << 2 | values[vi++] << 4 | values[vi++] << 6 | values[vi++] << 8 | values[vi++] << 10 | values[vi++] << 12 | values[vi++] << 14 | values[vi++] << 16 | values[vi++] << 18 | values[vi++] << 20 | values[vi++] << 22 | values[vi++] << 24 | values[vi++] << 26 | values[vi++] << 28 | values[vi++] << 30 | values[vi++] << 32 | values[vi++] << 34 | values[vi++] << 36 | values[vi++] << 38 | values[vi++] << 40 | values[vi++] << 42 | values[vi++] << 44 | values[vi++] << 46 | values[vi++] << 48 | values[vi++] << 50 | values[vi++] << 52 | values[vi++] << 54 | values[vi++] << 56 | values[vi++] << 58 | values[vi++] << 60 | values[vi++] << 62;
            }
        }
    }

    static final class Packed64SingleBlockBulkOperation1
    extends BulkOperation {
        Packed64SingleBlockBulkOperation1() {
        }

        @Override
        public int blocks() {
            return 1;
        }

        @Override
        public int values() {
            return 64;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block = blocks[bi++];
                values[vi++] = block & 1L;
                values[vi++] = block >>> 1 & 1L;
                values[vi++] = block >>> 2 & 1L;
                values[vi++] = block >>> 3 & 1L;
                values[vi++] = block >>> 4 & 1L;
                values[vi++] = block >>> 5 & 1L;
                values[vi++] = block >>> 6 & 1L;
                values[vi++] = block >>> 7 & 1L;
                values[vi++] = block >>> 8 & 1L;
                values[vi++] = block >>> 9 & 1L;
                values[vi++] = block >>> 10 & 1L;
                values[vi++] = block >>> 11 & 1L;
                values[vi++] = block >>> 12 & 1L;
                values[vi++] = block >>> 13 & 1L;
                values[vi++] = block >>> 14 & 1L;
                values[vi++] = block >>> 15 & 1L;
                values[vi++] = block >>> 16 & 1L;
                values[vi++] = block >>> 17 & 1L;
                values[vi++] = block >>> 18 & 1L;
                values[vi++] = block >>> 19 & 1L;
                values[vi++] = block >>> 20 & 1L;
                values[vi++] = block >>> 21 & 1L;
                values[vi++] = block >>> 22 & 1L;
                values[vi++] = block >>> 23 & 1L;
                values[vi++] = block >>> 24 & 1L;
                values[vi++] = block >>> 25 & 1L;
                values[vi++] = block >>> 26 & 1L;
                values[vi++] = block >>> 27 & 1L;
                values[vi++] = block >>> 28 & 1L;
                values[vi++] = block >>> 29 & 1L;
                values[vi++] = block >>> 30 & 1L;
                values[vi++] = block >>> 31 & 1L;
                values[vi++] = block >>> 32 & 1L;
                values[vi++] = block >>> 33 & 1L;
                values[vi++] = block >>> 34 & 1L;
                values[vi++] = block >>> 35 & 1L;
                values[vi++] = block >>> 36 & 1L;
                values[vi++] = block >>> 37 & 1L;
                values[vi++] = block >>> 38 & 1L;
                values[vi++] = block >>> 39 & 1L;
                values[vi++] = block >>> 40 & 1L;
                values[vi++] = block >>> 41 & 1L;
                values[vi++] = block >>> 42 & 1L;
                values[vi++] = block >>> 43 & 1L;
                values[vi++] = block >>> 44 & 1L;
                values[vi++] = block >>> 45 & 1L;
                values[vi++] = block >>> 46 & 1L;
                values[vi++] = block >>> 47 & 1L;
                values[vi++] = block >>> 48 & 1L;
                values[vi++] = block >>> 49 & 1L;
                values[vi++] = block >>> 50 & 1L;
                values[vi++] = block >>> 51 & 1L;
                values[vi++] = block >>> 52 & 1L;
                values[vi++] = block >>> 53 & 1L;
                values[vi++] = block >>> 54 & 1L;
                values[vi++] = block >>> 55 & 1L;
                values[vi++] = block >>> 56 & 1L;
                values[vi++] = block >>> 57 & 1L;
                values[vi++] = block >>> 58 & 1L;
                values[vi++] = block >>> 59 & 1L;
                values[vi++] = block >>> 60 & 1L;
                values[vi++] = block >>> 61 & 1L;
                values[vi++] = block >>> 62 & 1L;
                values[vi++] = block >>> 63;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] | values[vi++] << 1 | values[vi++] << 2 | values[vi++] << 3 | values[vi++] << 4 | values[vi++] << 5 | values[vi++] << 6 | values[vi++] << 7 | values[vi++] << 8 | values[vi++] << 9 | values[vi++] << 10 | values[vi++] << 11 | values[vi++] << 12 | values[vi++] << 13 | values[vi++] << 14 | values[vi++] << 15 | values[vi++] << 16 | values[vi++] << 17 | values[vi++] << 18 | values[vi++] << 19 | values[vi++] << 20 | values[vi++] << 21 | values[vi++] << 22 | values[vi++] << 23 | values[vi++] << 24 | values[vi++] << 25 | values[vi++] << 26 | values[vi++] << 27 | values[vi++] << 28 | values[vi++] << 29 | values[vi++] << 30 | values[vi++] << 31 | values[vi++] << 32 | values[vi++] << 33 | values[vi++] << 34 | values[vi++] << 35 | values[vi++] << 36 | values[vi++] << 37 | values[vi++] << 38 | values[vi++] << 39 | values[vi++] << 40 | values[vi++] << 41 | values[vi++] << 42 | values[vi++] << 43 | values[vi++] << 44 | values[vi++] << 45 | values[vi++] << 46 | values[vi++] << 47 | values[vi++] << 48 | values[vi++] << 49 | values[vi++] << 50 | values[vi++] << 51 | values[vi++] << 52 | values[vi++] << 53 | values[vi++] << 54 | values[vi++] << 55 | values[vi++] << 56 | values[vi++] << 57 | values[vi++] << 58 | values[vi++] << 59 | values[vi++] << 60 | values[vi++] << 61 | values[vi++] << 62 | values[vi++] << 63;
            }
        }
    }

    static final class Packed64BulkOperation64
    extends BulkOperation {
        Packed64BulkOperation64() {
        }

        @Override
        public int blocks() {
            return 1;
        }

        @Override
        public int values() {
            return 1;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            System.arraycopy(blocks, bi, values, vi, iterations);
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            System.arraycopy(values, bi, blocks, vi, iterations);
        }
    }

    static final class Packed64BulkOperation63
    extends BulkOperation {
        Packed64BulkOperation63() {
        }

        @Override
        public int blocks() {
            return 63;
        }

        @Override
        public int values() {
            return 64;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 1;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 1L) << 62 | block1 >>> 2;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 3L) << 61 | block2 >>> 3;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 7L) << 60 | block3 >>> 4;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0xFL) << 59 | block4 >>> 5;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0x1FL) << 58 | block5 >>> 6;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0x3FL) << 57 | block6 >>> 7;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0x7FL) << 56 | block7 >>> 8;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0xFFL) << 55 | block8 >>> 9;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0x1FFL) << 54 | block9 >>> 10;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 0x3FFL) << 53 | block10 >>> 11;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 0x7FFL) << 52 | block11 >>> 12;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 0xFFFL) << 51 | block12 >>> 13;
                long block13 = blocks[bi++];
                values[vi++] = (block12 & 0x1FFFL) << 50 | block13 >>> 14;
                long block14 = blocks[bi++];
                values[vi++] = (block13 & 0x3FFFL) << 49 | block14 >>> 15;
                long block15 = blocks[bi++];
                values[vi++] = (block14 & 0x7FFFL) << 48 | block15 >>> 16;
                long block16 = blocks[bi++];
                values[vi++] = (block15 & 0xFFFFL) << 47 | block16 >>> 17;
                long block17 = blocks[bi++];
                values[vi++] = (block16 & 0x1FFFFL) << 46 | block17 >>> 18;
                long block18 = blocks[bi++];
                values[vi++] = (block17 & 0x3FFFFL) << 45 | block18 >>> 19;
                long block19 = blocks[bi++];
                values[vi++] = (block18 & 0x7FFFFL) << 44 | block19 >>> 20;
                long block20 = blocks[bi++];
                values[vi++] = (block19 & 0xFFFFFL) << 43 | block20 >>> 21;
                long block21 = blocks[bi++];
                values[vi++] = (block20 & 0x1FFFFFL) << 42 | block21 >>> 22;
                long block22 = blocks[bi++];
                values[vi++] = (block21 & 0x3FFFFFL) << 41 | block22 >>> 23;
                long block23 = blocks[bi++];
                values[vi++] = (block22 & 0x7FFFFFL) << 40 | block23 >>> 24;
                long block24 = blocks[bi++];
                values[vi++] = (block23 & 0xFFFFFFL) << 39 | block24 >>> 25;
                long block25 = blocks[bi++];
                values[vi++] = (block24 & 0x1FFFFFFL) << 38 | block25 >>> 26;
                long block26 = blocks[bi++];
                values[vi++] = (block25 & 0x3FFFFFFL) << 37 | block26 >>> 27;
                long block27 = blocks[bi++];
                values[vi++] = (block26 & 0x7FFFFFFL) << 36 | block27 >>> 28;
                long block28 = blocks[bi++];
                values[vi++] = (block27 & 0xFFFFFFFL) << 35 | block28 >>> 29;
                long block29 = blocks[bi++];
                values[vi++] = (block28 & 0x1FFFFFFFL) << 34 | block29 >>> 30;
                long block30 = blocks[bi++];
                values[vi++] = (block29 & 0x3FFFFFFFL) << 33 | block30 >>> 31;
                long block31 = blocks[bi++];
                values[vi++] = (block30 & Integer.MAX_VALUE) << 32 | block31 >>> 32;
                long block32 = blocks[bi++];
                values[vi++] = (block31 & 0xFFFFFFFFL) << 31 | block32 >>> 33;
                long block33 = blocks[bi++];
                values[vi++] = (block32 & 0x1FFFFFFFFL) << 30 | block33 >>> 34;
                long block34 = blocks[bi++];
                values[vi++] = (block33 & 0x3FFFFFFFFL) << 29 | block34 >>> 35;
                long block35 = blocks[bi++];
                values[vi++] = (block34 & 0x7FFFFFFFFL) << 28 | block35 >>> 36;
                long block36 = blocks[bi++];
                values[vi++] = (block35 & 0xFFFFFFFFFL) << 27 | block36 >>> 37;
                long block37 = blocks[bi++];
                values[vi++] = (block36 & 0x1FFFFFFFFFL) << 26 | block37 >>> 38;
                long block38 = blocks[bi++];
                values[vi++] = (block37 & 0x3FFFFFFFFFL) << 25 | block38 >>> 39;
                long block39 = blocks[bi++];
                values[vi++] = (block38 & 0x7FFFFFFFFFL) << 24 | block39 >>> 40;
                long block40 = blocks[bi++];
                values[vi++] = (block39 & 0xFFFFFFFFFFL) << 23 | block40 >>> 41;
                long block41 = blocks[bi++];
                values[vi++] = (block40 & 0x1FFFFFFFFFFL) << 22 | block41 >>> 42;
                long block42 = blocks[bi++];
                values[vi++] = (block41 & 0x3FFFFFFFFFFL) << 21 | block42 >>> 43;
                long block43 = blocks[bi++];
                values[vi++] = (block42 & 0x7FFFFFFFFFFL) << 20 | block43 >>> 44;
                long block44 = blocks[bi++];
                values[vi++] = (block43 & 0xFFFFFFFFFFFL) << 19 | block44 >>> 45;
                long block45 = blocks[bi++];
                values[vi++] = (block44 & 0x1FFFFFFFFFFFL) << 18 | block45 >>> 46;
                long block46 = blocks[bi++];
                values[vi++] = (block45 & 0x3FFFFFFFFFFFL) << 17 | block46 >>> 47;
                long block47 = blocks[bi++];
                values[vi++] = (block46 & 0x7FFFFFFFFFFFL) << 16 | block47 >>> 48;
                long block48 = blocks[bi++];
                values[vi++] = (block47 & 0xFFFFFFFFFFFFL) << 15 | block48 >>> 49;
                long block49 = blocks[bi++];
                values[vi++] = (block48 & 0x1FFFFFFFFFFFFL) << 14 | block49 >>> 50;
                long block50 = blocks[bi++];
                values[vi++] = (block49 & 0x3FFFFFFFFFFFFL) << 13 | block50 >>> 51;
                long block51 = blocks[bi++];
                values[vi++] = (block50 & 0x7FFFFFFFFFFFFL) << 12 | block51 >>> 52;
                long block52 = blocks[bi++];
                values[vi++] = (block51 & 0xFFFFFFFFFFFFFL) << 11 | block52 >>> 53;
                long block53 = blocks[bi++];
                values[vi++] = (block52 & 0x1FFFFFFFFFFFFFL) << 10 | block53 >>> 54;
                long block54 = blocks[bi++];
                values[vi++] = (block53 & 0x3FFFFFFFFFFFFFL) << 9 | block54 >>> 55;
                long block55 = blocks[bi++];
                values[vi++] = (block54 & 0x7FFFFFFFFFFFFFL) << 8 | block55 >>> 56;
                long block56 = blocks[bi++];
                values[vi++] = (block55 & 0xFFFFFFFFFFFFFFL) << 7 | block56 >>> 57;
                long block57 = blocks[bi++];
                values[vi++] = (block56 & 0x1FFFFFFFFFFFFFFL) << 6 | block57 >>> 58;
                long block58 = blocks[bi++];
                values[vi++] = (block57 & 0x3FFFFFFFFFFFFFFL) << 5 | block58 >>> 59;
                long block59 = blocks[bi++];
                values[vi++] = (block58 & 0x7FFFFFFFFFFFFFFL) << 4 | block59 >>> 60;
                long block60 = blocks[bi++];
                values[vi++] = (block59 & 0xFFFFFFFFFFFFFFFL) << 3 | block60 >>> 61;
                long block61 = blocks[bi++];
                values[vi++] = (block60 & 0x1FFFFFFFFFFFFFFFL) << 2 | block61 >>> 62;
                long block62 = blocks[bi++];
                values[vi++] = (block61 & 0x3FFFFFFFFFFFFFFFL) << 1 | block62 >>> 63;
                values[vi++] = block62 & Long.MAX_VALUE;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 1 | values[vi] >>> 62;
                blocks[bi++] = values[vi++] << 2 | values[vi] >>> 61;
                blocks[bi++] = values[vi++] << 3 | values[vi] >>> 60;
                blocks[bi++] = values[vi++] << 4 | values[vi] >>> 59;
                blocks[bi++] = values[vi++] << 5 | values[vi] >>> 58;
                blocks[bi++] = values[vi++] << 6 | values[vi] >>> 57;
                blocks[bi++] = values[vi++] << 7 | values[vi] >>> 56;
                blocks[bi++] = values[vi++] << 8 | values[vi] >>> 55;
                blocks[bi++] = values[vi++] << 9 | values[vi] >>> 54;
                blocks[bi++] = values[vi++] << 10 | values[vi] >>> 53;
                blocks[bi++] = values[vi++] << 11 | values[vi] >>> 52;
                blocks[bi++] = values[vi++] << 12 | values[vi] >>> 51;
                blocks[bi++] = values[vi++] << 13 | values[vi] >>> 50;
                blocks[bi++] = values[vi++] << 14 | values[vi] >>> 49;
                blocks[bi++] = values[vi++] << 15 | values[vi] >>> 48;
                blocks[bi++] = values[vi++] << 16 | values[vi] >>> 47;
                blocks[bi++] = values[vi++] << 17 | values[vi] >>> 46;
                blocks[bi++] = values[vi++] << 18 | values[vi] >>> 45;
                blocks[bi++] = values[vi++] << 19 | values[vi] >>> 44;
                blocks[bi++] = values[vi++] << 20 | values[vi] >>> 43;
                blocks[bi++] = values[vi++] << 21 | values[vi] >>> 42;
                blocks[bi++] = values[vi++] << 22 | values[vi] >>> 41;
                blocks[bi++] = values[vi++] << 23 | values[vi] >>> 40;
                blocks[bi++] = values[vi++] << 24 | values[vi] >>> 39;
                blocks[bi++] = values[vi++] << 25 | values[vi] >>> 38;
                blocks[bi++] = values[vi++] << 26 | values[vi] >>> 37;
                blocks[bi++] = values[vi++] << 27 | values[vi] >>> 36;
                blocks[bi++] = values[vi++] << 28 | values[vi] >>> 35;
                blocks[bi++] = values[vi++] << 29 | values[vi] >>> 34;
                blocks[bi++] = values[vi++] << 30 | values[vi] >>> 33;
                blocks[bi++] = values[vi++] << 31 | values[vi] >>> 32;
                blocks[bi++] = values[vi++] << 32 | values[vi] >>> 31;
                blocks[bi++] = values[vi++] << 33 | values[vi] >>> 30;
                blocks[bi++] = values[vi++] << 34 | values[vi] >>> 29;
                blocks[bi++] = values[vi++] << 35 | values[vi] >>> 28;
                blocks[bi++] = values[vi++] << 36 | values[vi] >>> 27;
                blocks[bi++] = values[vi++] << 37 | values[vi] >>> 26;
                blocks[bi++] = values[vi++] << 38 | values[vi] >>> 25;
                blocks[bi++] = values[vi++] << 39 | values[vi] >>> 24;
                blocks[bi++] = values[vi++] << 40 | values[vi] >>> 23;
                blocks[bi++] = values[vi++] << 41 | values[vi] >>> 22;
                blocks[bi++] = values[vi++] << 42 | values[vi] >>> 21;
                blocks[bi++] = values[vi++] << 43 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi] >>> 19;
                blocks[bi++] = values[vi++] << 45 | values[vi] >>> 18;
                blocks[bi++] = values[vi++] << 46 | values[vi] >>> 17;
                blocks[bi++] = values[vi++] << 47 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi] >>> 15;
                blocks[bi++] = values[vi++] << 49 | values[vi] >>> 14;
                blocks[bi++] = values[vi++] << 50 | values[vi] >>> 13;
                blocks[bi++] = values[vi++] << 51 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi] >>> 11;
                blocks[bi++] = values[vi++] << 53 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi] >>> 9;
                blocks[bi++] = values[vi++] << 55 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi] >>> 7;
                blocks[bi++] = values[vi++] << 57 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi] >>> 5;
                blocks[bi++] = values[vi++] << 59 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi] >>> 3;
                blocks[bi++] = values[vi++] << 61 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi] >>> 1;
                blocks[bi++] = values[vi++] << 63 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation62
    extends BulkOperation {
        Packed64BulkOperation62() {
        }

        @Override
        public int blocks() {
            return 31;
        }

        @Override
        public int values() {
            return 32;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 2;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 3L) << 60 | block1 >>> 4;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0xFL) << 58 | block2 >>> 6;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0x3FL) << 56 | block3 >>> 8;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0xFFL) << 54 | block4 >>> 10;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0x3FFL) << 52 | block5 >>> 12;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0xFFFL) << 50 | block6 >>> 14;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0x3FFFL) << 48 | block7 >>> 16;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0xFFFFL) << 46 | block8 >>> 18;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0x3FFFFL) << 44 | block9 >>> 20;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 0xFFFFFL) << 42 | block10 >>> 22;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 0x3FFFFFL) << 40 | block11 >>> 24;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 0xFFFFFFL) << 38 | block12 >>> 26;
                long block13 = blocks[bi++];
                values[vi++] = (block12 & 0x3FFFFFFL) << 36 | block13 >>> 28;
                long block14 = blocks[bi++];
                values[vi++] = (block13 & 0xFFFFFFFL) << 34 | block14 >>> 30;
                long block15 = blocks[bi++];
                values[vi++] = (block14 & 0x3FFFFFFFL) << 32 | block15 >>> 32;
                long block16 = blocks[bi++];
                values[vi++] = (block15 & 0xFFFFFFFFL) << 30 | block16 >>> 34;
                long block17 = blocks[bi++];
                values[vi++] = (block16 & 0x3FFFFFFFFL) << 28 | block17 >>> 36;
                long block18 = blocks[bi++];
                values[vi++] = (block17 & 0xFFFFFFFFFL) << 26 | block18 >>> 38;
                long block19 = blocks[bi++];
                values[vi++] = (block18 & 0x3FFFFFFFFFL) << 24 | block19 >>> 40;
                long block20 = blocks[bi++];
                values[vi++] = (block19 & 0xFFFFFFFFFFL) << 22 | block20 >>> 42;
                long block21 = blocks[bi++];
                values[vi++] = (block20 & 0x3FFFFFFFFFFL) << 20 | block21 >>> 44;
                long block22 = blocks[bi++];
                values[vi++] = (block21 & 0xFFFFFFFFFFFL) << 18 | block22 >>> 46;
                long block23 = blocks[bi++];
                values[vi++] = (block22 & 0x3FFFFFFFFFFFL) << 16 | block23 >>> 48;
                long block24 = blocks[bi++];
                values[vi++] = (block23 & 0xFFFFFFFFFFFFL) << 14 | block24 >>> 50;
                long block25 = blocks[bi++];
                values[vi++] = (block24 & 0x3FFFFFFFFFFFFL) << 12 | block25 >>> 52;
                long block26 = blocks[bi++];
                values[vi++] = (block25 & 0xFFFFFFFFFFFFFL) << 10 | block26 >>> 54;
                long block27 = blocks[bi++];
                values[vi++] = (block26 & 0x3FFFFFFFFFFFFFL) << 8 | block27 >>> 56;
                long block28 = blocks[bi++];
                values[vi++] = (block27 & 0xFFFFFFFFFFFFFFL) << 6 | block28 >>> 58;
                long block29 = blocks[bi++];
                values[vi++] = (block28 & 0x3FFFFFFFFFFFFFFL) << 4 | block29 >>> 60;
                long block30 = blocks[bi++];
                values[vi++] = (block29 & 0xFFFFFFFFFFFFFFFL) << 2 | block30 >>> 62;
                values[vi++] = block30 & 0x3FFFFFFFFFFFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 2 | values[vi] >>> 60;
                blocks[bi++] = values[vi++] << 4 | values[vi] >>> 58;
                blocks[bi++] = values[vi++] << 6 | values[vi] >>> 56;
                blocks[bi++] = values[vi++] << 8 | values[vi] >>> 54;
                blocks[bi++] = values[vi++] << 10 | values[vi] >>> 52;
                blocks[bi++] = values[vi++] << 12 | values[vi] >>> 50;
                blocks[bi++] = values[vi++] << 14 | values[vi] >>> 48;
                blocks[bi++] = values[vi++] << 16 | values[vi] >>> 46;
                blocks[bi++] = values[vi++] << 18 | values[vi] >>> 44;
                blocks[bi++] = values[vi++] << 20 | values[vi] >>> 42;
                blocks[bi++] = values[vi++] << 22 | values[vi] >>> 40;
                blocks[bi++] = values[vi++] << 24 | values[vi] >>> 38;
                blocks[bi++] = values[vi++] << 26 | values[vi] >>> 36;
                blocks[bi++] = values[vi++] << 28 | values[vi] >>> 34;
                blocks[bi++] = values[vi++] << 30 | values[vi] >>> 32;
                blocks[bi++] = values[vi++] << 32 | values[vi] >>> 30;
                blocks[bi++] = values[vi++] << 34 | values[vi] >>> 28;
                blocks[bi++] = values[vi++] << 36 | values[vi] >>> 26;
                blocks[bi++] = values[vi++] << 38 | values[vi] >>> 24;
                blocks[bi++] = values[vi++] << 40 | values[vi] >>> 22;
                blocks[bi++] = values[vi++] << 42 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi] >>> 18;
                blocks[bi++] = values[vi++] << 46 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi] >>> 14;
                blocks[bi++] = values[vi++] << 50 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation61
    extends BulkOperation {
        Packed64BulkOperation61() {
        }

        @Override
        public int blocks() {
            return 61;
        }

        @Override
        public int values() {
            return 64;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 3;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 7L) << 58 | block1 >>> 6;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0x3FL) << 55 | block2 >>> 9;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0x1FFL) << 52 | block3 >>> 12;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0xFFFL) << 49 | block4 >>> 15;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0x7FFFL) << 46 | block5 >>> 18;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0x3FFFFL) << 43 | block6 >>> 21;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0x1FFFFFL) << 40 | block7 >>> 24;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0xFFFFFFL) << 37 | block8 >>> 27;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0x7FFFFFFL) << 34 | block9 >>> 30;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 0x3FFFFFFFL) << 31 | block10 >>> 33;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 0x1FFFFFFFFL) << 28 | block11 >>> 36;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 0xFFFFFFFFFL) << 25 | block12 >>> 39;
                long block13 = blocks[bi++];
                values[vi++] = (block12 & 0x7FFFFFFFFFL) << 22 | block13 >>> 42;
                long block14 = blocks[bi++];
                values[vi++] = (block13 & 0x3FFFFFFFFFFL) << 19 | block14 >>> 45;
                long block15 = blocks[bi++];
                values[vi++] = (block14 & 0x1FFFFFFFFFFFL) << 16 | block15 >>> 48;
                long block16 = blocks[bi++];
                values[vi++] = (block15 & 0xFFFFFFFFFFFFL) << 13 | block16 >>> 51;
                long block17 = blocks[bi++];
                values[vi++] = (block16 & 0x7FFFFFFFFFFFFL) << 10 | block17 >>> 54;
                long block18 = blocks[bi++];
                values[vi++] = (block17 & 0x3FFFFFFFFFFFFFL) << 7 | block18 >>> 57;
                long block19 = blocks[bi++];
                values[vi++] = (block18 & 0x1FFFFFFFFFFFFFFL) << 4 | block19 >>> 60;
                long block20 = blocks[bi++];
                values[vi++] = (block19 & 0xFFFFFFFFFFFFFFFL) << 1 | block20 >>> 63;
                values[vi++] = block20 >>> 2 & 0x1FFFFFFFFFFFFFFFL;
                long block21 = blocks[bi++];
                values[vi++] = (block20 & 3L) << 59 | block21 >>> 5;
                long block22 = blocks[bi++];
                values[vi++] = (block21 & 0x1FL) << 56 | block22 >>> 8;
                long block23 = blocks[bi++];
                values[vi++] = (block22 & 0xFFL) << 53 | block23 >>> 11;
                long block24 = blocks[bi++];
                values[vi++] = (block23 & 0x7FFL) << 50 | block24 >>> 14;
                long block25 = blocks[bi++];
                values[vi++] = (block24 & 0x3FFFL) << 47 | block25 >>> 17;
                long block26 = blocks[bi++];
                values[vi++] = (block25 & 0x1FFFFL) << 44 | block26 >>> 20;
                long block27 = blocks[bi++];
                values[vi++] = (block26 & 0xFFFFFL) << 41 | block27 >>> 23;
                long block28 = blocks[bi++];
                values[vi++] = (block27 & 0x7FFFFFL) << 38 | block28 >>> 26;
                long block29 = blocks[bi++];
                values[vi++] = (block28 & 0x3FFFFFFL) << 35 | block29 >>> 29;
                long block30 = blocks[bi++];
                values[vi++] = (block29 & 0x1FFFFFFFL) << 32 | block30 >>> 32;
                long block31 = blocks[bi++];
                values[vi++] = (block30 & 0xFFFFFFFFL) << 29 | block31 >>> 35;
                long block32 = blocks[bi++];
                values[vi++] = (block31 & 0x7FFFFFFFFL) << 26 | block32 >>> 38;
                long block33 = blocks[bi++];
                values[vi++] = (block32 & 0x3FFFFFFFFFL) << 23 | block33 >>> 41;
                long block34 = blocks[bi++];
                values[vi++] = (block33 & 0x1FFFFFFFFFFL) << 20 | block34 >>> 44;
                long block35 = blocks[bi++];
                values[vi++] = (block34 & 0xFFFFFFFFFFFL) << 17 | block35 >>> 47;
                long block36 = blocks[bi++];
                values[vi++] = (block35 & 0x7FFFFFFFFFFFL) << 14 | block36 >>> 50;
                long block37 = blocks[bi++];
                values[vi++] = (block36 & 0x3FFFFFFFFFFFFL) << 11 | block37 >>> 53;
                long block38 = blocks[bi++];
                values[vi++] = (block37 & 0x1FFFFFFFFFFFFFL) << 8 | block38 >>> 56;
                long block39 = blocks[bi++];
                values[vi++] = (block38 & 0xFFFFFFFFFFFFFFL) << 5 | block39 >>> 59;
                long block40 = blocks[bi++];
                values[vi++] = (block39 & 0x7FFFFFFFFFFFFFFL) << 2 | block40 >>> 62;
                values[vi++] = block40 >>> 1 & 0x1FFFFFFFFFFFFFFFL;
                long block41 = blocks[bi++];
                values[vi++] = (block40 & 1L) << 60 | block41 >>> 4;
                long block42 = blocks[bi++];
                values[vi++] = (block41 & 0xFL) << 57 | block42 >>> 7;
                long block43 = blocks[bi++];
                values[vi++] = (block42 & 0x7FL) << 54 | block43 >>> 10;
                long block44 = blocks[bi++];
                values[vi++] = (block43 & 0x3FFL) << 51 | block44 >>> 13;
                long block45 = blocks[bi++];
                values[vi++] = (block44 & 0x1FFFL) << 48 | block45 >>> 16;
                long block46 = blocks[bi++];
                values[vi++] = (block45 & 0xFFFFL) << 45 | block46 >>> 19;
                long block47 = blocks[bi++];
                values[vi++] = (block46 & 0x7FFFFL) << 42 | block47 >>> 22;
                long block48 = blocks[bi++];
                values[vi++] = (block47 & 0x3FFFFFL) << 39 | block48 >>> 25;
                long block49 = blocks[bi++];
                values[vi++] = (block48 & 0x1FFFFFFL) << 36 | block49 >>> 28;
                long block50 = blocks[bi++];
                values[vi++] = (block49 & 0xFFFFFFFL) << 33 | block50 >>> 31;
                long block51 = blocks[bi++];
                values[vi++] = (block50 & Integer.MAX_VALUE) << 30 | block51 >>> 34;
                long block52 = blocks[bi++];
                values[vi++] = (block51 & 0x3FFFFFFFFL) << 27 | block52 >>> 37;
                long block53 = blocks[bi++];
                values[vi++] = (block52 & 0x1FFFFFFFFFL) << 24 | block53 >>> 40;
                long block54 = blocks[bi++];
                values[vi++] = (block53 & 0xFFFFFFFFFFL) << 21 | block54 >>> 43;
                long block55 = blocks[bi++];
                values[vi++] = (block54 & 0x7FFFFFFFFFFL) << 18 | block55 >>> 46;
                long block56 = blocks[bi++];
                values[vi++] = (block55 & 0x3FFFFFFFFFFFL) << 15 | block56 >>> 49;
                long block57 = blocks[bi++];
                values[vi++] = (block56 & 0x1FFFFFFFFFFFFL) << 12 | block57 >>> 52;
                long block58 = blocks[bi++];
                values[vi++] = (block57 & 0xFFFFFFFFFFFFFL) << 9 | block58 >>> 55;
                long block59 = blocks[bi++];
                values[vi++] = (block58 & 0x7FFFFFFFFFFFFFL) << 6 | block59 >>> 58;
                long block60 = blocks[bi++];
                values[vi++] = (block59 & 0x3FFFFFFFFFFFFFFL) << 3 | block60 >>> 61;
                values[vi++] = block60 & 0x1FFFFFFFFFFFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 3 | values[vi] >>> 58;
                blocks[bi++] = values[vi++] << 6 | values[vi] >>> 55;
                blocks[bi++] = values[vi++] << 9 | values[vi] >>> 52;
                blocks[bi++] = values[vi++] << 12 | values[vi] >>> 49;
                blocks[bi++] = values[vi++] << 15 | values[vi] >>> 46;
                blocks[bi++] = values[vi++] << 18 | values[vi] >>> 43;
                blocks[bi++] = values[vi++] << 21 | values[vi] >>> 40;
                blocks[bi++] = values[vi++] << 24 | values[vi] >>> 37;
                blocks[bi++] = values[vi++] << 27 | values[vi] >>> 34;
                blocks[bi++] = values[vi++] << 30 | values[vi] >>> 31;
                blocks[bi++] = values[vi++] << 33 | values[vi] >>> 28;
                blocks[bi++] = values[vi++] << 36 | values[vi] >>> 25;
                blocks[bi++] = values[vi++] << 39 | values[vi] >>> 22;
                blocks[bi++] = values[vi++] << 42 | values[vi] >>> 19;
                blocks[bi++] = values[vi++] << 45 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi] >>> 13;
                blocks[bi++] = values[vi++] << 51 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi] >>> 7;
                blocks[bi++] = values[vi++] << 57 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi] >>> 1;
                blocks[bi++] = values[vi++] << 63 | values[vi++] << 2 | values[vi] >>> 59;
                blocks[bi++] = values[vi++] << 5 | values[vi] >>> 56;
                blocks[bi++] = values[vi++] << 8 | values[vi] >>> 53;
                blocks[bi++] = values[vi++] << 11 | values[vi] >>> 50;
                blocks[bi++] = values[vi++] << 14 | values[vi] >>> 47;
                blocks[bi++] = values[vi++] << 17 | values[vi] >>> 44;
                blocks[bi++] = values[vi++] << 20 | values[vi] >>> 41;
                blocks[bi++] = values[vi++] << 23 | values[vi] >>> 38;
                blocks[bi++] = values[vi++] << 26 | values[vi] >>> 35;
                blocks[bi++] = values[vi++] << 29 | values[vi] >>> 32;
                blocks[bi++] = values[vi++] << 32 | values[vi] >>> 29;
                blocks[bi++] = values[vi++] << 35 | values[vi] >>> 26;
                blocks[bi++] = values[vi++] << 38 | values[vi] >>> 23;
                blocks[bi++] = values[vi++] << 41 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi] >>> 17;
                blocks[bi++] = values[vi++] << 47 | values[vi] >>> 14;
                blocks[bi++] = values[vi++] << 50 | values[vi] >>> 11;
                blocks[bi++] = values[vi++] << 53 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi] >>> 5;
                blocks[bi++] = values[vi++] << 59 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 1 | values[vi] >>> 60;
                blocks[bi++] = values[vi++] << 4 | values[vi] >>> 57;
                blocks[bi++] = values[vi++] << 7 | values[vi] >>> 54;
                blocks[bi++] = values[vi++] << 10 | values[vi] >>> 51;
                blocks[bi++] = values[vi++] << 13 | values[vi] >>> 48;
                blocks[bi++] = values[vi++] << 16 | values[vi] >>> 45;
                blocks[bi++] = values[vi++] << 19 | values[vi] >>> 42;
                blocks[bi++] = values[vi++] << 22 | values[vi] >>> 39;
                blocks[bi++] = values[vi++] << 25 | values[vi] >>> 36;
                blocks[bi++] = values[vi++] << 28 | values[vi] >>> 33;
                blocks[bi++] = values[vi++] << 31 | values[vi] >>> 30;
                blocks[bi++] = values[vi++] << 34 | values[vi] >>> 27;
                blocks[bi++] = values[vi++] << 37 | values[vi] >>> 24;
                blocks[bi++] = values[vi++] << 40 | values[vi] >>> 21;
                blocks[bi++] = values[vi++] << 43 | values[vi] >>> 18;
                blocks[bi++] = values[vi++] << 46 | values[vi] >>> 15;
                blocks[bi++] = values[vi++] << 49 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi] >>> 9;
                blocks[bi++] = values[vi++] << 55 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi] >>> 3;
                blocks[bi++] = values[vi++] << 61 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation60
    extends BulkOperation {
        Packed64BulkOperation60() {
        }

        @Override
        public int blocks() {
            return 15;
        }

        @Override
        public int values() {
            return 16;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 4;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0xFL) << 56 | block1 >>> 8;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0xFFL) << 52 | block2 >>> 12;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0xFFFL) << 48 | block3 >>> 16;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0xFFFFL) << 44 | block4 >>> 20;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0xFFFFFL) << 40 | block5 >>> 24;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0xFFFFFFL) << 36 | block6 >>> 28;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0xFFFFFFFL) << 32 | block7 >>> 32;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0xFFFFFFFFL) << 28 | block8 >>> 36;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0xFFFFFFFFFL) << 24 | block9 >>> 40;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 0xFFFFFFFFFFL) << 20 | block10 >>> 44;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 0xFFFFFFFFFFFL) << 16 | block11 >>> 48;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 0xFFFFFFFFFFFFL) << 12 | block12 >>> 52;
                long block13 = blocks[bi++];
                values[vi++] = (block12 & 0xFFFFFFFFFFFFFL) << 8 | block13 >>> 56;
                long block14 = blocks[bi++];
                values[vi++] = (block13 & 0xFFFFFFFFFFFFFFL) << 4 | block14 >>> 60;
                values[vi++] = block14 & 0xFFFFFFFFFFFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 4 | values[vi] >>> 56;
                blocks[bi++] = values[vi++] << 8 | values[vi] >>> 52;
                blocks[bi++] = values[vi++] << 12 | values[vi] >>> 48;
                blocks[bi++] = values[vi++] << 16 | values[vi] >>> 44;
                blocks[bi++] = values[vi++] << 20 | values[vi] >>> 40;
                blocks[bi++] = values[vi++] << 24 | values[vi] >>> 36;
                blocks[bi++] = values[vi++] << 28 | values[vi] >>> 32;
                blocks[bi++] = values[vi++] << 32 | values[vi] >>> 28;
                blocks[bi++] = values[vi++] << 36 | values[vi] >>> 24;
                blocks[bi++] = values[vi++] << 40 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation59
    extends BulkOperation {
        Packed64BulkOperation59() {
        }

        @Override
        public int blocks() {
            return 59;
        }

        @Override
        public int values() {
            return 64;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 5;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0x1FL) << 54 | block1 >>> 10;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0x3FFL) << 49 | block2 >>> 15;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0x7FFFL) << 44 | block3 >>> 20;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0xFFFFFL) << 39 | block4 >>> 25;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0x1FFFFFFL) << 34 | block5 >>> 30;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0x3FFFFFFFL) << 29 | block6 >>> 35;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0x7FFFFFFFFL) << 24 | block7 >>> 40;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0xFFFFFFFFFFL) << 19 | block8 >>> 45;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0x1FFFFFFFFFFFL) << 14 | block9 >>> 50;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 0x3FFFFFFFFFFFFL) << 9 | block10 >>> 55;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 0x7FFFFFFFFFFFFFL) << 4 | block11 >>> 60;
                values[vi++] = block11 >>> 1 & 0x7FFFFFFFFFFFFFFL;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 1L) << 58 | block12 >>> 6;
                long block13 = blocks[bi++];
                values[vi++] = (block12 & 0x3FL) << 53 | block13 >>> 11;
                long block14 = blocks[bi++];
                values[vi++] = (block13 & 0x7FFL) << 48 | block14 >>> 16;
                long block15 = blocks[bi++];
                values[vi++] = (block14 & 0xFFFFL) << 43 | block15 >>> 21;
                long block16 = blocks[bi++];
                values[vi++] = (block15 & 0x1FFFFFL) << 38 | block16 >>> 26;
                long block17 = blocks[bi++];
                values[vi++] = (block16 & 0x3FFFFFFL) << 33 | block17 >>> 31;
                long block18 = blocks[bi++];
                values[vi++] = (block17 & Integer.MAX_VALUE) << 28 | block18 >>> 36;
                long block19 = blocks[bi++];
                values[vi++] = (block18 & 0xFFFFFFFFFL) << 23 | block19 >>> 41;
                long block20 = blocks[bi++];
                values[vi++] = (block19 & 0x1FFFFFFFFFFL) << 18 | block20 >>> 46;
                long block21 = blocks[bi++];
                values[vi++] = (block20 & 0x3FFFFFFFFFFFL) << 13 | block21 >>> 51;
                long block22 = blocks[bi++];
                values[vi++] = (block21 & 0x7FFFFFFFFFFFFL) << 8 | block22 >>> 56;
                long block23 = blocks[bi++];
                values[vi++] = (block22 & 0xFFFFFFFFFFFFFFL) << 3 | block23 >>> 61;
                values[vi++] = block23 >>> 2 & 0x7FFFFFFFFFFFFFFL;
                long block24 = blocks[bi++];
                values[vi++] = (block23 & 3L) << 57 | block24 >>> 7;
                long block25 = blocks[bi++];
                values[vi++] = (block24 & 0x7FL) << 52 | block25 >>> 12;
                long block26 = blocks[bi++];
                values[vi++] = (block25 & 0xFFFL) << 47 | block26 >>> 17;
                long block27 = blocks[bi++];
                values[vi++] = (block26 & 0x1FFFFL) << 42 | block27 >>> 22;
                long block28 = blocks[bi++];
                values[vi++] = (block27 & 0x3FFFFFL) << 37 | block28 >>> 27;
                long block29 = blocks[bi++];
                values[vi++] = (block28 & 0x7FFFFFFL) << 32 | block29 >>> 32;
                long block30 = blocks[bi++];
                values[vi++] = (block29 & 0xFFFFFFFFL) << 27 | block30 >>> 37;
                long block31 = blocks[bi++];
                values[vi++] = (block30 & 0x1FFFFFFFFFL) << 22 | block31 >>> 42;
                long block32 = blocks[bi++];
                values[vi++] = (block31 & 0x3FFFFFFFFFFL) << 17 | block32 >>> 47;
                long block33 = blocks[bi++];
                values[vi++] = (block32 & 0x7FFFFFFFFFFFL) << 12 | block33 >>> 52;
                long block34 = blocks[bi++];
                values[vi++] = (block33 & 0xFFFFFFFFFFFFFL) << 7 | block34 >>> 57;
                long block35 = blocks[bi++];
                values[vi++] = (block34 & 0x1FFFFFFFFFFFFFFL) << 2 | block35 >>> 62;
                values[vi++] = block35 >>> 3 & 0x7FFFFFFFFFFFFFFL;
                long block36 = blocks[bi++];
                values[vi++] = (block35 & 7L) << 56 | block36 >>> 8;
                long block37 = blocks[bi++];
                values[vi++] = (block36 & 0xFFL) << 51 | block37 >>> 13;
                long block38 = blocks[bi++];
                values[vi++] = (block37 & 0x1FFFL) << 46 | block38 >>> 18;
                long block39 = blocks[bi++];
                values[vi++] = (block38 & 0x3FFFFL) << 41 | block39 >>> 23;
                long block40 = blocks[bi++];
                values[vi++] = (block39 & 0x7FFFFFL) << 36 | block40 >>> 28;
                long block41 = blocks[bi++];
                values[vi++] = (block40 & 0xFFFFFFFL) << 31 | block41 >>> 33;
                long block42 = blocks[bi++];
                values[vi++] = (block41 & 0x1FFFFFFFFL) << 26 | block42 >>> 38;
                long block43 = blocks[bi++];
                values[vi++] = (block42 & 0x3FFFFFFFFFL) << 21 | block43 >>> 43;
                long block44 = blocks[bi++];
                values[vi++] = (block43 & 0x7FFFFFFFFFFL) << 16 | block44 >>> 48;
                long block45 = blocks[bi++];
                values[vi++] = (block44 & 0xFFFFFFFFFFFFL) << 11 | block45 >>> 53;
                long block46 = blocks[bi++];
                values[vi++] = (block45 & 0x1FFFFFFFFFFFFFL) << 6 | block46 >>> 58;
                long block47 = blocks[bi++];
                values[vi++] = (block46 & 0x3FFFFFFFFFFFFFFL) << 1 | block47 >>> 63;
                values[vi++] = block47 >>> 4 & 0x7FFFFFFFFFFFFFFL;
                long block48 = blocks[bi++];
                values[vi++] = (block47 & 0xFL) << 55 | block48 >>> 9;
                long block49 = blocks[bi++];
                values[vi++] = (block48 & 0x1FFL) << 50 | block49 >>> 14;
                long block50 = blocks[bi++];
                values[vi++] = (block49 & 0x3FFFL) << 45 | block50 >>> 19;
                long block51 = blocks[bi++];
                values[vi++] = (block50 & 0x7FFFFL) << 40 | block51 >>> 24;
                long block52 = blocks[bi++];
                values[vi++] = (block51 & 0xFFFFFFL) << 35 | block52 >>> 29;
                long block53 = blocks[bi++];
                values[vi++] = (block52 & 0x1FFFFFFFL) << 30 | block53 >>> 34;
                long block54 = blocks[bi++];
                values[vi++] = (block53 & 0x3FFFFFFFFL) << 25 | block54 >>> 39;
                long block55 = blocks[bi++];
                values[vi++] = (block54 & 0x7FFFFFFFFFL) << 20 | block55 >>> 44;
                long block56 = blocks[bi++];
                values[vi++] = (block55 & 0xFFFFFFFFFFFL) << 15 | block56 >>> 49;
                long block57 = blocks[bi++];
                values[vi++] = (block56 & 0x1FFFFFFFFFFFFL) << 10 | block57 >>> 54;
                long block58 = blocks[bi++];
                values[vi++] = (block57 & 0x3FFFFFFFFFFFFFL) << 5 | block58 >>> 59;
                values[vi++] = block58 & 0x7FFFFFFFFFFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 5 | values[vi] >>> 54;
                blocks[bi++] = values[vi++] << 10 | values[vi] >>> 49;
                blocks[bi++] = values[vi++] << 15 | values[vi] >>> 44;
                blocks[bi++] = values[vi++] << 20 | values[vi] >>> 39;
                blocks[bi++] = values[vi++] << 25 | values[vi] >>> 34;
                blocks[bi++] = values[vi++] << 30 | values[vi] >>> 29;
                blocks[bi++] = values[vi++] << 35 | values[vi] >>> 24;
                blocks[bi++] = values[vi++] << 40 | values[vi] >>> 19;
                blocks[bi++] = values[vi++] << 45 | values[vi] >>> 14;
                blocks[bi++] = values[vi++] << 50 | values[vi] >>> 9;
                blocks[bi++] = values[vi++] << 55 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 1 | values[vi] >>> 58;
                blocks[bi++] = values[vi++] << 6 | values[vi] >>> 53;
                blocks[bi++] = values[vi++] << 11 | values[vi] >>> 48;
                blocks[bi++] = values[vi++] << 16 | values[vi] >>> 43;
                blocks[bi++] = values[vi++] << 21 | values[vi] >>> 38;
                blocks[bi++] = values[vi++] << 26 | values[vi] >>> 33;
                blocks[bi++] = values[vi++] << 31 | values[vi] >>> 28;
                blocks[bi++] = values[vi++] << 36 | values[vi] >>> 23;
                blocks[bi++] = values[vi++] << 41 | values[vi] >>> 18;
                blocks[bi++] = values[vi++] << 46 | values[vi] >>> 13;
                blocks[bi++] = values[vi++] << 51 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi] >>> 3;
                blocks[bi++] = values[vi++] << 61 | values[vi++] << 2 | values[vi] >>> 57;
                blocks[bi++] = values[vi++] << 7 | values[vi] >>> 52;
                blocks[bi++] = values[vi++] << 12 | values[vi] >>> 47;
                blocks[bi++] = values[vi++] << 17 | values[vi] >>> 42;
                blocks[bi++] = values[vi++] << 22 | values[vi] >>> 37;
                blocks[bi++] = values[vi++] << 27 | values[vi] >>> 32;
                blocks[bi++] = values[vi++] << 32 | values[vi] >>> 27;
                blocks[bi++] = values[vi++] << 37 | values[vi] >>> 22;
                blocks[bi++] = values[vi++] << 42 | values[vi] >>> 17;
                blocks[bi++] = values[vi++] << 47 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi] >>> 7;
                blocks[bi++] = values[vi++] << 57 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 3 | values[vi] >>> 56;
                blocks[bi++] = values[vi++] << 8 | values[vi] >>> 51;
                blocks[bi++] = values[vi++] << 13 | values[vi] >>> 46;
                blocks[bi++] = values[vi++] << 18 | values[vi] >>> 41;
                blocks[bi++] = values[vi++] << 23 | values[vi] >>> 36;
                blocks[bi++] = values[vi++] << 28 | values[vi] >>> 31;
                blocks[bi++] = values[vi++] << 33 | values[vi] >>> 26;
                blocks[bi++] = values[vi++] << 38 | values[vi] >>> 21;
                blocks[bi++] = values[vi++] << 43 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi] >>> 11;
                blocks[bi++] = values[vi++] << 53 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi] >>> 1;
                blocks[bi++] = values[vi++] << 63 | values[vi++] << 4 | values[vi] >>> 55;
                blocks[bi++] = values[vi++] << 9 | values[vi] >>> 50;
                blocks[bi++] = values[vi++] << 14 | values[vi] >>> 45;
                blocks[bi++] = values[vi++] << 19 | values[vi] >>> 40;
                blocks[bi++] = values[vi++] << 24 | values[vi] >>> 35;
                blocks[bi++] = values[vi++] << 29 | values[vi] >>> 30;
                blocks[bi++] = values[vi++] << 34 | values[vi] >>> 25;
                blocks[bi++] = values[vi++] << 39 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi] >>> 15;
                blocks[bi++] = values[vi++] << 49 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi] >>> 5;
                blocks[bi++] = values[vi++] << 59 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation58
    extends BulkOperation {
        Packed64BulkOperation58() {
        }

        @Override
        public int blocks() {
            return 29;
        }

        @Override
        public int values() {
            return 32;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 6;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0x3FL) << 52 | block1 >>> 12;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0xFFFL) << 46 | block2 >>> 18;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0x3FFFFL) << 40 | block3 >>> 24;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0xFFFFFFL) << 34 | block4 >>> 30;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0x3FFFFFFFL) << 28 | block5 >>> 36;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0xFFFFFFFFFL) << 22 | block6 >>> 42;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0x3FFFFFFFFFFL) << 16 | block7 >>> 48;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0xFFFFFFFFFFFFL) << 10 | block8 >>> 54;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0x3FFFFFFFFFFFFFL) << 4 | block9 >>> 60;
                values[vi++] = block9 >>> 2 & 0x3FFFFFFFFFFFFFFL;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 3L) << 56 | block10 >>> 8;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 0xFFL) << 50 | block11 >>> 14;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 0x3FFFL) << 44 | block12 >>> 20;
                long block13 = blocks[bi++];
                values[vi++] = (block12 & 0xFFFFFL) << 38 | block13 >>> 26;
                long block14 = blocks[bi++];
                values[vi++] = (block13 & 0x3FFFFFFL) << 32 | block14 >>> 32;
                long block15 = blocks[bi++];
                values[vi++] = (block14 & 0xFFFFFFFFL) << 26 | block15 >>> 38;
                long block16 = blocks[bi++];
                values[vi++] = (block15 & 0x3FFFFFFFFFL) << 20 | block16 >>> 44;
                long block17 = blocks[bi++];
                values[vi++] = (block16 & 0xFFFFFFFFFFFL) << 14 | block17 >>> 50;
                long block18 = blocks[bi++];
                values[vi++] = (block17 & 0x3FFFFFFFFFFFFL) << 8 | block18 >>> 56;
                long block19 = blocks[bi++];
                values[vi++] = (block18 & 0xFFFFFFFFFFFFFFL) << 2 | block19 >>> 62;
                values[vi++] = block19 >>> 4 & 0x3FFFFFFFFFFFFFFL;
                long block20 = blocks[bi++];
                values[vi++] = (block19 & 0xFL) << 54 | block20 >>> 10;
                long block21 = blocks[bi++];
                values[vi++] = (block20 & 0x3FFL) << 48 | block21 >>> 16;
                long block22 = blocks[bi++];
                values[vi++] = (block21 & 0xFFFFL) << 42 | block22 >>> 22;
                long block23 = blocks[bi++];
                values[vi++] = (block22 & 0x3FFFFFL) << 36 | block23 >>> 28;
                long block24 = blocks[bi++];
                values[vi++] = (block23 & 0xFFFFFFFL) << 30 | block24 >>> 34;
                long block25 = blocks[bi++];
                values[vi++] = (block24 & 0x3FFFFFFFFL) << 24 | block25 >>> 40;
                long block26 = blocks[bi++];
                values[vi++] = (block25 & 0xFFFFFFFFFFL) << 18 | block26 >>> 46;
                long block27 = blocks[bi++];
                values[vi++] = (block26 & 0x3FFFFFFFFFFFL) << 12 | block27 >>> 52;
                long block28 = blocks[bi++];
                values[vi++] = (block27 & 0xFFFFFFFFFFFFFL) << 6 | block28 >>> 58;
                values[vi++] = block28 & 0x3FFFFFFFFFFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 6 | values[vi] >>> 52;
                blocks[bi++] = values[vi++] << 12 | values[vi] >>> 46;
                blocks[bi++] = values[vi++] << 18 | values[vi] >>> 40;
                blocks[bi++] = values[vi++] << 24 | values[vi] >>> 34;
                blocks[bi++] = values[vi++] << 30 | values[vi] >>> 28;
                blocks[bi++] = values[vi++] << 36 | values[vi] >>> 22;
                blocks[bi++] = values[vi++] << 42 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 2 | values[vi] >>> 56;
                blocks[bi++] = values[vi++] << 8 | values[vi] >>> 50;
                blocks[bi++] = values[vi++] << 14 | values[vi] >>> 44;
                blocks[bi++] = values[vi++] << 20 | values[vi] >>> 38;
                blocks[bi++] = values[vi++] << 26 | values[vi] >>> 32;
                blocks[bi++] = values[vi++] << 32 | values[vi] >>> 26;
                blocks[bi++] = values[vi++] << 38 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi] >>> 14;
                blocks[bi++] = values[vi++] << 50 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 4 | values[vi] >>> 54;
                blocks[bi++] = values[vi++] << 10 | values[vi] >>> 48;
                blocks[bi++] = values[vi++] << 16 | values[vi] >>> 42;
                blocks[bi++] = values[vi++] << 22 | values[vi] >>> 36;
                blocks[bi++] = values[vi++] << 28 | values[vi] >>> 30;
                blocks[bi++] = values[vi++] << 34 | values[vi] >>> 24;
                blocks[bi++] = values[vi++] << 40 | values[vi] >>> 18;
                blocks[bi++] = values[vi++] << 46 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation57
    extends BulkOperation {
        Packed64BulkOperation57() {
        }

        @Override
        public int blocks() {
            return 57;
        }

        @Override
        public int values() {
            return 64;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 7;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0x7FL) << 50 | block1 >>> 14;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0x3FFFL) << 43 | block2 >>> 21;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0x1FFFFFL) << 36 | block3 >>> 28;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0xFFFFFFFL) << 29 | block4 >>> 35;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0x7FFFFFFFFL) << 22 | block5 >>> 42;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0x3FFFFFFFFFFL) << 15 | block6 >>> 49;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0x1FFFFFFFFFFFFL) << 8 | block7 >>> 56;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0xFFFFFFFFFFFFFFL) << 1 | block8 >>> 63;
                values[vi++] = block8 >>> 6 & 0x1FFFFFFFFFFFFFFL;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0x3FL) << 51 | block9 >>> 13;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 0x1FFFL) << 44 | block10 >>> 20;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 0xFFFFFL) << 37 | block11 >>> 27;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 0x7FFFFFFL) << 30 | block12 >>> 34;
                long block13 = blocks[bi++];
                values[vi++] = (block12 & 0x3FFFFFFFFL) << 23 | block13 >>> 41;
                long block14 = blocks[bi++];
                values[vi++] = (block13 & 0x1FFFFFFFFFFL) << 16 | block14 >>> 48;
                long block15 = blocks[bi++];
                values[vi++] = (block14 & 0xFFFFFFFFFFFFL) << 9 | block15 >>> 55;
                long block16 = blocks[bi++];
                values[vi++] = (block15 & 0x7FFFFFFFFFFFFFL) << 2 | block16 >>> 62;
                values[vi++] = block16 >>> 5 & 0x1FFFFFFFFFFFFFFL;
                long block17 = blocks[bi++];
                values[vi++] = (block16 & 0x1FL) << 52 | block17 >>> 12;
                long block18 = blocks[bi++];
                values[vi++] = (block17 & 0xFFFL) << 45 | block18 >>> 19;
                long block19 = blocks[bi++];
                values[vi++] = (block18 & 0x7FFFFL) << 38 | block19 >>> 26;
                long block20 = blocks[bi++];
                values[vi++] = (block19 & 0x3FFFFFFL) << 31 | block20 >>> 33;
                long block21 = blocks[bi++];
                values[vi++] = (block20 & 0x1FFFFFFFFL) << 24 | block21 >>> 40;
                long block22 = blocks[bi++];
                values[vi++] = (block21 & 0xFFFFFFFFFFL) << 17 | block22 >>> 47;
                long block23 = blocks[bi++];
                values[vi++] = (block22 & 0x7FFFFFFFFFFFL) << 10 | block23 >>> 54;
                long block24 = blocks[bi++];
                values[vi++] = (block23 & 0x3FFFFFFFFFFFFFL) << 3 | block24 >>> 61;
                values[vi++] = block24 >>> 4 & 0x1FFFFFFFFFFFFFFL;
                long block25 = blocks[bi++];
                values[vi++] = (block24 & 0xFL) << 53 | block25 >>> 11;
                long block26 = blocks[bi++];
                values[vi++] = (block25 & 0x7FFL) << 46 | block26 >>> 18;
                long block27 = blocks[bi++];
                values[vi++] = (block26 & 0x3FFFFL) << 39 | block27 >>> 25;
                long block28 = blocks[bi++];
                values[vi++] = (block27 & 0x1FFFFFFL) << 32 | block28 >>> 32;
                long block29 = blocks[bi++];
                values[vi++] = (block28 & 0xFFFFFFFFL) << 25 | block29 >>> 39;
                long block30 = blocks[bi++];
                values[vi++] = (block29 & 0x7FFFFFFFFFL) << 18 | block30 >>> 46;
                long block31 = blocks[bi++];
                values[vi++] = (block30 & 0x3FFFFFFFFFFFL) << 11 | block31 >>> 53;
                long block32 = blocks[bi++];
                values[vi++] = (block31 & 0x1FFFFFFFFFFFFFL) << 4 | block32 >>> 60;
                values[vi++] = block32 >>> 3 & 0x1FFFFFFFFFFFFFFL;
                long block33 = blocks[bi++];
                values[vi++] = (block32 & 7L) << 54 | block33 >>> 10;
                long block34 = blocks[bi++];
                values[vi++] = (block33 & 0x3FFL) << 47 | block34 >>> 17;
                long block35 = blocks[bi++];
                values[vi++] = (block34 & 0x1FFFFL) << 40 | block35 >>> 24;
                long block36 = blocks[bi++];
                values[vi++] = (block35 & 0xFFFFFFL) << 33 | block36 >>> 31;
                long block37 = blocks[bi++];
                values[vi++] = (block36 & Integer.MAX_VALUE) << 26 | block37 >>> 38;
                long block38 = blocks[bi++];
                values[vi++] = (block37 & 0x3FFFFFFFFFL) << 19 | block38 >>> 45;
                long block39 = blocks[bi++];
                values[vi++] = (block38 & 0x1FFFFFFFFFFFL) << 12 | block39 >>> 52;
                long block40 = blocks[bi++];
                values[vi++] = (block39 & 0xFFFFFFFFFFFFFL) << 5 | block40 >>> 59;
                values[vi++] = block40 >>> 2 & 0x1FFFFFFFFFFFFFFL;
                long block41 = blocks[bi++];
                values[vi++] = (block40 & 3L) << 55 | block41 >>> 9;
                long block42 = blocks[bi++];
                values[vi++] = (block41 & 0x1FFL) << 48 | block42 >>> 16;
                long block43 = blocks[bi++];
                values[vi++] = (block42 & 0xFFFFL) << 41 | block43 >>> 23;
                long block44 = blocks[bi++];
                values[vi++] = (block43 & 0x7FFFFFL) << 34 | block44 >>> 30;
                long block45 = blocks[bi++];
                values[vi++] = (block44 & 0x3FFFFFFFL) << 27 | block45 >>> 37;
                long block46 = blocks[bi++];
                values[vi++] = (block45 & 0x1FFFFFFFFFL) << 20 | block46 >>> 44;
                long block47 = blocks[bi++];
                values[vi++] = (block46 & 0xFFFFFFFFFFFL) << 13 | block47 >>> 51;
                long block48 = blocks[bi++];
                values[vi++] = (block47 & 0x7FFFFFFFFFFFFL) << 6 | block48 >>> 58;
                values[vi++] = block48 >>> 1 & 0x1FFFFFFFFFFFFFFL;
                long block49 = blocks[bi++];
                values[vi++] = (block48 & 1L) << 56 | block49 >>> 8;
                long block50 = blocks[bi++];
                values[vi++] = (block49 & 0xFFL) << 49 | block50 >>> 15;
                long block51 = blocks[bi++];
                values[vi++] = (block50 & 0x7FFFL) << 42 | block51 >>> 22;
                long block52 = blocks[bi++];
                values[vi++] = (block51 & 0x3FFFFFL) << 35 | block52 >>> 29;
                long block53 = blocks[bi++];
                values[vi++] = (block52 & 0x1FFFFFFFL) << 28 | block53 >>> 36;
                long block54 = blocks[bi++];
                values[vi++] = (block53 & 0xFFFFFFFFFL) << 21 | block54 >>> 43;
                long block55 = blocks[bi++];
                values[vi++] = (block54 & 0x7FFFFFFFFFFL) << 14 | block55 >>> 50;
                long block56 = blocks[bi++];
                values[vi++] = (block55 & 0x3FFFFFFFFFFFFL) << 7 | block56 >>> 57;
                values[vi++] = block56 & 0x1FFFFFFFFFFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 7 | values[vi] >>> 50;
                blocks[bi++] = values[vi++] << 14 | values[vi] >>> 43;
                blocks[bi++] = values[vi++] << 21 | values[vi] >>> 36;
                blocks[bi++] = values[vi++] << 28 | values[vi] >>> 29;
                blocks[bi++] = values[vi++] << 35 | values[vi] >>> 22;
                blocks[bi++] = values[vi++] << 42 | values[vi] >>> 15;
                blocks[bi++] = values[vi++] << 49 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi] >>> 1;
                blocks[bi++] = values[vi++] << 63 | values[vi++] << 6 | values[vi] >>> 51;
                blocks[bi++] = values[vi++] << 13 | values[vi] >>> 44;
                blocks[bi++] = values[vi++] << 20 | values[vi] >>> 37;
                blocks[bi++] = values[vi++] << 27 | values[vi] >>> 30;
                blocks[bi++] = values[vi++] << 34 | values[vi] >>> 23;
                blocks[bi++] = values[vi++] << 41 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi] >>> 9;
                blocks[bi++] = values[vi++] << 55 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 5 | values[vi] >>> 52;
                blocks[bi++] = values[vi++] << 12 | values[vi] >>> 45;
                blocks[bi++] = values[vi++] << 19 | values[vi] >>> 38;
                blocks[bi++] = values[vi++] << 26 | values[vi] >>> 31;
                blocks[bi++] = values[vi++] << 33 | values[vi] >>> 24;
                blocks[bi++] = values[vi++] << 40 | values[vi] >>> 17;
                blocks[bi++] = values[vi++] << 47 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi] >>> 3;
                blocks[bi++] = values[vi++] << 61 | values[vi++] << 4 | values[vi] >>> 53;
                blocks[bi++] = values[vi++] << 11 | values[vi] >>> 46;
                blocks[bi++] = values[vi++] << 18 | values[vi] >>> 39;
                blocks[bi++] = values[vi++] << 25 | values[vi] >>> 32;
                blocks[bi++] = values[vi++] << 32 | values[vi] >>> 25;
                blocks[bi++] = values[vi++] << 39 | values[vi] >>> 18;
                blocks[bi++] = values[vi++] << 46 | values[vi] >>> 11;
                blocks[bi++] = values[vi++] << 53 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 3 | values[vi] >>> 54;
                blocks[bi++] = values[vi++] << 10 | values[vi] >>> 47;
                blocks[bi++] = values[vi++] << 17 | values[vi] >>> 40;
                blocks[bi++] = values[vi++] << 24 | values[vi] >>> 33;
                blocks[bi++] = values[vi++] << 31 | values[vi] >>> 26;
                blocks[bi++] = values[vi++] << 38 | values[vi] >>> 19;
                blocks[bi++] = values[vi++] << 45 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi] >>> 5;
                blocks[bi++] = values[vi++] << 59 | values[vi++] << 2 | values[vi] >>> 55;
                blocks[bi++] = values[vi++] << 9 | values[vi] >>> 48;
                blocks[bi++] = values[vi++] << 16 | values[vi] >>> 41;
                blocks[bi++] = values[vi++] << 23 | values[vi] >>> 34;
                blocks[bi++] = values[vi++] << 30 | values[vi] >>> 27;
                blocks[bi++] = values[vi++] << 37 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi] >>> 13;
                blocks[bi++] = values[vi++] << 51 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 1 | values[vi] >>> 56;
                blocks[bi++] = values[vi++] << 8 | values[vi] >>> 49;
                blocks[bi++] = values[vi++] << 15 | values[vi] >>> 42;
                blocks[bi++] = values[vi++] << 22 | values[vi] >>> 35;
                blocks[bi++] = values[vi++] << 29 | values[vi] >>> 28;
                blocks[bi++] = values[vi++] << 36 | values[vi] >>> 21;
                blocks[bi++] = values[vi++] << 43 | values[vi] >>> 14;
                blocks[bi++] = values[vi++] << 50 | values[vi] >>> 7;
                blocks[bi++] = values[vi++] << 57 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation56
    extends BulkOperation {
        Packed64BulkOperation56() {
        }

        @Override
        public int blocks() {
            return 7;
        }

        @Override
        public int values() {
            return 8;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 8;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0xFFL) << 48 | block1 >>> 16;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0xFFFFL) << 40 | block2 >>> 24;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0xFFFFFFL) << 32 | block3 >>> 32;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0xFFFFFFFFL) << 24 | block4 >>> 40;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0xFFFFFFFFFFL) << 16 | block5 >>> 48;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0xFFFFFFFFFFFFL) << 8 | block6 >>> 56;
                values[vi++] = block6 & 0xFFFFFFFFFFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 8 | values[vi] >>> 48;
                blocks[bi++] = values[vi++] << 16 | values[vi] >>> 40;
                blocks[bi++] = values[vi++] << 24 | values[vi] >>> 32;
                blocks[bi++] = values[vi++] << 32 | values[vi] >>> 24;
                blocks[bi++] = values[vi++] << 40 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation55
    extends BulkOperation {
        Packed64BulkOperation55() {
        }

        @Override
        public int blocks() {
            return 55;
        }

        @Override
        public int values() {
            return 64;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 9;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0x1FFL) << 46 | block1 >>> 18;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0x3FFFFL) << 37 | block2 >>> 27;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0x7FFFFFFL) << 28 | block3 >>> 36;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0xFFFFFFFFFL) << 19 | block4 >>> 45;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0x1FFFFFFFFFFFL) << 10 | block5 >>> 54;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0x3FFFFFFFFFFFFFL) << 1 | block6 >>> 63;
                values[vi++] = block6 >>> 8 & 0x7FFFFFFFFFFFFFL;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0xFFL) << 47 | block7 >>> 17;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0x1FFFFL) << 38 | block8 >>> 26;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0x3FFFFFFL) << 29 | block9 >>> 35;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 0x7FFFFFFFFL) << 20 | block10 >>> 44;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 0xFFFFFFFFFFFL) << 11 | block11 >>> 53;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 0x1FFFFFFFFFFFFFL) << 2 | block12 >>> 62;
                values[vi++] = block12 >>> 7 & 0x7FFFFFFFFFFFFFL;
                long block13 = blocks[bi++];
                values[vi++] = (block12 & 0x7FL) << 48 | block13 >>> 16;
                long block14 = blocks[bi++];
                values[vi++] = (block13 & 0xFFFFL) << 39 | block14 >>> 25;
                long block15 = blocks[bi++];
                values[vi++] = (block14 & 0x1FFFFFFL) << 30 | block15 >>> 34;
                long block16 = blocks[bi++];
                values[vi++] = (block15 & 0x3FFFFFFFFL) << 21 | block16 >>> 43;
                long block17 = blocks[bi++];
                values[vi++] = (block16 & 0x7FFFFFFFFFFL) << 12 | block17 >>> 52;
                long block18 = blocks[bi++];
                values[vi++] = (block17 & 0xFFFFFFFFFFFFFL) << 3 | block18 >>> 61;
                values[vi++] = block18 >>> 6 & 0x7FFFFFFFFFFFFFL;
                long block19 = blocks[bi++];
                values[vi++] = (block18 & 0x3FL) << 49 | block19 >>> 15;
                long block20 = blocks[bi++];
                values[vi++] = (block19 & 0x7FFFL) << 40 | block20 >>> 24;
                long block21 = blocks[bi++];
                values[vi++] = (block20 & 0xFFFFFFL) << 31 | block21 >>> 33;
                long block22 = blocks[bi++];
                values[vi++] = (block21 & 0x1FFFFFFFFL) << 22 | block22 >>> 42;
                long block23 = blocks[bi++];
                values[vi++] = (block22 & 0x3FFFFFFFFFFL) << 13 | block23 >>> 51;
                long block24 = blocks[bi++];
                values[vi++] = (block23 & 0x7FFFFFFFFFFFFL) << 4 | block24 >>> 60;
                values[vi++] = block24 >>> 5 & 0x7FFFFFFFFFFFFFL;
                long block25 = blocks[bi++];
                values[vi++] = (block24 & 0x1FL) << 50 | block25 >>> 14;
                long block26 = blocks[bi++];
                values[vi++] = (block25 & 0x3FFFL) << 41 | block26 >>> 23;
                long block27 = blocks[bi++];
                values[vi++] = (block26 & 0x7FFFFFL) << 32 | block27 >>> 32;
                long block28 = blocks[bi++];
                values[vi++] = (block27 & 0xFFFFFFFFL) << 23 | block28 >>> 41;
                long block29 = blocks[bi++];
                values[vi++] = (block28 & 0x1FFFFFFFFFFL) << 14 | block29 >>> 50;
                long block30 = blocks[bi++];
                values[vi++] = (block29 & 0x3FFFFFFFFFFFFL) << 5 | block30 >>> 59;
                values[vi++] = block30 >>> 4 & 0x7FFFFFFFFFFFFFL;
                long block31 = blocks[bi++];
                values[vi++] = (block30 & 0xFL) << 51 | block31 >>> 13;
                long block32 = blocks[bi++];
                values[vi++] = (block31 & 0x1FFFL) << 42 | block32 >>> 22;
                long block33 = blocks[bi++];
                values[vi++] = (block32 & 0x3FFFFFL) << 33 | block33 >>> 31;
                long block34 = blocks[bi++];
                values[vi++] = (block33 & Integer.MAX_VALUE) << 24 | block34 >>> 40;
                long block35 = blocks[bi++];
                values[vi++] = (block34 & 0xFFFFFFFFFFL) << 15 | block35 >>> 49;
                long block36 = blocks[bi++];
                values[vi++] = (block35 & 0x1FFFFFFFFFFFFL) << 6 | block36 >>> 58;
                values[vi++] = block36 >>> 3 & 0x7FFFFFFFFFFFFFL;
                long block37 = blocks[bi++];
                values[vi++] = (block36 & 7L) << 52 | block37 >>> 12;
                long block38 = blocks[bi++];
                values[vi++] = (block37 & 0xFFFL) << 43 | block38 >>> 21;
                long block39 = blocks[bi++];
                values[vi++] = (block38 & 0x1FFFFFL) << 34 | block39 >>> 30;
                long block40 = blocks[bi++];
                values[vi++] = (block39 & 0x3FFFFFFFL) << 25 | block40 >>> 39;
                long block41 = blocks[bi++];
                values[vi++] = (block40 & 0x7FFFFFFFFFL) << 16 | block41 >>> 48;
                long block42 = blocks[bi++];
                values[vi++] = (block41 & 0xFFFFFFFFFFFFL) << 7 | block42 >>> 57;
                values[vi++] = block42 >>> 2 & 0x7FFFFFFFFFFFFFL;
                long block43 = blocks[bi++];
                values[vi++] = (block42 & 3L) << 53 | block43 >>> 11;
                long block44 = blocks[bi++];
                values[vi++] = (block43 & 0x7FFL) << 44 | block44 >>> 20;
                long block45 = blocks[bi++];
                values[vi++] = (block44 & 0xFFFFFL) << 35 | block45 >>> 29;
                long block46 = blocks[bi++];
                values[vi++] = (block45 & 0x1FFFFFFFL) << 26 | block46 >>> 38;
                long block47 = blocks[bi++];
                values[vi++] = (block46 & 0x3FFFFFFFFFL) << 17 | block47 >>> 47;
                long block48 = blocks[bi++];
                values[vi++] = (block47 & 0x7FFFFFFFFFFFL) << 8 | block48 >>> 56;
                values[vi++] = block48 >>> 1 & 0x7FFFFFFFFFFFFFL;
                long block49 = blocks[bi++];
                values[vi++] = (block48 & 1L) << 54 | block49 >>> 10;
                long block50 = blocks[bi++];
                values[vi++] = (block49 & 0x3FFL) << 45 | block50 >>> 19;
                long block51 = blocks[bi++];
                values[vi++] = (block50 & 0x7FFFFL) << 36 | block51 >>> 28;
                long block52 = blocks[bi++];
                values[vi++] = (block51 & 0xFFFFFFFL) << 27 | block52 >>> 37;
                long block53 = blocks[bi++];
                values[vi++] = (block52 & 0x1FFFFFFFFFL) << 18 | block53 >>> 46;
                long block54 = blocks[bi++];
                values[vi++] = (block53 & 0x3FFFFFFFFFFFL) << 9 | block54 >>> 55;
                values[vi++] = block54 & 0x7FFFFFFFFFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 9 | values[vi] >>> 46;
                blocks[bi++] = values[vi++] << 18 | values[vi] >>> 37;
                blocks[bi++] = values[vi++] << 27 | values[vi] >>> 28;
                blocks[bi++] = values[vi++] << 36 | values[vi] >>> 19;
                blocks[bi++] = values[vi++] << 45 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi] >>> 1;
                blocks[bi++] = values[vi++] << 63 | values[vi++] << 8 | values[vi] >>> 47;
                blocks[bi++] = values[vi++] << 17 | values[vi] >>> 38;
                blocks[bi++] = values[vi++] << 26 | values[vi] >>> 29;
                blocks[bi++] = values[vi++] << 35 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi] >>> 11;
                blocks[bi++] = values[vi++] << 53 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 7 | values[vi] >>> 48;
                blocks[bi++] = values[vi++] << 16 | values[vi] >>> 39;
                blocks[bi++] = values[vi++] << 25 | values[vi] >>> 30;
                blocks[bi++] = values[vi++] << 34 | values[vi] >>> 21;
                blocks[bi++] = values[vi++] << 43 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi] >>> 3;
                blocks[bi++] = values[vi++] << 61 | values[vi++] << 6 | values[vi] >>> 49;
                blocks[bi++] = values[vi++] << 15 | values[vi] >>> 40;
                blocks[bi++] = values[vi++] << 24 | values[vi] >>> 31;
                blocks[bi++] = values[vi++] << 33 | values[vi] >>> 22;
                blocks[bi++] = values[vi++] << 42 | values[vi] >>> 13;
                blocks[bi++] = values[vi++] << 51 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 5 | values[vi] >>> 50;
                blocks[bi++] = values[vi++] << 14 | values[vi] >>> 41;
                blocks[bi++] = values[vi++] << 23 | values[vi] >>> 32;
                blocks[bi++] = values[vi++] << 32 | values[vi] >>> 23;
                blocks[bi++] = values[vi++] << 41 | values[vi] >>> 14;
                blocks[bi++] = values[vi++] << 50 | values[vi] >>> 5;
                blocks[bi++] = values[vi++] << 59 | values[vi++] << 4 | values[vi] >>> 51;
                blocks[bi++] = values[vi++] << 13 | values[vi] >>> 42;
                blocks[bi++] = values[vi++] << 22 | values[vi] >>> 33;
                blocks[bi++] = values[vi++] << 31 | values[vi] >>> 24;
                blocks[bi++] = values[vi++] << 40 | values[vi] >>> 15;
                blocks[bi++] = values[vi++] << 49 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 3 | values[vi] >>> 52;
                blocks[bi++] = values[vi++] << 12 | values[vi] >>> 43;
                blocks[bi++] = values[vi++] << 21 | values[vi] >>> 34;
                blocks[bi++] = values[vi++] << 30 | values[vi] >>> 25;
                blocks[bi++] = values[vi++] << 39 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi] >>> 7;
                blocks[bi++] = values[vi++] << 57 | values[vi++] << 2 | values[vi] >>> 53;
                blocks[bi++] = values[vi++] << 11 | values[vi] >>> 44;
                blocks[bi++] = values[vi++] << 20 | values[vi] >>> 35;
                blocks[bi++] = values[vi++] << 29 | values[vi] >>> 26;
                blocks[bi++] = values[vi++] << 38 | values[vi] >>> 17;
                blocks[bi++] = values[vi++] << 47 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 1 | values[vi] >>> 54;
                blocks[bi++] = values[vi++] << 10 | values[vi] >>> 45;
                blocks[bi++] = values[vi++] << 19 | values[vi] >>> 36;
                blocks[bi++] = values[vi++] << 28 | values[vi] >>> 27;
                blocks[bi++] = values[vi++] << 37 | values[vi] >>> 18;
                blocks[bi++] = values[vi++] << 46 | values[vi] >>> 9;
                blocks[bi++] = values[vi++] << 55 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation54
    extends BulkOperation {
        Packed64BulkOperation54() {
        }

        @Override
        public int blocks() {
            return 27;
        }

        @Override
        public int values() {
            return 32;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 10;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0x3FFL) << 44 | block1 >>> 20;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0xFFFFFL) << 34 | block2 >>> 30;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0x3FFFFFFFL) << 24 | block3 >>> 40;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0xFFFFFFFFFFL) << 14 | block4 >>> 50;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0x3FFFFFFFFFFFFL) << 4 | block5 >>> 60;
                values[vi++] = block5 >>> 6 & 0x3FFFFFFFFFFFFFL;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0x3FL) << 48 | block6 >>> 16;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0xFFFFL) << 38 | block7 >>> 26;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0x3FFFFFFL) << 28 | block8 >>> 36;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0xFFFFFFFFFL) << 18 | block9 >>> 46;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 0x3FFFFFFFFFFFL) << 8 | block10 >>> 56;
                values[vi++] = block10 >>> 2 & 0x3FFFFFFFFFFFFFL;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 3L) << 52 | block11 >>> 12;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 0xFFFL) << 42 | block12 >>> 22;
                long block13 = blocks[bi++];
                values[vi++] = (block12 & 0x3FFFFFL) << 32 | block13 >>> 32;
                long block14 = blocks[bi++];
                values[vi++] = (block13 & 0xFFFFFFFFL) << 22 | block14 >>> 42;
                long block15 = blocks[bi++];
                values[vi++] = (block14 & 0x3FFFFFFFFFFL) << 12 | block15 >>> 52;
                long block16 = blocks[bi++];
                values[vi++] = (block15 & 0xFFFFFFFFFFFFFL) << 2 | block16 >>> 62;
                values[vi++] = block16 >>> 8 & 0x3FFFFFFFFFFFFFL;
                long block17 = blocks[bi++];
                values[vi++] = (block16 & 0xFFL) << 46 | block17 >>> 18;
                long block18 = blocks[bi++];
                values[vi++] = (block17 & 0x3FFFFL) << 36 | block18 >>> 28;
                long block19 = blocks[bi++];
                values[vi++] = (block18 & 0xFFFFFFFL) << 26 | block19 >>> 38;
                long block20 = blocks[bi++];
                values[vi++] = (block19 & 0x3FFFFFFFFFL) << 16 | block20 >>> 48;
                long block21 = blocks[bi++];
                values[vi++] = (block20 & 0xFFFFFFFFFFFFL) << 6 | block21 >>> 58;
                values[vi++] = block21 >>> 4 & 0x3FFFFFFFFFFFFFL;
                long block22 = blocks[bi++];
                values[vi++] = (block21 & 0xFL) << 50 | block22 >>> 14;
                long block23 = blocks[bi++];
                values[vi++] = (block22 & 0x3FFFL) << 40 | block23 >>> 24;
                long block24 = blocks[bi++];
                values[vi++] = (block23 & 0xFFFFFFL) << 30 | block24 >>> 34;
                long block25 = blocks[bi++];
                values[vi++] = (block24 & 0x3FFFFFFFFL) << 20 | block25 >>> 44;
                long block26 = blocks[bi++];
                values[vi++] = (block25 & 0xFFFFFFFFFFFL) << 10 | block26 >>> 54;
                values[vi++] = block26 & 0x3FFFFFFFFFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 10 | values[vi] >>> 44;
                blocks[bi++] = values[vi++] << 20 | values[vi] >>> 34;
                blocks[bi++] = values[vi++] << 30 | values[vi] >>> 24;
                blocks[bi++] = values[vi++] << 40 | values[vi] >>> 14;
                blocks[bi++] = values[vi++] << 50 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 6 | values[vi] >>> 48;
                blocks[bi++] = values[vi++] << 16 | values[vi] >>> 38;
                blocks[bi++] = values[vi++] << 26 | values[vi] >>> 28;
                blocks[bi++] = values[vi++] << 36 | values[vi] >>> 18;
                blocks[bi++] = values[vi++] << 46 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 2 | values[vi] >>> 52;
                blocks[bi++] = values[vi++] << 12 | values[vi] >>> 42;
                blocks[bi++] = values[vi++] << 22 | values[vi] >>> 32;
                blocks[bi++] = values[vi++] << 32 | values[vi] >>> 22;
                blocks[bi++] = values[vi++] << 42 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 8 | values[vi] >>> 46;
                blocks[bi++] = values[vi++] << 18 | values[vi] >>> 36;
                blocks[bi++] = values[vi++] << 28 | values[vi] >>> 26;
                blocks[bi++] = values[vi++] << 38 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 4 | values[vi] >>> 50;
                blocks[bi++] = values[vi++] << 14 | values[vi] >>> 40;
                blocks[bi++] = values[vi++] << 24 | values[vi] >>> 30;
                blocks[bi++] = values[vi++] << 34 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation53
    extends BulkOperation {
        Packed64BulkOperation53() {
        }

        @Override
        public int blocks() {
            return 53;
        }

        @Override
        public int values() {
            return 64;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 11;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0x7FFL) << 42 | block1 >>> 22;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0x3FFFFFL) << 31 | block2 >>> 33;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0x1FFFFFFFFL) << 20 | block3 >>> 44;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0xFFFFFFFFFFFL) << 9 | block4 >>> 55;
                values[vi++] = block4 >>> 2 & 0x1FFFFFFFFFFFFFL;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 3L) << 51 | block5 >>> 13;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0x1FFFL) << 40 | block6 >>> 24;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0xFFFFFFL) << 29 | block7 >>> 35;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0x7FFFFFFFFL) << 18 | block8 >>> 46;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0x3FFFFFFFFFFFL) << 7 | block9 >>> 57;
                values[vi++] = block9 >>> 4 & 0x1FFFFFFFFFFFFFL;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 0xFL) << 49 | block10 >>> 15;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 0x7FFFL) << 38 | block11 >>> 26;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 0x3FFFFFFL) << 27 | block12 >>> 37;
                long block13 = blocks[bi++];
                values[vi++] = (block12 & 0x1FFFFFFFFFL) << 16 | block13 >>> 48;
                long block14 = blocks[bi++];
                values[vi++] = (block13 & 0xFFFFFFFFFFFFL) << 5 | block14 >>> 59;
                values[vi++] = block14 >>> 6 & 0x1FFFFFFFFFFFFFL;
                long block15 = blocks[bi++];
                values[vi++] = (block14 & 0x3FL) << 47 | block15 >>> 17;
                long block16 = blocks[bi++];
                values[vi++] = (block15 & 0x1FFFFL) << 36 | block16 >>> 28;
                long block17 = blocks[bi++];
                values[vi++] = (block16 & 0xFFFFFFFL) << 25 | block17 >>> 39;
                long block18 = blocks[bi++];
                values[vi++] = (block17 & 0x7FFFFFFFFFL) << 14 | block18 >>> 50;
                long block19 = blocks[bi++];
                values[vi++] = (block18 & 0x3FFFFFFFFFFFFL) << 3 | block19 >>> 61;
                values[vi++] = block19 >>> 8 & 0x1FFFFFFFFFFFFFL;
                long block20 = blocks[bi++];
                values[vi++] = (block19 & 0xFFL) << 45 | block20 >>> 19;
                long block21 = blocks[bi++];
                values[vi++] = (block20 & 0x7FFFFL) << 34 | block21 >>> 30;
                long block22 = blocks[bi++];
                values[vi++] = (block21 & 0x3FFFFFFFL) << 23 | block22 >>> 41;
                long block23 = blocks[bi++];
                values[vi++] = (block22 & 0x1FFFFFFFFFFL) << 12 | block23 >>> 52;
                long block24 = blocks[bi++];
                values[vi++] = (block23 & 0xFFFFFFFFFFFFFL) << 1 | block24 >>> 63;
                values[vi++] = block24 >>> 10 & 0x1FFFFFFFFFFFFFL;
                long block25 = blocks[bi++];
                values[vi++] = (block24 & 0x3FFL) << 43 | block25 >>> 21;
                long block26 = blocks[bi++];
                values[vi++] = (block25 & 0x1FFFFFL) << 32 | block26 >>> 32;
                long block27 = blocks[bi++];
                values[vi++] = (block26 & 0xFFFFFFFFL) << 21 | block27 >>> 43;
                long block28 = blocks[bi++];
                values[vi++] = (block27 & 0x7FFFFFFFFFFL) << 10 | block28 >>> 54;
                values[vi++] = block28 >>> 1 & 0x1FFFFFFFFFFFFFL;
                long block29 = blocks[bi++];
                values[vi++] = (block28 & 1L) << 52 | block29 >>> 12;
                long block30 = blocks[bi++];
                values[vi++] = (block29 & 0xFFFL) << 41 | block30 >>> 23;
                long block31 = blocks[bi++];
                values[vi++] = (block30 & 0x7FFFFFL) << 30 | block31 >>> 34;
                long block32 = blocks[bi++];
                values[vi++] = (block31 & 0x3FFFFFFFFL) << 19 | block32 >>> 45;
                long block33 = blocks[bi++];
                values[vi++] = (block32 & 0x1FFFFFFFFFFFL) << 8 | block33 >>> 56;
                values[vi++] = block33 >>> 3 & 0x1FFFFFFFFFFFFFL;
                long block34 = blocks[bi++];
                values[vi++] = (block33 & 7L) << 50 | block34 >>> 14;
                long block35 = blocks[bi++];
                values[vi++] = (block34 & 0x3FFFL) << 39 | block35 >>> 25;
                long block36 = blocks[bi++];
                values[vi++] = (block35 & 0x1FFFFFFL) << 28 | block36 >>> 36;
                long block37 = blocks[bi++];
                values[vi++] = (block36 & 0xFFFFFFFFFL) << 17 | block37 >>> 47;
                long block38 = blocks[bi++];
                values[vi++] = (block37 & 0x7FFFFFFFFFFFL) << 6 | block38 >>> 58;
                values[vi++] = block38 >>> 5 & 0x1FFFFFFFFFFFFFL;
                long block39 = blocks[bi++];
                values[vi++] = (block38 & 0x1FL) << 48 | block39 >>> 16;
                long block40 = blocks[bi++];
                values[vi++] = (block39 & 0xFFFFL) << 37 | block40 >>> 27;
                long block41 = blocks[bi++];
                values[vi++] = (block40 & 0x7FFFFFFL) << 26 | block41 >>> 38;
                long block42 = blocks[bi++];
                values[vi++] = (block41 & 0x3FFFFFFFFFL) << 15 | block42 >>> 49;
                long block43 = blocks[bi++];
                values[vi++] = (block42 & 0x1FFFFFFFFFFFFL) << 4 | block43 >>> 60;
                values[vi++] = block43 >>> 7 & 0x1FFFFFFFFFFFFFL;
                long block44 = blocks[bi++];
                values[vi++] = (block43 & 0x7FL) << 46 | block44 >>> 18;
                long block45 = blocks[bi++];
                values[vi++] = (block44 & 0x3FFFFL) << 35 | block45 >>> 29;
                long block46 = blocks[bi++];
                values[vi++] = (block45 & 0x1FFFFFFFL) << 24 | block46 >>> 40;
                long block47 = blocks[bi++];
                values[vi++] = (block46 & 0xFFFFFFFFFFL) << 13 | block47 >>> 51;
                long block48 = blocks[bi++];
                values[vi++] = (block47 & 0x7FFFFFFFFFFFFL) << 2 | block48 >>> 62;
                values[vi++] = block48 >>> 9 & 0x1FFFFFFFFFFFFFL;
                long block49 = blocks[bi++];
                values[vi++] = (block48 & 0x1FFL) << 44 | block49 >>> 20;
                long block50 = blocks[bi++];
                values[vi++] = (block49 & 0xFFFFFL) << 33 | block50 >>> 31;
                long block51 = blocks[bi++];
                values[vi++] = (block50 & Integer.MAX_VALUE) << 22 | block51 >>> 42;
                long block52 = blocks[bi++];
                values[vi++] = (block51 & 0x3FFFFFFFFFFL) << 11 | block52 >>> 53;
                values[vi++] = block52 & 0x1FFFFFFFFFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 11 | values[vi] >>> 42;
                blocks[bi++] = values[vi++] << 22 | values[vi] >>> 31;
                blocks[bi++] = values[vi++] << 33 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi] >>> 9;
                blocks[bi++] = values[vi++] << 55 | values[vi++] << 2 | values[vi] >>> 51;
                blocks[bi++] = values[vi++] << 13 | values[vi] >>> 40;
                blocks[bi++] = values[vi++] << 24 | values[vi] >>> 29;
                blocks[bi++] = values[vi++] << 35 | values[vi] >>> 18;
                blocks[bi++] = values[vi++] << 46 | values[vi] >>> 7;
                blocks[bi++] = values[vi++] << 57 | values[vi++] << 4 | values[vi] >>> 49;
                blocks[bi++] = values[vi++] << 15 | values[vi] >>> 38;
                blocks[bi++] = values[vi++] << 26 | values[vi] >>> 27;
                blocks[bi++] = values[vi++] << 37 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi] >>> 5;
                blocks[bi++] = values[vi++] << 59 | values[vi++] << 6 | values[vi] >>> 47;
                blocks[bi++] = values[vi++] << 17 | values[vi] >>> 36;
                blocks[bi++] = values[vi++] << 28 | values[vi] >>> 25;
                blocks[bi++] = values[vi++] << 39 | values[vi] >>> 14;
                blocks[bi++] = values[vi++] << 50 | values[vi] >>> 3;
                blocks[bi++] = values[vi++] << 61 | values[vi++] << 8 | values[vi] >>> 45;
                blocks[bi++] = values[vi++] << 19 | values[vi] >>> 34;
                blocks[bi++] = values[vi++] << 30 | values[vi] >>> 23;
                blocks[bi++] = values[vi++] << 41 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi] >>> 1;
                blocks[bi++] = values[vi++] << 63 | values[vi++] << 10 | values[vi] >>> 43;
                blocks[bi++] = values[vi++] << 21 | values[vi] >>> 32;
                blocks[bi++] = values[vi++] << 32 | values[vi] >>> 21;
                blocks[bi++] = values[vi++] << 43 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi++] << 1 | values[vi] >>> 52;
                blocks[bi++] = values[vi++] << 12 | values[vi] >>> 41;
                blocks[bi++] = values[vi++] << 23 | values[vi] >>> 30;
                blocks[bi++] = values[vi++] << 34 | values[vi] >>> 19;
                blocks[bi++] = values[vi++] << 45 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 3 | values[vi] >>> 50;
                blocks[bi++] = values[vi++] << 14 | values[vi] >>> 39;
                blocks[bi++] = values[vi++] << 25 | values[vi] >>> 28;
                blocks[bi++] = values[vi++] << 36 | values[vi] >>> 17;
                blocks[bi++] = values[vi++] << 47 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 5 | values[vi] >>> 48;
                blocks[bi++] = values[vi++] << 16 | values[vi] >>> 37;
                blocks[bi++] = values[vi++] << 27 | values[vi] >>> 26;
                blocks[bi++] = values[vi++] << 38 | values[vi] >>> 15;
                blocks[bi++] = values[vi++] << 49 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 7 | values[vi] >>> 46;
                blocks[bi++] = values[vi++] << 18 | values[vi] >>> 35;
                blocks[bi++] = values[vi++] << 29 | values[vi] >>> 24;
                blocks[bi++] = values[vi++] << 40 | values[vi] >>> 13;
                blocks[bi++] = values[vi++] << 51 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 9 | values[vi] >>> 44;
                blocks[bi++] = values[vi++] << 20 | values[vi] >>> 33;
                blocks[bi++] = values[vi++] << 31 | values[vi] >>> 22;
                blocks[bi++] = values[vi++] << 42 | values[vi] >>> 11;
                blocks[bi++] = values[vi++] << 53 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation52
    extends BulkOperation {
        Packed64BulkOperation52() {
        }

        @Override
        public int blocks() {
            return 13;
        }

        @Override
        public int values() {
            return 16;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 12;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0xFFFL) << 40 | block1 >>> 24;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0xFFFFFFL) << 28 | block2 >>> 36;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0xFFFFFFFFFL) << 16 | block3 >>> 48;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0xFFFFFFFFFFFFL) << 4 | block4 >>> 60;
                values[vi++] = block4 >>> 8 & 0xFFFFFFFFFFFFFL;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0xFFL) << 44 | block5 >>> 20;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0xFFFFFL) << 32 | block6 >>> 32;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0xFFFFFFFFL) << 20 | block7 >>> 44;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0xFFFFFFFFFFFL) << 8 | block8 >>> 56;
                values[vi++] = block8 >>> 4 & 0xFFFFFFFFFFFFFL;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0xFL) << 48 | block9 >>> 16;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 0xFFFFL) << 36 | block10 >>> 28;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 0xFFFFFFFL) << 24 | block11 >>> 40;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 0xFFFFFFFFFFL) << 12 | block12 >>> 52;
                values[vi++] = block12 & 0xFFFFFFFFFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 12 | values[vi] >>> 40;
                blocks[bi++] = values[vi++] << 24 | values[vi] >>> 28;
                blocks[bi++] = values[vi++] << 36 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 8 | values[vi] >>> 44;
                blocks[bi++] = values[vi++] << 20 | values[vi] >>> 32;
                blocks[bi++] = values[vi++] << 32 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 4 | values[vi] >>> 48;
                blocks[bi++] = values[vi++] << 16 | values[vi] >>> 36;
                blocks[bi++] = values[vi++] << 28 | values[vi] >>> 24;
                blocks[bi++] = values[vi++] << 40 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation51
    extends BulkOperation {
        Packed64BulkOperation51() {
        }

        @Override
        public int blocks() {
            return 51;
        }

        @Override
        public int values() {
            return 64;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 13;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0x1FFFL) << 38 | block1 >>> 26;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0x3FFFFFFL) << 25 | block2 >>> 39;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0x7FFFFFFFFFL) << 12 | block3 >>> 52;
                values[vi++] = block3 >>> 1 & 0x7FFFFFFFFFFFFL;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 1L) << 50 | block4 >>> 14;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0x3FFFL) << 37 | block5 >>> 27;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0x7FFFFFFL) << 24 | block6 >>> 40;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0xFFFFFFFFFFL) << 11 | block7 >>> 53;
                values[vi++] = block7 >>> 2 & 0x7FFFFFFFFFFFFL;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 3L) << 49 | block8 >>> 15;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0x7FFFL) << 36 | block9 >>> 28;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 0xFFFFFFFL) << 23 | block10 >>> 41;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 0x1FFFFFFFFFFL) << 10 | block11 >>> 54;
                values[vi++] = block11 >>> 3 & 0x7FFFFFFFFFFFFL;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 7L) << 48 | block12 >>> 16;
                long block13 = blocks[bi++];
                values[vi++] = (block12 & 0xFFFFL) << 35 | block13 >>> 29;
                long block14 = blocks[bi++];
                values[vi++] = (block13 & 0x1FFFFFFFL) << 22 | block14 >>> 42;
                long block15 = blocks[bi++];
                values[vi++] = (block14 & 0x3FFFFFFFFFFL) << 9 | block15 >>> 55;
                values[vi++] = block15 >>> 4 & 0x7FFFFFFFFFFFFL;
                long block16 = blocks[bi++];
                values[vi++] = (block15 & 0xFL) << 47 | block16 >>> 17;
                long block17 = blocks[bi++];
                values[vi++] = (block16 & 0x1FFFFL) << 34 | block17 >>> 30;
                long block18 = blocks[bi++];
                values[vi++] = (block17 & 0x3FFFFFFFL) << 21 | block18 >>> 43;
                long block19 = blocks[bi++];
                values[vi++] = (block18 & 0x7FFFFFFFFFFL) << 8 | block19 >>> 56;
                values[vi++] = block19 >>> 5 & 0x7FFFFFFFFFFFFL;
                long block20 = blocks[bi++];
                values[vi++] = (block19 & 0x1FL) << 46 | block20 >>> 18;
                long block21 = blocks[bi++];
                values[vi++] = (block20 & 0x3FFFFL) << 33 | block21 >>> 31;
                long block22 = blocks[bi++];
                values[vi++] = (block21 & Integer.MAX_VALUE) << 20 | block22 >>> 44;
                long block23 = blocks[bi++];
                values[vi++] = (block22 & 0xFFFFFFFFFFFL) << 7 | block23 >>> 57;
                values[vi++] = block23 >>> 6 & 0x7FFFFFFFFFFFFL;
                long block24 = blocks[bi++];
                values[vi++] = (block23 & 0x3FL) << 45 | block24 >>> 19;
                long block25 = blocks[bi++];
                values[vi++] = (block24 & 0x7FFFFL) << 32 | block25 >>> 32;
                long block26 = blocks[bi++];
                values[vi++] = (block25 & 0xFFFFFFFFL) << 19 | block26 >>> 45;
                long block27 = blocks[bi++];
                values[vi++] = (block26 & 0x1FFFFFFFFFFFL) << 6 | block27 >>> 58;
                values[vi++] = block27 >>> 7 & 0x7FFFFFFFFFFFFL;
                long block28 = blocks[bi++];
                values[vi++] = (block27 & 0x7FL) << 44 | block28 >>> 20;
                long block29 = blocks[bi++];
                values[vi++] = (block28 & 0xFFFFFL) << 31 | block29 >>> 33;
                long block30 = blocks[bi++];
                values[vi++] = (block29 & 0x1FFFFFFFFL) << 18 | block30 >>> 46;
                long block31 = blocks[bi++];
                values[vi++] = (block30 & 0x3FFFFFFFFFFFL) << 5 | block31 >>> 59;
                values[vi++] = block31 >>> 8 & 0x7FFFFFFFFFFFFL;
                long block32 = blocks[bi++];
                values[vi++] = (block31 & 0xFFL) << 43 | block32 >>> 21;
                long block33 = blocks[bi++];
                values[vi++] = (block32 & 0x1FFFFFL) << 30 | block33 >>> 34;
                long block34 = blocks[bi++];
                values[vi++] = (block33 & 0x3FFFFFFFFL) << 17 | block34 >>> 47;
                long block35 = blocks[bi++];
                values[vi++] = (block34 & 0x7FFFFFFFFFFFL) << 4 | block35 >>> 60;
                values[vi++] = block35 >>> 9 & 0x7FFFFFFFFFFFFL;
                long block36 = blocks[bi++];
                values[vi++] = (block35 & 0x1FFL) << 42 | block36 >>> 22;
                long block37 = blocks[bi++];
                values[vi++] = (block36 & 0x3FFFFFL) << 29 | block37 >>> 35;
                long block38 = blocks[bi++];
                values[vi++] = (block37 & 0x7FFFFFFFFL) << 16 | block38 >>> 48;
                long block39 = blocks[bi++];
                values[vi++] = (block38 & 0xFFFFFFFFFFFFL) << 3 | block39 >>> 61;
                values[vi++] = block39 >>> 10 & 0x7FFFFFFFFFFFFL;
                long block40 = blocks[bi++];
                values[vi++] = (block39 & 0x3FFL) << 41 | block40 >>> 23;
                long block41 = blocks[bi++];
                values[vi++] = (block40 & 0x7FFFFFL) << 28 | block41 >>> 36;
                long block42 = blocks[bi++];
                values[vi++] = (block41 & 0xFFFFFFFFFL) << 15 | block42 >>> 49;
                long block43 = blocks[bi++];
                values[vi++] = (block42 & 0x1FFFFFFFFFFFFL) << 2 | block43 >>> 62;
                values[vi++] = block43 >>> 11 & 0x7FFFFFFFFFFFFL;
                long block44 = blocks[bi++];
                values[vi++] = (block43 & 0x7FFL) << 40 | block44 >>> 24;
                long block45 = blocks[bi++];
                values[vi++] = (block44 & 0xFFFFFFL) << 27 | block45 >>> 37;
                long block46 = blocks[bi++];
                values[vi++] = (block45 & 0x1FFFFFFFFFL) << 14 | block46 >>> 50;
                long block47 = blocks[bi++];
                values[vi++] = (block46 & 0x3FFFFFFFFFFFFL) << 1 | block47 >>> 63;
                values[vi++] = block47 >>> 12 & 0x7FFFFFFFFFFFFL;
                long block48 = blocks[bi++];
                values[vi++] = (block47 & 0xFFFL) << 39 | block48 >>> 25;
                long block49 = blocks[bi++];
                values[vi++] = (block48 & 0x1FFFFFFL) << 26 | block49 >>> 38;
                long block50 = blocks[bi++];
                values[vi++] = (block49 & 0x3FFFFFFFFFL) << 13 | block50 >>> 51;
                values[vi++] = block50 & 0x7FFFFFFFFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 13 | values[vi] >>> 38;
                blocks[bi++] = values[vi++] << 26 | values[vi] >>> 25;
                blocks[bi++] = values[vi++] << 39 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi++] << 1 | values[vi] >>> 50;
                blocks[bi++] = values[vi++] << 14 | values[vi] >>> 37;
                blocks[bi++] = values[vi++] << 27 | values[vi] >>> 24;
                blocks[bi++] = values[vi++] << 40 | values[vi] >>> 11;
                blocks[bi++] = values[vi++] << 53 | values[vi++] << 2 | values[vi] >>> 49;
                blocks[bi++] = values[vi++] << 15 | values[vi] >>> 36;
                blocks[bi++] = values[vi++] << 28 | values[vi] >>> 23;
                blocks[bi++] = values[vi++] << 41 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi++] << 3 | values[vi] >>> 48;
                blocks[bi++] = values[vi++] << 16 | values[vi] >>> 35;
                blocks[bi++] = values[vi++] << 29 | values[vi] >>> 22;
                blocks[bi++] = values[vi++] << 42 | values[vi] >>> 9;
                blocks[bi++] = values[vi++] << 55 | values[vi++] << 4 | values[vi] >>> 47;
                blocks[bi++] = values[vi++] << 17 | values[vi] >>> 34;
                blocks[bi++] = values[vi++] << 30 | values[vi] >>> 21;
                blocks[bi++] = values[vi++] << 43 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 5 | values[vi] >>> 46;
                blocks[bi++] = values[vi++] << 18 | values[vi] >>> 33;
                blocks[bi++] = values[vi++] << 31 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi] >>> 7;
                blocks[bi++] = values[vi++] << 57 | values[vi++] << 6 | values[vi] >>> 45;
                blocks[bi++] = values[vi++] << 19 | values[vi] >>> 32;
                blocks[bi++] = values[vi++] << 32 | values[vi] >>> 19;
                blocks[bi++] = values[vi++] << 45 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 7 | values[vi] >>> 44;
                blocks[bi++] = values[vi++] << 20 | values[vi] >>> 31;
                blocks[bi++] = values[vi++] << 33 | values[vi] >>> 18;
                blocks[bi++] = values[vi++] << 46 | values[vi] >>> 5;
                blocks[bi++] = values[vi++] << 59 | values[vi++] << 8 | values[vi] >>> 43;
                blocks[bi++] = values[vi++] << 21 | values[vi] >>> 30;
                blocks[bi++] = values[vi++] << 34 | values[vi] >>> 17;
                blocks[bi++] = values[vi++] << 47 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 9 | values[vi] >>> 42;
                blocks[bi++] = values[vi++] << 22 | values[vi] >>> 29;
                blocks[bi++] = values[vi++] << 35 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi] >>> 3;
                blocks[bi++] = values[vi++] << 61 | values[vi++] << 10 | values[vi] >>> 41;
                blocks[bi++] = values[vi++] << 23 | values[vi] >>> 28;
                blocks[bi++] = values[vi++] << 36 | values[vi] >>> 15;
                blocks[bi++] = values[vi++] << 49 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 11 | values[vi] >>> 40;
                blocks[bi++] = values[vi++] << 24 | values[vi] >>> 27;
                blocks[bi++] = values[vi++] << 37 | values[vi] >>> 14;
                blocks[bi++] = values[vi++] << 50 | values[vi] >>> 1;
                blocks[bi++] = values[vi++] << 63 | values[vi++] << 12 | values[vi] >>> 39;
                blocks[bi++] = values[vi++] << 25 | values[vi] >>> 26;
                blocks[bi++] = values[vi++] << 38 | values[vi] >>> 13;
                blocks[bi++] = values[vi++] << 51 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation50
    extends BulkOperation {
        Packed64BulkOperation50() {
        }

        @Override
        public int blocks() {
            return 25;
        }

        @Override
        public int values() {
            return 32;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 14;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0x3FFFL) << 36 | block1 >>> 28;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0xFFFFFFFL) << 22 | block2 >>> 42;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0x3FFFFFFFFFFL) << 8 | block3 >>> 56;
                values[vi++] = block3 >>> 6 & 0x3FFFFFFFFFFFFL;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0x3FL) << 44 | block4 >>> 20;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0xFFFFFL) << 30 | block5 >>> 34;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0x3FFFFFFFFL) << 16 | block6 >>> 48;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0xFFFFFFFFFFFFL) << 2 | block7 >>> 62;
                values[vi++] = block7 >>> 12 & 0x3FFFFFFFFFFFFL;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0xFFFL) << 38 | block8 >>> 26;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0x3FFFFFFL) << 24 | block9 >>> 40;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 0xFFFFFFFFFFL) << 10 | block10 >>> 54;
                values[vi++] = block10 >>> 4 & 0x3FFFFFFFFFFFFL;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 0xFL) << 46 | block11 >>> 18;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 0x3FFFFL) << 32 | block12 >>> 32;
                long block13 = blocks[bi++];
                values[vi++] = (block12 & 0xFFFFFFFFL) << 18 | block13 >>> 46;
                long block14 = blocks[bi++];
                values[vi++] = (block13 & 0x3FFFFFFFFFFFL) << 4 | block14 >>> 60;
                values[vi++] = block14 >>> 10 & 0x3FFFFFFFFFFFFL;
                long block15 = blocks[bi++];
                values[vi++] = (block14 & 0x3FFL) << 40 | block15 >>> 24;
                long block16 = blocks[bi++];
                values[vi++] = (block15 & 0xFFFFFFL) << 26 | block16 >>> 38;
                long block17 = blocks[bi++];
                values[vi++] = (block16 & 0x3FFFFFFFFFL) << 12 | block17 >>> 52;
                values[vi++] = block17 >>> 2 & 0x3FFFFFFFFFFFFL;
                long block18 = blocks[bi++];
                values[vi++] = (block17 & 3L) << 48 | block18 >>> 16;
                long block19 = blocks[bi++];
                values[vi++] = (block18 & 0xFFFFL) << 34 | block19 >>> 30;
                long block20 = blocks[bi++];
                values[vi++] = (block19 & 0x3FFFFFFFL) << 20 | block20 >>> 44;
                long block21 = blocks[bi++];
                values[vi++] = (block20 & 0xFFFFFFFFFFFL) << 6 | block21 >>> 58;
                values[vi++] = block21 >>> 8 & 0x3FFFFFFFFFFFFL;
                long block22 = blocks[bi++];
                values[vi++] = (block21 & 0xFFL) << 42 | block22 >>> 22;
                long block23 = blocks[bi++];
                values[vi++] = (block22 & 0x3FFFFFL) << 28 | block23 >>> 36;
                long block24 = blocks[bi++];
                values[vi++] = (block23 & 0xFFFFFFFFFL) << 14 | block24 >>> 50;
                values[vi++] = block24 & 0x3FFFFFFFFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 14 | values[vi] >>> 36;
                blocks[bi++] = values[vi++] << 28 | values[vi] >>> 22;
                blocks[bi++] = values[vi++] << 42 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 6 | values[vi] >>> 44;
                blocks[bi++] = values[vi++] << 20 | values[vi] >>> 30;
                blocks[bi++] = values[vi++] << 34 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 12 | values[vi] >>> 38;
                blocks[bi++] = values[vi++] << 26 | values[vi] >>> 24;
                blocks[bi++] = values[vi++] << 40 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi++] << 4 | values[vi] >>> 46;
                blocks[bi++] = values[vi++] << 18 | values[vi] >>> 32;
                blocks[bi++] = values[vi++] << 32 | values[vi] >>> 18;
                blocks[bi++] = values[vi++] << 46 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 10 | values[vi] >>> 40;
                blocks[bi++] = values[vi++] << 24 | values[vi] >>> 26;
                blocks[bi++] = values[vi++] << 38 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi++] << 2 | values[vi] >>> 48;
                blocks[bi++] = values[vi++] << 16 | values[vi] >>> 34;
                blocks[bi++] = values[vi++] << 30 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 8 | values[vi] >>> 42;
                blocks[bi++] = values[vi++] << 22 | values[vi] >>> 28;
                blocks[bi++] = values[vi++] << 36 | values[vi] >>> 14;
                blocks[bi++] = values[vi++] << 50 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation49
    extends BulkOperation {
        Packed64BulkOperation49() {
        }

        @Override
        public int blocks() {
            return 49;
        }

        @Override
        public int values() {
            return 64;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 15;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0x7FFFL) << 34 | block1 >>> 30;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0x3FFFFFFFL) << 19 | block2 >>> 45;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0x1FFFFFFFFFFFL) << 4 | block3 >>> 60;
                values[vi++] = block3 >>> 11 & 0x1FFFFFFFFFFFFL;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0x7FFL) << 38 | block4 >>> 26;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0x3FFFFFFL) << 23 | block5 >>> 41;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0x1FFFFFFFFFFL) << 8 | block6 >>> 56;
                values[vi++] = block6 >>> 7 & 0x1FFFFFFFFFFFFL;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0x7FL) << 42 | block7 >>> 22;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0x3FFFFFL) << 27 | block8 >>> 37;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0x1FFFFFFFFFL) << 12 | block9 >>> 52;
                values[vi++] = block9 >>> 3 & 0x1FFFFFFFFFFFFL;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 7L) << 46 | block10 >>> 18;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 0x3FFFFL) << 31 | block11 >>> 33;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 0x1FFFFFFFFL) << 16 | block12 >>> 48;
                long block13 = blocks[bi++];
                values[vi++] = (block12 & 0xFFFFFFFFFFFFL) << 1 | block13 >>> 63;
                values[vi++] = block13 >>> 14 & 0x1FFFFFFFFFFFFL;
                long block14 = blocks[bi++];
                values[vi++] = (block13 & 0x3FFFL) << 35 | block14 >>> 29;
                long block15 = blocks[bi++];
                values[vi++] = (block14 & 0x1FFFFFFFL) << 20 | block15 >>> 44;
                long block16 = blocks[bi++];
                values[vi++] = (block15 & 0xFFFFFFFFFFFL) << 5 | block16 >>> 59;
                values[vi++] = block16 >>> 10 & 0x1FFFFFFFFFFFFL;
                long block17 = blocks[bi++];
                values[vi++] = (block16 & 0x3FFL) << 39 | block17 >>> 25;
                long block18 = blocks[bi++];
                values[vi++] = (block17 & 0x1FFFFFFL) << 24 | block18 >>> 40;
                long block19 = blocks[bi++];
                values[vi++] = (block18 & 0xFFFFFFFFFFL) << 9 | block19 >>> 55;
                values[vi++] = block19 >>> 6 & 0x1FFFFFFFFFFFFL;
                long block20 = blocks[bi++];
                values[vi++] = (block19 & 0x3FL) << 43 | block20 >>> 21;
                long block21 = blocks[bi++];
                values[vi++] = (block20 & 0x1FFFFFL) << 28 | block21 >>> 36;
                long block22 = blocks[bi++];
                values[vi++] = (block21 & 0xFFFFFFFFFL) << 13 | block22 >>> 51;
                values[vi++] = block22 >>> 2 & 0x1FFFFFFFFFFFFL;
                long block23 = blocks[bi++];
                values[vi++] = (block22 & 3L) << 47 | block23 >>> 17;
                long block24 = blocks[bi++];
                values[vi++] = (block23 & 0x1FFFFL) << 32 | block24 >>> 32;
                long block25 = blocks[bi++];
                values[vi++] = (block24 & 0xFFFFFFFFL) << 17 | block25 >>> 47;
                long block26 = blocks[bi++];
                values[vi++] = (block25 & 0x7FFFFFFFFFFFL) << 2 | block26 >>> 62;
                values[vi++] = block26 >>> 13 & 0x1FFFFFFFFFFFFL;
                long block27 = blocks[bi++];
                values[vi++] = (block26 & 0x1FFFL) << 36 | block27 >>> 28;
                long block28 = blocks[bi++];
                values[vi++] = (block27 & 0xFFFFFFFL) << 21 | block28 >>> 43;
                long block29 = blocks[bi++];
                values[vi++] = (block28 & 0x7FFFFFFFFFFL) << 6 | block29 >>> 58;
                values[vi++] = block29 >>> 9 & 0x1FFFFFFFFFFFFL;
                long block30 = blocks[bi++];
                values[vi++] = (block29 & 0x1FFL) << 40 | block30 >>> 24;
                long block31 = blocks[bi++];
                values[vi++] = (block30 & 0xFFFFFFL) << 25 | block31 >>> 39;
                long block32 = blocks[bi++];
                values[vi++] = (block31 & 0x7FFFFFFFFFL) << 10 | block32 >>> 54;
                values[vi++] = block32 >>> 5 & 0x1FFFFFFFFFFFFL;
                long block33 = blocks[bi++];
                values[vi++] = (block32 & 0x1FL) << 44 | block33 >>> 20;
                long block34 = blocks[bi++];
                values[vi++] = (block33 & 0xFFFFFL) << 29 | block34 >>> 35;
                long block35 = blocks[bi++];
                values[vi++] = (block34 & 0x7FFFFFFFFL) << 14 | block35 >>> 50;
                values[vi++] = block35 >>> 1 & 0x1FFFFFFFFFFFFL;
                long block36 = blocks[bi++];
                values[vi++] = (block35 & 1L) << 48 | block36 >>> 16;
                long block37 = blocks[bi++];
                values[vi++] = (block36 & 0xFFFFL) << 33 | block37 >>> 31;
                long block38 = blocks[bi++];
                values[vi++] = (block37 & Integer.MAX_VALUE) << 18 | block38 >>> 46;
                long block39 = blocks[bi++];
                values[vi++] = (block38 & 0x3FFFFFFFFFFFL) << 3 | block39 >>> 61;
                values[vi++] = block39 >>> 12 & 0x1FFFFFFFFFFFFL;
                long block40 = blocks[bi++];
                values[vi++] = (block39 & 0xFFFL) << 37 | block40 >>> 27;
                long block41 = blocks[bi++];
                values[vi++] = (block40 & 0x7FFFFFFL) << 22 | block41 >>> 42;
                long block42 = blocks[bi++];
                values[vi++] = (block41 & 0x3FFFFFFFFFFL) << 7 | block42 >>> 57;
                values[vi++] = block42 >>> 8 & 0x1FFFFFFFFFFFFL;
                long block43 = blocks[bi++];
                values[vi++] = (block42 & 0xFFL) << 41 | block43 >>> 23;
                long block44 = blocks[bi++];
                values[vi++] = (block43 & 0x7FFFFFL) << 26 | block44 >>> 38;
                long block45 = blocks[bi++];
                values[vi++] = (block44 & 0x3FFFFFFFFFL) << 11 | block45 >>> 53;
                values[vi++] = block45 >>> 4 & 0x1FFFFFFFFFFFFL;
                long block46 = blocks[bi++];
                values[vi++] = (block45 & 0xFL) << 45 | block46 >>> 19;
                long block47 = blocks[bi++];
                values[vi++] = (block46 & 0x7FFFFL) << 30 | block47 >>> 34;
                long block48 = blocks[bi++];
                values[vi++] = (block47 & 0x3FFFFFFFFL) << 15 | block48 >>> 49;
                values[vi++] = block48 & 0x1FFFFFFFFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 15 | values[vi] >>> 34;
                blocks[bi++] = values[vi++] << 30 | values[vi] >>> 19;
                blocks[bi++] = values[vi++] << 45 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 11 | values[vi] >>> 38;
                blocks[bi++] = values[vi++] << 26 | values[vi] >>> 23;
                blocks[bi++] = values[vi++] << 41 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 7 | values[vi] >>> 42;
                blocks[bi++] = values[vi++] << 22 | values[vi] >>> 27;
                blocks[bi++] = values[vi++] << 37 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi++] << 3 | values[vi] >>> 46;
                blocks[bi++] = values[vi++] << 18 | values[vi] >>> 31;
                blocks[bi++] = values[vi++] << 33 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi] >>> 1;
                blocks[bi++] = values[vi++] << 63 | values[vi++] << 14 | values[vi] >>> 35;
                blocks[bi++] = values[vi++] << 29 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi] >>> 5;
                blocks[bi++] = values[vi++] << 59 | values[vi++] << 10 | values[vi] >>> 39;
                blocks[bi++] = values[vi++] << 25 | values[vi] >>> 24;
                blocks[bi++] = values[vi++] << 40 | values[vi] >>> 9;
                blocks[bi++] = values[vi++] << 55 | values[vi++] << 6 | values[vi] >>> 43;
                blocks[bi++] = values[vi++] << 21 | values[vi] >>> 28;
                blocks[bi++] = values[vi++] << 36 | values[vi] >>> 13;
                blocks[bi++] = values[vi++] << 51 | values[vi++] << 2 | values[vi] >>> 47;
                blocks[bi++] = values[vi++] << 17 | values[vi] >>> 32;
                blocks[bi++] = values[vi++] << 32 | values[vi] >>> 17;
                blocks[bi++] = values[vi++] << 47 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 13 | values[vi] >>> 36;
                blocks[bi++] = values[vi++] << 28 | values[vi] >>> 21;
                blocks[bi++] = values[vi++] << 43 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 9 | values[vi] >>> 40;
                blocks[bi++] = values[vi++] << 24 | values[vi] >>> 25;
                blocks[bi++] = values[vi++] << 39 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi++] << 5 | values[vi] >>> 44;
                blocks[bi++] = values[vi++] << 20 | values[vi] >>> 29;
                blocks[bi++] = values[vi++] << 35 | values[vi] >>> 14;
                blocks[bi++] = values[vi++] << 50 | values[vi++] << 1 | values[vi] >>> 48;
                blocks[bi++] = values[vi++] << 16 | values[vi] >>> 33;
                blocks[bi++] = values[vi++] << 31 | values[vi] >>> 18;
                blocks[bi++] = values[vi++] << 46 | values[vi] >>> 3;
                blocks[bi++] = values[vi++] << 61 | values[vi++] << 12 | values[vi] >>> 37;
                blocks[bi++] = values[vi++] << 27 | values[vi] >>> 22;
                blocks[bi++] = values[vi++] << 42 | values[vi] >>> 7;
                blocks[bi++] = values[vi++] << 57 | values[vi++] << 8 | values[vi] >>> 41;
                blocks[bi++] = values[vi++] << 23 | values[vi] >>> 26;
                blocks[bi++] = values[vi++] << 38 | values[vi] >>> 11;
                blocks[bi++] = values[vi++] << 53 | values[vi++] << 4 | values[vi] >>> 45;
                blocks[bi++] = values[vi++] << 19 | values[vi] >>> 30;
                blocks[bi++] = values[vi++] << 34 | values[vi] >>> 15;
                blocks[bi++] = values[vi++] << 49 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation48
    extends BulkOperation {
        Packed64BulkOperation48() {
        }

        @Override
        public int blocks() {
            return 3;
        }

        @Override
        public int values() {
            return 4;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 16;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0xFFFFL) << 32 | block1 >>> 32;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0xFFFFFFFFL) << 16 | block2 >>> 48;
                values[vi++] = block2 & 0xFFFFFFFFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 16 | values[vi] >>> 32;
                blocks[bi++] = values[vi++] << 32 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation47
    extends BulkOperation {
        Packed64BulkOperation47() {
        }

        @Override
        public int blocks() {
            return 47;
        }

        @Override
        public int values() {
            return 64;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 17;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0x1FFFFL) << 30 | block1 >>> 34;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0x3FFFFFFFFL) << 13 | block2 >>> 51;
                values[vi++] = block2 >>> 4 & 0x7FFFFFFFFFFFL;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0xFL) << 43 | block3 >>> 21;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0x1FFFFFL) << 26 | block4 >>> 38;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0x3FFFFFFFFFL) << 9 | block5 >>> 55;
                values[vi++] = block5 >>> 8 & 0x7FFFFFFFFFFFL;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0xFFL) << 39 | block6 >>> 25;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0x1FFFFFFL) << 22 | block7 >>> 42;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0x3FFFFFFFFFFL) << 5 | block8 >>> 59;
                values[vi++] = block8 >>> 12 & 0x7FFFFFFFFFFFL;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0xFFFL) << 35 | block9 >>> 29;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 0x1FFFFFFFL) << 18 | block10 >>> 46;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 0x3FFFFFFFFFFFL) << 1 | block11 >>> 63;
                values[vi++] = block11 >>> 16 & 0x7FFFFFFFFFFFL;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 0xFFFFL) << 31 | block12 >>> 33;
                long block13 = blocks[bi++];
                values[vi++] = (block12 & 0x1FFFFFFFFL) << 14 | block13 >>> 50;
                values[vi++] = block13 >>> 3 & 0x7FFFFFFFFFFFL;
                long block14 = blocks[bi++];
                values[vi++] = (block13 & 7L) << 44 | block14 >>> 20;
                long block15 = blocks[bi++];
                values[vi++] = (block14 & 0xFFFFFL) << 27 | block15 >>> 37;
                long block16 = blocks[bi++];
                values[vi++] = (block15 & 0x1FFFFFFFFFL) << 10 | block16 >>> 54;
                values[vi++] = block16 >>> 7 & 0x7FFFFFFFFFFFL;
                long block17 = blocks[bi++];
                values[vi++] = (block16 & 0x7FL) << 40 | block17 >>> 24;
                long block18 = blocks[bi++];
                values[vi++] = (block17 & 0xFFFFFFL) << 23 | block18 >>> 41;
                long block19 = blocks[bi++];
                values[vi++] = (block18 & 0x1FFFFFFFFFFL) << 6 | block19 >>> 58;
                values[vi++] = block19 >>> 11 & 0x7FFFFFFFFFFFL;
                long block20 = blocks[bi++];
                values[vi++] = (block19 & 0x7FFL) << 36 | block20 >>> 28;
                long block21 = blocks[bi++];
                values[vi++] = (block20 & 0xFFFFFFFL) << 19 | block21 >>> 45;
                long block22 = blocks[bi++];
                values[vi++] = (block21 & 0x1FFFFFFFFFFFL) << 2 | block22 >>> 62;
                values[vi++] = block22 >>> 15 & 0x7FFFFFFFFFFFL;
                long block23 = blocks[bi++];
                values[vi++] = (block22 & 0x7FFFL) << 32 | block23 >>> 32;
                long block24 = blocks[bi++];
                values[vi++] = (block23 & 0xFFFFFFFFL) << 15 | block24 >>> 49;
                values[vi++] = block24 >>> 2 & 0x7FFFFFFFFFFFL;
                long block25 = blocks[bi++];
                values[vi++] = (block24 & 3L) << 45 | block25 >>> 19;
                long block26 = blocks[bi++];
                values[vi++] = (block25 & 0x7FFFFL) << 28 | block26 >>> 36;
                long block27 = blocks[bi++];
                values[vi++] = (block26 & 0xFFFFFFFFFL) << 11 | block27 >>> 53;
                values[vi++] = block27 >>> 6 & 0x7FFFFFFFFFFFL;
                long block28 = blocks[bi++];
                values[vi++] = (block27 & 0x3FL) << 41 | block28 >>> 23;
                long block29 = blocks[bi++];
                values[vi++] = (block28 & 0x7FFFFFL) << 24 | block29 >>> 40;
                long block30 = blocks[bi++];
                values[vi++] = (block29 & 0xFFFFFFFFFFL) << 7 | block30 >>> 57;
                values[vi++] = block30 >>> 10 & 0x7FFFFFFFFFFFL;
                long block31 = blocks[bi++];
                values[vi++] = (block30 & 0x3FFL) << 37 | block31 >>> 27;
                long block32 = blocks[bi++];
                values[vi++] = (block31 & 0x7FFFFFFL) << 20 | block32 >>> 44;
                long block33 = blocks[bi++];
                values[vi++] = (block32 & 0xFFFFFFFFFFFL) << 3 | block33 >>> 61;
                values[vi++] = block33 >>> 14 & 0x7FFFFFFFFFFFL;
                long block34 = blocks[bi++];
                values[vi++] = (block33 & 0x3FFFL) << 33 | block34 >>> 31;
                long block35 = blocks[bi++];
                values[vi++] = (block34 & Integer.MAX_VALUE) << 16 | block35 >>> 48;
                values[vi++] = block35 >>> 1 & 0x7FFFFFFFFFFFL;
                long block36 = blocks[bi++];
                values[vi++] = (block35 & 1L) << 46 | block36 >>> 18;
                long block37 = blocks[bi++];
                values[vi++] = (block36 & 0x3FFFFL) << 29 | block37 >>> 35;
                long block38 = blocks[bi++];
                values[vi++] = (block37 & 0x7FFFFFFFFL) << 12 | block38 >>> 52;
                values[vi++] = block38 >>> 5 & 0x7FFFFFFFFFFFL;
                long block39 = blocks[bi++];
                values[vi++] = (block38 & 0x1FL) << 42 | block39 >>> 22;
                long block40 = blocks[bi++];
                values[vi++] = (block39 & 0x3FFFFFL) << 25 | block40 >>> 39;
                long block41 = blocks[bi++];
                values[vi++] = (block40 & 0x7FFFFFFFFFL) << 8 | block41 >>> 56;
                values[vi++] = block41 >>> 9 & 0x7FFFFFFFFFFFL;
                long block42 = blocks[bi++];
                values[vi++] = (block41 & 0x1FFL) << 38 | block42 >>> 26;
                long block43 = blocks[bi++];
                values[vi++] = (block42 & 0x3FFFFFFL) << 21 | block43 >>> 43;
                long block44 = blocks[bi++];
                values[vi++] = (block43 & 0x7FFFFFFFFFFL) << 4 | block44 >>> 60;
                values[vi++] = block44 >>> 13 & 0x7FFFFFFFFFFFL;
                long block45 = blocks[bi++];
                values[vi++] = (block44 & 0x1FFFL) << 34 | block45 >>> 30;
                long block46 = blocks[bi++];
                values[vi++] = (block45 & 0x3FFFFFFFL) << 17 | block46 >>> 47;
                values[vi++] = block46 & 0x7FFFFFFFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 17 | values[vi] >>> 30;
                blocks[bi++] = values[vi++] << 34 | values[vi] >>> 13;
                blocks[bi++] = values[vi++] << 51 | values[vi++] << 4 | values[vi] >>> 43;
                blocks[bi++] = values[vi++] << 21 | values[vi] >>> 26;
                blocks[bi++] = values[vi++] << 38 | values[vi] >>> 9;
                blocks[bi++] = values[vi++] << 55 | values[vi++] << 8 | values[vi] >>> 39;
                blocks[bi++] = values[vi++] << 25 | values[vi] >>> 22;
                blocks[bi++] = values[vi++] << 42 | values[vi] >>> 5;
                blocks[bi++] = values[vi++] << 59 | values[vi++] << 12 | values[vi] >>> 35;
                blocks[bi++] = values[vi++] << 29 | values[vi] >>> 18;
                blocks[bi++] = values[vi++] << 46 | values[vi] >>> 1;
                blocks[bi++] = values[vi++] << 63 | values[vi++] << 16 | values[vi] >>> 31;
                blocks[bi++] = values[vi++] << 33 | values[vi] >>> 14;
                blocks[bi++] = values[vi++] << 50 | values[vi++] << 3 | values[vi] >>> 44;
                blocks[bi++] = values[vi++] << 20 | values[vi] >>> 27;
                blocks[bi++] = values[vi++] << 37 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi++] << 7 | values[vi] >>> 40;
                blocks[bi++] = values[vi++] << 24 | values[vi] >>> 23;
                blocks[bi++] = values[vi++] << 41 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 11 | values[vi] >>> 36;
                blocks[bi++] = values[vi++] << 28 | values[vi] >>> 19;
                blocks[bi++] = values[vi++] << 45 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 15 | values[vi] >>> 32;
                blocks[bi++] = values[vi++] << 32 | values[vi] >>> 15;
                blocks[bi++] = values[vi++] << 49 | values[vi++] << 2 | values[vi] >>> 45;
                blocks[bi++] = values[vi++] << 19 | values[vi] >>> 28;
                blocks[bi++] = values[vi++] << 36 | values[vi] >>> 11;
                blocks[bi++] = values[vi++] << 53 | values[vi++] << 6 | values[vi] >>> 41;
                blocks[bi++] = values[vi++] << 23 | values[vi] >>> 24;
                blocks[bi++] = values[vi++] << 40 | values[vi] >>> 7;
                blocks[bi++] = values[vi++] << 57 | values[vi++] << 10 | values[vi] >>> 37;
                blocks[bi++] = values[vi++] << 27 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi] >>> 3;
                blocks[bi++] = values[vi++] << 61 | values[vi++] << 14 | values[vi] >>> 33;
                blocks[bi++] = values[vi++] << 31 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi++] << 1 | values[vi] >>> 46;
                blocks[bi++] = values[vi++] << 18 | values[vi] >>> 29;
                blocks[bi++] = values[vi++] << 35 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi++] << 5 | values[vi] >>> 42;
                blocks[bi++] = values[vi++] << 22 | values[vi] >>> 25;
                blocks[bi++] = values[vi++] << 39 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 9 | values[vi] >>> 38;
                blocks[bi++] = values[vi++] << 26 | values[vi] >>> 21;
                blocks[bi++] = values[vi++] << 43 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 13 | values[vi] >>> 34;
                blocks[bi++] = values[vi++] << 30 | values[vi] >>> 17;
                blocks[bi++] = values[vi++] << 47 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation46
    extends BulkOperation {
        Packed64BulkOperation46() {
        }

        @Override
        public int blocks() {
            return 23;
        }

        @Override
        public int values() {
            return 32;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 18;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0x3FFFFL) << 28 | block1 >>> 36;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0xFFFFFFFFFL) << 10 | block2 >>> 54;
                values[vi++] = block2 >>> 8 & 0x3FFFFFFFFFFFL;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0xFFL) << 38 | block3 >>> 26;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0x3FFFFFFL) << 20 | block4 >>> 44;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0xFFFFFFFFFFFL) << 2 | block5 >>> 62;
                values[vi++] = block5 >>> 16 & 0x3FFFFFFFFFFFL;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0xFFFFL) << 30 | block6 >>> 34;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0x3FFFFFFFFL) << 12 | block7 >>> 52;
                values[vi++] = block7 >>> 6 & 0x3FFFFFFFFFFFL;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0x3FL) << 40 | block8 >>> 24;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0xFFFFFFL) << 22 | block9 >>> 42;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 0x3FFFFFFFFFFL) << 4 | block10 >>> 60;
                values[vi++] = block10 >>> 14 & 0x3FFFFFFFFFFFL;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 0x3FFFL) << 32 | block11 >>> 32;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 0xFFFFFFFFL) << 14 | block12 >>> 50;
                values[vi++] = block12 >>> 4 & 0x3FFFFFFFFFFFL;
                long block13 = blocks[bi++];
                values[vi++] = (block12 & 0xFL) << 42 | block13 >>> 22;
                long block14 = blocks[bi++];
                values[vi++] = (block13 & 0x3FFFFFL) << 24 | block14 >>> 40;
                long block15 = blocks[bi++];
                values[vi++] = (block14 & 0xFFFFFFFFFFL) << 6 | block15 >>> 58;
                values[vi++] = block15 >>> 12 & 0x3FFFFFFFFFFFL;
                long block16 = blocks[bi++];
                values[vi++] = (block15 & 0xFFFL) << 34 | block16 >>> 30;
                long block17 = blocks[bi++];
                values[vi++] = (block16 & 0x3FFFFFFFL) << 16 | block17 >>> 48;
                values[vi++] = block17 >>> 2 & 0x3FFFFFFFFFFFL;
                long block18 = blocks[bi++];
                values[vi++] = (block17 & 3L) << 44 | block18 >>> 20;
                long block19 = blocks[bi++];
                values[vi++] = (block18 & 0xFFFFFL) << 26 | block19 >>> 38;
                long block20 = blocks[bi++];
                values[vi++] = (block19 & 0x3FFFFFFFFFL) << 8 | block20 >>> 56;
                values[vi++] = block20 >>> 10 & 0x3FFFFFFFFFFFL;
                long block21 = blocks[bi++];
                values[vi++] = (block20 & 0x3FFL) << 36 | block21 >>> 28;
                long block22 = blocks[bi++];
                values[vi++] = (block21 & 0xFFFFFFFL) << 18 | block22 >>> 46;
                values[vi++] = block22 & 0x3FFFFFFFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 18 | values[vi] >>> 28;
                blocks[bi++] = values[vi++] << 36 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi++] << 8 | values[vi] >>> 38;
                blocks[bi++] = values[vi++] << 26 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 16 | values[vi] >>> 30;
                blocks[bi++] = values[vi++] << 34 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi++] << 6 | values[vi] >>> 40;
                blocks[bi++] = values[vi++] << 24 | values[vi] >>> 22;
                blocks[bi++] = values[vi++] << 42 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 14 | values[vi] >>> 32;
                blocks[bi++] = values[vi++] << 32 | values[vi] >>> 14;
                blocks[bi++] = values[vi++] << 50 | values[vi++] << 4 | values[vi] >>> 42;
                blocks[bi++] = values[vi++] << 22 | values[vi] >>> 24;
                blocks[bi++] = values[vi++] << 40 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 12 | values[vi] >>> 34;
                blocks[bi++] = values[vi++] << 30 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi++] << 2 | values[vi] >>> 44;
                blocks[bi++] = values[vi++] << 20 | values[vi] >>> 26;
                blocks[bi++] = values[vi++] << 38 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 10 | values[vi] >>> 36;
                blocks[bi++] = values[vi++] << 28 | values[vi] >>> 18;
                blocks[bi++] = values[vi++] << 46 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation45
    extends BulkOperation {
        Packed64BulkOperation45() {
        }

        @Override
        public int blocks() {
            return 45;
        }

        @Override
        public int values() {
            return 64;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 19;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0x7FFFFL) << 26 | block1 >>> 38;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0x3FFFFFFFFFL) << 7 | block2 >>> 57;
                values[vi++] = block2 >>> 12 & 0x1FFFFFFFFFFFL;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0xFFFL) << 33 | block3 >>> 31;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & Integer.MAX_VALUE) << 14 | block4 >>> 50;
                values[vi++] = block4 >>> 5 & 0x1FFFFFFFFFFFL;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0x1FL) << 40 | block5 >>> 24;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0xFFFFFFL) << 21 | block6 >>> 43;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0x7FFFFFFFFFFL) << 2 | block7 >>> 62;
                values[vi++] = block7 >>> 17 & 0x1FFFFFFFFFFFL;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0x1FFFFL) << 28 | block8 >>> 36;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0xFFFFFFFFFL) << 9 | block9 >>> 55;
                values[vi++] = block9 >>> 10 & 0x1FFFFFFFFFFFL;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 0x3FFL) << 35 | block10 >>> 29;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 0x1FFFFFFFL) << 16 | block11 >>> 48;
                values[vi++] = block11 >>> 3 & 0x1FFFFFFFFFFFL;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 7L) << 42 | block12 >>> 22;
                long block13 = blocks[bi++];
                values[vi++] = (block12 & 0x3FFFFFL) << 23 | block13 >>> 41;
                long block14 = blocks[bi++];
                values[vi++] = (block13 & 0x1FFFFFFFFFFL) << 4 | block14 >>> 60;
                values[vi++] = block14 >>> 15 & 0x1FFFFFFFFFFFL;
                long block15 = blocks[bi++];
                values[vi++] = (block14 & 0x7FFFL) << 30 | block15 >>> 34;
                long block16 = blocks[bi++];
                values[vi++] = (block15 & 0x3FFFFFFFFL) << 11 | block16 >>> 53;
                values[vi++] = block16 >>> 8 & 0x1FFFFFFFFFFFL;
                long block17 = blocks[bi++];
                values[vi++] = (block16 & 0xFFL) << 37 | block17 >>> 27;
                long block18 = blocks[bi++];
                values[vi++] = (block17 & 0x7FFFFFFL) << 18 | block18 >>> 46;
                values[vi++] = block18 >>> 1 & 0x1FFFFFFFFFFFL;
                long block19 = blocks[bi++];
                values[vi++] = (block18 & 1L) << 44 | block19 >>> 20;
                long block20 = blocks[bi++];
                values[vi++] = (block19 & 0xFFFFFL) << 25 | block20 >>> 39;
                long block21 = blocks[bi++];
                values[vi++] = (block20 & 0x7FFFFFFFFFL) << 6 | block21 >>> 58;
                values[vi++] = block21 >>> 13 & 0x1FFFFFFFFFFFL;
                long block22 = blocks[bi++];
                values[vi++] = (block21 & 0x1FFFL) << 32 | block22 >>> 32;
                long block23 = blocks[bi++];
                values[vi++] = (block22 & 0xFFFFFFFFL) << 13 | block23 >>> 51;
                values[vi++] = block23 >>> 6 & 0x1FFFFFFFFFFFL;
                long block24 = blocks[bi++];
                values[vi++] = (block23 & 0x3FL) << 39 | block24 >>> 25;
                long block25 = blocks[bi++];
                values[vi++] = (block24 & 0x1FFFFFFL) << 20 | block25 >>> 44;
                long block26 = blocks[bi++];
                values[vi++] = (block25 & 0xFFFFFFFFFFFL) << 1 | block26 >>> 63;
                values[vi++] = block26 >>> 18 & 0x1FFFFFFFFFFFL;
                long block27 = blocks[bi++];
                values[vi++] = (block26 & 0x3FFFFL) << 27 | block27 >>> 37;
                long block28 = blocks[bi++];
                values[vi++] = (block27 & 0x1FFFFFFFFFL) << 8 | block28 >>> 56;
                values[vi++] = block28 >>> 11 & 0x1FFFFFFFFFFFL;
                long block29 = blocks[bi++];
                values[vi++] = (block28 & 0x7FFL) << 34 | block29 >>> 30;
                long block30 = blocks[bi++];
                values[vi++] = (block29 & 0x3FFFFFFFL) << 15 | block30 >>> 49;
                values[vi++] = block30 >>> 4 & 0x1FFFFFFFFFFFL;
                long block31 = blocks[bi++];
                values[vi++] = (block30 & 0xFL) << 41 | block31 >>> 23;
                long block32 = blocks[bi++];
                values[vi++] = (block31 & 0x7FFFFFL) << 22 | block32 >>> 42;
                long block33 = blocks[bi++];
                values[vi++] = (block32 & 0x3FFFFFFFFFFL) << 3 | block33 >>> 61;
                values[vi++] = block33 >>> 16 & 0x1FFFFFFFFFFFL;
                long block34 = blocks[bi++];
                values[vi++] = (block33 & 0xFFFFL) << 29 | block34 >>> 35;
                long block35 = blocks[bi++];
                values[vi++] = (block34 & 0x7FFFFFFFFL) << 10 | block35 >>> 54;
                values[vi++] = block35 >>> 9 & 0x1FFFFFFFFFFFL;
                long block36 = blocks[bi++];
                values[vi++] = (block35 & 0x1FFL) << 36 | block36 >>> 28;
                long block37 = blocks[bi++];
                values[vi++] = (block36 & 0xFFFFFFFL) << 17 | block37 >>> 47;
                values[vi++] = block37 >>> 2 & 0x1FFFFFFFFFFFL;
                long block38 = blocks[bi++];
                values[vi++] = (block37 & 3L) << 43 | block38 >>> 21;
                long block39 = blocks[bi++];
                values[vi++] = (block38 & 0x1FFFFFL) << 24 | block39 >>> 40;
                long block40 = blocks[bi++];
                values[vi++] = (block39 & 0xFFFFFFFFFFL) << 5 | block40 >>> 59;
                values[vi++] = block40 >>> 14 & 0x1FFFFFFFFFFFL;
                long block41 = blocks[bi++];
                values[vi++] = (block40 & 0x3FFFL) << 31 | block41 >>> 33;
                long block42 = blocks[bi++];
                values[vi++] = (block41 & 0x1FFFFFFFFL) << 12 | block42 >>> 52;
                values[vi++] = block42 >>> 7 & 0x1FFFFFFFFFFFL;
                long block43 = blocks[bi++];
                values[vi++] = (block42 & 0x7FL) << 38 | block43 >>> 26;
                long block44 = blocks[bi++];
                values[vi++] = (block43 & 0x3FFFFFFL) << 19 | block44 >>> 45;
                values[vi++] = block44 & 0x1FFFFFFFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 19 | values[vi] >>> 26;
                blocks[bi++] = values[vi++] << 38 | values[vi] >>> 7;
                blocks[bi++] = values[vi++] << 57 | values[vi++] << 12 | values[vi] >>> 33;
                blocks[bi++] = values[vi++] << 31 | values[vi] >>> 14;
                blocks[bi++] = values[vi++] << 50 | values[vi++] << 5 | values[vi] >>> 40;
                blocks[bi++] = values[vi++] << 24 | values[vi] >>> 21;
                blocks[bi++] = values[vi++] << 43 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 17 | values[vi] >>> 28;
                blocks[bi++] = values[vi++] << 36 | values[vi] >>> 9;
                blocks[bi++] = values[vi++] << 55 | values[vi++] << 10 | values[vi] >>> 35;
                blocks[bi++] = values[vi++] << 29 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi++] << 3 | values[vi] >>> 42;
                blocks[bi++] = values[vi++] << 22 | values[vi] >>> 23;
                blocks[bi++] = values[vi++] << 41 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 15 | values[vi] >>> 30;
                blocks[bi++] = values[vi++] << 34 | values[vi] >>> 11;
                blocks[bi++] = values[vi++] << 53 | values[vi++] << 8 | values[vi] >>> 37;
                blocks[bi++] = values[vi++] << 27 | values[vi] >>> 18;
                blocks[bi++] = values[vi++] << 46 | values[vi++] << 1 | values[vi] >>> 44;
                blocks[bi++] = values[vi++] << 20 | values[vi] >>> 25;
                blocks[bi++] = values[vi++] << 39 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 13 | values[vi] >>> 32;
                blocks[bi++] = values[vi++] << 32 | values[vi] >>> 13;
                blocks[bi++] = values[vi++] << 51 | values[vi++] << 6 | values[vi] >>> 39;
                blocks[bi++] = values[vi++] << 25 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi] >>> 1;
                blocks[bi++] = values[vi++] << 63 | values[vi++] << 18 | values[vi] >>> 27;
                blocks[bi++] = values[vi++] << 37 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 11 | values[vi] >>> 34;
                blocks[bi++] = values[vi++] << 30 | values[vi] >>> 15;
                blocks[bi++] = values[vi++] << 49 | values[vi++] << 4 | values[vi] >>> 41;
                blocks[bi++] = values[vi++] << 23 | values[vi] >>> 22;
                blocks[bi++] = values[vi++] << 42 | values[vi] >>> 3;
                blocks[bi++] = values[vi++] << 61 | values[vi++] << 16 | values[vi] >>> 29;
                blocks[bi++] = values[vi++] << 35 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi++] << 9 | values[vi] >>> 36;
                blocks[bi++] = values[vi++] << 28 | values[vi] >>> 17;
                blocks[bi++] = values[vi++] << 47 | values[vi++] << 2 | values[vi] >>> 43;
                blocks[bi++] = values[vi++] << 21 | values[vi] >>> 24;
                blocks[bi++] = values[vi++] << 40 | values[vi] >>> 5;
                blocks[bi++] = values[vi++] << 59 | values[vi++] << 14 | values[vi] >>> 31;
                blocks[bi++] = values[vi++] << 33 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi++] << 7 | values[vi] >>> 38;
                blocks[bi++] = values[vi++] << 26 | values[vi] >>> 19;
                blocks[bi++] = values[vi++] << 45 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation44
    extends BulkOperation {
        Packed64BulkOperation44() {
        }

        @Override
        public int blocks() {
            return 11;
        }

        @Override
        public int values() {
            return 16;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 20;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0xFFFFFL) << 24 | block1 >>> 40;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0xFFFFFFFFFFL) << 4 | block2 >>> 60;
                values[vi++] = block2 >>> 16 & 0xFFFFFFFFFFFL;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0xFFFFL) << 28 | block3 >>> 36;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0xFFFFFFFFFL) << 8 | block4 >>> 56;
                values[vi++] = block4 >>> 12 & 0xFFFFFFFFFFFL;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0xFFFL) << 32 | block5 >>> 32;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0xFFFFFFFFL) << 12 | block6 >>> 52;
                values[vi++] = block6 >>> 8 & 0xFFFFFFFFFFFL;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0xFFL) << 36 | block7 >>> 28;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0xFFFFFFFL) << 16 | block8 >>> 48;
                values[vi++] = block8 >>> 4 & 0xFFFFFFFFFFFL;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0xFL) << 40 | block9 >>> 24;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 0xFFFFFFL) << 20 | block10 >>> 44;
                values[vi++] = block10 & 0xFFFFFFFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 20 | values[vi] >>> 24;
                blocks[bi++] = values[vi++] << 40 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 16 | values[vi] >>> 28;
                blocks[bi++] = values[vi++] << 36 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 12 | values[vi] >>> 32;
                blocks[bi++] = values[vi++] << 32 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi++] << 8 | values[vi] >>> 36;
                blocks[bi++] = values[vi++] << 28 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi++] << 4 | values[vi] >>> 40;
                blocks[bi++] = values[vi++] << 24 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation43
    extends BulkOperation {
        Packed64BulkOperation43() {
        }

        @Override
        public int blocks() {
            return 43;
        }

        @Override
        public int values() {
            return 64;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 21;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0x1FFFFFL) << 22 | block1 >>> 42;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0x3FFFFFFFFFFL) << 1 | block2 >>> 63;
                values[vi++] = block2 >>> 20 & 0x7FFFFFFFFFFL;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0xFFFFFL) << 23 | block3 >>> 41;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0x1FFFFFFFFFFL) << 2 | block4 >>> 62;
                values[vi++] = block4 >>> 19 & 0x7FFFFFFFFFFL;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0x7FFFFL) << 24 | block5 >>> 40;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0xFFFFFFFFFFL) << 3 | block6 >>> 61;
                values[vi++] = block6 >>> 18 & 0x7FFFFFFFFFFL;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0x3FFFFL) << 25 | block7 >>> 39;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0x7FFFFFFFFFL) << 4 | block8 >>> 60;
                values[vi++] = block8 >>> 17 & 0x7FFFFFFFFFFL;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0x1FFFFL) << 26 | block9 >>> 38;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 0x3FFFFFFFFFL) << 5 | block10 >>> 59;
                values[vi++] = block10 >>> 16 & 0x7FFFFFFFFFFL;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 0xFFFFL) << 27 | block11 >>> 37;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 0x1FFFFFFFFFL) << 6 | block12 >>> 58;
                values[vi++] = block12 >>> 15 & 0x7FFFFFFFFFFL;
                long block13 = blocks[bi++];
                values[vi++] = (block12 & 0x7FFFL) << 28 | block13 >>> 36;
                long block14 = blocks[bi++];
                values[vi++] = (block13 & 0xFFFFFFFFFL) << 7 | block14 >>> 57;
                values[vi++] = block14 >>> 14 & 0x7FFFFFFFFFFL;
                long block15 = blocks[bi++];
                values[vi++] = (block14 & 0x3FFFL) << 29 | block15 >>> 35;
                long block16 = blocks[bi++];
                values[vi++] = (block15 & 0x7FFFFFFFFL) << 8 | block16 >>> 56;
                values[vi++] = block16 >>> 13 & 0x7FFFFFFFFFFL;
                long block17 = blocks[bi++];
                values[vi++] = (block16 & 0x1FFFL) << 30 | block17 >>> 34;
                long block18 = blocks[bi++];
                values[vi++] = (block17 & 0x3FFFFFFFFL) << 9 | block18 >>> 55;
                values[vi++] = block18 >>> 12 & 0x7FFFFFFFFFFL;
                long block19 = blocks[bi++];
                values[vi++] = (block18 & 0xFFFL) << 31 | block19 >>> 33;
                long block20 = blocks[bi++];
                values[vi++] = (block19 & 0x1FFFFFFFFL) << 10 | block20 >>> 54;
                values[vi++] = block20 >>> 11 & 0x7FFFFFFFFFFL;
                long block21 = blocks[bi++];
                values[vi++] = (block20 & 0x7FFL) << 32 | block21 >>> 32;
                long block22 = blocks[bi++];
                values[vi++] = (block21 & 0xFFFFFFFFL) << 11 | block22 >>> 53;
                values[vi++] = block22 >>> 10 & 0x7FFFFFFFFFFL;
                long block23 = blocks[bi++];
                values[vi++] = (block22 & 0x3FFL) << 33 | block23 >>> 31;
                long block24 = blocks[bi++];
                values[vi++] = (block23 & Integer.MAX_VALUE) << 12 | block24 >>> 52;
                values[vi++] = block24 >>> 9 & 0x7FFFFFFFFFFL;
                long block25 = blocks[bi++];
                values[vi++] = (block24 & 0x1FFL) << 34 | block25 >>> 30;
                long block26 = blocks[bi++];
                values[vi++] = (block25 & 0x3FFFFFFFL) << 13 | block26 >>> 51;
                values[vi++] = block26 >>> 8 & 0x7FFFFFFFFFFL;
                long block27 = blocks[bi++];
                values[vi++] = (block26 & 0xFFL) << 35 | block27 >>> 29;
                long block28 = blocks[bi++];
                values[vi++] = (block27 & 0x1FFFFFFFL) << 14 | block28 >>> 50;
                values[vi++] = block28 >>> 7 & 0x7FFFFFFFFFFL;
                long block29 = blocks[bi++];
                values[vi++] = (block28 & 0x7FL) << 36 | block29 >>> 28;
                long block30 = blocks[bi++];
                values[vi++] = (block29 & 0xFFFFFFFL) << 15 | block30 >>> 49;
                values[vi++] = block30 >>> 6 & 0x7FFFFFFFFFFL;
                long block31 = blocks[bi++];
                values[vi++] = (block30 & 0x3FL) << 37 | block31 >>> 27;
                long block32 = blocks[bi++];
                values[vi++] = (block31 & 0x7FFFFFFL) << 16 | block32 >>> 48;
                values[vi++] = block32 >>> 5 & 0x7FFFFFFFFFFL;
                long block33 = blocks[bi++];
                values[vi++] = (block32 & 0x1FL) << 38 | block33 >>> 26;
                long block34 = blocks[bi++];
                values[vi++] = (block33 & 0x3FFFFFFL) << 17 | block34 >>> 47;
                values[vi++] = block34 >>> 4 & 0x7FFFFFFFFFFL;
                long block35 = blocks[bi++];
                values[vi++] = (block34 & 0xFL) << 39 | block35 >>> 25;
                long block36 = blocks[bi++];
                values[vi++] = (block35 & 0x1FFFFFFL) << 18 | block36 >>> 46;
                values[vi++] = block36 >>> 3 & 0x7FFFFFFFFFFL;
                long block37 = blocks[bi++];
                values[vi++] = (block36 & 7L) << 40 | block37 >>> 24;
                long block38 = blocks[bi++];
                values[vi++] = (block37 & 0xFFFFFFL) << 19 | block38 >>> 45;
                values[vi++] = block38 >>> 2 & 0x7FFFFFFFFFFL;
                long block39 = blocks[bi++];
                values[vi++] = (block38 & 3L) << 41 | block39 >>> 23;
                long block40 = blocks[bi++];
                values[vi++] = (block39 & 0x7FFFFFL) << 20 | block40 >>> 44;
                values[vi++] = block40 >>> 1 & 0x7FFFFFFFFFFL;
                long block41 = blocks[bi++];
                values[vi++] = (block40 & 1L) << 42 | block41 >>> 22;
                long block42 = blocks[bi++];
                values[vi++] = (block41 & 0x3FFFFFL) << 21 | block42 >>> 43;
                values[vi++] = block42 & 0x7FFFFFFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 21 | values[vi] >>> 22;
                blocks[bi++] = values[vi++] << 42 | values[vi] >>> 1;
                blocks[bi++] = values[vi++] << 63 | values[vi++] << 20 | values[vi] >>> 23;
                blocks[bi++] = values[vi++] << 41 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 19 | values[vi] >>> 24;
                blocks[bi++] = values[vi++] << 40 | values[vi] >>> 3;
                blocks[bi++] = values[vi++] << 61 | values[vi++] << 18 | values[vi] >>> 25;
                blocks[bi++] = values[vi++] << 39 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 17 | values[vi] >>> 26;
                blocks[bi++] = values[vi++] << 38 | values[vi] >>> 5;
                blocks[bi++] = values[vi++] << 59 | values[vi++] << 16 | values[vi] >>> 27;
                blocks[bi++] = values[vi++] << 37 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 15 | values[vi] >>> 28;
                blocks[bi++] = values[vi++] << 36 | values[vi] >>> 7;
                blocks[bi++] = values[vi++] << 57 | values[vi++] << 14 | values[vi] >>> 29;
                blocks[bi++] = values[vi++] << 35 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 13 | values[vi] >>> 30;
                blocks[bi++] = values[vi++] << 34 | values[vi] >>> 9;
                blocks[bi++] = values[vi++] << 55 | values[vi++] << 12 | values[vi] >>> 31;
                blocks[bi++] = values[vi++] << 33 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi++] << 11 | values[vi] >>> 32;
                blocks[bi++] = values[vi++] << 32 | values[vi] >>> 11;
                blocks[bi++] = values[vi++] << 53 | values[vi++] << 10 | values[vi] >>> 33;
                blocks[bi++] = values[vi++] << 31 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi++] << 9 | values[vi] >>> 34;
                blocks[bi++] = values[vi++] << 30 | values[vi] >>> 13;
                blocks[bi++] = values[vi++] << 51 | values[vi++] << 8 | values[vi] >>> 35;
                blocks[bi++] = values[vi++] << 29 | values[vi] >>> 14;
                blocks[bi++] = values[vi++] << 50 | values[vi++] << 7 | values[vi] >>> 36;
                blocks[bi++] = values[vi++] << 28 | values[vi] >>> 15;
                blocks[bi++] = values[vi++] << 49 | values[vi++] << 6 | values[vi] >>> 37;
                blocks[bi++] = values[vi++] << 27 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi++] << 5 | values[vi] >>> 38;
                blocks[bi++] = values[vi++] << 26 | values[vi] >>> 17;
                blocks[bi++] = values[vi++] << 47 | values[vi++] << 4 | values[vi] >>> 39;
                blocks[bi++] = values[vi++] << 25 | values[vi] >>> 18;
                blocks[bi++] = values[vi++] << 46 | values[vi++] << 3 | values[vi] >>> 40;
                blocks[bi++] = values[vi++] << 24 | values[vi] >>> 19;
                blocks[bi++] = values[vi++] << 45 | values[vi++] << 2 | values[vi] >>> 41;
                blocks[bi++] = values[vi++] << 23 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi++] << 1 | values[vi] >>> 42;
                blocks[bi++] = values[vi++] << 22 | values[vi] >>> 21;
                blocks[bi++] = values[vi++] << 43 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation42
    extends BulkOperation {
        Packed64BulkOperation42() {
        }

        @Override
        public int blocks() {
            return 21;
        }

        @Override
        public int values() {
            return 32;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 22;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0x3FFFFFL) << 20 | block1 >>> 44;
                values[vi++] = block1 >>> 2 & 0x3FFFFFFFFFFL;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 3L) << 40 | block2 >>> 24;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0xFFFFFFL) << 18 | block3 >>> 46;
                values[vi++] = block3 >>> 4 & 0x3FFFFFFFFFFL;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0xFL) << 38 | block4 >>> 26;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0x3FFFFFFL) << 16 | block5 >>> 48;
                values[vi++] = block5 >>> 6 & 0x3FFFFFFFFFFL;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0x3FL) << 36 | block6 >>> 28;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0xFFFFFFFL) << 14 | block7 >>> 50;
                values[vi++] = block7 >>> 8 & 0x3FFFFFFFFFFL;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0xFFL) << 34 | block8 >>> 30;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0x3FFFFFFFL) << 12 | block9 >>> 52;
                values[vi++] = block9 >>> 10 & 0x3FFFFFFFFFFL;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 0x3FFL) << 32 | block10 >>> 32;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 0xFFFFFFFFL) << 10 | block11 >>> 54;
                values[vi++] = block11 >>> 12 & 0x3FFFFFFFFFFL;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 0xFFFL) << 30 | block12 >>> 34;
                long block13 = blocks[bi++];
                values[vi++] = (block12 & 0x3FFFFFFFFL) << 8 | block13 >>> 56;
                values[vi++] = block13 >>> 14 & 0x3FFFFFFFFFFL;
                long block14 = blocks[bi++];
                values[vi++] = (block13 & 0x3FFFL) << 28 | block14 >>> 36;
                long block15 = blocks[bi++];
                values[vi++] = (block14 & 0xFFFFFFFFFL) << 6 | block15 >>> 58;
                values[vi++] = block15 >>> 16 & 0x3FFFFFFFFFFL;
                long block16 = blocks[bi++];
                values[vi++] = (block15 & 0xFFFFL) << 26 | block16 >>> 38;
                long block17 = blocks[bi++];
                values[vi++] = (block16 & 0x3FFFFFFFFFL) << 4 | block17 >>> 60;
                values[vi++] = block17 >>> 18 & 0x3FFFFFFFFFFL;
                long block18 = blocks[bi++];
                values[vi++] = (block17 & 0x3FFFFL) << 24 | block18 >>> 40;
                long block19 = blocks[bi++];
                values[vi++] = (block18 & 0xFFFFFFFFFFL) << 2 | block19 >>> 62;
                values[vi++] = block19 >>> 20 & 0x3FFFFFFFFFFL;
                long block20 = blocks[bi++];
                values[vi++] = (block19 & 0xFFFFFL) << 22 | block20 >>> 42;
                values[vi++] = block20 & 0x3FFFFFFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 22 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi++] << 2 | values[vi] >>> 40;
                blocks[bi++] = values[vi++] << 24 | values[vi] >>> 18;
                blocks[bi++] = values[vi++] << 46 | values[vi++] << 4 | values[vi] >>> 38;
                blocks[bi++] = values[vi++] << 26 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi++] << 6 | values[vi] >>> 36;
                blocks[bi++] = values[vi++] << 28 | values[vi] >>> 14;
                blocks[bi++] = values[vi++] << 50 | values[vi++] << 8 | values[vi] >>> 34;
                blocks[bi++] = values[vi++] << 30 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi++] << 10 | values[vi] >>> 32;
                blocks[bi++] = values[vi++] << 32 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi++] << 12 | values[vi] >>> 30;
                blocks[bi++] = values[vi++] << 34 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 14 | values[vi] >>> 28;
                blocks[bi++] = values[vi++] << 36 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 16 | values[vi] >>> 26;
                blocks[bi++] = values[vi++] << 38 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 18 | values[vi] >>> 24;
                blocks[bi++] = values[vi++] << 40 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 20 | values[vi] >>> 22;
                blocks[bi++] = values[vi++] << 42 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation41
    extends BulkOperation {
        Packed64BulkOperation41() {
        }

        @Override
        public int blocks() {
            return 41;
        }

        @Override
        public int values() {
            return 64;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 23;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0x7FFFFFL) << 18 | block1 >>> 46;
                values[vi++] = block1 >>> 5 & 0x1FFFFFFFFFFL;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0x1FL) << 36 | block2 >>> 28;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0xFFFFFFFL) << 13 | block3 >>> 51;
                values[vi++] = block3 >>> 10 & 0x1FFFFFFFFFFL;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0x3FFL) << 31 | block4 >>> 33;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0x1FFFFFFFFL) << 8 | block5 >>> 56;
                values[vi++] = block5 >>> 15 & 0x1FFFFFFFFFFL;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0x7FFFL) << 26 | block6 >>> 38;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0x3FFFFFFFFFL) << 3 | block7 >>> 61;
                values[vi++] = block7 >>> 20 & 0x1FFFFFFFFFFL;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0xFFFFFL) << 21 | block8 >>> 43;
                values[vi++] = block8 >>> 2 & 0x1FFFFFFFFFFL;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 3L) << 39 | block9 >>> 25;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 0x1FFFFFFL) << 16 | block10 >>> 48;
                values[vi++] = block10 >>> 7 & 0x1FFFFFFFFFFL;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 0x7FL) << 34 | block11 >>> 30;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 0x3FFFFFFFL) << 11 | block12 >>> 53;
                values[vi++] = block12 >>> 12 & 0x1FFFFFFFFFFL;
                long block13 = blocks[bi++];
                values[vi++] = (block12 & 0xFFFL) << 29 | block13 >>> 35;
                long block14 = blocks[bi++];
                values[vi++] = (block13 & 0x7FFFFFFFFL) << 6 | block14 >>> 58;
                values[vi++] = block14 >>> 17 & 0x1FFFFFFFFFFL;
                long block15 = blocks[bi++];
                values[vi++] = (block14 & 0x1FFFFL) << 24 | block15 >>> 40;
                long block16 = blocks[bi++];
                values[vi++] = (block15 & 0xFFFFFFFFFFL) << 1 | block16 >>> 63;
                values[vi++] = block16 >>> 22 & 0x1FFFFFFFFFFL;
                long block17 = blocks[bi++];
                values[vi++] = (block16 & 0x3FFFFFL) << 19 | block17 >>> 45;
                values[vi++] = block17 >>> 4 & 0x1FFFFFFFFFFL;
                long block18 = blocks[bi++];
                values[vi++] = (block17 & 0xFL) << 37 | block18 >>> 27;
                long block19 = blocks[bi++];
                values[vi++] = (block18 & 0x7FFFFFFL) << 14 | block19 >>> 50;
                values[vi++] = block19 >>> 9 & 0x1FFFFFFFFFFL;
                long block20 = blocks[bi++];
                values[vi++] = (block19 & 0x1FFL) << 32 | block20 >>> 32;
                long block21 = blocks[bi++];
                values[vi++] = (block20 & 0xFFFFFFFFL) << 9 | block21 >>> 55;
                values[vi++] = block21 >>> 14 & 0x1FFFFFFFFFFL;
                long block22 = blocks[bi++];
                values[vi++] = (block21 & 0x3FFFL) << 27 | block22 >>> 37;
                long block23 = blocks[bi++];
                values[vi++] = (block22 & 0x1FFFFFFFFFL) << 4 | block23 >>> 60;
                values[vi++] = block23 >>> 19 & 0x1FFFFFFFFFFL;
                long block24 = blocks[bi++];
                values[vi++] = (block23 & 0x7FFFFL) << 22 | block24 >>> 42;
                values[vi++] = block24 >>> 1 & 0x1FFFFFFFFFFL;
                long block25 = blocks[bi++];
                values[vi++] = (block24 & 1L) << 40 | block25 >>> 24;
                long block26 = blocks[bi++];
                values[vi++] = (block25 & 0xFFFFFFL) << 17 | block26 >>> 47;
                values[vi++] = block26 >>> 6 & 0x1FFFFFFFFFFL;
                long block27 = blocks[bi++];
                values[vi++] = (block26 & 0x3FL) << 35 | block27 >>> 29;
                long block28 = blocks[bi++];
                values[vi++] = (block27 & 0x1FFFFFFFL) << 12 | block28 >>> 52;
                values[vi++] = block28 >>> 11 & 0x1FFFFFFFFFFL;
                long block29 = blocks[bi++];
                values[vi++] = (block28 & 0x7FFL) << 30 | block29 >>> 34;
                long block30 = blocks[bi++];
                values[vi++] = (block29 & 0x3FFFFFFFFL) << 7 | block30 >>> 57;
                values[vi++] = block30 >>> 16 & 0x1FFFFFFFFFFL;
                long block31 = blocks[bi++];
                values[vi++] = (block30 & 0xFFFFL) << 25 | block31 >>> 39;
                long block32 = blocks[bi++];
                values[vi++] = (block31 & 0x7FFFFFFFFFL) << 2 | block32 >>> 62;
                values[vi++] = block32 >>> 21 & 0x1FFFFFFFFFFL;
                long block33 = blocks[bi++];
                values[vi++] = (block32 & 0x1FFFFFL) << 20 | block33 >>> 44;
                values[vi++] = block33 >>> 3 & 0x1FFFFFFFFFFL;
                long block34 = blocks[bi++];
                values[vi++] = (block33 & 7L) << 38 | block34 >>> 26;
                long block35 = blocks[bi++];
                values[vi++] = (block34 & 0x3FFFFFFL) << 15 | block35 >>> 49;
                values[vi++] = block35 >>> 8 & 0x1FFFFFFFFFFL;
                long block36 = blocks[bi++];
                values[vi++] = (block35 & 0xFFL) << 33 | block36 >>> 31;
                long block37 = blocks[bi++];
                values[vi++] = (block36 & Integer.MAX_VALUE) << 10 | block37 >>> 54;
                values[vi++] = block37 >>> 13 & 0x1FFFFFFFFFFL;
                long block38 = blocks[bi++];
                values[vi++] = (block37 & 0x1FFFL) << 28 | block38 >>> 36;
                long block39 = blocks[bi++];
                values[vi++] = (block38 & 0xFFFFFFFFFL) << 5 | block39 >>> 59;
                values[vi++] = block39 >>> 18 & 0x1FFFFFFFFFFL;
                long block40 = blocks[bi++];
                values[vi++] = (block39 & 0x3FFFFL) << 23 | block40 >>> 41;
                values[vi++] = block40 & 0x1FFFFFFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 23 | values[vi] >>> 18;
                blocks[bi++] = values[vi++] << 46 | values[vi++] << 5 | values[vi] >>> 36;
                blocks[bi++] = values[vi++] << 28 | values[vi] >>> 13;
                blocks[bi++] = values[vi++] << 51 | values[vi++] << 10 | values[vi] >>> 31;
                blocks[bi++] = values[vi++] << 33 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 15 | values[vi] >>> 26;
                blocks[bi++] = values[vi++] << 38 | values[vi] >>> 3;
                blocks[bi++] = values[vi++] << 61 | values[vi++] << 20 | values[vi] >>> 21;
                blocks[bi++] = values[vi++] << 43 | values[vi++] << 2 | values[vi] >>> 39;
                blocks[bi++] = values[vi++] << 25 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi++] << 7 | values[vi] >>> 34;
                blocks[bi++] = values[vi++] << 30 | values[vi] >>> 11;
                blocks[bi++] = values[vi++] << 53 | values[vi++] << 12 | values[vi] >>> 29;
                blocks[bi++] = values[vi++] << 35 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 17 | values[vi] >>> 24;
                blocks[bi++] = values[vi++] << 40 | values[vi] >>> 1;
                blocks[bi++] = values[vi++] << 63 | values[vi++] << 22 | values[vi] >>> 19;
                blocks[bi++] = values[vi++] << 45 | values[vi++] << 4 | values[vi] >>> 37;
                blocks[bi++] = values[vi++] << 27 | values[vi] >>> 14;
                blocks[bi++] = values[vi++] << 50 | values[vi++] << 9 | values[vi] >>> 32;
                blocks[bi++] = values[vi++] << 32 | values[vi] >>> 9;
                blocks[bi++] = values[vi++] << 55 | values[vi++] << 14 | values[vi] >>> 27;
                blocks[bi++] = values[vi++] << 37 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 19 | values[vi] >>> 22;
                blocks[bi++] = values[vi++] << 42 | values[vi++] << 1 | values[vi] >>> 40;
                blocks[bi++] = values[vi++] << 24 | values[vi] >>> 17;
                blocks[bi++] = values[vi++] << 47 | values[vi++] << 6 | values[vi] >>> 35;
                blocks[bi++] = values[vi++] << 29 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi++] << 11 | values[vi] >>> 30;
                blocks[bi++] = values[vi++] << 34 | values[vi] >>> 7;
                blocks[bi++] = values[vi++] << 57 | values[vi++] << 16 | values[vi] >>> 25;
                blocks[bi++] = values[vi++] << 39 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 21 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi++] << 3 | values[vi] >>> 38;
                blocks[bi++] = values[vi++] << 26 | values[vi] >>> 15;
                blocks[bi++] = values[vi++] << 49 | values[vi++] << 8 | values[vi] >>> 33;
                blocks[bi++] = values[vi++] << 31 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi++] << 13 | values[vi] >>> 28;
                blocks[bi++] = values[vi++] << 36 | values[vi] >>> 5;
                blocks[bi++] = values[vi++] << 59 | values[vi++] << 18 | values[vi] >>> 23;
                blocks[bi++] = values[vi++] << 41 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation40
    extends BulkOperation {
        Packed64BulkOperation40() {
        }

        @Override
        public int blocks() {
            return 5;
        }

        @Override
        public int values() {
            return 8;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 24;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0xFFFFFFL) << 16 | block1 >>> 48;
                values[vi++] = block1 >>> 8 & 0xFFFFFFFFFFL;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0xFFL) << 32 | block2 >>> 32;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0xFFFFFFFFL) << 8 | block3 >>> 56;
                values[vi++] = block3 >>> 16 & 0xFFFFFFFFFFL;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0xFFFFL) << 24 | block4 >>> 40;
                values[vi++] = block4 & 0xFFFFFFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 24 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi++] << 8 | values[vi] >>> 32;
                blocks[bi++] = values[vi++] << 32 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 16 | values[vi] >>> 24;
                blocks[bi++] = values[vi++] << 40 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation39
    extends BulkOperation {
        Packed64BulkOperation39() {
        }

        @Override
        public int blocks() {
            return 39;
        }

        @Override
        public int values() {
            return 64;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 25;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0x1FFFFFFL) << 14 | block1 >>> 50;
                values[vi++] = block1 >>> 11 & 0x7FFFFFFFFFL;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0x7FFL) << 28 | block2 >>> 36;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0xFFFFFFFFFL) << 3 | block3 >>> 61;
                values[vi++] = block3 >>> 22 & 0x7FFFFFFFFFL;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0x3FFFFFL) << 17 | block4 >>> 47;
                values[vi++] = block4 >>> 8 & 0x7FFFFFFFFFL;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0xFFL) << 31 | block5 >>> 33;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0x1FFFFFFFFL) << 6 | block6 >>> 58;
                values[vi++] = block6 >>> 19 & 0x7FFFFFFFFFL;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0x7FFFFL) << 20 | block7 >>> 44;
                values[vi++] = block7 >>> 5 & 0x7FFFFFFFFFL;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0x1FL) << 34 | block8 >>> 30;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0x3FFFFFFFL) << 9 | block9 >>> 55;
                values[vi++] = block9 >>> 16 & 0x7FFFFFFFFFL;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 0xFFFFL) << 23 | block10 >>> 41;
                values[vi++] = block10 >>> 2 & 0x7FFFFFFFFFL;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 3L) << 37 | block11 >>> 27;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 0x7FFFFFFL) << 12 | block12 >>> 52;
                values[vi++] = block12 >>> 13 & 0x7FFFFFFFFFL;
                long block13 = blocks[bi++];
                values[vi++] = (block12 & 0x1FFFL) << 26 | block13 >>> 38;
                long block14 = blocks[bi++];
                values[vi++] = (block13 & 0x3FFFFFFFFFL) << 1 | block14 >>> 63;
                values[vi++] = block14 >>> 24 & 0x7FFFFFFFFFL;
                long block15 = blocks[bi++];
                values[vi++] = (block14 & 0xFFFFFFL) << 15 | block15 >>> 49;
                values[vi++] = block15 >>> 10 & 0x7FFFFFFFFFL;
                long block16 = blocks[bi++];
                values[vi++] = (block15 & 0x3FFL) << 29 | block16 >>> 35;
                long block17 = blocks[bi++];
                values[vi++] = (block16 & 0x7FFFFFFFFL) << 4 | block17 >>> 60;
                values[vi++] = block17 >>> 21 & 0x7FFFFFFFFFL;
                long block18 = blocks[bi++];
                values[vi++] = (block17 & 0x1FFFFFL) << 18 | block18 >>> 46;
                values[vi++] = block18 >>> 7 & 0x7FFFFFFFFFL;
                long block19 = blocks[bi++];
                values[vi++] = (block18 & 0x7FL) << 32 | block19 >>> 32;
                long block20 = blocks[bi++];
                values[vi++] = (block19 & 0xFFFFFFFFL) << 7 | block20 >>> 57;
                values[vi++] = block20 >>> 18 & 0x7FFFFFFFFFL;
                long block21 = blocks[bi++];
                values[vi++] = (block20 & 0x3FFFFL) << 21 | block21 >>> 43;
                values[vi++] = block21 >>> 4 & 0x7FFFFFFFFFL;
                long block22 = blocks[bi++];
                values[vi++] = (block21 & 0xFL) << 35 | block22 >>> 29;
                long block23 = blocks[bi++];
                values[vi++] = (block22 & 0x1FFFFFFFL) << 10 | block23 >>> 54;
                values[vi++] = block23 >>> 15 & 0x7FFFFFFFFFL;
                long block24 = blocks[bi++];
                values[vi++] = (block23 & 0x7FFFL) << 24 | block24 >>> 40;
                values[vi++] = block24 >>> 1 & 0x7FFFFFFFFFL;
                long block25 = blocks[bi++];
                values[vi++] = (block24 & 1L) << 38 | block25 >>> 26;
                long block26 = blocks[bi++];
                values[vi++] = (block25 & 0x3FFFFFFL) << 13 | block26 >>> 51;
                values[vi++] = block26 >>> 12 & 0x7FFFFFFFFFL;
                long block27 = blocks[bi++];
                values[vi++] = (block26 & 0xFFFL) << 27 | block27 >>> 37;
                long block28 = blocks[bi++];
                values[vi++] = (block27 & 0x1FFFFFFFFFL) << 2 | block28 >>> 62;
                values[vi++] = block28 >>> 23 & 0x7FFFFFFFFFL;
                long block29 = blocks[bi++];
                values[vi++] = (block28 & 0x7FFFFFL) << 16 | block29 >>> 48;
                values[vi++] = block29 >>> 9 & 0x7FFFFFFFFFL;
                long block30 = blocks[bi++];
                values[vi++] = (block29 & 0x1FFL) << 30 | block30 >>> 34;
                long block31 = blocks[bi++];
                values[vi++] = (block30 & 0x3FFFFFFFFL) << 5 | block31 >>> 59;
                values[vi++] = block31 >>> 20 & 0x7FFFFFFFFFL;
                long block32 = blocks[bi++];
                values[vi++] = (block31 & 0xFFFFFL) << 19 | block32 >>> 45;
                values[vi++] = block32 >>> 6 & 0x7FFFFFFFFFL;
                long block33 = blocks[bi++];
                values[vi++] = (block32 & 0x3FL) << 33 | block33 >>> 31;
                long block34 = blocks[bi++];
                values[vi++] = (block33 & Integer.MAX_VALUE) << 8 | block34 >>> 56;
                values[vi++] = block34 >>> 17 & 0x7FFFFFFFFFL;
                long block35 = blocks[bi++];
                values[vi++] = (block34 & 0x1FFFFL) << 22 | block35 >>> 42;
                values[vi++] = block35 >>> 3 & 0x7FFFFFFFFFL;
                long block36 = blocks[bi++];
                values[vi++] = (block35 & 7L) << 36 | block36 >>> 28;
                long block37 = blocks[bi++];
                values[vi++] = (block36 & 0xFFFFFFFL) << 11 | block37 >>> 53;
                values[vi++] = block37 >>> 14 & 0x7FFFFFFFFFL;
                long block38 = blocks[bi++];
                values[vi++] = (block37 & 0x3FFFL) << 25 | block38 >>> 39;
                values[vi++] = block38 & 0x7FFFFFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 25 | values[vi] >>> 14;
                blocks[bi++] = values[vi++] << 50 | values[vi++] << 11 | values[vi] >>> 28;
                blocks[bi++] = values[vi++] << 36 | values[vi] >>> 3;
                blocks[bi++] = values[vi++] << 61 | values[vi++] << 22 | values[vi] >>> 17;
                blocks[bi++] = values[vi++] << 47 | values[vi++] << 8 | values[vi] >>> 31;
                blocks[bi++] = values[vi++] << 33 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 19 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi++] << 5 | values[vi] >>> 34;
                blocks[bi++] = values[vi++] << 30 | values[vi] >>> 9;
                blocks[bi++] = values[vi++] << 55 | values[vi++] << 16 | values[vi] >>> 23;
                blocks[bi++] = values[vi++] << 41 | values[vi++] << 2 | values[vi] >>> 37;
                blocks[bi++] = values[vi++] << 27 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi++] << 13 | values[vi] >>> 26;
                blocks[bi++] = values[vi++] << 38 | values[vi] >>> 1;
                blocks[bi++] = values[vi++] << 63 | values[vi++] << 24 | values[vi] >>> 15;
                blocks[bi++] = values[vi++] << 49 | values[vi++] << 10 | values[vi] >>> 29;
                blocks[bi++] = values[vi++] << 35 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 21 | values[vi] >>> 18;
                blocks[bi++] = values[vi++] << 46 | values[vi++] << 7 | values[vi] >>> 32;
                blocks[bi++] = values[vi++] << 32 | values[vi] >>> 7;
                blocks[bi++] = values[vi++] << 57 | values[vi++] << 18 | values[vi] >>> 21;
                blocks[bi++] = values[vi++] << 43 | values[vi++] << 4 | values[vi] >>> 35;
                blocks[bi++] = values[vi++] << 29 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi++] << 15 | values[vi] >>> 24;
                blocks[bi++] = values[vi++] << 40 | values[vi++] << 1 | values[vi] >>> 38;
                blocks[bi++] = values[vi++] << 26 | values[vi] >>> 13;
                blocks[bi++] = values[vi++] << 51 | values[vi++] << 12 | values[vi] >>> 27;
                blocks[bi++] = values[vi++] << 37 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 23 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi++] << 9 | values[vi] >>> 30;
                blocks[bi++] = values[vi++] << 34 | values[vi] >>> 5;
                blocks[bi++] = values[vi++] << 59 | values[vi++] << 20 | values[vi] >>> 19;
                blocks[bi++] = values[vi++] << 45 | values[vi++] << 6 | values[vi] >>> 33;
                blocks[bi++] = values[vi++] << 31 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 17 | values[vi] >>> 22;
                blocks[bi++] = values[vi++] << 42 | values[vi++] << 3 | values[vi] >>> 36;
                blocks[bi++] = values[vi++] << 28 | values[vi] >>> 11;
                blocks[bi++] = values[vi++] << 53 | values[vi++] << 14 | values[vi] >>> 25;
                blocks[bi++] = values[vi++] << 39 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation38
    extends BulkOperation {
        Packed64BulkOperation38() {
        }

        @Override
        public int blocks() {
            return 19;
        }

        @Override
        public int values() {
            return 32;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 26;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0x3FFFFFFL) << 12 | block1 >>> 52;
                values[vi++] = block1 >>> 14 & 0x3FFFFFFFFFL;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0x3FFFL) << 24 | block2 >>> 40;
                values[vi++] = block2 >>> 2 & 0x3FFFFFFFFFL;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 3L) << 36 | block3 >>> 28;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0xFFFFFFFL) << 10 | block4 >>> 54;
                values[vi++] = block4 >>> 16 & 0x3FFFFFFFFFL;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0xFFFFL) << 22 | block5 >>> 42;
                values[vi++] = block5 >>> 4 & 0x3FFFFFFFFFL;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0xFL) << 34 | block6 >>> 30;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0x3FFFFFFFL) << 8 | block7 >>> 56;
                values[vi++] = block7 >>> 18 & 0x3FFFFFFFFFL;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0x3FFFFL) << 20 | block8 >>> 44;
                values[vi++] = block8 >>> 6 & 0x3FFFFFFFFFL;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0x3FL) << 32 | block9 >>> 32;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 0xFFFFFFFFL) << 6 | block10 >>> 58;
                values[vi++] = block10 >>> 20 & 0x3FFFFFFFFFL;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 0xFFFFFL) << 18 | block11 >>> 46;
                values[vi++] = block11 >>> 8 & 0x3FFFFFFFFFL;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 0xFFL) << 30 | block12 >>> 34;
                long block13 = blocks[bi++];
                values[vi++] = (block12 & 0x3FFFFFFFFL) << 4 | block13 >>> 60;
                values[vi++] = block13 >>> 22 & 0x3FFFFFFFFFL;
                long block14 = blocks[bi++];
                values[vi++] = (block13 & 0x3FFFFFL) << 16 | block14 >>> 48;
                values[vi++] = block14 >>> 10 & 0x3FFFFFFFFFL;
                long block15 = blocks[bi++];
                values[vi++] = (block14 & 0x3FFL) << 28 | block15 >>> 36;
                long block16 = blocks[bi++];
                values[vi++] = (block15 & 0xFFFFFFFFFL) << 2 | block16 >>> 62;
                values[vi++] = block16 >>> 24 & 0x3FFFFFFFFFL;
                long block17 = blocks[bi++];
                values[vi++] = (block16 & 0xFFFFFFL) << 14 | block17 >>> 50;
                values[vi++] = block17 >>> 12 & 0x3FFFFFFFFFL;
                long block18 = blocks[bi++];
                values[vi++] = (block17 & 0xFFFL) << 26 | block18 >>> 38;
                values[vi++] = block18 & 0x3FFFFFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 26 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi++] << 14 | values[vi] >>> 24;
                blocks[bi++] = values[vi++] << 40 | values[vi++] << 2 | values[vi] >>> 36;
                blocks[bi++] = values[vi++] << 28 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi++] << 16 | values[vi] >>> 22;
                blocks[bi++] = values[vi++] << 42 | values[vi++] << 4 | values[vi] >>> 34;
                blocks[bi++] = values[vi++] << 30 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 18 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi++] << 6 | values[vi] >>> 32;
                blocks[bi++] = values[vi++] << 32 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 20 | values[vi] >>> 18;
                blocks[bi++] = values[vi++] << 46 | values[vi++] << 8 | values[vi] >>> 30;
                blocks[bi++] = values[vi++] << 34 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 22 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi++] << 10 | values[vi] >>> 28;
                blocks[bi++] = values[vi++] << 36 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 24 | values[vi] >>> 14;
                blocks[bi++] = values[vi++] << 50 | values[vi++] << 12 | values[vi] >>> 26;
                blocks[bi++] = values[vi++] << 38 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation37
    extends BulkOperation {
        Packed64BulkOperation37() {
        }

        @Override
        public int blocks() {
            return 37;
        }

        @Override
        public int values() {
            return 64;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 27;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0x7FFFFFFL) << 10 | block1 >>> 54;
                values[vi++] = block1 >>> 17 & 0x1FFFFFFFFFL;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0x1FFFFL) << 20 | block2 >>> 44;
                values[vi++] = block2 >>> 7 & 0x1FFFFFFFFFL;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0x7FL) << 30 | block3 >>> 34;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0x3FFFFFFFFL) << 3 | block4 >>> 61;
                values[vi++] = block4 >>> 24 & 0x1FFFFFFFFFL;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0xFFFFFFL) << 13 | block5 >>> 51;
                values[vi++] = block5 >>> 14 & 0x1FFFFFFFFFL;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0x3FFFL) << 23 | block6 >>> 41;
                values[vi++] = block6 >>> 4 & 0x1FFFFFFFFFL;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0xFL) << 33 | block7 >>> 31;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & Integer.MAX_VALUE) << 6 | block8 >>> 58;
                values[vi++] = block8 >>> 21 & 0x1FFFFFFFFFL;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0x1FFFFFL) << 16 | block9 >>> 48;
                values[vi++] = block9 >>> 11 & 0x1FFFFFFFFFL;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 0x7FFL) << 26 | block10 >>> 38;
                values[vi++] = block10 >>> 1 & 0x1FFFFFFFFFL;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 1L) << 36 | block11 >>> 28;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 0xFFFFFFFL) << 9 | block12 >>> 55;
                values[vi++] = block12 >>> 18 & 0x1FFFFFFFFFL;
                long block13 = blocks[bi++];
                values[vi++] = (block12 & 0x3FFFFL) << 19 | block13 >>> 45;
                values[vi++] = block13 >>> 8 & 0x1FFFFFFFFFL;
                long block14 = blocks[bi++];
                values[vi++] = (block13 & 0xFFL) << 29 | block14 >>> 35;
                long block15 = blocks[bi++];
                values[vi++] = (block14 & 0x7FFFFFFFFL) << 2 | block15 >>> 62;
                values[vi++] = block15 >>> 25 & 0x1FFFFFFFFFL;
                long block16 = blocks[bi++];
                values[vi++] = (block15 & 0x1FFFFFFL) << 12 | block16 >>> 52;
                values[vi++] = block16 >>> 15 & 0x1FFFFFFFFFL;
                long block17 = blocks[bi++];
                values[vi++] = (block16 & 0x7FFFL) << 22 | block17 >>> 42;
                values[vi++] = block17 >>> 5 & 0x1FFFFFFFFFL;
                long block18 = blocks[bi++];
                values[vi++] = (block17 & 0x1FL) << 32 | block18 >>> 32;
                long block19 = blocks[bi++];
                values[vi++] = (block18 & 0xFFFFFFFFL) << 5 | block19 >>> 59;
                values[vi++] = block19 >>> 22 & 0x1FFFFFFFFFL;
                long block20 = blocks[bi++];
                values[vi++] = (block19 & 0x3FFFFFL) << 15 | block20 >>> 49;
                values[vi++] = block20 >>> 12 & 0x1FFFFFFFFFL;
                long block21 = blocks[bi++];
                values[vi++] = (block20 & 0xFFFL) << 25 | block21 >>> 39;
                values[vi++] = block21 >>> 2 & 0x1FFFFFFFFFL;
                long block22 = blocks[bi++];
                values[vi++] = (block21 & 3L) << 35 | block22 >>> 29;
                long block23 = blocks[bi++];
                values[vi++] = (block22 & 0x1FFFFFFFL) << 8 | block23 >>> 56;
                values[vi++] = block23 >>> 19 & 0x1FFFFFFFFFL;
                long block24 = blocks[bi++];
                values[vi++] = (block23 & 0x7FFFFL) << 18 | block24 >>> 46;
                values[vi++] = block24 >>> 9 & 0x1FFFFFFFFFL;
                long block25 = blocks[bi++];
                values[vi++] = (block24 & 0x1FFL) << 28 | block25 >>> 36;
                long block26 = blocks[bi++];
                values[vi++] = (block25 & 0xFFFFFFFFFL) << 1 | block26 >>> 63;
                values[vi++] = block26 >>> 26 & 0x1FFFFFFFFFL;
                long block27 = blocks[bi++];
                values[vi++] = (block26 & 0x3FFFFFFL) << 11 | block27 >>> 53;
                values[vi++] = block27 >>> 16 & 0x1FFFFFFFFFL;
                long block28 = blocks[bi++];
                values[vi++] = (block27 & 0xFFFFL) << 21 | block28 >>> 43;
                values[vi++] = block28 >>> 6 & 0x1FFFFFFFFFL;
                long block29 = blocks[bi++];
                values[vi++] = (block28 & 0x3FL) << 31 | block29 >>> 33;
                long block30 = blocks[bi++];
                values[vi++] = (block29 & 0x1FFFFFFFFL) << 4 | block30 >>> 60;
                values[vi++] = block30 >>> 23 & 0x1FFFFFFFFFL;
                long block31 = blocks[bi++];
                values[vi++] = (block30 & 0x7FFFFFL) << 14 | block31 >>> 50;
                values[vi++] = block31 >>> 13 & 0x1FFFFFFFFFL;
                long block32 = blocks[bi++];
                values[vi++] = (block31 & 0x1FFFL) << 24 | block32 >>> 40;
                values[vi++] = block32 >>> 3 & 0x1FFFFFFFFFL;
                long block33 = blocks[bi++];
                values[vi++] = (block32 & 7L) << 34 | block33 >>> 30;
                long block34 = blocks[bi++];
                values[vi++] = (block33 & 0x3FFFFFFFL) << 7 | block34 >>> 57;
                values[vi++] = block34 >>> 20 & 0x1FFFFFFFFFL;
                long block35 = blocks[bi++];
                values[vi++] = (block34 & 0xFFFFFL) << 17 | block35 >>> 47;
                values[vi++] = block35 >>> 10 & 0x1FFFFFFFFFL;
                long block36 = blocks[bi++];
                values[vi++] = (block35 & 0x3FFL) << 27 | block36 >>> 37;
                values[vi++] = block36 & 0x1FFFFFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 27 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi++] << 17 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi++] << 7 | values[vi] >>> 30;
                blocks[bi++] = values[vi++] << 34 | values[vi] >>> 3;
                blocks[bi++] = values[vi++] << 61 | values[vi++] << 24 | values[vi] >>> 13;
                blocks[bi++] = values[vi++] << 51 | values[vi++] << 14 | values[vi] >>> 23;
                blocks[bi++] = values[vi++] << 41 | values[vi++] << 4 | values[vi] >>> 33;
                blocks[bi++] = values[vi++] << 31 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 21 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi++] << 11 | values[vi] >>> 26;
                blocks[bi++] = values[vi++] << 38 | values[vi++] << 1 | values[vi] >>> 36;
                blocks[bi++] = values[vi++] << 28 | values[vi] >>> 9;
                blocks[bi++] = values[vi++] << 55 | values[vi++] << 18 | values[vi] >>> 19;
                blocks[bi++] = values[vi++] << 45 | values[vi++] << 8 | values[vi] >>> 29;
                blocks[bi++] = values[vi++] << 35 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 25 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi++] << 15 | values[vi] >>> 22;
                blocks[bi++] = values[vi++] << 42 | values[vi++] << 5 | values[vi] >>> 32;
                blocks[bi++] = values[vi++] << 32 | values[vi] >>> 5;
                blocks[bi++] = values[vi++] << 59 | values[vi++] << 22 | values[vi] >>> 15;
                blocks[bi++] = values[vi++] << 49 | values[vi++] << 12 | values[vi] >>> 25;
                blocks[bi++] = values[vi++] << 39 | values[vi++] << 2 | values[vi] >>> 35;
                blocks[bi++] = values[vi++] << 29 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 19 | values[vi] >>> 18;
                blocks[bi++] = values[vi++] << 46 | values[vi++] << 9 | values[vi] >>> 28;
                blocks[bi++] = values[vi++] << 36 | values[vi] >>> 1;
                blocks[bi++] = values[vi++] << 63 | values[vi++] << 26 | values[vi] >>> 11;
                blocks[bi++] = values[vi++] << 53 | values[vi++] << 16 | values[vi] >>> 21;
                blocks[bi++] = values[vi++] << 43 | values[vi++] << 6 | values[vi] >>> 31;
                blocks[bi++] = values[vi++] << 33 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 23 | values[vi] >>> 14;
                blocks[bi++] = values[vi++] << 50 | values[vi++] << 13 | values[vi] >>> 24;
                blocks[bi++] = values[vi++] << 40 | values[vi++] << 3 | values[vi] >>> 34;
                blocks[bi++] = values[vi++] << 30 | values[vi] >>> 7;
                blocks[bi++] = values[vi++] << 57 | values[vi++] << 20 | values[vi] >>> 17;
                blocks[bi++] = values[vi++] << 47 | values[vi++] << 10 | values[vi] >>> 27;
                blocks[bi++] = values[vi++] << 37 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation36
    extends BulkOperation {
        Packed64BulkOperation36() {
        }

        @Override
        public int blocks() {
            return 9;
        }

        @Override
        public int values() {
            return 16;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 28;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0xFFFFFFFL) << 8 | block1 >>> 56;
                values[vi++] = block1 >>> 20 & 0xFFFFFFFFFL;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0xFFFFFL) << 16 | block2 >>> 48;
                values[vi++] = block2 >>> 12 & 0xFFFFFFFFFL;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0xFFFL) << 24 | block3 >>> 40;
                values[vi++] = block3 >>> 4 & 0xFFFFFFFFFL;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0xFL) << 32 | block4 >>> 32;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0xFFFFFFFFL) << 4 | block5 >>> 60;
                values[vi++] = block5 >>> 24 & 0xFFFFFFFFFL;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0xFFFFFFL) << 12 | block6 >>> 52;
                values[vi++] = block6 >>> 16 & 0xFFFFFFFFFL;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0xFFFFL) << 20 | block7 >>> 44;
                values[vi++] = block7 >>> 8 & 0xFFFFFFFFFL;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0xFFL) << 28 | block8 >>> 36;
                values[vi++] = block8 & 0xFFFFFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 28 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 20 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi++] << 12 | values[vi] >>> 24;
                blocks[bi++] = values[vi++] << 40 | values[vi++] << 4 | values[vi] >>> 32;
                blocks[bi++] = values[vi++] << 32 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 24 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi++] << 16 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi++] << 8 | values[vi] >>> 28;
                blocks[bi++] = values[vi++] << 36 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation35
    extends BulkOperation {
        Packed64BulkOperation35() {
        }

        @Override
        public int blocks() {
            return 35;
        }

        @Override
        public int values() {
            return 64;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 29;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0x1FFFFFFFL) << 6 | block1 >>> 58;
                values[vi++] = block1 >>> 23 & 0x7FFFFFFFFL;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0x7FFFFFL) << 12 | block2 >>> 52;
                values[vi++] = block2 >>> 17 & 0x7FFFFFFFFL;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0x1FFFFL) << 18 | block3 >>> 46;
                values[vi++] = block3 >>> 11 & 0x7FFFFFFFFL;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0x7FFL) << 24 | block4 >>> 40;
                values[vi++] = block4 >>> 5 & 0x7FFFFFFFFL;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0x1FL) << 30 | block5 >>> 34;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0x3FFFFFFFFL) << 1 | block6 >>> 63;
                values[vi++] = block6 >>> 28 & 0x7FFFFFFFFL;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0xFFFFFFFL) << 7 | block7 >>> 57;
                values[vi++] = block7 >>> 22 & 0x7FFFFFFFFL;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0x3FFFFFL) << 13 | block8 >>> 51;
                values[vi++] = block8 >>> 16 & 0x7FFFFFFFFL;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0xFFFFL) << 19 | block9 >>> 45;
                values[vi++] = block9 >>> 10 & 0x7FFFFFFFFL;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 0x3FFL) << 25 | block10 >>> 39;
                values[vi++] = block10 >>> 4 & 0x7FFFFFFFFL;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 0xFL) << 31 | block11 >>> 33;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 0x1FFFFFFFFL) << 2 | block12 >>> 62;
                values[vi++] = block12 >>> 27 & 0x7FFFFFFFFL;
                long block13 = blocks[bi++];
                values[vi++] = (block12 & 0x7FFFFFFL) << 8 | block13 >>> 56;
                values[vi++] = block13 >>> 21 & 0x7FFFFFFFFL;
                long block14 = blocks[bi++];
                values[vi++] = (block13 & 0x1FFFFFL) << 14 | block14 >>> 50;
                values[vi++] = block14 >>> 15 & 0x7FFFFFFFFL;
                long block15 = blocks[bi++];
                values[vi++] = (block14 & 0x7FFFL) << 20 | block15 >>> 44;
                values[vi++] = block15 >>> 9 & 0x7FFFFFFFFL;
                long block16 = blocks[bi++];
                values[vi++] = (block15 & 0x1FFL) << 26 | block16 >>> 38;
                values[vi++] = block16 >>> 3 & 0x7FFFFFFFFL;
                long block17 = blocks[bi++];
                values[vi++] = (block16 & 7L) << 32 | block17 >>> 32;
                long block18 = blocks[bi++];
                values[vi++] = (block17 & 0xFFFFFFFFL) << 3 | block18 >>> 61;
                values[vi++] = block18 >>> 26 & 0x7FFFFFFFFL;
                long block19 = blocks[bi++];
                values[vi++] = (block18 & 0x3FFFFFFL) << 9 | block19 >>> 55;
                values[vi++] = block19 >>> 20 & 0x7FFFFFFFFL;
                long block20 = blocks[bi++];
                values[vi++] = (block19 & 0xFFFFFL) << 15 | block20 >>> 49;
                values[vi++] = block20 >>> 14 & 0x7FFFFFFFFL;
                long block21 = blocks[bi++];
                values[vi++] = (block20 & 0x3FFFL) << 21 | block21 >>> 43;
                values[vi++] = block21 >>> 8 & 0x7FFFFFFFFL;
                long block22 = blocks[bi++];
                values[vi++] = (block21 & 0xFFL) << 27 | block22 >>> 37;
                values[vi++] = block22 >>> 2 & 0x7FFFFFFFFL;
                long block23 = blocks[bi++];
                values[vi++] = (block22 & 3L) << 33 | block23 >>> 31;
                long block24 = blocks[bi++];
                values[vi++] = (block23 & Integer.MAX_VALUE) << 4 | block24 >>> 60;
                values[vi++] = block24 >>> 25 & 0x7FFFFFFFFL;
                long block25 = blocks[bi++];
                values[vi++] = (block24 & 0x1FFFFFFL) << 10 | block25 >>> 54;
                values[vi++] = block25 >>> 19 & 0x7FFFFFFFFL;
                long block26 = blocks[bi++];
                values[vi++] = (block25 & 0x7FFFFL) << 16 | block26 >>> 48;
                values[vi++] = block26 >>> 13 & 0x7FFFFFFFFL;
                long block27 = blocks[bi++];
                values[vi++] = (block26 & 0x1FFFL) << 22 | block27 >>> 42;
                values[vi++] = block27 >>> 7 & 0x7FFFFFFFFL;
                long block28 = blocks[bi++];
                values[vi++] = (block27 & 0x7FL) << 28 | block28 >>> 36;
                values[vi++] = block28 >>> 1 & 0x7FFFFFFFFL;
                long block29 = blocks[bi++];
                values[vi++] = (block28 & 1L) << 34 | block29 >>> 30;
                long block30 = blocks[bi++];
                values[vi++] = (block29 & 0x3FFFFFFFL) << 5 | block30 >>> 59;
                values[vi++] = block30 >>> 24 & 0x7FFFFFFFFL;
                long block31 = blocks[bi++];
                values[vi++] = (block30 & 0xFFFFFFL) << 11 | block31 >>> 53;
                values[vi++] = block31 >>> 18 & 0x7FFFFFFFFL;
                long block32 = blocks[bi++];
                values[vi++] = (block31 & 0x3FFFFL) << 17 | block32 >>> 47;
                values[vi++] = block32 >>> 12 & 0x7FFFFFFFFL;
                long block33 = blocks[bi++];
                values[vi++] = (block32 & 0xFFFL) << 23 | block33 >>> 41;
                values[vi++] = block33 >>> 6 & 0x7FFFFFFFFL;
                long block34 = blocks[bi++];
                values[vi++] = (block33 & 0x3FL) << 29 | block34 >>> 35;
                values[vi++] = block34 & 0x7FFFFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 29 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 23 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi++] << 17 | values[vi] >>> 18;
                blocks[bi++] = values[vi++] << 46 | values[vi++] << 11 | values[vi] >>> 24;
                blocks[bi++] = values[vi++] << 40 | values[vi++] << 5 | values[vi] >>> 30;
                blocks[bi++] = values[vi++] << 34 | values[vi] >>> 1;
                blocks[bi++] = values[vi++] << 63 | values[vi++] << 28 | values[vi] >>> 7;
                blocks[bi++] = values[vi++] << 57 | values[vi++] << 22 | values[vi] >>> 13;
                blocks[bi++] = values[vi++] << 51 | values[vi++] << 16 | values[vi] >>> 19;
                blocks[bi++] = values[vi++] << 45 | values[vi++] << 10 | values[vi] >>> 25;
                blocks[bi++] = values[vi++] << 39 | values[vi++] << 4 | values[vi] >>> 31;
                blocks[bi++] = values[vi++] << 33 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 27 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 21 | values[vi] >>> 14;
                blocks[bi++] = values[vi++] << 50 | values[vi++] << 15 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi++] << 9 | values[vi] >>> 26;
                blocks[bi++] = values[vi++] << 38 | values[vi++] << 3 | values[vi] >>> 32;
                blocks[bi++] = values[vi++] << 32 | values[vi] >>> 3;
                blocks[bi++] = values[vi++] << 61 | values[vi++] << 26 | values[vi] >>> 9;
                blocks[bi++] = values[vi++] << 55 | values[vi++] << 20 | values[vi] >>> 15;
                blocks[bi++] = values[vi++] << 49 | values[vi++] << 14 | values[vi] >>> 21;
                blocks[bi++] = values[vi++] << 43 | values[vi++] << 8 | values[vi] >>> 27;
                blocks[bi++] = values[vi++] << 37 | values[vi++] << 2 | values[vi] >>> 33;
                blocks[bi++] = values[vi++] << 31 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 25 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi++] << 19 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi++] << 13 | values[vi] >>> 22;
                blocks[bi++] = values[vi++] << 42 | values[vi++] << 7 | values[vi] >>> 28;
                blocks[bi++] = values[vi++] << 36 | values[vi++] << 1 | values[vi] >>> 34;
                blocks[bi++] = values[vi++] << 30 | values[vi] >>> 5;
                blocks[bi++] = values[vi++] << 59 | values[vi++] << 24 | values[vi] >>> 11;
                blocks[bi++] = values[vi++] << 53 | values[vi++] << 18 | values[vi] >>> 17;
                blocks[bi++] = values[vi++] << 47 | values[vi++] << 12 | values[vi] >>> 23;
                blocks[bi++] = values[vi++] << 41 | values[vi++] << 6 | values[vi] >>> 29;
                blocks[bi++] = values[vi++] << 35 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation34
    extends BulkOperation {
        Packed64BulkOperation34() {
        }

        @Override
        public int blocks() {
            return 17;
        }

        @Override
        public int values() {
            return 32;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 30;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0x3FFFFFFFL) << 4 | block1 >>> 60;
                values[vi++] = block1 >>> 26 & 0x3FFFFFFFFL;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0x3FFFFFFL) << 8 | block2 >>> 56;
                values[vi++] = block2 >>> 22 & 0x3FFFFFFFFL;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0x3FFFFFL) << 12 | block3 >>> 52;
                values[vi++] = block3 >>> 18 & 0x3FFFFFFFFL;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0x3FFFFL) << 16 | block4 >>> 48;
                values[vi++] = block4 >>> 14 & 0x3FFFFFFFFL;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0x3FFFL) << 20 | block5 >>> 44;
                values[vi++] = block5 >>> 10 & 0x3FFFFFFFFL;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0x3FFL) << 24 | block6 >>> 40;
                values[vi++] = block6 >>> 6 & 0x3FFFFFFFFL;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0x3FL) << 28 | block7 >>> 36;
                values[vi++] = block7 >>> 2 & 0x3FFFFFFFFL;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 3L) << 32 | block8 >>> 32;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0xFFFFFFFFL) << 2 | block9 >>> 62;
                values[vi++] = block9 >>> 28 & 0x3FFFFFFFFL;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 0xFFFFFFFL) << 6 | block10 >>> 58;
                values[vi++] = block10 >>> 24 & 0x3FFFFFFFFL;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 0xFFFFFFL) << 10 | block11 >>> 54;
                values[vi++] = block11 >>> 20 & 0x3FFFFFFFFL;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 0xFFFFFL) << 14 | block12 >>> 50;
                values[vi++] = block12 >>> 16 & 0x3FFFFFFFFL;
                long block13 = blocks[bi++];
                values[vi++] = (block12 & 0xFFFFL) << 18 | block13 >>> 46;
                values[vi++] = block13 >>> 12 & 0x3FFFFFFFFL;
                long block14 = blocks[bi++];
                values[vi++] = (block13 & 0xFFFL) << 22 | block14 >>> 42;
                values[vi++] = block14 >>> 8 & 0x3FFFFFFFFL;
                long block15 = blocks[bi++];
                values[vi++] = (block14 & 0xFFL) << 26 | block15 >>> 38;
                values[vi++] = block15 >>> 4 & 0x3FFFFFFFFL;
                long block16 = blocks[bi++];
                values[vi++] = (block15 & 0xFL) << 30 | block16 >>> 34;
                values[vi++] = block16 & 0x3FFFFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 30 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 26 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 22 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi++] << 18 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi++] << 14 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi++] << 10 | values[vi] >>> 24;
                blocks[bi++] = values[vi++] << 40 | values[vi++] << 6 | values[vi] >>> 28;
                blocks[bi++] = values[vi++] << 36 | values[vi++] << 2 | values[vi] >>> 32;
                blocks[bi++] = values[vi++] << 32 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 28 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 24 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi++] << 20 | values[vi] >>> 14;
                blocks[bi++] = values[vi++] << 50 | values[vi++] << 16 | values[vi] >>> 18;
                blocks[bi++] = values[vi++] << 46 | values[vi++] << 12 | values[vi] >>> 22;
                blocks[bi++] = values[vi++] << 42 | values[vi++] << 8 | values[vi] >>> 26;
                blocks[bi++] = values[vi++] << 38 | values[vi++] << 4 | values[vi] >>> 30;
                blocks[bi++] = values[vi++] << 34 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation33
    extends BulkOperation {
        Packed64BulkOperation33() {
        }

        @Override
        public int blocks() {
            return 33;
        }

        @Override
        public int values() {
            return 64;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 31;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & Integer.MAX_VALUE) << 2 | block1 >>> 62;
                values[vi++] = block1 >>> 29 & 0x1FFFFFFFFL;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0x1FFFFFFFL) << 4 | block2 >>> 60;
                values[vi++] = block2 >>> 27 & 0x1FFFFFFFFL;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0x7FFFFFFL) << 6 | block3 >>> 58;
                values[vi++] = block3 >>> 25 & 0x1FFFFFFFFL;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0x1FFFFFFL) << 8 | block4 >>> 56;
                values[vi++] = block4 >>> 23 & 0x1FFFFFFFFL;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0x7FFFFFL) << 10 | block5 >>> 54;
                values[vi++] = block5 >>> 21 & 0x1FFFFFFFFL;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0x1FFFFFL) << 12 | block6 >>> 52;
                values[vi++] = block6 >>> 19 & 0x1FFFFFFFFL;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0x7FFFFL) << 14 | block7 >>> 50;
                values[vi++] = block7 >>> 17 & 0x1FFFFFFFFL;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0x1FFFFL) << 16 | block8 >>> 48;
                values[vi++] = block8 >>> 15 & 0x1FFFFFFFFL;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0x7FFFL) << 18 | block9 >>> 46;
                values[vi++] = block9 >>> 13 & 0x1FFFFFFFFL;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 0x1FFFL) << 20 | block10 >>> 44;
                values[vi++] = block10 >>> 11 & 0x1FFFFFFFFL;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 0x7FFL) << 22 | block11 >>> 42;
                values[vi++] = block11 >>> 9 & 0x1FFFFFFFFL;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 0x1FFL) << 24 | block12 >>> 40;
                values[vi++] = block12 >>> 7 & 0x1FFFFFFFFL;
                long block13 = blocks[bi++];
                values[vi++] = (block12 & 0x7FL) << 26 | block13 >>> 38;
                values[vi++] = block13 >>> 5 & 0x1FFFFFFFFL;
                long block14 = blocks[bi++];
                values[vi++] = (block13 & 0x1FL) << 28 | block14 >>> 36;
                values[vi++] = block14 >>> 3 & 0x1FFFFFFFFL;
                long block15 = blocks[bi++];
                values[vi++] = (block14 & 7L) << 30 | block15 >>> 34;
                values[vi++] = block15 >>> 1 & 0x1FFFFFFFFL;
                long block16 = blocks[bi++];
                values[vi++] = (block15 & 1L) << 32 | block16 >>> 32;
                long block17 = blocks[bi++];
                values[vi++] = (block16 & 0xFFFFFFFFL) << 1 | block17 >>> 63;
                values[vi++] = block17 >>> 30 & 0x1FFFFFFFFL;
                long block18 = blocks[bi++];
                values[vi++] = (block17 & 0x3FFFFFFFL) << 3 | block18 >>> 61;
                values[vi++] = block18 >>> 28 & 0x1FFFFFFFFL;
                long block19 = blocks[bi++];
                values[vi++] = (block18 & 0xFFFFFFFL) << 5 | block19 >>> 59;
                values[vi++] = block19 >>> 26 & 0x1FFFFFFFFL;
                long block20 = blocks[bi++];
                values[vi++] = (block19 & 0x3FFFFFFL) << 7 | block20 >>> 57;
                values[vi++] = block20 >>> 24 & 0x1FFFFFFFFL;
                long block21 = blocks[bi++];
                values[vi++] = (block20 & 0xFFFFFFL) << 9 | block21 >>> 55;
                values[vi++] = block21 >>> 22 & 0x1FFFFFFFFL;
                long block22 = blocks[bi++];
                values[vi++] = (block21 & 0x3FFFFFL) << 11 | block22 >>> 53;
                values[vi++] = block22 >>> 20 & 0x1FFFFFFFFL;
                long block23 = blocks[bi++];
                values[vi++] = (block22 & 0xFFFFFL) << 13 | block23 >>> 51;
                values[vi++] = block23 >>> 18 & 0x1FFFFFFFFL;
                long block24 = blocks[bi++];
                values[vi++] = (block23 & 0x3FFFFL) << 15 | block24 >>> 49;
                values[vi++] = block24 >>> 16 & 0x1FFFFFFFFL;
                long block25 = blocks[bi++];
                values[vi++] = (block24 & 0xFFFFL) << 17 | block25 >>> 47;
                values[vi++] = block25 >>> 14 & 0x1FFFFFFFFL;
                long block26 = blocks[bi++];
                values[vi++] = (block25 & 0x3FFFL) << 19 | block26 >>> 45;
                values[vi++] = block26 >>> 12 & 0x1FFFFFFFFL;
                long block27 = blocks[bi++];
                values[vi++] = (block26 & 0xFFFL) << 21 | block27 >>> 43;
                values[vi++] = block27 >>> 10 & 0x1FFFFFFFFL;
                long block28 = blocks[bi++];
                values[vi++] = (block27 & 0x3FFL) << 23 | block28 >>> 41;
                values[vi++] = block28 >>> 8 & 0x1FFFFFFFFL;
                long block29 = blocks[bi++];
                values[vi++] = (block28 & 0xFFL) << 25 | block29 >>> 39;
                values[vi++] = block29 >>> 6 & 0x1FFFFFFFFL;
                long block30 = blocks[bi++];
                values[vi++] = (block29 & 0x3FL) << 27 | block30 >>> 37;
                values[vi++] = block30 >>> 4 & 0x1FFFFFFFFL;
                long block31 = blocks[bi++];
                values[vi++] = (block30 & 0xFL) << 29 | block31 >>> 35;
                values[vi++] = block31 >>> 2 & 0x1FFFFFFFFL;
                long block32 = blocks[bi++];
                values[vi++] = (block31 & 3L) << 31 | block32 >>> 33;
                values[vi++] = block32 & 0x1FFFFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 31 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 29 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 27 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 25 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 23 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi++] << 21 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi++] << 19 | values[vi] >>> 14;
                blocks[bi++] = values[vi++] << 50 | values[vi++] << 17 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi++] << 15 | values[vi] >>> 18;
                blocks[bi++] = values[vi++] << 46 | values[vi++] << 13 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi++] << 11 | values[vi] >>> 22;
                blocks[bi++] = values[vi++] << 42 | values[vi++] << 9 | values[vi] >>> 24;
                blocks[bi++] = values[vi++] << 40 | values[vi++] << 7 | values[vi] >>> 26;
                blocks[bi++] = values[vi++] << 38 | values[vi++] << 5 | values[vi] >>> 28;
                blocks[bi++] = values[vi++] << 36 | values[vi++] << 3 | values[vi] >>> 30;
                blocks[bi++] = values[vi++] << 34 | values[vi++] << 1 | values[vi] >>> 32;
                blocks[bi++] = values[vi++] << 32 | values[vi] >>> 1;
                blocks[bi++] = values[vi++] << 63 | values[vi++] << 30 | values[vi] >>> 3;
                blocks[bi++] = values[vi++] << 61 | values[vi++] << 28 | values[vi] >>> 5;
                blocks[bi++] = values[vi++] << 59 | values[vi++] << 26 | values[vi] >>> 7;
                blocks[bi++] = values[vi++] << 57 | values[vi++] << 24 | values[vi] >>> 9;
                blocks[bi++] = values[vi++] << 55 | values[vi++] << 22 | values[vi] >>> 11;
                blocks[bi++] = values[vi++] << 53 | values[vi++] << 20 | values[vi] >>> 13;
                blocks[bi++] = values[vi++] << 51 | values[vi++] << 18 | values[vi] >>> 15;
                blocks[bi++] = values[vi++] << 49 | values[vi++] << 16 | values[vi] >>> 17;
                blocks[bi++] = values[vi++] << 47 | values[vi++] << 14 | values[vi] >>> 19;
                blocks[bi++] = values[vi++] << 45 | values[vi++] << 12 | values[vi] >>> 21;
                blocks[bi++] = values[vi++] << 43 | values[vi++] << 10 | values[vi] >>> 23;
                blocks[bi++] = values[vi++] << 41 | values[vi++] << 8 | values[vi] >>> 25;
                blocks[bi++] = values[vi++] << 39 | values[vi++] << 6 | values[vi] >>> 27;
                blocks[bi++] = values[vi++] << 37 | values[vi++] << 4 | values[vi] >>> 29;
                blocks[bi++] = values[vi++] << 35 | values[vi++] << 2 | values[vi] >>> 31;
                blocks[bi++] = values[vi++] << 33 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation32
    extends BulkOperation {
        Packed64BulkOperation32() {
        }

        @Override
        public int blocks() {
            return 1;
        }

        @Override
        public int values() {
            return 2;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 32;
                values[vi++] = block0 & 0xFFFFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 32 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation31
    extends BulkOperation {
        Packed64BulkOperation31() {
        }

        @Override
        public int blocks() {
            return 31;
        }

        @Override
        public int values() {
            return 64;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 33;
                values[vi++] = block0 >>> 2 & Integer.MAX_VALUE;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 3L) << 29 | block1 >>> 35;
                values[vi++] = block1 >>> 4 & Integer.MAX_VALUE;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0xFL) << 27 | block2 >>> 37;
                values[vi++] = block2 >>> 6 & Integer.MAX_VALUE;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0x3FL) << 25 | block3 >>> 39;
                values[vi++] = block3 >>> 8 & Integer.MAX_VALUE;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0xFFL) << 23 | block4 >>> 41;
                values[vi++] = block4 >>> 10 & Integer.MAX_VALUE;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0x3FFL) << 21 | block5 >>> 43;
                values[vi++] = block5 >>> 12 & Integer.MAX_VALUE;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0xFFFL) << 19 | block6 >>> 45;
                values[vi++] = block6 >>> 14 & Integer.MAX_VALUE;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0x3FFFL) << 17 | block7 >>> 47;
                values[vi++] = block7 >>> 16 & Integer.MAX_VALUE;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0xFFFFL) << 15 | block8 >>> 49;
                values[vi++] = block8 >>> 18 & Integer.MAX_VALUE;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0x3FFFFL) << 13 | block9 >>> 51;
                values[vi++] = block9 >>> 20 & Integer.MAX_VALUE;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 0xFFFFFL) << 11 | block10 >>> 53;
                values[vi++] = block10 >>> 22 & Integer.MAX_VALUE;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 0x3FFFFFL) << 9 | block11 >>> 55;
                values[vi++] = block11 >>> 24 & Integer.MAX_VALUE;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 0xFFFFFFL) << 7 | block12 >>> 57;
                values[vi++] = block12 >>> 26 & Integer.MAX_VALUE;
                long block13 = blocks[bi++];
                values[vi++] = (block12 & 0x3FFFFFFL) << 5 | block13 >>> 59;
                values[vi++] = block13 >>> 28 & Integer.MAX_VALUE;
                long block14 = blocks[bi++];
                values[vi++] = (block13 & 0xFFFFFFFL) << 3 | block14 >>> 61;
                values[vi++] = block14 >>> 30 & Integer.MAX_VALUE;
                long block15 = blocks[bi++];
                values[vi++] = (block14 & 0x3FFFFFFFL) << 1 | block15 >>> 63;
                values[vi++] = block15 >>> 32 & Integer.MAX_VALUE;
                values[vi++] = block15 >>> 1 & Integer.MAX_VALUE;
                long block16 = blocks[bi++];
                values[vi++] = (block15 & 1L) << 30 | block16 >>> 34;
                values[vi++] = block16 >>> 3 & Integer.MAX_VALUE;
                long block17 = blocks[bi++];
                values[vi++] = (block16 & 7L) << 28 | block17 >>> 36;
                values[vi++] = block17 >>> 5 & Integer.MAX_VALUE;
                long block18 = blocks[bi++];
                values[vi++] = (block17 & 0x1FL) << 26 | block18 >>> 38;
                values[vi++] = block18 >>> 7 & Integer.MAX_VALUE;
                long block19 = blocks[bi++];
                values[vi++] = (block18 & 0x7FL) << 24 | block19 >>> 40;
                values[vi++] = block19 >>> 9 & Integer.MAX_VALUE;
                long block20 = blocks[bi++];
                values[vi++] = (block19 & 0x1FFL) << 22 | block20 >>> 42;
                values[vi++] = block20 >>> 11 & Integer.MAX_VALUE;
                long block21 = blocks[bi++];
                values[vi++] = (block20 & 0x7FFL) << 20 | block21 >>> 44;
                values[vi++] = block21 >>> 13 & Integer.MAX_VALUE;
                long block22 = blocks[bi++];
                values[vi++] = (block21 & 0x1FFFL) << 18 | block22 >>> 46;
                values[vi++] = block22 >>> 15 & Integer.MAX_VALUE;
                long block23 = blocks[bi++];
                values[vi++] = (block22 & 0x7FFFL) << 16 | block23 >>> 48;
                values[vi++] = block23 >>> 17 & Integer.MAX_VALUE;
                long block24 = blocks[bi++];
                values[vi++] = (block23 & 0x1FFFFL) << 14 | block24 >>> 50;
                values[vi++] = block24 >>> 19 & Integer.MAX_VALUE;
                long block25 = blocks[bi++];
                values[vi++] = (block24 & 0x7FFFFL) << 12 | block25 >>> 52;
                values[vi++] = block25 >>> 21 & Integer.MAX_VALUE;
                long block26 = blocks[bi++];
                values[vi++] = (block25 & 0x1FFFFFL) << 10 | block26 >>> 54;
                values[vi++] = block26 >>> 23 & Integer.MAX_VALUE;
                long block27 = blocks[bi++];
                values[vi++] = (block26 & 0x7FFFFFL) << 8 | block27 >>> 56;
                values[vi++] = block27 >>> 25 & Integer.MAX_VALUE;
                long block28 = blocks[bi++];
                values[vi++] = (block27 & 0x1FFFFFFL) << 6 | block28 >>> 58;
                values[vi++] = block28 >>> 27 & Integer.MAX_VALUE;
                long block29 = blocks[bi++];
                values[vi++] = (block28 & 0x7FFFFFFL) << 4 | block29 >>> 60;
                values[vi++] = block29 >>> 29 & Integer.MAX_VALUE;
                long block30 = blocks[bi++];
                values[vi++] = (block29 & 0x1FFFFFFFL) << 2 | block30 >>> 62;
                values[vi++] = block30 >>> 31 & Integer.MAX_VALUE;
                values[vi++] = block30 & Integer.MAX_VALUE;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 33 | values[vi++] << 2 | values[vi] >>> 29;
                blocks[bi++] = values[vi++] << 35 | values[vi++] << 4 | values[vi] >>> 27;
                blocks[bi++] = values[vi++] << 37 | values[vi++] << 6 | values[vi] >>> 25;
                blocks[bi++] = values[vi++] << 39 | values[vi++] << 8 | values[vi] >>> 23;
                blocks[bi++] = values[vi++] << 41 | values[vi++] << 10 | values[vi] >>> 21;
                blocks[bi++] = values[vi++] << 43 | values[vi++] << 12 | values[vi] >>> 19;
                blocks[bi++] = values[vi++] << 45 | values[vi++] << 14 | values[vi] >>> 17;
                blocks[bi++] = values[vi++] << 47 | values[vi++] << 16 | values[vi] >>> 15;
                blocks[bi++] = values[vi++] << 49 | values[vi++] << 18 | values[vi] >>> 13;
                blocks[bi++] = values[vi++] << 51 | values[vi++] << 20 | values[vi] >>> 11;
                blocks[bi++] = values[vi++] << 53 | values[vi++] << 22 | values[vi] >>> 9;
                blocks[bi++] = values[vi++] << 55 | values[vi++] << 24 | values[vi] >>> 7;
                blocks[bi++] = values[vi++] << 57 | values[vi++] << 26 | values[vi] >>> 5;
                blocks[bi++] = values[vi++] << 59 | values[vi++] << 28 | values[vi] >>> 3;
                blocks[bi++] = values[vi++] << 61 | values[vi++] << 30 | values[vi] >>> 1;
                blocks[bi++] = values[vi++] << 63 | values[vi++] << 32 | values[vi++] << 1 | values[vi] >>> 30;
                blocks[bi++] = values[vi++] << 34 | values[vi++] << 3 | values[vi] >>> 28;
                blocks[bi++] = values[vi++] << 36 | values[vi++] << 5 | values[vi] >>> 26;
                blocks[bi++] = values[vi++] << 38 | values[vi++] << 7 | values[vi] >>> 24;
                blocks[bi++] = values[vi++] << 40 | values[vi++] << 9 | values[vi] >>> 22;
                blocks[bi++] = values[vi++] << 42 | values[vi++] << 11 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi++] << 13 | values[vi] >>> 18;
                blocks[bi++] = values[vi++] << 46 | values[vi++] << 15 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi++] << 17 | values[vi] >>> 14;
                blocks[bi++] = values[vi++] << 50 | values[vi++] << 19 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi++] << 21 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi++] << 23 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 25 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 27 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 29 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 31 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation30
    extends BulkOperation {
        Packed64BulkOperation30() {
        }

        @Override
        public int blocks() {
            return 15;
        }

        @Override
        public int values() {
            return 32;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 34;
                values[vi++] = block0 >>> 4 & 0x3FFFFFFFL;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0xFL) << 26 | block1 >>> 38;
                values[vi++] = block1 >>> 8 & 0x3FFFFFFFL;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0xFFL) << 22 | block2 >>> 42;
                values[vi++] = block2 >>> 12 & 0x3FFFFFFFL;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0xFFFL) << 18 | block3 >>> 46;
                values[vi++] = block3 >>> 16 & 0x3FFFFFFFL;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0xFFFFL) << 14 | block4 >>> 50;
                values[vi++] = block4 >>> 20 & 0x3FFFFFFFL;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0xFFFFFL) << 10 | block5 >>> 54;
                values[vi++] = block5 >>> 24 & 0x3FFFFFFFL;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0xFFFFFFL) << 6 | block6 >>> 58;
                values[vi++] = block6 >>> 28 & 0x3FFFFFFFL;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0xFFFFFFFL) << 2 | block7 >>> 62;
                values[vi++] = block7 >>> 32 & 0x3FFFFFFFL;
                values[vi++] = block7 >>> 2 & 0x3FFFFFFFL;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 3L) << 28 | block8 >>> 36;
                values[vi++] = block8 >>> 6 & 0x3FFFFFFFL;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0x3FL) << 24 | block9 >>> 40;
                values[vi++] = block9 >>> 10 & 0x3FFFFFFFL;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 0x3FFL) << 20 | block10 >>> 44;
                values[vi++] = block10 >>> 14 & 0x3FFFFFFFL;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 0x3FFFL) << 16 | block11 >>> 48;
                values[vi++] = block11 >>> 18 & 0x3FFFFFFFL;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 0x3FFFFL) << 12 | block12 >>> 52;
                values[vi++] = block12 >>> 22 & 0x3FFFFFFFL;
                long block13 = blocks[bi++];
                values[vi++] = (block12 & 0x3FFFFFL) << 8 | block13 >>> 56;
                values[vi++] = block13 >>> 26 & 0x3FFFFFFFL;
                long block14 = blocks[bi++];
                values[vi++] = (block13 & 0x3FFFFFFL) << 4 | block14 >>> 60;
                values[vi++] = block14 >>> 30 & 0x3FFFFFFFL;
                values[vi++] = block14 & 0x3FFFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 34 | values[vi++] << 4 | values[vi] >>> 26;
                blocks[bi++] = values[vi++] << 38 | values[vi++] << 8 | values[vi] >>> 22;
                blocks[bi++] = values[vi++] << 42 | values[vi++] << 12 | values[vi] >>> 18;
                blocks[bi++] = values[vi++] << 46 | values[vi++] << 16 | values[vi] >>> 14;
                blocks[bi++] = values[vi++] << 50 | values[vi++] << 20 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi++] << 24 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 28 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 32 | values[vi++] << 2 | values[vi] >>> 28;
                blocks[bi++] = values[vi++] << 36 | values[vi++] << 6 | values[vi] >>> 24;
                blocks[bi++] = values[vi++] << 40 | values[vi++] << 10 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi++] << 14 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi++] << 18 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi++] << 22 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 26 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 30 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation29
    extends BulkOperation {
        Packed64BulkOperation29() {
        }

        @Override
        public int blocks() {
            return 29;
        }

        @Override
        public int values() {
            return 64;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 35;
                values[vi++] = block0 >>> 6 & 0x1FFFFFFFL;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0x3FL) << 23 | block1 >>> 41;
                values[vi++] = block1 >>> 12 & 0x1FFFFFFFL;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0xFFFL) << 17 | block2 >>> 47;
                values[vi++] = block2 >>> 18 & 0x1FFFFFFFL;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0x3FFFFL) << 11 | block3 >>> 53;
                values[vi++] = block3 >>> 24 & 0x1FFFFFFFL;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0xFFFFFFL) << 5 | block4 >>> 59;
                values[vi++] = block4 >>> 30 & 0x1FFFFFFFL;
                values[vi++] = block4 >>> 1 & 0x1FFFFFFFL;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 1L) << 28 | block5 >>> 36;
                values[vi++] = block5 >>> 7 & 0x1FFFFFFFL;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0x7FL) << 22 | block6 >>> 42;
                values[vi++] = block6 >>> 13 & 0x1FFFFFFFL;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0x1FFFL) << 16 | block7 >>> 48;
                values[vi++] = block7 >>> 19 & 0x1FFFFFFFL;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0x7FFFFL) << 10 | block8 >>> 54;
                values[vi++] = block8 >>> 25 & 0x1FFFFFFFL;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0x1FFFFFFL) << 4 | block9 >>> 60;
                values[vi++] = block9 >>> 31 & 0x1FFFFFFFL;
                values[vi++] = block9 >>> 2 & 0x1FFFFFFFL;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 3L) << 27 | block10 >>> 37;
                values[vi++] = block10 >>> 8 & 0x1FFFFFFFL;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 0xFFL) << 21 | block11 >>> 43;
                values[vi++] = block11 >>> 14 & 0x1FFFFFFFL;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 0x3FFFL) << 15 | block12 >>> 49;
                values[vi++] = block12 >>> 20 & 0x1FFFFFFFL;
                long block13 = blocks[bi++];
                values[vi++] = (block12 & 0xFFFFFL) << 9 | block13 >>> 55;
                values[vi++] = block13 >>> 26 & 0x1FFFFFFFL;
                long block14 = blocks[bi++];
                values[vi++] = (block13 & 0x3FFFFFFL) << 3 | block14 >>> 61;
                values[vi++] = block14 >>> 32 & 0x1FFFFFFFL;
                values[vi++] = block14 >>> 3 & 0x1FFFFFFFL;
                long block15 = blocks[bi++];
                values[vi++] = (block14 & 7L) << 26 | block15 >>> 38;
                values[vi++] = block15 >>> 9 & 0x1FFFFFFFL;
                long block16 = blocks[bi++];
                values[vi++] = (block15 & 0x1FFL) << 20 | block16 >>> 44;
                values[vi++] = block16 >>> 15 & 0x1FFFFFFFL;
                long block17 = blocks[bi++];
                values[vi++] = (block16 & 0x7FFFL) << 14 | block17 >>> 50;
                values[vi++] = block17 >>> 21 & 0x1FFFFFFFL;
                long block18 = blocks[bi++];
                values[vi++] = (block17 & 0x1FFFFFL) << 8 | block18 >>> 56;
                values[vi++] = block18 >>> 27 & 0x1FFFFFFFL;
                long block19 = blocks[bi++];
                values[vi++] = (block18 & 0x7FFFFFFL) << 2 | block19 >>> 62;
                values[vi++] = block19 >>> 33 & 0x1FFFFFFFL;
                values[vi++] = block19 >>> 4 & 0x1FFFFFFFL;
                long block20 = blocks[bi++];
                values[vi++] = (block19 & 0xFL) << 25 | block20 >>> 39;
                values[vi++] = block20 >>> 10 & 0x1FFFFFFFL;
                long block21 = blocks[bi++];
                values[vi++] = (block20 & 0x3FFL) << 19 | block21 >>> 45;
                values[vi++] = block21 >>> 16 & 0x1FFFFFFFL;
                long block22 = blocks[bi++];
                values[vi++] = (block21 & 0xFFFFL) << 13 | block22 >>> 51;
                values[vi++] = block22 >>> 22 & 0x1FFFFFFFL;
                long block23 = blocks[bi++];
                values[vi++] = (block22 & 0x3FFFFFL) << 7 | block23 >>> 57;
                values[vi++] = block23 >>> 28 & 0x1FFFFFFFL;
                long block24 = blocks[bi++];
                values[vi++] = (block23 & 0xFFFFFFFL) << 1 | block24 >>> 63;
                values[vi++] = block24 >>> 34 & 0x1FFFFFFFL;
                values[vi++] = block24 >>> 5 & 0x1FFFFFFFL;
                long block25 = blocks[bi++];
                values[vi++] = (block24 & 0x1FL) << 24 | block25 >>> 40;
                values[vi++] = block25 >>> 11 & 0x1FFFFFFFL;
                long block26 = blocks[bi++];
                values[vi++] = (block25 & 0x7FFL) << 18 | block26 >>> 46;
                values[vi++] = block26 >>> 17 & 0x1FFFFFFFL;
                long block27 = blocks[bi++];
                values[vi++] = (block26 & 0x1FFFFL) << 12 | block27 >>> 52;
                values[vi++] = block27 >>> 23 & 0x1FFFFFFFL;
                long block28 = blocks[bi++];
                values[vi++] = (block27 & 0x7FFFFFL) << 6 | block28 >>> 58;
                values[vi++] = block28 >>> 29 & 0x1FFFFFFFL;
                values[vi++] = block28 & 0x1FFFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 35 | values[vi++] << 6 | values[vi] >>> 23;
                blocks[bi++] = values[vi++] << 41 | values[vi++] << 12 | values[vi] >>> 17;
                blocks[bi++] = values[vi++] << 47 | values[vi++] << 18 | values[vi] >>> 11;
                blocks[bi++] = values[vi++] << 53 | values[vi++] << 24 | values[vi] >>> 5;
                blocks[bi++] = values[vi++] << 59 | values[vi++] << 30 | values[vi++] << 1 | values[vi] >>> 28;
                blocks[bi++] = values[vi++] << 36 | values[vi++] << 7 | values[vi] >>> 22;
                blocks[bi++] = values[vi++] << 42 | values[vi++] << 13 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi++] << 19 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi++] << 25 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 31 | values[vi++] << 2 | values[vi] >>> 27;
                blocks[bi++] = values[vi++] << 37 | values[vi++] << 8 | values[vi] >>> 21;
                blocks[bi++] = values[vi++] << 43 | values[vi++] << 14 | values[vi] >>> 15;
                blocks[bi++] = values[vi++] << 49 | values[vi++] << 20 | values[vi] >>> 9;
                blocks[bi++] = values[vi++] << 55 | values[vi++] << 26 | values[vi] >>> 3;
                blocks[bi++] = values[vi++] << 61 | values[vi++] << 32 | values[vi++] << 3 | values[vi] >>> 26;
                blocks[bi++] = values[vi++] << 38 | values[vi++] << 9 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi++] << 15 | values[vi] >>> 14;
                blocks[bi++] = values[vi++] << 50 | values[vi++] << 21 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 27 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 33 | values[vi++] << 4 | values[vi] >>> 25;
                blocks[bi++] = values[vi++] << 39 | values[vi++] << 10 | values[vi] >>> 19;
                blocks[bi++] = values[vi++] << 45 | values[vi++] << 16 | values[vi] >>> 13;
                blocks[bi++] = values[vi++] << 51 | values[vi++] << 22 | values[vi] >>> 7;
                blocks[bi++] = values[vi++] << 57 | values[vi++] << 28 | values[vi] >>> 1;
                blocks[bi++] = values[vi++] << 63 | values[vi++] << 34 | values[vi++] << 5 | values[vi] >>> 24;
                blocks[bi++] = values[vi++] << 40 | values[vi++] << 11 | values[vi] >>> 18;
                blocks[bi++] = values[vi++] << 46 | values[vi++] << 17 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi++] << 23 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 29 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation28
    extends BulkOperation {
        Packed64BulkOperation28() {
        }

        @Override
        public int blocks() {
            return 7;
        }

        @Override
        public int values() {
            return 16;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 36;
                values[vi++] = block0 >>> 8 & 0xFFFFFFFL;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0xFFL) << 20 | block1 >>> 44;
                values[vi++] = block1 >>> 16 & 0xFFFFFFFL;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0xFFFFL) << 12 | block2 >>> 52;
                values[vi++] = block2 >>> 24 & 0xFFFFFFFL;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0xFFFFFFL) << 4 | block3 >>> 60;
                values[vi++] = block3 >>> 32 & 0xFFFFFFFL;
                values[vi++] = block3 >>> 4 & 0xFFFFFFFL;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0xFL) << 24 | block4 >>> 40;
                values[vi++] = block4 >>> 12 & 0xFFFFFFFL;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0xFFFL) << 16 | block5 >>> 48;
                values[vi++] = block5 >>> 20 & 0xFFFFFFFL;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0xFFFFFL) << 8 | block6 >>> 56;
                values[vi++] = block6 >>> 28 & 0xFFFFFFFL;
                values[vi++] = block6 & 0xFFFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 36 | values[vi++] << 8 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi++] << 16 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi++] << 24 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 32 | values[vi++] << 4 | values[vi] >>> 24;
                blocks[bi++] = values[vi++] << 40 | values[vi++] << 12 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi++] << 20 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 28 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation27
    extends BulkOperation {
        Packed64BulkOperation27() {
        }

        @Override
        public int blocks() {
            return 27;
        }

        @Override
        public int values() {
            return 64;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 37;
                values[vi++] = block0 >>> 10 & 0x7FFFFFFL;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0x3FFL) << 17 | block1 >>> 47;
                values[vi++] = block1 >>> 20 & 0x7FFFFFFL;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0xFFFFFL) << 7 | block2 >>> 57;
                values[vi++] = block2 >>> 30 & 0x7FFFFFFL;
                values[vi++] = block2 >>> 3 & 0x7FFFFFFL;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 7L) << 24 | block3 >>> 40;
                values[vi++] = block3 >>> 13 & 0x7FFFFFFL;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0x1FFFL) << 14 | block4 >>> 50;
                values[vi++] = block4 >>> 23 & 0x7FFFFFFL;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0x7FFFFFL) << 4 | block5 >>> 60;
                values[vi++] = block5 >>> 33 & 0x7FFFFFFL;
                values[vi++] = block5 >>> 6 & 0x7FFFFFFL;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0x3FL) << 21 | block6 >>> 43;
                values[vi++] = block6 >>> 16 & 0x7FFFFFFL;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0xFFFFL) << 11 | block7 >>> 53;
                values[vi++] = block7 >>> 26 & 0x7FFFFFFL;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0x3FFFFFFL) << 1 | block8 >>> 63;
                values[vi++] = block8 >>> 36 & 0x7FFFFFFL;
                values[vi++] = block8 >>> 9 & 0x7FFFFFFL;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0x1FFL) << 18 | block9 >>> 46;
                values[vi++] = block9 >>> 19 & 0x7FFFFFFL;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 0x7FFFFL) << 8 | block10 >>> 56;
                values[vi++] = block10 >>> 29 & 0x7FFFFFFL;
                values[vi++] = block10 >>> 2 & 0x7FFFFFFL;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 3L) << 25 | block11 >>> 39;
                values[vi++] = block11 >>> 12 & 0x7FFFFFFL;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 0xFFFL) << 15 | block12 >>> 49;
                values[vi++] = block12 >>> 22 & 0x7FFFFFFL;
                long block13 = blocks[bi++];
                values[vi++] = (block12 & 0x3FFFFFL) << 5 | block13 >>> 59;
                values[vi++] = block13 >>> 32 & 0x7FFFFFFL;
                values[vi++] = block13 >>> 5 & 0x7FFFFFFL;
                long block14 = blocks[bi++];
                values[vi++] = (block13 & 0x1FL) << 22 | block14 >>> 42;
                values[vi++] = block14 >>> 15 & 0x7FFFFFFL;
                long block15 = blocks[bi++];
                values[vi++] = (block14 & 0x7FFFL) << 12 | block15 >>> 52;
                values[vi++] = block15 >>> 25 & 0x7FFFFFFL;
                long block16 = blocks[bi++];
                values[vi++] = (block15 & 0x1FFFFFFL) << 2 | block16 >>> 62;
                values[vi++] = block16 >>> 35 & 0x7FFFFFFL;
                values[vi++] = block16 >>> 8 & 0x7FFFFFFL;
                long block17 = blocks[bi++];
                values[vi++] = (block16 & 0xFFL) << 19 | block17 >>> 45;
                values[vi++] = block17 >>> 18 & 0x7FFFFFFL;
                long block18 = blocks[bi++];
                values[vi++] = (block17 & 0x3FFFFL) << 9 | block18 >>> 55;
                values[vi++] = block18 >>> 28 & 0x7FFFFFFL;
                values[vi++] = block18 >>> 1 & 0x7FFFFFFL;
                long block19 = blocks[bi++];
                values[vi++] = (block18 & 1L) << 26 | block19 >>> 38;
                values[vi++] = block19 >>> 11 & 0x7FFFFFFL;
                long block20 = blocks[bi++];
                values[vi++] = (block19 & 0x7FFL) << 16 | block20 >>> 48;
                values[vi++] = block20 >>> 21 & 0x7FFFFFFL;
                long block21 = blocks[bi++];
                values[vi++] = (block20 & 0x1FFFFFL) << 6 | block21 >>> 58;
                values[vi++] = block21 >>> 31 & 0x7FFFFFFL;
                values[vi++] = block21 >>> 4 & 0x7FFFFFFL;
                long block22 = blocks[bi++];
                values[vi++] = (block21 & 0xFL) << 23 | block22 >>> 41;
                values[vi++] = block22 >>> 14 & 0x7FFFFFFL;
                long block23 = blocks[bi++];
                values[vi++] = (block22 & 0x3FFFL) << 13 | block23 >>> 51;
                values[vi++] = block23 >>> 24 & 0x7FFFFFFL;
                long block24 = blocks[bi++];
                values[vi++] = (block23 & 0xFFFFFFL) << 3 | block24 >>> 61;
                values[vi++] = block24 >>> 34 & 0x7FFFFFFL;
                values[vi++] = block24 >>> 7 & 0x7FFFFFFL;
                long block25 = blocks[bi++];
                values[vi++] = (block24 & 0x7FL) << 20 | block25 >>> 44;
                values[vi++] = block25 >>> 17 & 0x7FFFFFFL;
                long block26 = blocks[bi++];
                values[vi++] = (block25 & 0x1FFFFL) << 10 | block26 >>> 54;
                values[vi++] = block26 >>> 27 & 0x7FFFFFFL;
                values[vi++] = block26 & 0x7FFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 37 | values[vi++] << 10 | values[vi] >>> 17;
                blocks[bi++] = values[vi++] << 47 | values[vi++] << 20 | values[vi] >>> 7;
                blocks[bi++] = values[vi++] << 57 | values[vi++] << 30 | values[vi++] << 3 | values[vi] >>> 24;
                blocks[bi++] = values[vi++] << 40 | values[vi++] << 13 | values[vi] >>> 14;
                blocks[bi++] = values[vi++] << 50 | values[vi++] << 23 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 33 | values[vi++] << 6 | values[vi] >>> 21;
                blocks[bi++] = values[vi++] << 43 | values[vi++] << 16 | values[vi] >>> 11;
                blocks[bi++] = values[vi++] << 53 | values[vi++] << 26 | values[vi] >>> 1;
                blocks[bi++] = values[vi++] << 63 | values[vi++] << 36 | values[vi++] << 9 | values[vi] >>> 18;
                blocks[bi++] = values[vi++] << 46 | values[vi++] << 19 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 29 | values[vi++] << 2 | values[vi] >>> 25;
                blocks[bi++] = values[vi++] << 39 | values[vi++] << 12 | values[vi] >>> 15;
                blocks[bi++] = values[vi++] << 49 | values[vi++] << 22 | values[vi] >>> 5;
                blocks[bi++] = values[vi++] << 59 | values[vi++] << 32 | values[vi++] << 5 | values[vi] >>> 22;
                blocks[bi++] = values[vi++] << 42 | values[vi++] << 15 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi++] << 25 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 35 | values[vi++] << 8 | values[vi] >>> 19;
                blocks[bi++] = values[vi++] << 45 | values[vi++] << 18 | values[vi] >>> 9;
                blocks[bi++] = values[vi++] << 55 | values[vi++] << 28 | values[vi++] << 1 | values[vi] >>> 26;
                blocks[bi++] = values[vi++] << 38 | values[vi++] << 11 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi++] << 21 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 31 | values[vi++] << 4 | values[vi] >>> 23;
                blocks[bi++] = values[vi++] << 41 | values[vi++] << 14 | values[vi] >>> 13;
                blocks[bi++] = values[vi++] << 51 | values[vi++] << 24 | values[vi] >>> 3;
                blocks[bi++] = values[vi++] << 61 | values[vi++] << 34 | values[vi++] << 7 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi++] << 17 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi++] << 27 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation26
    extends BulkOperation {
        Packed64BulkOperation26() {
        }

        @Override
        public int blocks() {
            return 13;
        }

        @Override
        public int values() {
            return 32;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 38;
                values[vi++] = block0 >>> 12 & 0x3FFFFFFL;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0xFFFL) << 14 | block1 >>> 50;
                values[vi++] = block1 >>> 24 & 0x3FFFFFFL;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0xFFFFFFL) << 2 | block2 >>> 62;
                values[vi++] = block2 >>> 36 & 0x3FFFFFFL;
                values[vi++] = block2 >>> 10 & 0x3FFFFFFL;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0x3FFL) << 16 | block3 >>> 48;
                values[vi++] = block3 >>> 22 & 0x3FFFFFFL;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0x3FFFFFL) << 4 | block4 >>> 60;
                values[vi++] = block4 >>> 34 & 0x3FFFFFFL;
                values[vi++] = block4 >>> 8 & 0x3FFFFFFL;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0xFFL) << 18 | block5 >>> 46;
                values[vi++] = block5 >>> 20 & 0x3FFFFFFL;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0xFFFFFL) << 6 | block6 >>> 58;
                values[vi++] = block6 >>> 32 & 0x3FFFFFFL;
                values[vi++] = block6 >>> 6 & 0x3FFFFFFL;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0x3FL) << 20 | block7 >>> 44;
                values[vi++] = block7 >>> 18 & 0x3FFFFFFL;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0x3FFFFL) << 8 | block8 >>> 56;
                values[vi++] = block8 >>> 30 & 0x3FFFFFFL;
                values[vi++] = block8 >>> 4 & 0x3FFFFFFL;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0xFL) << 22 | block9 >>> 42;
                values[vi++] = block9 >>> 16 & 0x3FFFFFFL;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 0xFFFFL) << 10 | block10 >>> 54;
                values[vi++] = block10 >>> 28 & 0x3FFFFFFL;
                values[vi++] = block10 >>> 2 & 0x3FFFFFFL;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 3L) << 24 | block11 >>> 40;
                values[vi++] = block11 >>> 14 & 0x3FFFFFFL;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 0x3FFFL) << 12 | block12 >>> 52;
                values[vi++] = block12 >>> 26 & 0x3FFFFFFL;
                values[vi++] = block12 & 0x3FFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 38 | values[vi++] << 12 | values[vi] >>> 14;
                blocks[bi++] = values[vi++] << 50 | values[vi++] << 24 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 36 | values[vi++] << 10 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi++] << 22 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 34 | values[vi++] << 8 | values[vi] >>> 18;
                blocks[bi++] = values[vi++] << 46 | values[vi++] << 20 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 32 | values[vi++] << 6 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi++] << 18 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 30 | values[vi++] << 4 | values[vi] >>> 22;
                blocks[bi++] = values[vi++] << 42 | values[vi++] << 16 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi++] << 28 | values[vi++] << 2 | values[vi] >>> 24;
                blocks[bi++] = values[vi++] << 40 | values[vi++] << 14 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi++] << 26 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation25
    extends BulkOperation {
        Packed64BulkOperation25() {
        }

        @Override
        public int blocks() {
            return 25;
        }

        @Override
        public int values() {
            return 64;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 39;
                values[vi++] = block0 >>> 14 & 0x1FFFFFFL;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0x3FFFL) << 11 | block1 >>> 53;
                values[vi++] = block1 >>> 28 & 0x1FFFFFFL;
                values[vi++] = block1 >>> 3 & 0x1FFFFFFL;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 7L) << 22 | block2 >>> 42;
                values[vi++] = block2 >>> 17 & 0x1FFFFFFL;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0x1FFFFL) << 8 | block3 >>> 56;
                values[vi++] = block3 >>> 31 & 0x1FFFFFFL;
                values[vi++] = block3 >>> 6 & 0x1FFFFFFL;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0x3FL) << 19 | block4 >>> 45;
                values[vi++] = block4 >>> 20 & 0x1FFFFFFL;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0xFFFFFL) << 5 | block5 >>> 59;
                values[vi++] = block5 >>> 34 & 0x1FFFFFFL;
                values[vi++] = block5 >>> 9 & 0x1FFFFFFL;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0x1FFL) << 16 | block6 >>> 48;
                values[vi++] = block6 >>> 23 & 0x1FFFFFFL;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0x7FFFFFL) << 2 | block7 >>> 62;
                values[vi++] = block7 >>> 37 & 0x1FFFFFFL;
                values[vi++] = block7 >>> 12 & 0x1FFFFFFL;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0xFFFL) << 13 | block8 >>> 51;
                values[vi++] = block8 >>> 26 & 0x1FFFFFFL;
                values[vi++] = block8 >>> 1 & 0x1FFFFFFL;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 1L) << 24 | block9 >>> 40;
                values[vi++] = block9 >>> 15 & 0x1FFFFFFL;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 0x7FFFL) << 10 | block10 >>> 54;
                values[vi++] = block10 >>> 29 & 0x1FFFFFFL;
                values[vi++] = block10 >>> 4 & 0x1FFFFFFL;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 0xFL) << 21 | block11 >>> 43;
                values[vi++] = block11 >>> 18 & 0x1FFFFFFL;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 0x3FFFFL) << 7 | block12 >>> 57;
                values[vi++] = block12 >>> 32 & 0x1FFFFFFL;
                values[vi++] = block12 >>> 7 & 0x1FFFFFFL;
                long block13 = blocks[bi++];
                values[vi++] = (block12 & 0x7FL) << 18 | block13 >>> 46;
                values[vi++] = block13 >>> 21 & 0x1FFFFFFL;
                long block14 = blocks[bi++];
                values[vi++] = (block13 & 0x1FFFFFL) << 4 | block14 >>> 60;
                values[vi++] = block14 >>> 35 & 0x1FFFFFFL;
                values[vi++] = block14 >>> 10 & 0x1FFFFFFL;
                long block15 = blocks[bi++];
                values[vi++] = (block14 & 0x3FFL) << 15 | block15 >>> 49;
                values[vi++] = block15 >>> 24 & 0x1FFFFFFL;
                long block16 = blocks[bi++];
                values[vi++] = (block15 & 0xFFFFFFL) << 1 | block16 >>> 63;
                values[vi++] = block16 >>> 38 & 0x1FFFFFFL;
                values[vi++] = block16 >>> 13 & 0x1FFFFFFL;
                long block17 = blocks[bi++];
                values[vi++] = (block16 & 0x1FFFL) << 12 | block17 >>> 52;
                values[vi++] = block17 >>> 27 & 0x1FFFFFFL;
                values[vi++] = block17 >>> 2 & 0x1FFFFFFL;
                long block18 = blocks[bi++];
                values[vi++] = (block17 & 3L) << 23 | block18 >>> 41;
                values[vi++] = block18 >>> 16 & 0x1FFFFFFL;
                long block19 = blocks[bi++];
                values[vi++] = (block18 & 0xFFFFL) << 9 | block19 >>> 55;
                values[vi++] = block19 >>> 30 & 0x1FFFFFFL;
                values[vi++] = block19 >>> 5 & 0x1FFFFFFL;
                long block20 = blocks[bi++];
                values[vi++] = (block19 & 0x1FL) << 20 | block20 >>> 44;
                values[vi++] = block20 >>> 19 & 0x1FFFFFFL;
                long block21 = blocks[bi++];
                values[vi++] = (block20 & 0x7FFFFL) << 6 | block21 >>> 58;
                values[vi++] = block21 >>> 33 & 0x1FFFFFFL;
                values[vi++] = block21 >>> 8 & 0x1FFFFFFL;
                long block22 = blocks[bi++];
                values[vi++] = (block21 & 0xFFL) << 17 | block22 >>> 47;
                values[vi++] = block22 >>> 22 & 0x1FFFFFFL;
                long block23 = blocks[bi++];
                values[vi++] = (block22 & 0x3FFFFFL) << 3 | block23 >>> 61;
                values[vi++] = block23 >>> 36 & 0x1FFFFFFL;
                values[vi++] = block23 >>> 11 & 0x1FFFFFFL;
                long block24 = blocks[bi++];
                values[vi++] = (block23 & 0x7FFL) << 14 | block24 >>> 50;
                values[vi++] = block24 >>> 25 & 0x1FFFFFFL;
                values[vi++] = block24 & 0x1FFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 39 | values[vi++] << 14 | values[vi] >>> 11;
                blocks[bi++] = values[vi++] << 53 | values[vi++] << 28 | values[vi++] << 3 | values[vi] >>> 22;
                blocks[bi++] = values[vi++] << 42 | values[vi++] << 17 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 31 | values[vi++] << 6 | values[vi] >>> 19;
                blocks[bi++] = values[vi++] << 45 | values[vi++] << 20 | values[vi] >>> 5;
                blocks[bi++] = values[vi++] << 59 | values[vi++] << 34 | values[vi++] << 9 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi++] << 23 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 37 | values[vi++] << 12 | values[vi] >>> 13;
                blocks[bi++] = values[vi++] << 51 | values[vi++] << 26 | values[vi++] << 1 | values[vi] >>> 24;
                blocks[bi++] = values[vi++] << 40 | values[vi++] << 15 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi++] << 29 | values[vi++] << 4 | values[vi] >>> 21;
                blocks[bi++] = values[vi++] << 43 | values[vi++] << 18 | values[vi] >>> 7;
                blocks[bi++] = values[vi++] << 57 | values[vi++] << 32 | values[vi++] << 7 | values[vi] >>> 18;
                blocks[bi++] = values[vi++] << 46 | values[vi++] << 21 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 35 | values[vi++] << 10 | values[vi] >>> 15;
                blocks[bi++] = values[vi++] << 49 | values[vi++] << 24 | values[vi] >>> 1;
                blocks[bi++] = values[vi++] << 63 | values[vi++] << 38 | values[vi++] << 13 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi++] << 27 | values[vi++] << 2 | values[vi] >>> 23;
                blocks[bi++] = values[vi++] << 41 | values[vi++] << 16 | values[vi] >>> 9;
                blocks[bi++] = values[vi++] << 55 | values[vi++] << 30 | values[vi++] << 5 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi++] << 19 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 33 | values[vi++] << 8 | values[vi] >>> 17;
                blocks[bi++] = values[vi++] << 47 | values[vi++] << 22 | values[vi] >>> 3;
                blocks[bi++] = values[vi++] << 61 | values[vi++] << 36 | values[vi++] << 11 | values[vi] >>> 14;
                blocks[bi++] = values[vi++] << 50 | values[vi++] << 25 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation24
    extends BulkOperation {
        Packed64BulkOperation24() {
        }

        @Override
        public int blocks() {
            return 3;
        }

        @Override
        public int values() {
            return 8;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 40;
                values[vi++] = block0 >>> 16 & 0xFFFFFFL;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0xFFFFL) << 8 | block1 >>> 56;
                values[vi++] = block1 >>> 32 & 0xFFFFFFL;
                values[vi++] = block1 >>> 8 & 0xFFFFFFL;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0xFFL) << 16 | block2 >>> 48;
                values[vi++] = block2 >>> 24 & 0xFFFFFFL;
                values[vi++] = block2 & 0xFFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 40 | values[vi++] << 16 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 32 | values[vi++] << 8 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi++] << 24 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation23
    extends BulkOperation {
        Packed64BulkOperation23() {
        }

        @Override
        public int blocks() {
            return 23;
        }

        @Override
        public int values() {
            return 64;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 41;
                values[vi++] = block0 >>> 18 & 0x7FFFFFL;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0x3FFFFL) << 5 | block1 >>> 59;
                values[vi++] = block1 >>> 36 & 0x7FFFFFL;
                values[vi++] = block1 >>> 13 & 0x7FFFFFL;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0x1FFFL) << 10 | block2 >>> 54;
                values[vi++] = block2 >>> 31 & 0x7FFFFFL;
                values[vi++] = block2 >>> 8 & 0x7FFFFFL;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0xFFL) << 15 | block3 >>> 49;
                values[vi++] = block3 >>> 26 & 0x7FFFFFL;
                values[vi++] = block3 >>> 3 & 0x7FFFFFL;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 7L) << 20 | block4 >>> 44;
                values[vi++] = block4 >>> 21 & 0x7FFFFFL;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0x1FFFFFL) << 2 | block5 >>> 62;
                values[vi++] = block5 >>> 39 & 0x7FFFFFL;
                values[vi++] = block5 >>> 16 & 0x7FFFFFL;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0xFFFFL) << 7 | block6 >>> 57;
                values[vi++] = block6 >>> 34 & 0x7FFFFFL;
                values[vi++] = block6 >>> 11 & 0x7FFFFFL;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0x7FFL) << 12 | block7 >>> 52;
                values[vi++] = block7 >>> 29 & 0x7FFFFFL;
                values[vi++] = block7 >>> 6 & 0x7FFFFFL;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0x3FL) << 17 | block8 >>> 47;
                values[vi++] = block8 >>> 24 & 0x7FFFFFL;
                values[vi++] = block8 >>> 1 & 0x7FFFFFL;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 1L) << 22 | block9 >>> 42;
                values[vi++] = block9 >>> 19 & 0x7FFFFFL;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 0x7FFFFL) << 4 | block10 >>> 60;
                values[vi++] = block10 >>> 37 & 0x7FFFFFL;
                values[vi++] = block10 >>> 14 & 0x7FFFFFL;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 0x3FFFL) << 9 | block11 >>> 55;
                values[vi++] = block11 >>> 32 & 0x7FFFFFL;
                values[vi++] = block11 >>> 9 & 0x7FFFFFL;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 0x1FFL) << 14 | block12 >>> 50;
                values[vi++] = block12 >>> 27 & 0x7FFFFFL;
                values[vi++] = block12 >>> 4 & 0x7FFFFFL;
                long block13 = blocks[bi++];
                values[vi++] = (block12 & 0xFL) << 19 | block13 >>> 45;
                values[vi++] = block13 >>> 22 & 0x7FFFFFL;
                long block14 = blocks[bi++];
                values[vi++] = (block13 & 0x3FFFFFL) << 1 | block14 >>> 63;
                values[vi++] = block14 >>> 40 & 0x7FFFFFL;
                values[vi++] = block14 >>> 17 & 0x7FFFFFL;
                long block15 = blocks[bi++];
                values[vi++] = (block14 & 0x1FFFFL) << 6 | block15 >>> 58;
                values[vi++] = block15 >>> 35 & 0x7FFFFFL;
                values[vi++] = block15 >>> 12 & 0x7FFFFFL;
                long block16 = blocks[bi++];
                values[vi++] = (block15 & 0xFFFL) << 11 | block16 >>> 53;
                values[vi++] = block16 >>> 30 & 0x7FFFFFL;
                values[vi++] = block16 >>> 7 & 0x7FFFFFL;
                long block17 = blocks[bi++];
                values[vi++] = (block16 & 0x7FL) << 16 | block17 >>> 48;
                values[vi++] = block17 >>> 25 & 0x7FFFFFL;
                values[vi++] = block17 >>> 2 & 0x7FFFFFL;
                long block18 = blocks[bi++];
                values[vi++] = (block17 & 3L) << 21 | block18 >>> 43;
                values[vi++] = block18 >>> 20 & 0x7FFFFFL;
                long block19 = blocks[bi++];
                values[vi++] = (block18 & 0xFFFFFL) << 3 | block19 >>> 61;
                values[vi++] = block19 >>> 38 & 0x7FFFFFL;
                values[vi++] = block19 >>> 15 & 0x7FFFFFL;
                long block20 = blocks[bi++];
                values[vi++] = (block19 & 0x7FFFL) << 8 | block20 >>> 56;
                values[vi++] = block20 >>> 33 & 0x7FFFFFL;
                values[vi++] = block20 >>> 10 & 0x7FFFFFL;
                long block21 = blocks[bi++];
                values[vi++] = (block20 & 0x3FFL) << 13 | block21 >>> 51;
                values[vi++] = block21 >>> 28 & 0x7FFFFFL;
                values[vi++] = block21 >>> 5 & 0x7FFFFFL;
                long block22 = blocks[bi++];
                values[vi++] = (block21 & 0x1FL) << 18 | block22 >>> 46;
                values[vi++] = block22 >>> 23 & 0x7FFFFFL;
                values[vi++] = block22 & 0x7FFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 41 | values[vi++] << 18 | values[vi] >>> 5;
                blocks[bi++] = values[vi++] << 59 | values[vi++] << 36 | values[vi++] << 13 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi++] << 31 | values[vi++] << 8 | values[vi] >>> 15;
                blocks[bi++] = values[vi++] << 49 | values[vi++] << 26 | values[vi++] << 3 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi++] << 21 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 39 | values[vi++] << 16 | values[vi] >>> 7;
                blocks[bi++] = values[vi++] << 57 | values[vi++] << 34 | values[vi++] << 11 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi++] << 29 | values[vi++] << 6 | values[vi] >>> 17;
                blocks[bi++] = values[vi++] << 47 | values[vi++] << 24 | values[vi++] << 1 | values[vi] >>> 22;
                blocks[bi++] = values[vi++] << 42 | values[vi++] << 19 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 37 | values[vi++] << 14 | values[vi] >>> 9;
                blocks[bi++] = values[vi++] << 55 | values[vi++] << 32 | values[vi++] << 9 | values[vi] >>> 14;
                blocks[bi++] = values[vi++] << 50 | values[vi++] << 27 | values[vi++] << 4 | values[vi] >>> 19;
                blocks[bi++] = values[vi++] << 45 | values[vi++] << 22 | values[vi] >>> 1;
                blocks[bi++] = values[vi++] << 63 | values[vi++] << 40 | values[vi++] << 17 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 35 | values[vi++] << 12 | values[vi] >>> 11;
                blocks[bi++] = values[vi++] << 53 | values[vi++] << 30 | values[vi++] << 7 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi++] << 25 | values[vi++] << 2 | values[vi] >>> 21;
                blocks[bi++] = values[vi++] << 43 | values[vi++] << 20 | values[vi] >>> 3;
                blocks[bi++] = values[vi++] << 61 | values[vi++] << 38 | values[vi++] << 15 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 33 | values[vi++] << 10 | values[vi] >>> 13;
                blocks[bi++] = values[vi++] << 51 | values[vi++] << 28 | values[vi++] << 5 | values[vi] >>> 18;
                blocks[bi++] = values[vi++] << 46 | values[vi++] << 23 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation22
    extends BulkOperation {
        Packed64BulkOperation22() {
        }

        @Override
        public int blocks() {
            return 11;
        }

        @Override
        public int values() {
            return 32;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 42;
                values[vi++] = block0 >>> 20 & 0x3FFFFFL;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0xFFFFFL) << 2 | block1 >>> 62;
                values[vi++] = block1 >>> 40 & 0x3FFFFFL;
                values[vi++] = block1 >>> 18 & 0x3FFFFFL;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0x3FFFFL) << 4 | block2 >>> 60;
                values[vi++] = block2 >>> 38 & 0x3FFFFFL;
                values[vi++] = block2 >>> 16 & 0x3FFFFFL;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0xFFFFL) << 6 | block3 >>> 58;
                values[vi++] = block3 >>> 36 & 0x3FFFFFL;
                values[vi++] = block3 >>> 14 & 0x3FFFFFL;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0x3FFFL) << 8 | block4 >>> 56;
                values[vi++] = block4 >>> 34 & 0x3FFFFFL;
                values[vi++] = block4 >>> 12 & 0x3FFFFFL;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0xFFFL) << 10 | block5 >>> 54;
                values[vi++] = block5 >>> 32 & 0x3FFFFFL;
                values[vi++] = block5 >>> 10 & 0x3FFFFFL;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0x3FFL) << 12 | block6 >>> 52;
                values[vi++] = block6 >>> 30 & 0x3FFFFFL;
                values[vi++] = block6 >>> 8 & 0x3FFFFFL;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0xFFL) << 14 | block7 >>> 50;
                values[vi++] = block7 >>> 28 & 0x3FFFFFL;
                values[vi++] = block7 >>> 6 & 0x3FFFFFL;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0x3FL) << 16 | block8 >>> 48;
                values[vi++] = block8 >>> 26 & 0x3FFFFFL;
                values[vi++] = block8 >>> 4 & 0x3FFFFFL;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0xFL) << 18 | block9 >>> 46;
                values[vi++] = block9 >>> 24 & 0x3FFFFFL;
                values[vi++] = block9 >>> 2 & 0x3FFFFFL;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 3L) << 20 | block10 >>> 44;
                values[vi++] = block10 >>> 22 & 0x3FFFFFL;
                values[vi++] = block10 & 0x3FFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 42 | values[vi++] << 20 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 40 | values[vi++] << 18 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 38 | values[vi++] << 16 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 36 | values[vi++] << 14 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 34 | values[vi++] << 12 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi++] << 32 | values[vi++] << 10 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi++] << 30 | values[vi++] << 8 | values[vi] >>> 14;
                blocks[bi++] = values[vi++] << 50 | values[vi++] << 28 | values[vi++] << 6 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi++] << 26 | values[vi++] << 4 | values[vi] >>> 18;
                blocks[bi++] = values[vi++] << 46 | values[vi++] << 24 | values[vi++] << 2 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi++] << 22 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation21
    extends BulkOperation {
        Packed64BulkOperation21() {
        }

        @Override
        public int blocks() {
            return 21;
        }

        @Override
        public int values() {
            return 64;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 43;
                values[vi++] = block0 >>> 22 & 0x1FFFFFL;
                values[vi++] = block0 >>> 1 & 0x1FFFFFL;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 1L) << 20 | block1 >>> 44;
                values[vi++] = block1 >>> 23 & 0x1FFFFFL;
                values[vi++] = block1 >>> 2 & 0x1FFFFFL;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 3L) << 19 | block2 >>> 45;
                values[vi++] = block2 >>> 24 & 0x1FFFFFL;
                values[vi++] = block2 >>> 3 & 0x1FFFFFL;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 7L) << 18 | block3 >>> 46;
                values[vi++] = block3 >>> 25 & 0x1FFFFFL;
                values[vi++] = block3 >>> 4 & 0x1FFFFFL;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0xFL) << 17 | block4 >>> 47;
                values[vi++] = block4 >>> 26 & 0x1FFFFFL;
                values[vi++] = block4 >>> 5 & 0x1FFFFFL;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0x1FL) << 16 | block5 >>> 48;
                values[vi++] = block5 >>> 27 & 0x1FFFFFL;
                values[vi++] = block5 >>> 6 & 0x1FFFFFL;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0x3FL) << 15 | block6 >>> 49;
                values[vi++] = block6 >>> 28 & 0x1FFFFFL;
                values[vi++] = block6 >>> 7 & 0x1FFFFFL;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0x7FL) << 14 | block7 >>> 50;
                values[vi++] = block7 >>> 29 & 0x1FFFFFL;
                values[vi++] = block7 >>> 8 & 0x1FFFFFL;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0xFFL) << 13 | block8 >>> 51;
                values[vi++] = block8 >>> 30 & 0x1FFFFFL;
                values[vi++] = block8 >>> 9 & 0x1FFFFFL;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0x1FFL) << 12 | block9 >>> 52;
                values[vi++] = block9 >>> 31 & 0x1FFFFFL;
                values[vi++] = block9 >>> 10 & 0x1FFFFFL;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 0x3FFL) << 11 | block10 >>> 53;
                values[vi++] = block10 >>> 32 & 0x1FFFFFL;
                values[vi++] = block10 >>> 11 & 0x1FFFFFL;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 0x7FFL) << 10 | block11 >>> 54;
                values[vi++] = block11 >>> 33 & 0x1FFFFFL;
                values[vi++] = block11 >>> 12 & 0x1FFFFFL;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 0xFFFL) << 9 | block12 >>> 55;
                values[vi++] = block12 >>> 34 & 0x1FFFFFL;
                values[vi++] = block12 >>> 13 & 0x1FFFFFL;
                long block13 = blocks[bi++];
                values[vi++] = (block12 & 0x1FFFL) << 8 | block13 >>> 56;
                values[vi++] = block13 >>> 35 & 0x1FFFFFL;
                values[vi++] = block13 >>> 14 & 0x1FFFFFL;
                long block14 = blocks[bi++];
                values[vi++] = (block13 & 0x3FFFL) << 7 | block14 >>> 57;
                values[vi++] = block14 >>> 36 & 0x1FFFFFL;
                values[vi++] = block14 >>> 15 & 0x1FFFFFL;
                long block15 = blocks[bi++];
                values[vi++] = (block14 & 0x7FFFL) << 6 | block15 >>> 58;
                values[vi++] = block15 >>> 37 & 0x1FFFFFL;
                values[vi++] = block15 >>> 16 & 0x1FFFFFL;
                long block16 = blocks[bi++];
                values[vi++] = (block15 & 0xFFFFL) << 5 | block16 >>> 59;
                values[vi++] = block16 >>> 38 & 0x1FFFFFL;
                values[vi++] = block16 >>> 17 & 0x1FFFFFL;
                long block17 = blocks[bi++];
                values[vi++] = (block16 & 0x1FFFFL) << 4 | block17 >>> 60;
                values[vi++] = block17 >>> 39 & 0x1FFFFFL;
                values[vi++] = block17 >>> 18 & 0x1FFFFFL;
                long block18 = blocks[bi++];
                values[vi++] = (block17 & 0x3FFFFL) << 3 | block18 >>> 61;
                values[vi++] = block18 >>> 40 & 0x1FFFFFL;
                values[vi++] = block18 >>> 19 & 0x1FFFFFL;
                long block19 = blocks[bi++];
                values[vi++] = (block18 & 0x7FFFFL) << 2 | block19 >>> 62;
                values[vi++] = block19 >>> 41 & 0x1FFFFFL;
                values[vi++] = block19 >>> 20 & 0x1FFFFFL;
                long block20 = blocks[bi++];
                values[vi++] = (block19 & 0xFFFFFL) << 1 | block20 >>> 63;
                values[vi++] = block20 >>> 42 & 0x1FFFFFL;
                values[vi++] = block20 >>> 21 & 0x1FFFFFL;
                values[vi++] = block20 & 0x1FFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 43 | values[vi++] << 22 | values[vi++] << 1 | values[vi] >>> 20;
                blocks[bi++] = values[vi++] << 44 | values[vi++] << 23 | values[vi++] << 2 | values[vi] >>> 19;
                blocks[bi++] = values[vi++] << 45 | values[vi++] << 24 | values[vi++] << 3 | values[vi] >>> 18;
                blocks[bi++] = values[vi++] << 46 | values[vi++] << 25 | values[vi++] << 4 | values[vi] >>> 17;
                blocks[bi++] = values[vi++] << 47 | values[vi++] << 26 | values[vi++] << 5 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi++] << 27 | values[vi++] << 6 | values[vi] >>> 15;
                blocks[bi++] = values[vi++] << 49 | values[vi++] << 28 | values[vi++] << 7 | values[vi] >>> 14;
                blocks[bi++] = values[vi++] << 50 | values[vi++] << 29 | values[vi++] << 8 | values[vi] >>> 13;
                blocks[bi++] = values[vi++] << 51 | values[vi++] << 30 | values[vi++] << 9 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi++] << 31 | values[vi++] << 10 | values[vi] >>> 11;
                blocks[bi++] = values[vi++] << 53 | values[vi++] << 32 | values[vi++] << 11 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi++] << 33 | values[vi++] << 12 | values[vi] >>> 9;
                blocks[bi++] = values[vi++] << 55 | values[vi++] << 34 | values[vi++] << 13 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 35 | values[vi++] << 14 | values[vi] >>> 7;
                blocks[bi++] = values[vi++] << 57 | values[vi++] << 36 | values[vi++] << 15 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 37 | values[vi++] << 16 | values[vi] >>> 5;
                blocks[bi++] = values[vi++] << 59 | values[vi++] << 38 | values[vi++] << 17 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 39 | values[vi++] << 18 | values[vi] >>> 3;
                blocks[bi++] = values[vi++] << 61 | values[vi++] << 40 | values[vi++] << 19 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 41 | values[vi++] << 20 | values[vi] >>> 1;
                blocks[bi++] = values[vi++] << 63 | values[vi++] << 42 | values[vi++] << 21 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation20
    extends BulkOperation {
        Packed64BulkOperation20() {
        }

        @Override
        public int blocks() {
            return 5;
        }

        @Override
        public int values() {
            return 16;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 44;
                values[vi++] = block0 >>> 24 & 0xFFFFFL;
                values[vi++] = block0 >>> 4 & 0xFFFFFL;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0xFL) << 16 | block1 >>> 48;
                values[vi++] = block1 >>> 28 & 0xFFFFFL;
                values[vi++] = block1 >>> 8 & 0xFFFFFL;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0xFFL) << 12 | block2 >>> 52;
                values[vi++] = block2 >>> 32 & 0xFFFFFL;
                values[vi++] = block2 >>> 12 & 0xFFFFFL;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0xFFFL) << 8 | block3 >>> 56;
                values[vi++] = block3 >>> 36 & 0xFFFFFL;
                values[vi++] = block3 >>> 16 & 0xFFFFFL;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0xFFFFL) << 4 | block4 >>> 60;
                values[vi++] = block4 >>> 40 & 0xFFFFFL;
                values[vi++] = block4 >>> 20 & 0xFFFFFL;
                values[vi++] = block4 & 0xFFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 44 | values[vi++] << 24 | values[vi++] << 4 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi++] << 28 | values[vi++] << 8 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi++] << 32 | values[vi++] << 12 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 36 | values[vi++] << 16 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 40 | values[vi++] << 20 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation19
    extends BulkOperation {
        Packed64BulkOperation19() {
        }

        @Override
        public int blocks() {
            return 19;
        }

        @Override
        public int values() {
            return 64;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 45;
                values[vi++] = block0 >>> 26 & 0x7FFFFL;
                values[vi++] = block0 >>> 7 & 0x7FFFFL;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0x7FL) << 12 | block1 >>> 52;
                values[vi++] = block1 >>> 33 & 0x7FFFFL;
                values[vi++] = block1 >>> 14 & 0x7FFFFL;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0x3FFFL) << 5 | block2 >>> 59;
                values[vi++] = block2 >>> 40 & 0x7FFFFL;
                values[vi++] = block2 >>> 21 & 0x7FFFFL;
                values[vi++] = block2 >>> 2 & 0x7FFFFL;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 3L) << 17 | block3 >>> 47;
                values[vi++] = block3 >>> 28 & 0x7FFFFL;
                values[vi++] = block3 >>> 9 & 0x7FFFFL;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0x1FFL) << 10 | block4 >>> 54;
                values[vi++] = block4 >>> 35 & 0x7FFFFL;
                values[vi++] = block4 >>> 16 & 0x7FFFFL;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0xFFFFL) << 3 | block5 >>> 61;
                values[vi++] = block5 >>> 42 & 0x7FFFFL;
                values[vi++] = block5 >>> 23 & 0x7FFFFL;
                values[vi++] = block5 >>> 4 & 0x7FFFFL;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0xFL) << 15 | block6 >>> 49;
                values[vi++] = block6 >>> 30 & 0x7FFFFL;
                values[vi++] = block6 >>> 11 & 0x7FFFFL;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0x7FFL) << 8 | block7 >>> 56;
                values[vi++] = block7 >>> 37 & 0x7FFFFL;
                values[vi++] = block7 >>> 18 & 0x7FFFFL;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0x3FFFFL) << 1 | block8 >>> 63;
                values[vi++] = block8 >>> 44 & 0x7FFFFL;
                values[vi++] = block8 >>> 25 & 0x7FFFFL;
                values[vi++] = block8 >>> 6 & 0x7FFFFL;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0x3FL) << 13 | block9 >>> 51;
                values[vi++] = block9 >>> 32 & 0x7FFFFL;
                values[vi++] = block9 >>> 13 & 0x7FFFFL;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 0x1FFFL) << 6 | block10 >>> 58;
                values[vi++] = block10 >>> 39 & 0x7FFFFL;
                values[vi++] = block10 >>> 20 & 0x7FFFFL;
                values[vi++] = block10 >>> 1 & 0x7FFFFL;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 1L) << 18 | block11 >>> 46;
                values[vi++] = block11 >>> 27 & 0x7FFFFL;
                values[vi++] = block11 >>> 8 & 0x7FFFFL;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 0xFFL) << 11 | block12 >>> 53;
                values[vi++] = block12 >>> 34 & 0x7FFFFL;
                values[vi++] = block12 >>> 15 & 0x7FFFFL;
                long block13 = blocks[bi++];
                values[vi++] = (block12 & 0x7FFFL) << 4 | block13 >>> 60;
                values[vi++] = block13 >>> 41 & 0x7FFFFL;
                values[vi++] = block13 >>> 22 & 0x7FFFFL;
                values[vi++] = block13 >>> 3 & 0x7FFFFL;
                long block14 = blocks[bi++];
                values[vi++] = (block13 & 7L) << 16 | block14 >>> 48;
                values[vi++] = block14 >>> 29 & 0x7FFFFL;
                values[vi++] = block14 >>> 10 & 0x7FFFFL;
                long block15 = blocks[bi++];
                values[vi++] = (block14 & 0x3FFL) << 9 | block15 >>> 55;
                values[vi++] = block15 >>> 36 & 0x7FFFFL;
                values[vi++] = block15 >>> 17 & 0x7FFFFL;
                long block16 = blocks[bi++];
                values[vi++] = (block15 & 0x1FFFFL) << 2 | block16 >>> 62;
                values[vi++] = block16 >>> 43 & 0x7FFFFL;
                values[vi++] = block16 >>> 24 & 0x7FFFFL;
                values[vi++] = block16 >>> 5 & 0x7FFFFL;
                long block17 = blocks[bi++];
                values[vi++] = (block16 & 0x1FL) << 14 | block17 >>> 50;
                values[vi++] = block17 >>> 31 & 0x7FFFFL;
                values[vi++] = block17 >>> 12 & 0x7FFFFL;
                long block18 = blocks[bi++];
                values[vi++] = (block17 & 0xFFFL) << 7 | block18 >>> 57;
                values[vi++] = block18 >>> 38 & 0x7FFFFL;
                values[vi++] = block18 >>> 19 & 0x7FFFFL;
                values[vi++] = block18 & 0x7FFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 45 | values[vi++] << 26 | values[vi++] << 7 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi++] << 33 | values[vi++] << 14 | values[vi] >>> 5;
                blocks[bi++] = values[vi++] << 59 | values[vi++] << 40 | values[vi++] << 21 | values[vi++] << 2 | values[vi] >>> 17;
                blocks[bi++] = values[vi++] << 47 | values[vi++] << 28 | values[vi++] << 9 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi++] << 35 | values[vi++] << 16 | values[vi] >>> 3;
                blocks[bi++] = values[vi++] << 61 | values[vi++] << 42 | values[vi++] << 23 | values[vi++] << 4 | values[vi] >>> 15;
                blocks[bi++] = values[vi++] << 49 | values[vi++] << 30 | values[vi++] << 11 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 37 | values[vi++] << 18 | values[vi] >>> 1;
                blocks[bi++] = values[vi++] << 63 | values[vi++] << 44 | values[vi++] << 25 | values[vi++] << 6 | values[vi] >>> 13;
                blocks[bi++] = values[vi++] << 51 | values[vi++] << 32 | values[vi++] << 13 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 39 | values[vi++] << 20 | values[vi++] << 1 | values[vi] >>> 18;
                blocks[bi++] = values[vi++] << 46 | values[vi++] << 27 | values[vi++] << 8 | values[vi] >>> 11;
                blocks[bi++] = values[vi++] << 53 | values[vi++] << 34 | values[vi++] << 15 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 41 | values[vi++] << 22 | values[vi++] << 3 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi++] << 29 | values[vi++] << 10 | values[vi] >>> 9;
                blocks[bi++] = values[vi++] << 55 | values[vi++] << 36 | values[vi++] << 17 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 43 | values[vi++] << 24 | values[vi++] << 5 | values[vi] >>> 14;
                blocks[bi++] = values[vi++] << 50 | values[vi++] << 31 | values[vi++] << 12 | values[vi] >>> 7;
                blocks[bi++] = values[vi++] << 57 | values[vi++] << 38 | values[vi++] << 19 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation18
    extends BulkOperation {
        Packed64BulkOperation18() {
        }

        @Override
        public int blocks() {
            return 9;
        }

        @Override
        public int values() {
            return 32;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 46;
                values[vi++] = block0 >>> 28 & 0x3FFFFL;
                values[vi++] = block0 >>> 10 & 0x3FFFFL;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0x3FFL) << 8 | block1 >>> 56;
                values[vi++] = block1 >>> 38 & 0x3FFFFL;
                values[vi++] = block1 >>> 20 & 0x3FFFFL;
                values[vi++] = block1 >>> 2 & 0x3FFFFL;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 3L) << 16 | block2 >>> 48;
                values[vi++] = block2 >>> 30 & 0x3FFFFL;
                values[vi++] = block2 >>> 12 & 0x3FFFFL;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0xFFFL) << 6 | block3 >>> 58;
                values[vi++] = block3 >>> 40 & 0x3FFFFL;
                values[vi++] = block3 >>> 22 & 0x3FFFFL;
                values[vi++] = block3 >>> 4 & 0x3FFFFL;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0xFL) << 14 | block4 >>> 50;
                values[vi++] = block4 >>> 32 & 0x3FFFFL;
                values[vi++] = block4 >>> 14 & 0x3FFFFL;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0x3FFFL) << 4 | block5 >>> 60;
                values[vi++] = block5 >>> 42 & 0x3FFFFL;
                values[vi++] = block5 >>> 24 & 0x3FFFFL;
                values[vi++] = block5 >>> 6 & 0x3FFFFL;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0x3FL) << 12 | block6 >>> 52;
                values[vi++] = block6 >>> 34 & 0x3FFFFL;
                values[vi++] = block6 >>> 16 & 0x3FFFFL;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0xFFFFL) << 2 | block7 >>> 62;
                values[vi++] = block7 >>> 44 & 0x3FFFFL;
                values[vi++] = block7 >>> 26 & 0x3FFFFL;
                values[vi++] = block7 >>> 8 & 0x3FFFFL;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0xFFL) << 10 | block8 >>> 54;
                values[vi++] = block8 >>> 36 & 0x3FFFFL;
                values[vi++] = block8 >>> 18 & 0x3FFFFL;
                values[vi++] = block8 & 0x3FFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 46 | values[vi++] << 28 | values[vi++] << 10 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 38 | values[vi++] << 20 | values[vi++] << 2 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi++] << 30 | values[vi++] << 12 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 40 | values[vi++] << 22 | values[vi++] << 4 | values[vi] >>> 14;
                blocks[bi++] = values[vi++] << 50 | values[vi++] << 32 | values[vi++] << 14 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 42 | values[vi++] << 24 | values[vi++] << 6 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi++] << 34 | values[vi++] << 16 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 44 | values[vi++] << 26 | values[vi++] << 8 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi++] << 36 | values[vi++] << 18 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation17
    extends BulkOperation {
        Packed64BulkOperation17() {
        }

        @Override
        public int blocks() {
            return 17;
        }

        @Override
        public int values() {
            return 64;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 47;
                values[vi++] = block0 >>> 30 & 0x1FFFFL;
                values[vi++] = block0 >>> 13 & 0x1FFFFL;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0x1FFFL) << 4 | block1 >>> 60;
                values[vi++] = block1 >>> 43 & 0x1FFFFL;
                values[vi++] = block1 >>> 26 & 0x1FFFFL;
                values[vi++] = block1 >>> 9 & 0x1FFFFL;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0x1FFL) << 8 | block2 >>> 56;
                values[vi++] = block2 >>> 39 & 0x1FFFFL;
                values[vi++] = block2 >>> 22 & 0x1FFFFL;
                values[vi++] = block2 >>> 5 & 0x1FFFFL;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0x1FL) << 12 | block3 >>> 52;
                values[vi++] = block3 >>> 35 & 0x1FFFFL;
                values[vi++] = block3 >>> 18 & 0x1FFFFL;
                values[vi++] = block3 >>> 1 & 0x1FFFFL;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 1L) << 16 | block4 >>> 48;
                values[vi++] = block4 >>> 31 & 0x1FFFFL;
                values[vi++] = block4 >>> 14 & 0x1FFFFL;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0x3FFFL) << 3 | block5 >>> 61;
                values[vi++] = block5 >>> 44 & 0x1FFFFL;
                values[vi++] = block5 >>> 27 & 0x1FFFFL;
                values[vi++] = block5 >>> 10 & 0x1FFFFL;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0x3FFL) << 7 | block6 >>> 57;
                values[vi++] = block6 >>> 40 & 0x1FFFFL;
                values[vi++] = block6 >>> 23 & 0x1FFFFL;
                values[vi++] = block6 >>> 6 & 0x1FFFFL;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0x3FL) << 11 | block7 >>> 53;
                values[vi++] = block7 >>> 36 & 0x1FFFFL;
                values[vi++] = block7 >>> 19 & 0x1FFFFL;
                values[vi++] = block7 >>> 2 & 0x1FFFFL;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 3L) << 15 | block8 >>> 49;
                values[vi++] = block8 >>> 32 & 0x1FFFFL;
                values[vi++] = block8 >>> 15 & 0x1FFFFL;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0x7FFFL) << 2 | block9 >>> 62;
                values[vi++] = block9 >>> 45 & 0x1FFFFL;
                values[vi++] = block9 >>> 28 & 0x1FFFFL;
                values[vi++] = block9 >>> 11 & 0x1FFFFL;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 0x7FFL) << 6 | block10 >>> 58;
                values[vi++] = block10 >>> 41 & 0x1FFFFL;
                values[vi++] = block10 >>> 24 & 0x1FFFFL;
                values[vi++] = block10 >>> 7 & 0x1FFFFL;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 0x7FL) << 10 | block11 >>> 54;
                values[vi++] = block11 >>> 37 & 0x1FFFFL;
                values[vi++] = block11 >>> 20 & 0x1FFFFL;
                values[vi++] = block11 >>> 3 & 0x1FFFFL;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 7L) << 14 | block12 >>> 50;
                values[vi++] = block12 >>> 33 & 0x1FFFFL;
                values[vi++] = block12 >>> 16 & 0x1FFFFL;
                long block13 = blocks[bi++];
                values[vi++] = (block12 & 0xFFFFL) << 1 | block13 >>> 63;
                values[vi++] = block13 >>> 46 & 0x1FFFFL;
                values[vi++] = block13 >>> 29 & 0x1FFFFL;
                values[vi++] = block13 >>> 12 & 0x1FFFFL;
                long block14 = blocks[bi++];
                values[vi++] = (block13 & 0xFFFL) << 5 | block14 >>> 59;
                values[vi++] = block14 >>> 42 & 0x1FFFFL;
                values[vi++] = block14 >>> 25 & 0x1FFFFL;
                values[vi++] = block14 >>> 8 & 0x1FFFFL;
                long block15 = blocks[bi++];
                values[vi++] = (block14 & 0xFFL) << 9 | block15 >>> 55;
                values[vi++] = block15 >>> 38 & 0x1FFFFL;
                values[vi++] = block15 >>> 21 & 0x1FFFFL;
                values[vi++] = block15 >>> 4 & 0x1FFFFL;
                long block16 = blocks[bi++];
                values[vi++] = (block15 & 0xFL) << 13 | block16 >>> 51;
                values[vi++] = block16 >>> 34 & 0x1FFFFL;
                values[vi++] = block16 >>> 17 & 0x1FFFFL;
                values[vi++] = block16 & 0x1FFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 47 | values[vi++] << 30 | values[vi++] << 13 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 43 | values[vi++] << 26 | values[vi++] << 9 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 39 | values[vi++] << 22 | values[vi++] << 5 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi++] << 35 | values[vi++] << 18 | values[vi++] << 1 | values[vi] >>> 16;
                blocks[bi++] = values[vi++] << 48 | values[vi++] << 31 | values[vi++] << 14 | values[vi] >>> 3;
                blocks[bi++] = values[vi++] << 61 | values[vi++] << 44 | values[vi++] << 27 | values[vi++] << 10 | values[vi] >>> 7;
                blocks[bi++] = values[vi++] << 57 | values[vi++] << 40 | values[vi++] << 23 | values[vi++] << 6 | values[vi] >>> 11;
                blocks[bi++] = values[vi++] << 53 | values[vi++] << 36 | values[vi++] << 19 | values[vi++] << 2 | values[vi] >>> 15;
                blocks[bi++] = values[vi++] << 49 | values[vi++] << 32 | values[vi++] << 15 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 45 | values[vi++] << 28 | values[vi++] << 11 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 41 | values[vi++] << 24 | values[vi++] << 7 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi++] << 37 | values[vi++] << 20 | values[vi++] << 3 | values[vi] >>> 14;
                blocks[bi++] = values[vi++] << 50 | values[vi++] << 33 | values[vi++] << 16 | values[vi] >>> 1;
                blocks[bi++] = values[vi++] << 63 | values[vi++] << 46 | values[vi++] << 29 | values[vi++] << 12 | values[vi] >>> 5;
                blocks[bi++] = values[vi++] << 59 | values[vi++] << 42 | values[vi++] << 25 | values[vi++] << 8 | values[vi] >>> 9;
                blocks[bi++] = values[vi++] << 55 | values[vi++] << 38 | values[vi++] << 21 | values[vi++] << 4 | values[vi] >>> 13;
                blocks[bi++] = values[vi++] << 51 | values[vi++] << 34 | values[vi++] << 17 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation16
    extends BulkOperation {
        Packed64BulkOperation16() {
        }

        @Override
        public int blocks() {
            return 1;
        }

        @Override
        public int values() {
            return 4;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 48;
                values[vi++] = block0 >>> 32 & 0xFFFFL;
                values[vi++] = block0 >>> 16 & 0xFFFFL;
                values[vi++] = block0 & 0xFFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 48 | values[vi++] << 32 | values[vi++] << 16 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation15
    extends BulkOperation {
        Packed64BulkOperation15() {
        }

        @Override
        public int blocks() {
            return 15;
        }

        @Override
        public int values() {
            return 64;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 49;
                values[vi++] = block0 >>> 34 & 0x7FFFL;
                values[vi++] = block0 >>> 19 & 0x7FFFL;
                values[vi++] = block0 >>> 4 & 0x7FFFL;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0xFL) << 11 | block1 >>> 53;
                values[vi++] = block1 >>> 38 & 0x7FFFL;
                values[vi++] = block1 >>> 23 & 0x7FFFL;
                values[vi++] = block1 >>> 8 & 0x7FFFL;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0xFFL) << 7 | block2 >>> 57;
                values[vi++] = block2 >>> 42 & 0x7FFFL;
                values[vi++] = block2 >>> 27 & 0x7FFFL;
                values[vi++] = block2 >>> 12 & 0x7FFFL;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0xFFFL) << 3 | block3 >>> 61;
                values[vi++] = block3 >>> 46 & 0x7FFFL;
                values[vi++] = block3 >>> 31 & 0x7FFFL;
                values[vi++] = block3 >>> 16 & 0x7FFFL;
                values[vi++] = block3 >>> 1 & 0x7FFFL;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 1L) << 14 | block4 >>> 50;
                values[vi++] = block4 >>> 35 & 0x7FFFL;
                values[vi++] = block4 >>> 20 & 0x7FFFL;
                values[vi++] = block4 >>> 5 & 0x7FFFL;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0x1FL) << 10 | block5 >>> 54;
                values[vi++] = block5 >>> 39 & 0x7FFFL;
                values[vi++] = block5 >>> 24 & 0x7FFFL;
                values[vi++] = block5 >>> 9 & 0x7FFFL;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0x1FFL) << 6 | block6 >>> 58;
                values[vi++] = block6 >>> 43 & 0x7FFFL;
                values[vi++] = block6 >>> 28 & 0x7FFFL;
                values[vi++] = block6 >>> 13 & 0x7FFFL;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0x1FFFL) << 2 | block7 >>> 62;
                values[vi++] = block7 >>> 47 & 0x7FFFL;
                values[vi++] = block7 >>> 32 & 0x7FFFL;
                values[vi++] = block7 >>> 17 & 0x7FFFL;
                values[vi++] = block7 >>> 2 & 0x7FFFL;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 3L) << 13 | block8 >>> 51;
                values[vi++] = block8 >>> 36 & 0x7FFFL;
                values[vi++] = block8 >>> 21 & 0x7FFFL;
                values[vi++] = block8 >>> 6 & 0x7FFFL;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0x3FL) << 9 | block9 >>> 55;
                values[vi++] = block9 >>> 40 & 0x7FFFL;
                values[vi++] = block9 >>> 25 & 0x7FFFL;
                values[vi++] = block9 >>> 10 & 0x7FFFL;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 0x3FFL) << 5 | block10 >>> 59;
                values[vi++] = block10 >>> 44 & 0x7FFFL;
                values[vi++] = block10 >>> 29 & 0x7FFFL;
                values[vi++] = block10 >>> 14 & 0x7FFFL;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 0x3FFFL) << 1 | block11 >>> 63;
                values[vi++] = block11 >>> 48 & 0x7FFFL;
                values[vi++] = block11 >>> 33 & 0x7FFFL;
                values[vi++] = block11 >>> 18 & 0x7FFFL;
                values[vi++] = block11 >>> 3 & 0x7FFFL;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 7L) << 12 | block12 >>> 52;
                values[vi++] = block12 >>> 37 & 0x7FFFL;
                values[vi++] = block12 >>> 22 & 0x7FFFL;
                values[vi++] = block12 >>> 7 & 0x7FFFL;
                long block13 = blocks[bi++];
                values[vi++] = (block12 & 0x7FL) << 8 | block13 >>> 56;
                values[vi++] = block13 >>> 41 & 0x7FFFL;
                values[vi++] = block13 >>> 26 & 0x7FFFL;
                values[vi++] = block13 >>> 11 & 0x7FFFL;
                long block14 = blocks[bi++];
                values[vi++] = (block13 & 0x7FFL) << 4 | block14 >>> 60;
                values[vi++] = block14 >>> 45 & 0x7FFFL;
                values[vi++] = block14 >>> 30 & 0x7FFFL;
                values[vi++] = block14 >>> 15 & 0x7FFFL;
                values[vi++] = block14 & 0x7FFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 49 | values[vi++] << 34 | values[vi++] << 19 | values[vi++] << 4 | values[vi] >>> 11;
                blocks[bi++] = values[vi++] << 53 | values[vi++] << 38 | values[vi++] << 23 | values[vi++] << 8 | values[vi] >>> 7;
                blocks[bi++] = values[vi++] << 57 | values[vi++] << 42 | values[vi++] << 27 | values[vi++] << 12 | values[vi] >>> 3;
                blocks[bi++] = values[vi++] << 61 | values[vi++] << 46 | values[vi++] << 31 | values[vi++] << 16 | values[vi++] << 1 | values[vi] >>> 14;
                blocks[bi++] = values[vi++] << 50 | values[vi++] << 35 | values[vi++] << 20 | values[vi++] << 5 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi++] << 39 | values[vi++] << 24 | values[vi++] << 9 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 43 | values[vi++] << 28 | values[vi++] << 13 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 47 | values[vi++] << 32 | values[vi++] << 17 | values[vi++] << 2 | values[vi] >>> 13;
                blocks[bi++] = values[vi++] << 51 | values[vi++] << 36 | values[vi++] << 21 | values[vi++] << 6 | values[vi] >>> 9;
                blocks[bi++] = values[vi++] << 55 | values[vi++] << 40 | values[vi++] << 25 | values[vi++] << 10 | values[vi] >>> 5;
                blocks[bi++] = values[vi++] << 59 | values[vi++] << 44 | values[vi++] << 29 | values[vi++] << 14 | values[vi] >>> 1;
                blocks[bi++] = values[vi++] << 63 | values[vi++] << 48 | values[vi++] << 33 | values[vi++] << 18 | values[vi++] << 3 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi++] << 37 | values[vi++] << 22 | values[vi++] << 7 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 41 | values[vi++] << 26 | values[vi++] << 11 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 45 | values[vi++] << 30 | values[vi++] << 15 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation14
    extends BulkOperation {
        Packed64BulkOperation14() {
        }

        @Override
        public int blocks() {
            return 7;
        }

        @Override
        public int values() {
            return 32;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 50;
                values[vi++] = block0 >>> 36 & 0x3FFFL;
                values[vi++] = block0 >>> 22 & 0x3FFFL;
                values[vi++] = block0 >>> 8 & 0x3FFFL;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0xFFL) << 6 | block1 >>> 58;
                values[vi++] = block1 >>> 44 & 0x3FFFL;
                values[vi++] = block1 >>> 30 & 0x3FFFL;
                values[vi++] = block1 >>> 16 & 0x3FFFL;
                values[vi++] = block1 >>> 2 & 0x3FFFL;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 3L) << 12 | block2 >>> 52;
                values[vi++] = block2 >>> 38 & 0x3FFFL;
                values[vi++] = block2 >>> 24 & 0x3FFFL;
                values[vi++] = block2 >>> 10 & 0x3FFFL;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0x3FFL) << 4 | block3 >>> 60;
                values[vi++] = block3 >>> 46 & 0x3FFFL;
                values[vi++] = block3 >>> 32 & 0x3FFFL;
                values[vi++] = block3 >>> 18 & 0x3FFFL;
                values[vi++] = block3 >>> 4 & 0x3FFFL;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0xFL) << 10 | block4 >>> 54;
                values[vi++] = block4 >>> 40 & 0x3FFFL;
                values[vi++] = block4 >>> 26 & 0x3FFFL;
                values[vi++] = block4 >>> 12 & 0x3FFFL;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0xFFFL) << 2 | block5 >>> 62;
                values[vi++] = block5 >>> 48 & 0x3FFFL;
                values[vi++] = block5 >>> 34 & 0x3FFFL;
                values[vi++] = block5 >>> 20 & 0x3FFFL;
                values[vi++] = block5 >>> 6 & 0x3FFFL;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0x3FL) << 8 | block6 >>> 56;
                values[vi++] = block6 >>> 42 & 0x3FFFL;
                values[vi++] = block6 >>> 28 & 0x3FFFL;
                values[vi++] = block6 >>> 14 & 0x3FFFL;
                values[vi++] = block6 & 0x3FFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 50 | values[vi++] << 36 | values[vi++] << 22 | values[vi++] << 8 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 44 | values[vi++] << 30 | values[vi++] << 16 | values[vi++] << 2 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi++] << 38 | values[vi++] << 24 | values[vi++] << 10 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 46 | values[vi++] << 32 | values[vi++] << 18 | values[vi++] << 4 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi++] << 40 | values[vi++] << 26 | values[vi++] << 12 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 48 | values[vi++] << 34 | values[vi++] << 20 | values[vi++] << 6 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 42 | values[vi++] << 28 | values[vi++] << 14 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation13
    extends BulkOperation {
        Packed64BulkOperation13() {
        }

        @Override
        public int blocks() {
            return 13;
        }

        @Override
        public int values() {
            return 64;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 51;
                values[vi++] = block0 >>> 38 & 0x1FFFL;
                values[vi++] = block0 >>> 25 & 0x1FFFL;
                values[vi++] = block0 >>> 12 & 0x1FFFL;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0xFFFL) << 1 | block1 >>> 63;
                values[vi++] = block1 >>> 50 & 0x1FFFL;
                values[vi++] = block1 >>> 37 & 0x1FFFL;
                values[vi++] = block1 >>> 24 & 0x1FFFL;
                values[vi++] = block1 >>> 11 & 0x1FFFL;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0x7FFL) << 2 | block2 >>> 62;
                values[vi++] = block2 >>> 49 & 0x1FFFL;
                values[vi++] = block2 >>> 36 & 0x1FFFL;
                values[vi++] = block2 >>> 23 & 0x1FFFL;
                values[vi++] = block2 >>> 10 & 0x1FFFL;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0x3FFL) << 3 | block3 >>> 61;
                values[vi++] = block3 >>> 48 & 0x1FFFL;
                values[vi++] = block3 >>> 35 & 0x1FFFL;
                values[vi++] = block3 >>> 22 & 0x1FFFL;
                values[vi++] = block3 >>> 9 & 0x1FFFL;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0x1FFL) << 4 | block4 >>> 60;
                values[vi++] = block4 >>> 47 & 0x1FFFL;
                values[vi++] = block4 >>> 34 & 0x1FFFL;
                values[vi++] = block4 >>> 21 & 0x1FFFL;
                values[vi++] = block4 >>> 8 & 0x1FFFL;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0xFFL) << 5 | block5 >>> 59;
                values[vi++] = block5 >>> 46 & 0x1FFFL;
                values[vi++] = block5 >>> 33 & 0x1FFFL;
                values[vi++] = block5 >>> 20 & 0x1FFFL;
                values[vi++] = block5 >>> 7 & 0x1FFFL;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0x7FL) << 6 | block6 >>> 58;
                values[vi++] = block6 >>> 45 & 0x1FFFL;
                values[vi++] = block6 >>> 32 & 0x1FFFL;
                values[vi++] = block6 >>> 19 & 0x1FFFL;
                values[vi++] = block6 >>> 6 & 0x1FFFL;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0x3FL) << 7 | block7 >>> 57;
                values[vi++] = block7 >>> 44 & 0x1FFFL;
                values[vi++] = block7 >>> 31 & 0x1FFFL;
                values[vi++] = block7 >>> 18 & 0x1FFFL;
                values[vi++] = block7 >>> 5 & 0x1FFFL;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0x1FL) << 8 | block8 >>> 56;
                values[vi++] = block8 >>> 43 & 0x1FFFL;
                values[vi++] = block8 >>> 30 & 0x1FFFL;
                values[vi++] = block8 >>> 17 & 0x1FFFL;
                values[vi++] = block8 >>> 4 & 0x1FFFL;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0xFL) << 9 | block9 >>> 55;
                values[vi++] = block9 >>> 42 & 0x1FFFL;
                values[vi++] = block9 >>> 29 & 0x1FFFL;
                values[vi++] = block9 >>> 16 & 0x1FFFL;
                values[vi++] = block9 >>> 3 & 0x1FFFL;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 7L) << 10 | block10 >>> 54;
                values[vi++] = block10 >>> 41 & 0x1FFFL;
                values[vi++] = block10 >>> 28 & 0x1FFFL;
                values[vi++] = block10 >>> 15 & 0x1FFFL;
                values[vi++] = block10 >>> 2 & 0x1FFFL;
                long block11 = blocks[bi++];
                values[vi++] = (block10 & 3L) << 11 | block11 >>> 53;
                values[vi++] = block11 >>> 40 & 0x1FFFL;
                values[vi++] = block11 >>> 27 & 0x1FFFL;
                values[vi++] = block11 >>> 14 & 0x1FFFL;
                values[vi++] = block11 >>> 1 & 0x1FFFL;
                long block12 = blocks[bi++];
                values[vi++] = (block11 & 1L) << 12 | block12 >>> 52;
                values[vi++] = block12 >>> 39 & 0x1FFFL;
                values[vi++] = block12 >>> 26 & 0x1FFFL;
                values[vi++] = block12 >>> 13 & 0x1FFFL;
                values[vi++] = block12 & 0x1FFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 51 | values[vi++] << 38 | values[vi++] << 25 | values[vi++] << 12 | values[vi] >>> 1;
                blocks[bi++] = values[vi++] << 63 | values[vi++] << 50 | values[vi++] << 37 | values[vi++] << 24 | values[vi++] << 11 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 49 | values[vi++] << 36 | values[vi++] << 23 | values[vi++] << 10 | values[vi] >>> 3;
                blocks[bi++] = values[vi++] << 61 | values[vi++] << 48 | values[vi++] << 35 | values[vi++] << 22 | values[vi++] << 9 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 47 | values[vi++] << 34 | values[vi++] << 21 | values[vi++] << 8 | values[vi] >>> 5;
                blocks[bi++] = values[vi++] << 59 | values[vi++] << 46 | values[vi++] << 33 | values[vi++] << 20 | values[vi++] << 7 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 45 | values[vi++] << 32 | values[vi++] << 19 | values[vi++] << 6 | values[vi] >>> 7;
                blocks[bi++] = values[vi++] << 57 | values[vi++] << 44 | values[vi++] << 31 | values[vi++] << 18 | values[vi++] << 5 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 43 | values[vi++] << 30 | values[vi++] << 17 | values[vi++] << 4 | values[vi] >>> 9;
                blocks[bi++] = values[vi++] << 55 | values[vi++] << 42 | values[vi++] << 29 | values[vi++] << 16 | values[vi++] << 3 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi++] << 41 | values[vi++] << 28 | values[vi++] << 15 | values[vi++] << 2 | values[vi] >>> 11;
                blocks[bi++] = values[vi++] << 53 | values[vi++] << 40 | values[vi++] << 27 | values[vi++] << 14 | values[vi++] << 1 | values[vi] >>> 12;
                blocks[bi++] = values[vi++] << 52 | values[vi++] << 39 | values[vi++] << 26 | values[vi++] << 13 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation12
    extends BulkOperation {
        Packed64BulkOperation12() {
        }

        @Override
        public int blocks() {
            return 3;
        }

        @Override
        public int values() {
            return 16;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 52;
                values[vi++] = block0 >>> 40 & 0xFFFL;
                values[vi++] = block0 >>> 28 & 0xFFFL;
                values[vi++] = block0 >>> 16 & 0xFFFL;
                values[vi++] = block0 >>> 4 & 0xFFFL;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0xFL) << 8 | block1 >>> 56;
                values[vi++] = block1 >>> 44 & 0xFFFL;
                values[vi++] = block1 >>> 32 & 0xFFFL;
                values[vi++] = block1 >>> 20 & 0xFFFL;
                values[vi++] = block1 >>> 8 & 0xFFFL;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0xFFL) << 4 | block2 >>> 60;
                values[vi++] = block2 >>> 48 & 0xFFFL;
                values[vi++] = block2 >>> 36 & 0xFFFL;
                values[vi++] = block2 >>> 24 & 0xFFFL;
                values[vi++] = block2 >>> 12 & 0xFFFL;
                values[vi++] = block2 & 0xFFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 52 | values[vi++] << 40 | values[vi++] << 28 | values[vi++] << 16 | values[vi++] << 4 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 44 | values[vi++] << 32 | values[vi++] << 20 | values[vi++] << 8 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 48 | values[vi++] << 36 | values[vi++] << 24 | values[vi++] << 12 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation11
    extends BulkOperation {
        Packed64BulkOperation11() {
        }

        @Override
        public int blocks() {
            return 11;
        }

        @Override
        public int values() {
            return 64;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 53;
                values[vi++] = block0 >>> 42 & 0x7FFL;
                values[vi++] = block0 >>> 31 & 0x7FFL;
                values[vi++] = block0 >>> 20 & 0x7FFL;
                values[vi++] = block0 >>> 9 & 0x7FFL;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0x1FFL) << 2 | block1 >>> 62;
                values[vi++] = block1 >>> 51 & 0x7FFL;
                values[vi++] = block1 >>> 40 & 0x7FFL;
                values[vi++] = block1 >>> 29 & 0x7FFL;
                values[vi++] = block1 >>> 18 & 0x7FFL;
                values[vi++] = block1 >>> 7 & 0x7FFL;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0x7FL) << 4 | block2 >>> 60;
                values[vi++] = block2 >>> 49 & 0x7FFL;
                values[vi++] = block2 >>> 38 & 0x7FFL;
                values[vi++] = block2 >>> 27 & 0x7FFL;
                values[vi++] = block2 >>> 16 & 0x7FFL;
                values[vi++] = block2 >>> 5 & 0x7FFL;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 0x1FL) << 6 | block3 >>> 58;
                values[vi++] = block3 >>> 47 & 0x7FFL;
                values[vi++] = block3 >>> 36 & 0x7FFL;
                values[vi++] = block3 >>> 25 & 0x7FFL;
                values[vi++] = block3 >>> 14 & 0x7FFL;
                values[vi++] = block3 >>> 3 & 0x7FFL;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 7L) << 8 | block4 >>> 56;
                values[vi++] = block4 >>> 45 & 0x7FFL;
                values[vi++] = block4 >>> 34 & 0x7FFL;
                values[vi++] = block4 >>> 23 & 0x7FFL;
                values[vi++] = block4 >>> 12 & 0x7FFL;
                values[vi++] = block4 >>> 1 & 0x7FFL;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 1L) << 10 | block5 >>> 54;
                values[vi++] = block5 >>> 43 & 0x7FFL;
                values[vi++] = block5 >>> 32 & 0x7FFL;
                values[vi++] = block5 >>> 21 & 0x7FFL;
                values[vi++] = block5 >>> 10 & 0x7FFL;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0x3FFL) << 1 | block6 >>> 63;
                values[vi++] = block6 >>> 52 & 0x7FFL;
                values[vi++] = block6 >>> 41 & 0x7FFL;
                values[vi++] = block6 >>> 30 & 0x7FFL;
                values[vi++] = block6 >>> 19 & 0x7FFL;
                values[vi++] = block6 >>> 8 & 0x7FFL;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0xFFL) << 3 | block7 >>> 61;
                values[vi++] = block7 >>> 50 & 0x7FFL;
                values[vi++] = block7 >>> 39 & 0x7FFL;
                values[vi++] = block7 >>> 28 & 0x7FFL;
                values[vi++] = block7 >>> 17 & 0x7FFL;
                values[vi++] = block7 >>> 6 & 0x7FFL;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0x3FL) << 5 | block8 >>> 59;
                values[vi++] = block8 >>> 48 & 0x7FFL;
                values[vi++] = block8 >>> 37 & 0x7FFL;
                values[vi++] = block8 >>> 26 & 0x7FFL;
                values[vi++] = block8 >>> 15 & 0x7FFL;
                values[vi++] = block8 >>> 4 & 0x7FFL;
                long block9 = blocks[bi++];
                values[vi++] = (block8 & 0xFL) << 7 | block9 >>> 57;
                values[vi++] = block9 >>> 46 & 0x7FFL;
                values[vi++] = block9 >>> 35 & 0x7FFL;
                values[vi++] = block9 >>> 24 & 0x7FFL;
                values[vi++] = block9 >>> 13 & 0x7FFL;
                values[vi++] = block9 >>> 2 & 0x7FFL;
                long block10 = blocks[bi++];
                values[vi++] = (block9 & 3L) << 9 | block10 >>> 55;
                values[vi++] = block10 >>> 44 & 0x7FFL;
                values[vi++] = block10 >>> 33 & 0x7FFL;
                values[vi++] = block10 >>> 22 & 0x7FFL;
                values[vi++] = block10 >>> 11 & 0x7FFL;
                values[vi++] = block10 & 0x7FFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 53 | values[vi++] << 42 | values[vi++] << 31 | values[vi++] << 20 | values[vi++] << 9 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 51 | values[vi++] << 40 | values[vi++] << 29 | values[vi++] << 18 | values[vi++] << 7 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 49 | values[vi++] << 38 | values[vi++] << 27 | values[vi++] << 16 | values[vi++] << 5 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 47 | values[vi++] << 36 | values[vi++] << 25 | values[vi++] << 14 | values[vi++] << 3 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 45 | values[vi++] << 34 | values[vi++] << 23 | values[vi++] << 12 | values[vi++] << 1 | values[vi] >>> 10;
                blocks[bi++] = values[vi++] << 54 | values[vi++] << 43 | values[vi++] << 32 | values[vi++] << 21 | values[vi++] << 10 | values[vi] >>> 1;
                blocks[bi++] = values[vi++] << 63 | values[vi++] << 52 | values[vi++] << 41 | values[vi++] << 30 | values[vi++] << 19 | values[vi++] << 8 | values[vi] >>> 3;
                blocks[bi++] = values[vi++] << 61 | values[vi++] << 50 | values[vi++] << 39 | values[vi++] << 28 | values[vi++] << 17 | values[vi++] << 6 | values[vi] >>> 5;
                blocks[bi++] = values[vi++] << 59 | values[vi++] << 48 | values[vi++] << 37 | values[vi++] << 26 | values[vi++] << 15 | values[vi++] << 4 | values[vi] >>> 7;
                blocks[bi++] = values[vi++] << 57 | values[vi++] << 46 | values[vi++] << 35 | values[vi++] << 24 | values[vi++] << 13 | values[vi++] << 2 | values[vi] >>> 9;
                blocks[bi++] = values[vi++] << 55 | values[vi++] << 44 | values[vi++] << 33 | values[vi++] << 22 | values[vi++] << 11 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation10
    extends BulkOperation {
        Packed64BulkOperation10() {
        }

        @Override
        public int blocks() {
            return 5;
        }

        @Override
        public int values() {
            return 32;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 54;
                values[vi++] = block0 >>> 44 & 0x3FFL;
                values[vi++] = block0 >>> 34 & 0x3FFL;
                values[vi++] = block0 >>> 24 & 0x3FFL;
                values[vi++] = block0 >>> 14 & 0x3FFL;
                values[vi++] = block0 >>> 4 & 0x3FFL;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0xFL) << 6 | block1 >>> 58;
                values[vi++] = block1 >>> 48 & 0x3FFL;
                values[vi++] = block1 >>> 38 & 0x3FFL;
                values[vi++] = block1 >>> 28 & 0x3FFL;
                values[vi++] = block1 >>> 18 & 0x3FFL;
                values[vi++] = block1 >>> 8 & 0x3FFL;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 0xFFL) << 2 | block2 >>> 62;
                values[vi++] = block2 >>> 52 & 0x3FFL;
                values[vi++] = block2 >>> 42 & 0x3FFL;
                values[vi++] = block2 >>> 32 & 0x3FFL;
                values[vi++] = block2 >>> 22 & 0x3FFL;
                values[vi++] = block2 >>> 12 & 0x3FFL;
                values[vi++] = block2 >>> 2 & 0x3FFL;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 3L) << 8 | block3 >>> 56;
                values[vi++] = block3 >>> 46 & 0x3FFL;
                values[vi++] = block3 >>> 36 & 0x3FFL;
                values[vi++] = block3 >>> 26 & 0x3FFL;
                values[vi++] = block3 >>> 16 & 0x3FFL;
                values[vi++] = block3 >>> 6 & 0x3FFL;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0x3FL) << 4 | block4 >>> 60;
                values[vi++] = block4 >>> 50 & 0x3FFL;
                values[vi++] = block4 >>> 40 & 0x3FFL;
                values[vi++] = block4 >>> 30 & 0x3FFL;
                values[vi++] = block4 >>> 20 & 0x3FFL;
                values[vi++] = block4 >>> 10 & 0x3FFL;
                values[vi++] = block4 & 0x3FFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 54 | values[vi++] << 44 | values[vi++] << 34 | values[vi++] << 24 | values[vi++] << 14 | values[vi++] << 4 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 48 | values[vi++] << 38 | values[vi++] << 28 | values[vi++] << 18 | values[vi++] << 8 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 52 | values[vi++] << 42 | values[vi++] << 32 | values[vi++] << 22 | values[vi++] << 12 | values[vi++] << 2 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 46 | values[vi++] << 36 | values[vi++] << 26 | values[vi++] << 16 | values[vi++] << 6 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 50 | values[vi++] << 40 | values[vi++] << 30 | values[vi++] << 20 | values[vi++] << 10 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation9
    extends BulkOperation {
        Packed64BulkOperation9() {
        }

        @Override
        public int blocks() {
            return 9;
        }

        @Override
        public int values() {
            return 64;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 55;
                values[vi++] = block0 >>> 46 & 0x1FFL;
                values[vi++] = block0 >>> 37 & 0x1FFL;
                values[vi++] = block0 >>> 28 & 0x1FFL;
                values[vi++] = block0 >>> 19 & 0x1FFL;
                values[vi++] = block0 >>> 10 & 0x1FFL;
                values[vi++] = block0 >>> 1 & 0x1FFL;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 1L) << 8 | block1 >>> 56;
                values[vi++] = block1 >>> 47 & 0x1FFL;
                values[vi++] = block1 >>> 38 & 0x1FFL;
                values[vi++] = block1 >>> 29 & 0x1FFL;
                values[vi++] = block1 >>> 20 & 0x1FFL;
                values[vi++] = block1 >>> 11 & 0x1FFL;
                values[vi++] = block1 >>> 2 & 0x1FFL;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 3L) << 7 | block2 >>> 57;
                values[vi++] = block2 >>> 48 & 0x1FFL;
                values[vi++] = block2 >>> 39 & 0x1FFL;
                values[vi++] = block2 >>> 30 & 0x1FFL;
                values[vi++] = block2 >>> 21 & 0x1FFL;
                values[vi++] = block2 >>> 12 & 0x1FFL;
                values[vi++] = block2 >>> 3 & 0x1FFL;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 7L) << 6 | block3 >>> 58;
                values[vi++] = block3 >>> 49 & 0x1FFL;
                values[vi++] = block3 >>> 40 & 0x1FFL;
                values[vi++] = block3 >>> 31 & 0x1FFL;
                values[vi++] = block3 >>> 22 & 0x1FFL;
                values[vi++] = block3 >>> 13 & 0x1FFL;
                values[vi++] = block3 >>> 4 & 0x1FFL;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0xFL) << 5 | block4 >>> 59;
                values[vi++] = block4 >>> 50 & 0x1FFL;
                values[vi++] = block4 >>> 41 & 0x1FFL;
                values[vi++] = block4 >>> 32 & 0x1FFL;
                values[vi++] = block4 >>> 23 & 0x1FFL;
                values[vi++] = block4 >>> 14 & 0x1FFL;
                values[vi++] = block4 >>> 5 & 0x1FFL;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0x1FL) << 4 | block5 >>> 60;
                values[vi++] = block5 >>> 51 & 0x1FFL;
                values[vi++] = block5 >>> 42 & 0x1FFL;
                values[vi++] = block5 >>> 33 & 0x1FFL;
                values[vi++] = block5 >>> 24 & 0x1FFL;
                values[vi++] = block5 >>> 15 & 0x1FFL;
                values[vi++] = block5 >>> 6 & 0x1FFL;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0x3FL) << 3 | block6 >>> 61;
                values[vi++] = block6 >>> 52 & 0x1FFL;
                values[vi++] = block6 >>> 43 & 0x1FFL;
                values[vi++] = block6 >>> 34 & 0x1FFL;
                values[vi++] = block6 >>> 25 & 0x1FFL;
                values[vi++] = block6 >>> 16 & 0x1FFL;
                values[vi++] = block6 >>> 7 & 0x1FFL;
                long block7 = blocks[bi++];
                values[vi++] = (block6 & 0x7FL) << 2 | block7 >>> 62;
                values[vi++] = block7 >>> 53 & 0x1FFL;
                values[vi++] = block7 >>> 44 & 0x1FFL;
                values[vi++] = block7 >>> 35 & 0x1FFL;
                values[vi++] = block7 >>> 26 & 0x1FFL;
                values[vi++] = block7 >>> 17 & 0x1FFL;
                values[vi++] = block7 >>> 8 & 0x1FFL;
                long block8 = blocks[bi++];
                values[vi++] = (block7 & 0xFFL) << 1 | block8 >>> 63;
                values[vi++] = block8 >>> 54 & 0x1FFL;
                values[vi++] = block8 >>> 45 & 0x1FFL;
                values[vi++] = block8 >>> 36 & 0x1FFL;
                values[vi++] = block8 >>> 27 & 0x1FFL;
                values[vi++] = block8 >>> 18 & 0x1FFL;
                values[vi++] = block8 >>> 9 & 0x1FFL;
                values[vi++] = block8 & 0x1FFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 55 | values[vi++] << 46 | values[vi++] << 37 | values[vi++] << 28 | values[vi++] << 19 | values[vi++] << 10 | values[vi++] << 1 | values[vi] >>> 8;
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 47 | values[vi++] << 38 | values[vi++] << 29 | values[vi++] << 20 | values[vi++] << 11 | values[vi++] << 2 | values[vi] >>> 7;
                blocks[bi++] = values[vi++] << 57 | values[vi++] << 48 | values[vi++] << 39 | values[vi++] << 30 | values[vi++] << 21 | values[vi++] << 12 | values[vi++] << 3 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 49 | values[vi++] << 40 | values[vi++] << 31 | values[vi++] << 22 | values[vi++] << 13 | values[vi++] << 4 | values[vi] >>> 5;
                blocks[bi++] = values[vi++] << 59 | values[vi++] << 50 | values[vi++] << 41 | values[vi++] << 32 | values[vi++] << 23 | values[vi++] << 14 | values[vi++] << 5 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 51 | values[vi++] << 42 | values[vi++] << 33 | values[vi++] << 24 | values[vi++] << 15 | values[vi++] << 6 | values[vi] >>> 3;
                blocks[bi++] = values[vi++] << 61 | values[vi++] << 52 | values[vi++] << 43 | values[vi++] << 34 | values[vi++] << 25 | values[vi++] << 16 | values[vi++] << 7 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 53 | values[vi++] << 44 | values[vi++] << 35 | values[vi++] << 26 | values[vi++] << 17 | values[vi++] << 8 | values[vi] >>> 1;
                blocks[bi++] = values[vi++] << 63 | values[vi++] << 54 | values[vi++] << 45 | values[vi++] << 36 | values[vi++] << 27 | values[vi++] << 18 | values[vi++] << 9 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation8
    extends BulkOperation {
        Packed64BulkOperation8() {
        }

        @Override
        public int blocks() {
            return 1;
        }

        @Override
        public int values() {
            return 8;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 56;
                values[vi++] = block0 >>> 48 & 0xFFL;
                values[vi++] = block0 >>> 40 & 0xFFL;
                values[vi++] = block0 >>> 32 & 0xFFL;
                values[vi++] = block0 >>> 24 & 0xFFL;
                values[vi++] = block0 >>> 16 & 0xFFL;
                values[vi++] = block0 >>> 8 & 0xFFL;
                values[vi++] = block0 & 0xFFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 56 | values[vi++] << 48 | values[vi++] << 40 | values[vi++] << 32 | values[vi++] << 24 | values[vi++] << 16 | values[vi++] << 8 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation7
    extends BulkOperation {
        Packed64BulkOperation7() {
        }

        @Override
        public int blocks() {
            return 7;
        }

        @Override
        public int values() {
            return 64;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 57;
                values[vi++] = block0 >>> 50 & 0x7FL;
                values[vi++] = block0 >>> 43 & 0x7FL;
                values[vi++] = block0 >>> 36 & 0x7FL;
                values[vi++] = block0 >>> 29 & 0x7FL;
                values[vi++] = block0 >>> 22 & 0x7FL;
                values[vi++] = block0 >>> 15 & 0x7FL;
                values[vi++] = block0 >>> 8 & 0x7FL;
                values[vi++] = block0 >>> 1 & 0x7FL;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 1L) << 6 | block1 >>> 58;
                values[vi++] = block1 >>> 51 & 0x7FL;
                values[vi++] = block1 >>> 44 & 0x7FL;
                values[vi++] = block1 >>> 37 & 0x7FL;
                values[vi++] = block1 >>> 30 & 0x7FL;
                values[vi++] = block1 >>> 23 & 0x7FL;
                values[vi++] = block1 >>> 16 & 0x7FL;
                values[vi++] = block1 >>> 9 & 0x7FL;
                values[vi++] = block1 >>> 2 & 0x7FL;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 3L) << 5 | block2 >>> 59;
                values[vi++] = block2 >>> 52 & 0x7FL;
                values[vi++] = block2 >>> 45 & 0x7FL;
                values[vi++] = block2 >>> 38 & 0x7FL;
                values[vi++] = block2 >>> 31 & 0x7FL;
                values[vi++] = block2 >>> 24 & 0x7FL;
                values[vi++] = block2 >>> 17 & 0x7FL;
                values[vi++] = block2 >>> 10 & 0x7FL;
                values[vi++] = block2 >>> 3 & 0x7FL;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 7L) << 4 | block3 >>> 60;
                values[vi++] = block3 >>> 53 & 0x7FL;
                values[vi++] = block3 >>> 46 & 0x7FL;
                values[vi++] = block3 >>> 39 & 0x7FL;
                values[vi++] = block3 >>> 32 & 0x7FL;
                values[vi++] = block3 >>> 25 & 0x7FL;
                values[vi++] = block3 >>> 18 & 0x7FL;
                values[vi++] = block3 >>> 11 & 0x7FL;
                values[vi++] = block3 >>> 4 & 0x7FL;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 0xFL) << 3 | block4 >>> 61;
                values[vi++] = block4 >>> 54 & 0x7FL;
                values[vi++] = block4 >>> 47 & 0x7FL;
                values[vi++] = block4 >>> 40 & 0x7FL;
                values[vi++] = block4 >>> 33 & 0x7FL;
                values[vi++] = block4 >>> 26 & 0x7FL;
                values[vi++] = block4 >>> 19 & 0x7FL;
                values[vi++] = block4 >>> 12 & 0x7FL;
                values[vi++] = block4 >>> 5 & 0x7FL;
                long block5 = blocks[bi++];
                values[vi++] = (block4 & 0x1FL) << 2 | block5 >>> 62;
                values[vi++] = block5 >>> 55 & 0x7FL;
                values[vi++] = block5 >>> 48 & 0x7FL;
                values[vi++] = block5 >>> 41 & 0x7FL;
                values[vi++] = block5 >>> 34 & 0x7FL;
                values[vi++] = block5 >>> 27 & 0x7FL;
                values[vi++] = block5 >>> 20 & 0x7FL;
                values[vi++] = block5 >>> 13 & 0x7FL;
                values[vi++] = block5 >>> 6 & 0x7FL;
                long block6 = blocks[bi++];
                values[vi++] = (block5 & 0x3FL) << 1 | block6 >>> 63;
                values[vi++] = block6 >>> 56 & 0x7FL;
                values[vi++] = block6 >>> 49 & 0x7FL;
                values[vi++] = block6 >>> 42 & 0x7FL;
                values[vi++] = block6 >>> 35 & 0x7FL;
                values[vi++] = block6 >>> 28 & 0x7FL;
                values[vi++] = block6 >>> 21 & 0x7FL;
                values[vi++] = block6 >>> 14 & 0x7FL;
                values[vi++] = block6 >>> 7 & 0x7FL;
                values[vi++] = block6 & 0x7FL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 57 | values[vi++] << 50 | values[vi++] << 43 | values[vi++] << 36 | values[vi++] << 29 | values[vi++] << 22 | values[vi++] << 15 | values[vi++] << 8 | values[vi++] << 1 | values[vi] >>> 6;
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 51 | values[vi++] << 44 | values[vi++] << 37 | values[vi++] << 30 | values[vi++] << 23 | values[vi++] << 16 | values[vi++] << 9 | values[vi++] << 2 | values[vi] >>> 5;
                blocks[bi++] = values[vi++] << 59 | values[vi++] << 52 | values[vi++] << 45 | values[vi++] << 38 | values[vi++] << 31 | values[vi++] << 24 | values[vi++] << 17 | values[vi++] << 10 | values[vi++] << 3 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 53 | values[vi++] << 46 | values[vi++] << 39 | values[vi++] << 32 | values[vi++] << 25 | values[vi++] << 18 | values[vi++] << 11 | values[vi++] << 4 | values[vi] >>> 3;
                blocks[bi++] = values[vi++] << 61 | values[vi++] << 54 | values[vi++] << 47 | values[vi++] << 40 | values[vi++] << 33 | values[vi++] << 26 | values[vi++] << 19 | values[vi++] << 12 | values[vi++] << 5 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 55 | values[vi++] << 48 | values[vi++] << 41 | values[vi++] << 34 | values[vi++] << 27 | values[vi++] << 20 | values[vi++] << 13 | values[vi++] << 6 | values[vi] >>> 1;
                blocks[bi++] = values[vi++] << 63 | values[vi++] << 56 | values[vi++] << 49 | values[vi++] << 42 | values[vi++] << 35 | values[vi++] << 28 | values[vi++] << 21 | values[vi++] << 14 | values[vi++] << 7 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation6
    extends BulkOperation {
        Packed64BulkOperation6() {
        }

        @Override
        public int blocks() {
            return 3;
        }

        @Override
        public int values() {
            return 32;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 58;
                values[vi++] = block0 >>> 52 & 0x3FL;
                values[vi++] = block0 >>> 46 & 0x3FL;
                values[vi++] = block0 >>> 40 & 0x3FL;
                values[vi++] = block0 >>> 34 & 0x3FL;
                values[vi++] = block0 >>> 28 & 0x3FL;
                values[vi++] = block0 >>> 22 & 0x3FL;
                values[vi++] = block0 >>> 16 & 0x3FL;
                values[vi++] = block0 >>> 10 & 0x3FL;
                values[vi++] = block0 >>> 4 & 0x3FL;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0xFL) << 2 | block1 >>> 62;
                values[vi++] = block1 >>> 56 & 0x3FL;
                values[vi++] = block1 >>> 50 & 0x3FL;
                values[vi++] = block1 >>> 44 & 0x3FL;
                values[vi++] = block1 >>> 38 & 0x3FL;
                values[vi++] = block1 >>> 32 & 0x3FL;
                values[vi++] = block1 >>> 26 & 0x3FL;
                values[vi++] = block1 >>> 20 & 0x3FL;
                values[vi++] = block1 >>> 14 & 0x3FL;
                values[vi++] = block1 >>> 8 & 0x3FL;
                values[vi++] = block1 >>> 2 & 0x3FL;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 3L) << 4 | block2 >>> 60;
                values[vi++] = block2 >>> 54 & 0x3FL;
                values[vi++] = block2 >>> 48 & 0x3FL;
                values[vi++] = block2 >>> 42 & 0x3FL;
                values[vi++] = block2 >>> 36 & 0x3FL;
                values[vi++] = block2 >>> 30 & 0x3FL;
                values[vi++] = block2 >>> 24 & 0x3FL;
                values[vi++] = block2 >>> 18 & 0x3FL;
                values[vi++] = block2 >>> 12 & 0x3FL;
                values[vi++] = block2 >>> 6 & 0x3FL;
                values[vi++] = block2 & 0x3FL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 58 | values[vi++] << 52 | values[vi++] << 46 | values[vi++] << 40 | values[vi++] << 34 | values[vi++] << 28 | values[vi++] << 22 | values[vi++] << 16 | values[vi++] << 10 | values[vi++] << 4 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 56 | values[vi++] << 50 | values[vi++] << 44 | values[vi++] << 38 | values[vi++] << 32 | values[vi++] << 26 | values[vi++] << 20 | values[vi++] << 14 | values[vi++] << 8 | values[vi++] << 2 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 54 | values[vi++] << 48 | values[vi++] << 42 | values[vi++] << 36 | values[vi++] << 30 | values[vi++] << 24 | values[vi++] << 18 | values[vi++] << 12 | values[vi++] << 6 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation5
    extends BulkOperation {
        Packed64BulkOperation5() {
        }

        @Override
        public int blocks() {
            return 5;
        }

        @Override
        public int values() {
            return 64;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 59;
                values[vi++] = block0 >>> 54 & 0x1FL;
                values[vi++] = block0 >>> 49 & 0x1FL;
                values[vi++] = block0 >>> 44 & 0x1FL;
                values[vi++] = block0 >>> 39 & 0x1FL;
                values[vi++] = block0 >>> 34 & 0x1FL;
                values[vi++] = block0 >>> 29 & 0x1FL;
                values[vi++] = block0 >>> 24 & 0x1FL;
                values[vi++] = block0 >>> 19 & 0x1FL;
                values[vi++] = block0 >>> 14 & 0x1FL;
                values[vi++] = block0 >>> 9 & 0x1FL;
                values[vi++] = block0 >>> 4 & 0x1FL;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 0xFL) << 1 | block1 >>> 63;
                values[vi++] = block1 >>> 58 & 0x1FL;
                values[vi++] = block1 >>> 53 & 0x1FL;
                values[vi++] = block1 >>> 48 & 0x1FL;
                values[vi++] = block1 >>> 43 & 0x1FL;
                values[vi++] = block1 >>> 38 & 0x1FL;
                values[vi++] = block1 >>> 33 & 0x1FL;
                values[vi++] = block1 >>> 28 & 0x1FL;
                values[vi++] = block1 >>> 23 & 0x1FL;
                values[vi++] = block1 >>> 18 & 0x1FL;
                values[vi++] = block1 >>> 13 & 0x1FL;
                values[vi++] = block1 >>> 8 & 0x1FL;
                values[vi++] = block1 >>> 3 & 0x1FL;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 7L) << 2 | block2 >>> 62;
                values[vi++] = block2 >>> 57 & 0x1FL;
                values[vi++] = block2 >>> 52 & 0x1FL;
                values[vi++] = block2 >>> 47 & 0x1FL;
                values[vi++] = block2 >>> 42 & 0x1FL;
                values[vi++] = block2 >>> 37 & 0x1FL;
                values[vi++] = block2 >>> 32 & 0x1FL;
                values[vi++] = block2 >>> 27 & 0x1FL;
                values[vi++] = block2 >>> 22 & 0x1FL;
                values[vi++] = block2 >>> 17 & 0x1FL;
                values[vi++] = block2 >>> 12 & 0x1FL;
                values[vi++] = block2 >>> 7 & 0x1FL;
                values[vi++] = block2 >>> 2 & 0x1FL;
                long block3 = blocks[bi++];
                values[vi++] = (block2 & 3L) << 3 | block3 >>> 61;
                values[vi++] = block3 >>> 56 & 0x1FL;
                values[vi++] = block3 >>> 51 & 0x1FL;
                values[vi++] = block3 >>> 46 & 0x1FL;
                values[vi++] = block3 >>> 41 & 0x1FL;
                values[vi++] = block3 >>> 36 & 0x1FL;
                values[vi++] = block3 >>> 31 & 0x1FL;
                values[vi++] = block3 >>> 26 & 0x1FL;
                values[vi++] = block3 >>> 21 & 0x1FL;
                values[vi++] = block3 >>> 16 & 0x1FL;
                values[vi++] = block3 >>> 11 & 0x1FL;
                values[vi++] = block3 >>> 6 & 0x1FL;
                values[vi++] = block3 >>> 1 & 0x1FL;
                long block4 = blocks[bi++];
                values[vi++] = (block3 & 1L) << 4 | block4 >>> 60;
                values[vi++] = block4 >>> 55 & 0x1FL;
                values[vi++] = block4 >>> 50 & 0x1FL;
                values[vi++] = block4 >>> 45 & 0x1FL;
                values[vi++] = block4 >>> 40 & 0x1FL;
                values[vi++] = block4 >>> 35 & 0x1FL;
                values[vi++] = block4 >>> 30 & 0x1FL;
                values[vi++] = block4 >>> 25 & 0x1FL;
                values[vi++] = block4 >>> 20 & 0x1FL;
                values[vi++] = block4 >>> 15 & 0x1FL;
                values[vi++] = block4 >>> 10 & 0x1FL;
                values[vi++] = block4 >>> 5 & 0x1FL;
                values[vi++] = block4 & 0x1FL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 59 | values[vi++] << 54 | values[vi++] << 49 | values[vi++] << 44 | values[vi++] << 39 | values[vi++] << 34 | values[vi++] << 29 | values[vi++] << 24 | values[vi++] << 19 | values[vi++] << 14 | values[vi++] << 9 | values[vi++] << 4 | values[vi] >>> 1;
                blocks[bi++] = values[vi++] << 63 | values[vi++] << 58 | values[vi++] << 53 | values[vi++] << 48 | values[vi++] << 43 | values[vi++] << 38 | values[vi++] << 33 | values[vi++] << 28 | values[vi++] << 23 | values[vi++] << 18 | values[vi++] << 13 | values[vi++] << 8 | values[vi++] << 3 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 57 | values[vi++] << 52 | values[vi++] << 47 | values[vi++] << 42 | values[vi++] << 37 | values[vi++] << 32 | values[vi++] << 27 | values[vi++] << 22 | values[vi++] << 17 | values[vi++] << 12 | values[vi++] << 7 | values[vi++] << 2 | values[vi] >>> 3;
                blocks[bi++] = values[vi++] << 61 | values[vi++] << 56 | values[vi++] << 51 | values[vi++] << 46 | values[vi++] << 41 | values[vi++] << 36 | values[vi++] << 31 | values[vi++] << 26 | values[vi++] << 21 | values[vi++] << 16 | values[vi++] << 11 | values[vi++] << 6 | values[vi++] << 1 | values[vi] >>> 4;
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 55 | values[vi++] << 50 | values[vi++] << 45 | values[vi++] << 40 | values[vi++] << 35 | values[vi++] << 30 | values[vi++] << 25 | values[vi++] << 20 | values[vi++] << 15 | values[vi++] << 10 | values[vi++] << 5 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation4
    extends BulkOperation {
        Packed64BulkOperation4() {
        }

        @Override
        public int blocks() {
            return 1;
        }

        @Override
        public int values() {
            return 16;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 60;
                values[vi++] = block0 >>> 56 & 0xFL;
                values[vi++] = block0 >>> 52 & 0xFL;
                values[vi++] = block0 >>> 48 & 0xFL;
                values[vi++] = block0 >>> 44 & 0xFL;
                values[vi++] = block0 >>> 40 & 0xFL;
                values[vi++] = block0 >>> 36 & 0xFL;
                values[vi++] = block0 >>> 32 & 0xFL;
                values[vi++] = block0 >>> 28 & 0xFL;
                values[vi++] = block0 >>> 24 & 0xFL;
                values[vi++] = block0 >>> 20 & 0xFL;
                values[vi++] = block0 >>> 16 & 0xFL;
                values[vi++] = block0 >>> 12 & 0xFL;
                values[vi++] = block0 >>> 8 & 0xFL;
                values[vi++] = block0 >>> 4 & 0xFL;
                values[vi++] = block0 & 0xFL;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 60 | values[vi++] << 56 | values[vi++] << 52 | values[vi++] << 48 | values[vi++] << 44 | values[vi++] << 40 | values[vi++] << 36 | values[vi++] << 32 | values[vi++] << 28 | values[vi++] << 24 | values[vi++] << 20 | values[vi++] << 16 | values[vi++] << 12 | values[vi++] << 8 | values[vi++] << 4 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation3
    extends BulkOperation {
        Packed64BulkOperation3() {
        }

        @Override
        public int blocks() {
            return 3;
        }

        @Override
        public int values() {
            return 64;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 61;
                values[vi++] = block0 >>> 58 & 7L;
                values[vi++] = block0 >>> 55 & 7L;
                values[vi++] = block0 >>> 52 & 7L;
                values[vi++] = block0 >>> 49 & 7L;
                values[vi++] = block0 >>> 46 & 7L;
                values[vi++] = block0 >>> 43 & 7L;
                values[vi++] = block0 >>> 40 & 7L;
                values[vi++] = block0 >>> 37 & 7L;
                values[vi++] = block0 >>> 34 & 7L;
                values[vi++] = block0 >>> 31 & 7L;
                values[vi++] = block0 >>> 28 & 7L;
                values[vi++] = block0 >>> 25 & 7L;
                values[vi++] = block0 >>> 22 & 7L;
                values[vi++] = block0 >>> 19 & 7L;
                values[vi++] = block0 >>> 16 & 7L;
                values[vi++] = block0 >>> 13 & 7L;
                values[vi++] = block0 >>> 10 & 7L;
                values[vi++] = block0 >>> 7 & 7L;
                values[vi++] = block0 >>> 4 & 7L;
                values[vi++] = block0 >>> 1 & 7L;
                long block1 = blocks[bi++];
                values[vi++] = (block0 & 1L) << 2 | block1 >>> 62;
                values[vi++] = block1 >>> 59 & 7L;
                values[vi++] = block1 >>> 56 & 7L;
                values[vi++] = block1 >>> 53 & 7L;
                values[vi++] = block1 >>> 50 & 7L;
                values[vi++] = block1 >>> 47 & 7L;
                values[vi++] = block1 >>> 44 & 7L;
                values[vi++] = block1 >>> 41 & 7L;
                values[vi++] = block1 >>> 38 & 7L;
                values[vi++] = block1 >>> 35 & 7L;
                values[vi++] = block1 >>> 32 & 7L;
                values[vi++] = block1 >>> 29 & 7L;
                values[vi++] = block1 >>> 26 & 7L;
                values[vi++] = block1 >>> 23 & 7L;
                values[vi++] = block1 >>> 20 & 7L;
                values[vi++] = block1 >>> 17 & 7L;
                values[vi++] = block1 >>> 14 & 7L;
                values[vi++] = block1 >>> 11 & 7L;
                values[vi++] = block1 >>> 8 & 7L;
                values[vi++] = block1 >>> 5 & 7L;
                values[vi++] = block1 >>> 2 & 7L;
                long block2 = blocks[bi++];
                values[vi++] = (block1 & 3L) << 1 | block2 >>> 63;
                values[vi++] = block2 >>> 60 & 7L;
                values[vi++] = block2 >>> 57 & 7L;
                values[vi++] = block2 >>> 54 & 7L;
                values[vi++] = block2 >>> 51 & 7L;
                values[vi++] = block2 >>> 48 & 7L;
                values[vi++] = block2 >>> 45 & 7L;
                values[vi++] = block2 >>> 42 & 7L;
                values[vi++] = block2 >>> 39 & 7L;
                values[vi++] = block2 >>> 36 & 7L;
                values[vi++] = block2 >>> 33 & 7L;
                values[vi++] = block2 >>> 30 & 7L;
                values[vi++] = block2 >>> 27 & 7L;
                values[vi++] = block2 >>> 24 & 7L;
                values[vi++] = block2 >>> 21 & 7L;
                values[vi++] = block2 >>> 18 & 7L;
                values[vi++] = block2 >>> 15 & 7L;
                values[vi++] = block2 >>> 12 & 7L;
                values[vi++] = block2 >>> 9 & 7L;
                values[vi++] = block2 >>> 6 & 7L;
                values[vi++] = block2 >>> 3 & 7L;
                values[vi++] = block2 & 7L;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 61 | values[vi++] << 58 | values[vi++] << 55 | values[vi++] << 52 | values[vi++] << 49 | values[vi++] << 46 | values[vi++] << 43 | values[vi++] << 40 | values[vi++] << 37 | values[vi++] << 34 | values[vi++] << 31 | values[vi++] << 28 | values[vi++] << 25 | values[vi++] << 22 | values[vi++] << 19 | values[vi++] << 16 | values[vi++] << 13 | values[vi++] << 10 | values[vi++] << 7 | values[vi++] << 4 | values[vi++] << 1 | values[vi] >>> 2;
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 59 | values[vi++] << 56 | values[vi++] << 53 | values[vi++] << 50 | values[vi++] << 47 | values[vi++] << 44 | values[vi++] << 41 | values[vi++] << 38 | values[vi++] << 35 | values[vi++] << 32 | values[vi++] << 29 | values[vi++] << 26 | values[vi++] << 23 | values[vi++] << 20 | values[vi++] << 17 | values[vi++] << 14 | values[vi++] << 11 | values[vi++] << 8 | values[vi++] << 5 | values[vi++] << 2 | values[vi] >>> 1;
                blocks[bi++] = values[vi++] << 63 | values[vi++] << 60 | values[vi++] << 57 | values[vi++] << 54 | values[vi++] << 51 | values[vi++] << 48 | values[vi++] << 45 | values[vi++] << 42 | values[vi++] << 39 | values[vi++] << 36 | values[vi++] << 33 | values[vi++] << 30 | values[vi++] << 27 | values[vi++] << 24 | values[vi++] << 21 | values[vi++] << 18 | values[vi++] << 15 | values[vi++] << 12 | values[vi++] << 9 | values[vi++] << 6 | values[vi++] << 3 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation2
    extends BulkOperation {
        Packed64BulkOperation2() {
        }

        @Override
        public int blocks() {
            return 1;
        }

        @Override
        public int values() {
            return 32;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 62;
                values[vi++] = block0 >>> 60 & 3L;
                values[vi++] = block0 >>> 58 & 3L;
                values[vi++] = block0 >>> 56 & 3L;
                values[vi++] = block0 >>> 54 & 3L;
                values[vi++] = block0 >>> 52 & 3L;
                values[vi++] = block0 >>> 50 & 3L;
                values[vi++] = block0 >>> 48 & 3L;
                values[vi++] = block0 >>> 46 & 3L;
                values[vi++] = block0 >>> 44 & 3L;
                values[vi++] = block0 >>> 42 & 3L;
                values[vi++] = block0 >>> 40 & 3L;
                values[vi++] = block0 >>> 38 & 3L;
                values[vi++] = block0 >>> 36 & 3L;
                values[vi++] = block0 >>> 34 & 3L;
                values[vi++] = block0 >>> 32 & 3L;
                values[vi++] = block0 >>> 30 & 3L;
                values[vi++] = block0 >>> 28 & 3L;
                values[vi++] = block0 >>> 26 & 3L;
                values[vi++] = block0 >>> 24 & 3L;
                values[vi++] = block0 >>> 22 & 3L;
                values[vi++] = block0 >>> 20 & 3L;
                values[vi++] = block0 >>> 18 & 3L;
                values[vi++] = block0 >>> 16 & 3L;
                values[vi++] = block0 >>> 14 & 3L;
                values[vi++] = block0 >>> 12 & 3L;
                values[vi++] = block0 >>> 10 & 3L;
                values[vi++] = block0 >>> 8 & 3L;
                values[vi++] = block0 >>> 6 & 3L;
                values[vi++] = block0 >>> 4 & 3L;
                values[vi++] = block0 >>> 2 & 3L;
                values[vi++] = block0 & 3L;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 62 | values[vi++] << 60 | values[vi++] << 58 | values[vi++] << 56 | values[vi++] << 54 | values[vi++] << 52 | values[vi++] << 50 | values[vi++] << 48 | values[vi++] << 46 | values[vi++] << 44 | values[vi++] << 42 | values[vi++] << 40 | values[vi++] << 38 | values[vi++] << 36 | values[vi++] << 34 | values[vi++] << 32 | values[vi++] << 30 | values[vi++] << 28 | values[vi++] << 26 | values[vi++] << 24 | values[vi++] << 22 | values[vi++] << 20 | values[vi++] << 18 | values[vi++] << 16 | values[vi++] << 14 | values[vi++] << 12 | values[vi++] << 10 | values[vi++] << 8 | values[vi++] << 6 | values[vi++] << 4 | values[vi++] << 2 | values[vi++];
            }
        }
    }

    static final class Packed64BulkOperation1
    extends BulkOperation {
        Packed64BulkOperation1() {
        }

        @Override
        public int blocks() {
            return 1;
        }

        @Override
        public int values() {
            return 64;
        }

        @Override
        public void get(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                long block0 = blocks[bi++];
                values[vi++] = block0 >>> 63;
                values[vi++] = block0 >>> 62 & 1L;
                values[vi++] = block0 >>> 61 & 1L;
                values[vi++] = block0 >>> 60 & 1L;
                values[vi++] = block0 >>> 59 & 1L;
                values[vi++] = block0 >>> 58 & 1L;
                values[vi++] = block0 >>> 57 & 1L;
                values[vi++] = block0 >>> 56 & 1L;
                values[vi++] = block0 >>> 55 & 1L;
                values[vi++] = block0 >>> 54 & 1L;
                values[vi++] = block0 >>> 53 & 1L;
                values[vi++] = block0 >>> 52 & 1L;
                values[vi++] = block0 >>> 51 & 1L;
                values[vi++] = block0 >>> 50 & 1L;
                values[vi++] = block0 >>> 49 & 1L;
                values[vi++] = block0 >>> 48 & 1L;
                values[vi++] = block0 >>> 47 & 1L;
                values[vi++] = block0 >>> 46 & 1L;
                values[vi++] = block0 >>> 45 & 1L;
                values[vi++] = block0 >>> 44 & 1L;
                values[vi++] = block0 >>> 43 & 1L;
                values[vi++] = block0 >>> 42 & 1L;
                values[vi++] = block0 >>> 41 & 1L;
                values[vi++] = block0 >>> 40 & 1L;
                values[vi++] = block0 >>> 39 & 1L;
                values[vi++] = block0 >>> 38 & 1L;
                values[vi++] = block0 >>> 37 & 1L;
                values[vi++] = block0 >>> 36 & 1L;
                values[vi++] = block0 >>> 35 & 1L;
                values[vi++] = block0 >>> 34 & 1L;
                values[vi++] = block0 >>> 33 & 1L;
                values[vi++] = block0 >>> 32 & 1L;
                values[vi++] = block0 >>> 31 & 1L;
                values[vi++] = block0 >>> 30 & 1L;
                values[vi++] = block0 >>> 29 & 1L;
                values[vi++] = block0 >>> 28 & 1L;
                values[vi++] = block0 >>> 27 & 1L;
                values[vi++] = block0 >>> 26 & 1L;
                values[vi++] = block0 >>> 25 & 1L;
                values[vi++] = block0 >>> 24 & 1L;
                values[vi++] = block0 >>> 23 & 1L;
                values[vi++] = block0 >>> 22 & 1L;
                values[vi++] = block0 >>> 21 & 1L;
                values[vi++] = block0 >>> 20 & 1L;
                values[vi++] = block0 >>> 19 & 1L;
                values[vi++] = block0 >>> 18 & 1L;
                values[vi++] = block0 >>> 17 & 1L;
                values[vi++] = block0 >>> 16 & 1L;
                values[vi++] = block0 >>> 15 & 1L;
                values[vi++] = block0 >>> 14 & 1L;
                values[vi++] = block0 >>> 13 & 1L;
                values[vi++] = block0 >>> 12 & 1L;
                values[vi++] = block0 >>> 11 & 1L;
                values[vi++] = block0 >>> 10 & 1L;
                values[vi++] = block0 >>> 9 & 1L;
                values[vi++] = block0 >>> 8 & 1L;
                values[vi++] = block0 >>> 7 & 1L;
                values[vi++] = block0 >>> 6 & 1L;
                values[vi++] = block0 >>> 5 & 1L;
                values[vi++] = block0 >>> 4 & 1L;
                values[vi++] = block0 >>> 3 & 1L;
                values[vi++] = block0 >>> 2 & 1L;
                values[vi++] = block0 >>> 1 & 1L;
                values[vi++] = block0 & 1L;
            }
        }

        @Override
        public void set(long[] blocks, int bi, long[] values, int vi, int iterations) {
            assert (bi + iterations * this.blocks() <= blocks.length);
            assert (vi + iterations * this.values() <= values.length);
            for (int i = 0; i < iterations; ++i) {
                blocks[bi++] = values[vi++] << 63 | values[vi++] << 62 | values[vi++] << 61 | values[vi++] << 60 | values[vi++] << 59 | values[vi++] << 58 | values[vi++] << 57 | values[vi++] << 56 | values[vi++] << 55 | values[vi++] << 54 | values[vi++] << 53 | values[vi++] << 52 | values[vi++] << 51 | values[vi++] << 50 | values[vi++] << 49 | values[vi++] << 48 | values[vi++] << 47 | values[vi++] << 46 | values[vi++] << 45 | values[vi++] << 44 | values[vi++] << 43 | values[vi++] << 42 | values[vi++] << 41 | values[vi++] << 40 | values[vi++] << 39 | values[vi++] << 38 | values[vi++] << 37 | values[vi++] << 36 | values[vi++] << 35 | values[vi++] << 34 | values[vi++] << 33 | values[vi++] << 32 | values[vi++] << 31 | values[vi++] << 30 | values[vi++] << 29 | values[vi++] << 28 | values[vi++] << 27 | values[vi++] << 26 | values[vi++] << 25 | values[vi++] << 24 | values[vi++] << 23 | values[vi++] << 22 | values[vi++] << 21 | values[vi++] << 20 | values[vi++] << 19 | values[vi++] << 18 | values[vi++] << 17 | values[vi++] << 16 | values[vi++] << 15 | values[vi++] << 14 | values[vi++] << 13 | values[vi++] << 12 | values[vi++] << 11 | values[vi++] << 10 | values[vi++] << 9 | values[vi++] << 8 | values[vi++] << 7 | values[vi++] << 6 | values[vi++] << 5 | values[vi++] << 4 | values[vi++] << 3 | values[vi++] << 2 | values[vi++] << 1 | values[vi++];
            }
        }
    }
}

