/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.hash;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.hash.HashFunction;

public class MurmurHash2
extends HashFunction {
    public static final String HASH_NAME = "MurmurHash2";

    public MurmurHash2() {
        super(HASH_NAME);
    }

    public static int hash(byte[] data, int seed, int offset, int len) {
        int m = 1540483477;
        int r = 24;
        int h = seed ^ len;
        int len_4 = len >> 2;
        for (int i = 0; i < len_4; ++i) {
            int i_4 = offset + (i << 2);
            int k = data[i_4 + 3];
            k <<= 8;
            k |= data[i_4 + 2] & 0xFF;
            k <<= 8;
            k |= data[i_4 + 1] & 0xFF;
            k <<= 8;
            k |= data[i_4 + 0] & 0xFF;
            k *= m;
            k ^= k >>> r;
            h *= m;
            h ^= (k *= m);
        }
        int len_m = len_4 << 2;
        int left = len - len_m;
        if (left != 0) {
            if (left >= 3) {
                h ^= data[offset + len - 3] << 16;
            }
            if (left >= 2) {
                h ^= data[offset + len - 2] << 8;
            }
            if (left >= 1) {
                h ^= data[offset + len - 1];
            }
            h *= m;
        }
        h ^= h >>> 13;
        h *= m;
        h ^= h >>> 15;
        return h;
    }

    public static final int hash32(byte[] data, int offset, int len) {
        return MurmurHash2.hash(data, -1756908916, offset, len);
    }

    @Override
    public final int hash(BytesRef br) {
        return MurmurHash2.hash32(br.bytes, br.offset, br.length);
    }
}

