/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.lucene.store.BufferedIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;

public class SimpleFSDirectory
extends FSDirectory {
    public SimpleFSDirectory(File path, LockFactory lockFactory) throws IOException {
        super(path, lockFactory);
    }

    public SimpleFSDirectory(File path) throws IOException {
        super(path, null);
    }

    @Override
    public IndexInput openInput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        File path = new File(this.directory, name);
        return new SimpleFSIndexInput("SimpleFSIndexInput(path=\"" + path.getPath() + "\")", path, context, this.getReadChunkSize());
    }

    @Override
    public Directory.IndexInputSlicer createSlicer(String name, final IOContext context) throws IOException {
        this.ensureOpen();
        final File file = new File(this.getDirectory(), name);
        final SimpleFSIndexInput.Descriptor descriptor = new SimpleFSIndexInput.Descriptor(file, "r");
        return new Directory.IndexInputSlicer(){

            @Override
            public void close() throws IOException {
                descriptor.close();
            }

            @Override
            public IndexInput openSlice(String sliceDescription, long offset, long length) {
                return new SimpleFSIndexInput("SimpleFSIndexInput(" + sliceDescription + " in path=\"" + file.getPath() + "\" slice=" + offset + ":" + (offset + length) + ")", descriptor, offset, length, BufferedIndexInput.bufferSize(context), SimpleFSDirectory.this.getReadChunkSize());
            }

            @Override
            public IndexInput openFullSlice() {
                return this.openSlice("full-slice", 0L, descriptor.length);
            }
        };
    }

    protected static class SimpleFSIndexInput
    extends BufferedIndexInput {
        protected final Descriptor file;
        boolean isClone;
        protected final int chunkSize;
        protected final long off;
        protected final long end;

        public SimpleFSIndexInput(String resourceDesc, File path, IOContext context, int chunkSize) throws IOException {
            super(resourceDesc, context);
            this.file = new Descriptor(path, "r");
            this.chunkSize = chunkSize;
            this.off = 0L;
            this.end = this.file.length;
        }

        public SimpleFSIndexInput(String resourceDesc, Descriptor file, long off, long length, int bufferSize, int chunkSize) {
            super(resourceDesc, bufferSize);
            this.file = file;
            this.chunkSize = chunkSize;
            this.off = off;
            this.end = off + length;
            this.isClone = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void readInternal(byte[] b, int offset, int len) throws IOException {
            Descriptor descriptor = this.file;
            synchronized (descriptor) {
                long position = this.off + this.getFilePointer();
                if (position != this.file.position) {
                    this.file.seek(position);
                    this.file.position = position;
                }
                int total = 0;
                if (position + (long)len > this.end) {
                    throw new EOFException("read past EOF: " + this);
                }
                try {
                    int i;
                    do {
                        int readLength = total + this.chunkSize > len ? len - total : this.chunkSize;
                        i = this.file.read(b, offset + total, readLength);
                        this.file.position += (long)i;
                    } while ((total += i) < len);
                }
                catch (OutOfMemoryError e) {
                    OutOfMemoryError outOfMemoryError = new OutOfMemoryError("OutOfMemoryError likely caused by the Sun VM Bug described in https://issues.apache.org/jira/browse/LUCENE-1566; try calling FSDirectory.setReadChunkSize with a value smaller than the current chunk size (" + this.chunkSize + ")");
                    outOfMemoryError.initCause(e);
                    throw outOfMemoryError;
                }
                catch (IOException ioe) {
                    throw new IOException(ioe.getMessage() + ": " + this, ioe);
                }
            }
        }

        @Override
        public void close() throws IOException {
            if (!this.isClone) {
                this.file.close();
            }
        }

        @Override
        protected void seekInternal(long position) {
        }

        @Override
        public long length() {
            return this.end - this.off;
        }

        @Override
        public SimpleFSIndexInput clone() {
            SimpleFSIndexInput clone = (SimpleFSIndexInput)super.clone();
            clone.isClone = true;
            return clone;
        }

        boolean isFDValid() throws IOException {
            return this.file.getFD().valid();
        }

        @Override
        public void copyBytes(IndexOutput out, long numBytes) throws IOException {
            numBytes -= (long)this.flushBuffer(out, numBytes);
            out.copyBytes(this, numBytes);
        }

        protected static class Descriptor
        extends RandomAccessFile {
            protected volatile boolean isOpen = true;
            long position;
            final long length = this.length();

            public Descriptor(File file, String mode) throws IOException {
                super(file, mode);
            }

            @Override
            public void close() throws IOException {
                if (this.isOpen) {
                    this.isOpen = false;
                    super.close();
                }
            }
        }
    }
}

