/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ToStringUtils;

public class FilteredQuery
extends Query {
    private final Query query;
    private final Filter filter;

    public FilteredQuery(Query query, Filter filter) {
        if (query == null || filter == null) {
            throw new IllegalArgumentException("Query and filter cannot be null.");
        }
        this.query = query;
        this.filter = filter;
    }

    protected boolean useRandomAccess(Bits bits, int firstFilterDoc) {
        return firstFilterDoc < 100;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher) throws IOException {
        final Weight weight = this.query.createWeight(searcher);
        return new Weight(){

            @Override
            public boolean scoresDocsOutOfOrder() {
                return false;
            }

            @Override
            public float getValueForNormalization() throws IOException {
                return weight.getValueForNormalization() * FilteredQuery.this.getBoost() * FilteredQuery.this.getBoost();
            }

            @Override
            public void normalize(float norm, float topLevelBoost) {
                weight.normalize(norm, topLevelBoost * FilteredQuery.this.getBoost());
            }

            @Override
            public Explanation explain(AtomicReaderContext ir, int i) throws IOException {
                DocIdSetIterator docIdSetIterator;
                Explanation inner = weight.explain(ir, i);
                Filter f = FilteredQuery.this.filter;
                DocIdSet docIdSet = f.getDocIdSet(ir, ir.reader().getLiveDocs());
                DocIdSetIterator docIdSetIterator2 = docIdSetIterator = docIdSet == null ? DocIdSet.EMPTY_DOCIDSET.iterator() : docIdSet.iterator();
                if (docIdSetIterator == null) {
                    docIdSetIterator = DocIdSet.EMPTY_DOCIDSET.iterator();
                }
                if (docIdSetIterator.advance(i) == i) {
                    return inner;
                }
                Explanation result = new Explanation(0.0f, "failure to match filter: " + f.toString());
                result.addDetail(inner);
                return result;
            }

            @Override
            public Query getQuery() {
                return FilteredQuery.this;
            }

            @Override
            public Scorer scorer(AtomicReaderContext context, boolean scoreDocsInOrder, boolean topScorer, Bits acceptDocs) throws IOException {
                boolean useRandomAccess;
                assert (FilteredQuery.this.filter != null);
                DocIdSet filterDocIdSet = FilteredQuery.this.filter.getDocIdSet(context, acceptDocs);
                if (filterDocIdSet == null) {
                    return null;
                }
                final DocIdSetIterator filterIter = filterDocIdSet.iterator();
                if (filterIter == null) {
                    return null;
                }
                final int firstFilterDoc = filterIter.nextDoc();
                if (firstFilterDoc == Integer.MAX_VALUE) {
                    return null;
                }
                Bits filterAcceptDocs = filterDocIdSet.bits();
                boolean bl = useRandomAccess = filterAcceptDocs != null && FilteredQuery.this.useRandomAccess(filterAcceptDocs, firstFilterDoc);
                if (useRandomAccess) {
                    return weight.scorer(context, true, topScorer, filterAcceptDocs);
                }
                assert (firstFilterDoc > -1);
                final Scorer scorer = weight.scorer(context, true, false, null);
                return scorer == null ? null : new Scorer(this){
                    private int scorerDoc;
                    private int filterDoc;
                    {
                        super(x0);
                        this.scorerDoc = -1;
                        this.filterDoc = firstFilterDoc;
                    }

                    @Override
                    public void score(Collector collector) throws IOException {
                        int filterDoc = firstFilterDoc;
                        int scorerDoc = scorer.advance(filterDoc);
                        collector.setScorer(scorer);
                        while (true) {
                            if (scorerDoc == filterDoc) {
                                if (scorerDoc == Integer.MAX_VALUE) break;
                                collector.collect(scorerDoc);
                                filterDoc = filterIter.nextDoc();
                                scorerDoc = scorer.advance(filterDoc);
                                continue;
                            }
                            if (scorerDoc > filterDoc) {
                                filterDoc = filterIter.advance(scorerDoc);
                                continue;
                            }
                            scorerDoc = scorer.advance(filterDoc);
                        }
                    }

                    private int advanceToNextCommonDoc() throws IOException {
                        while (true) {
                            if (this.scorerDoc < this.filterDoc) {
                                this.scorerDoc = scorer.advance(this.filterDoc);
                                continue;
                            }
                            if (this.scorerDoc == this.filterDoc) {
                                return this.scorerDoc;
                            }
                            this.filterDoc = filterIter.advance(this.scorerDoc);
                        }
                    }

                    @Override
                    public int nextDoc() throws IOException {
                        if (this.scorerDoc != -1) {
                            this.filterDoc = filterIter.nextDoc();
                        }
                        return this.advanceToNextCommonDoc();
                    }

                    @Override
                    public int advance(int target) throws IOException {
                        if (target > this.filterDoc) {
                            this.filterDoc = filterIter.advance(target);
                        }
                        return this.advanceToNextCommonDoc();
                    }

                    @Override
                    public int docID() {
                        return this.scorerDoc;
                    }

                    @Override
                    public float score() throws IOException {
                        return scorer.score();
                    }

                    @Override
                    public float freq() throws IOException {
                        return scorer.freq();
                    }

                    @Override
                    public Collection<Scorer.ChildScorer> getChildren() {
                        return Collections.singleton(new Scorer.ChildScorer(scorer, "FILTERED"));
                    }
                };
            }
        };
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query queryRewritten = this.query.rewrite(reader);
        if (queryRewritten instanceof MatchAllDocsQuery) {
            ConstantScoreQuery rewritten = new ConstantScoreQuery(this.filter);
            rewritten.setBoost(this.getBoost() * queryRewritten.getBoost());
            return rewritten;
        }
        if (queryRewritten != this.query) {
            FilteredQuery rewritten = new FilteredQuery(queryRewritten, this.filter);
            rewritten.setBoost(this.getBoost());
            return rewritten;
        }
        return this;
    }

    public final Query getQuery() {
        return this.query;
    }

    public final Filter getFilter() {
        return this.filter;
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        this.getQuery().extractTerms(terms);
    }

    @Override
    public String toString(String s) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("filtered(");
        buffer.append(this.query.toString(s));
        buffer.append(")->");
        buffer.append(this.filter);
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        assert (o instanceof FilteredQuery);
        FilteredQuery fq = (FilteredQuery)o;
        return fq.query.equals(this.query) && fq.filter.equals(this.filter);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = hash * 31 + this.query.hashCode();
        hash = hash * 31 + this.filter.hashCode();
        return hash;
    }
}

