/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import org.apache.lucene.index.MultiTermsEnum;
import org.apache.lucene.index.ReaderSlice;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.CompiledAutomaton;

public final class MultiTerms
extends Terms {
    private final Terms[] subs;
    private final ReaderSlice[] subSlices;
    private final Comparator<BytesRef> termComp;

    public MultiTerms(Terms[] subs, ReaderSlice[] subSlices) throws IOException {
        this.subs = subs;
        this.subSlices = subSlices;
        Comparator<BytesRef> _termComp = null;
        for (int i = 0; i < subs.length; ++i) {
            if (_termComp == null) {
                _termComp = subs[i].getComparator();
                continue;
            }
            Comparator<BytesRef> subTermComp = subs[i].getComparator();
            if (subTermComp == null || ((Object)subTermComp).equals(_termComp)) continue;
            throw new IllegalStateException("sub-readers have different BytesRef.Comparators; cannot merge");
        }
        this.termComp = _termComp;
    }

    @Override
    public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
        ArrayList<MultiTermsEnum.TermsEnumIndex> termsEnums = new ArrayList<MultiTermsEnum.TermsEnumIndex>();
        for (int i = 0; i < this.subs.length; ++i) {
            TermsEnum termsEnum = this.subs[i].intersect(compiled, startTerm);
            if (termsEnum == null) continue;
            termsEnums.add(new MultiTermsEnum.TermsEnumIndex(termsEnum, i));
        }
        if (termsEnums.size() > 0) {
            return new MultiTermsEnum(this.subSlices).reset(termsEnums.toArray(MultiTermsEnum.TermsEnumIndex.EMPTY_ARRAY));
        }
        return TermsEnum.EMPTY;
    }

    @Override
    public TermsEnum iterator(TermsEnum reuse) throws IOException {
        ArrayList<MultiTermsEnum.TermsEnumIndex> termsEnums = new ArrayList<MultiTermsEnum.TermsEnumIndex>();
        for (int i = 0; i < this.subs.length; ++i) {
            TermsEnum termsEnum = this.subs[i].iterator(null);
            if (termsEnum == null) continue;
            termsEnums.add(new MultiTermsEnum.TermsEnumIndex(termsEnum, i));
        }
        if (termsEnums.size() > 0) {
            return new MultiTermsEnum(this.subSlices).reset(termsEnums.toArray(MultiTermsEnum.TermsEnumIndex.EMPTY_ARRAY));
        }
        return TermsEnum.EMPTY;
    }

    @Override
    public long size() {
        return -1L;
    }

    @Override
    public long getSumTotalTermFreq() throws IOException {
        long sum = 0L;
        for (Terms terms : this.subs) {
            long v = terms.getSumTotalTermFreq();
            if (v == -1L) {
                return -1L;
            }
            sum += v;
        }
        return sum;
    }

    @Override
    public long getSumDocFreq() throws IOException {
        long sum = 0L;
        for (Terms terms : this.subs) {
            long v = terms.getSumDocFreq();
            if (v == -1L) {
                return -1L;
            }
            sum += v;
        }
        return sum;
    }

    @Override
    public int getDocCount() throws IOException {
        int sum = 0;
        for (Terms terms : this.subs) {
            int v = terms.getDocCount();
            if (v == -1) {
                return -1;
            }
            sum += v;
        }
        return sum;
    }

    @Override
    public Comparator<BytesRef> getComparator() {
        return this.termComp;
    }
}

