/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.codecs.BlockTreeTermsReader;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FieldsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentInfoPerCommit;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CommandLineUtil;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.StringHelper;

public class CheckIndex {
    private PrintStream infoStream;
    private Directory dir;
    private boolean crossCheckTermVectors;
    private boolean verbose;
    private static boolean assertsOn;

    public CheckIndex(Directory dir) {
        this.dir = dir;
        this.infoStream = null;
    }

    public void setCrossCheckTermVectors(boolean v) {
        this.crossCheckTermVectors = v;
    }

    public boolean getCrossCheckTermVectors() {
        return this.crossCheckTermVectors;
    }

    public void setInfoStream(PrintStream out, boolean verbose) {
        this.infoStream = out;
        this.verbose = verbose;
    }

    public void setInfoStream(PrintStream out) {
        this.setInfoStream(out, false);
    }

    private void msg(String msg) {
        if (this.infoStream != null) {
            this.infoStream.println(msg);
        }
    }

    public Status checkIndex() throws IOException {
        return this.checkIndex(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status checkIndex(List<String> onlySegments) throws IOException {
        NumberFormat nf = NumberFormat.getInstance(Locale.ROOT);
        SegmentInfos sis = new SegmentInfos();
        Status result = new Status();
        result.dir = this.dir;
        try {
            sis.read(this.dir);
        }
        catch (Throwable t) {
            this.msg("ERROR: could not read any segments file in directory");
            result.missingSegments = true;
            if (this.infoStream != null) {
                t.printStackTrace(this.infoStream);
            }
            return result;
        }
        String oldest = Integer.toString(Integer.MAX_VALUE);
        String newest = Integer.toString(Integer.MIN_VALUE);
        String oldSegs = null;
        boolean foundNonNullVersion = false;
        Comparator<String> versionComparator = StringHelper.getVersionComparator();
        for (SegmentInfoPerCommit si : sis) {
            String version = si.info.getVersion();
            if (version == null) {
                oldSegs = "pre-3.1";
                continue;
            }
            foundNonNullVersion = true;
            if (versionComparator.compare(version, oldest) < 0) {
                oldest = version;
            }
            if (versionComparator.compare(version, newest) <= 0) continue;
            newest = version;
        }
        int numSegments = sis.size();
        String segmentsFileName = sis.getSegmentsFileName();
        IndexInput input = null;
        try {
            input = this.dir.openInput(segmentsFileName, IOContext.DEFAULT);
        }
        catch (Throwable t) {
            this.msg("ERROR: could not open segments file in directory");
            if (this.infoStream != null) {
                t.printStackTrace(this.infoStream);
            }
            result.cantOpenSegments = true;
            return result;
        }
        int format = 0;
        try {
            format = input.readInt();
        }
        catch (Throwable t) {
            this.msg("ERROR: could not read segment file version in directory");
            if (this.infoStream != null) {
                t.printStackTrace(this.infoStream);
            }
            result.missingSegmentVersion = true;
            Status status = result;
            return status;
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
        String sFormat = "";
        boolean skip = false;
        result.segmentsFileName = segmentsFileName;
        result.numSegments = numSegments;
        result.userData = sis.getUserData();
        String userDataString = sis.getUserData().size() > 0 ? " userData=" + sis.getUserData() : "";
        String versionString = null;
        versionString = oldSegs != null ? (foundNonNullVersion ? "versions=[" + oldSegs + " .. " + newest + "]" : "version=" + oldSegs) : (oldest.equals(newest) ? "version=" + oldest : "versions=[" + oldest + " .. " + newest + "]");
        this.msg("Segments file=" + segmentsFileName + " numSegments=" + numSegments + " " + versionString + " format=" + sFormat + userDataString);
        if (onlySegments != null) {
            result.partial = true;
            if (this.infoStream != null) {
                this.infoStream.print("\nChecking only these segments:");
            }
            for (String s : onlySegments) {
                if (this.infoStream == null) continue;
                this.infoStream.print(" " + s);
            }
            result.segmentsChecked.addAll(onlySegments);
            this.msg(":");
        }
        if (skip) {
            this.msg("\nERROR: this index appears to be created by a newer version of Lucene than this tool was compiled on; please re-compile this tool on the matching version of Lucene; exiting");
            result.toolOutOfDate = true;
            return result;
        }
        result.newSegments = sis.clone();
        result.newSegments.clear();
        result.maxSegmentName = -1;
        for (int i = 0; i < numSegments; ++i) {
            SegmentInfoPerCommit info = sis.info(i);
            int segmentName = Integer.parseInt(info.info.name.substring(1), 36);
            if (segmentName > result.maxSegmentName) {
                result.maxSegmentName = segmentName;
            }
            if (onlySegments != null && !onlySegments.contains(info.info.name)) continue;
            Status.SegmentInfoStatus segInfoStat = new Status.SegmentInfoStatus();
            result.segmentInfos.add(segInfoStat);
            this.msg("  " + (1 + i) + " of " + numSegments + ": name=" + info.info.name + " docCount=" + info.info.getDocCount());
            segInfoStat.name = info.info.name;
            segInfoStat.docCount = info.info.getDocCount();
            int toLoseDocCount = info.info.getDocCount();
            IndexReader reader = null;
            try {
                Bits liveDocs;
                int numDocs;
                Codec codec = info.info.getCodec();
                this.msg("    codec=" + codec);
                segInfoStat.codec = codec;
                this.msg("    compound=" + info.info.getUseCompoundFile());
                segInfoStat.compound = info.info.getUseCompoundFile();
                this.msg("    numFiles=" + info.files().size());
                segInfoStat.numFiles = info.files().size();
                segInfoStat.sizeMB = (double)info.sizeInBytes() / 1048576.0;
                this.msg("    size (MB)=" + nf.format(segInfoStat.sizeMB));
                Map<String, String> diagnostics = info.info.getDiagnostics();
                segInfoStat.diagnostics = diagnostics;
                if (diagnostics.size() > 0) {
                    this.msg("    diagnostics = " + diagnostics);
                }
                if (info.hasDeletions()) {
                    this.msg("    no deletions");
                    segInfoStat.hasDeletions = false;
                } else {
                    this.msg("    has deletions [delGen=" + info.getDelGen() + "]");
                    segInfoStat.hasDeletions = true;
                    segInfoStat.deletionsGen = info.getDelGen();
                }
                if (this.infoStream != null) {
                    this.infoStream.print("    test: open reader.........");
                }
                reader = new SegmentReader(info, 1, IOContext.DEFAULT);
                segInfoStat.openReaderPassed = true;
                toLoseDocCount = numDocs = ((SegmentReader)reader).numDocs();
                if (((SegmentReader)reader).hasDeletions()) {
                    if (((SegmentReader)reader).numDocs() != info.info.getDocCount() - info.getDelCount()) {
                        throw new RuntimeException("delete count mismatch: info=" + (info.info.getDocCount() - info.getDelCount()) + " vs reader=" + ((SegmentReader)reader).numDocs());
                    }
                    if (info.info.getDocCount() - ((SegmentReader)reader).numDocs() > ((SegmentReader)reader).maxDoc()) {
                        throw new RuntimeException("too many deleted docs: maxDoc()=" + ((SegmentReader)reader).maxDoc() + " vs del count=" + (info.info.getDocCount() - ((SegmentReader)reader).numDocs()));
                    }
                    if (info.info.getDocCount() - numDocs != info.getDelCount()) {
                        throw new RuntimeException("delete count mismatch: info=" + info.getDelCount() + " vs reader=" + (info.info.getDocCount() - numDocs));
                    }
                    liveDocs = ((SegmentReader)reader).getLiveDocs();
                    if (liveDocs == null) {
                        throw new RuntimeException("segment should have deletions, but liveDocs is null");
                    }
                    int numLive = 0;
                    for (int j = 0; j < liveDocs.length(); ++j) {
                        if (!liveDocs.get(j)) continue;
                        ++numLive;
                    }
                    if (numLive != numDocs) {
                        throw new RuntimeException("liveDocs count mismatch: info=" + numDocs + ", vs bits=" + numLive);
                    }
                    segInfoStat.numDeleted = info.info.getDocCount() - numDocs;
                    this.msg("OK [" + segInfoStat.numDeleted + " deleted docs]");
                } else {
                    if (info.getDelCount() != 0) {
                        throw new RuntimeException("delete count mismatch: info=" + info.getDelCount() + " vs reader=" + (info.info.getDocCount() - numDocs));
                    }
                    liveDocs = ((SegmentReader)reader).getLiveDocs();
                    if (liveDocs != null) {
                        for (int j = 0; j < liveDocs.length(); ++j) {
                            if (liveDocs.get(j)) continue;
                            throw new RuntimeException("liveDocs mismatch: info says no deletions but doc " + j + " is deleted.");
                        }
                    }
                    this.msg("OK");
                }
                if (((SegmentReader)reader).maxDoc() != info.info.getDocCount()) {
                    throw new RuntimeException("SegmentReader.maxDoc() " + ((SegmentReader)reader).maxDoc() + " != SegmentInfos.docCount " + info.info.getDocCount());
                }
                if (this.infoStream != null) {
                    this.infoStream.print("    test: fields..............");
                }
                FieldInfos fieldInfos = ((SegmentReader)reader).getFieldInfos();
                this.msg("OK [" + fieldInfos.size() + " fields]");
                segInfoStat.numFields = fieldInfos.size();
                segInfoStat.fieldNormStatus = this.testFieldNorms(fieldInfos, (SegmentReader)reader);
                segInfoStat.termIndexStatus = this.testPostings(fieldInfos, (SegmentReader)reader);
                segInfoStat.storedFieldStatus = this.testStoredFields(info, (SegmentReader)reader, nf);
                segInfoStat.termVectorStatus = this.testTermVectors(fieldInfos, info, (SegmentReader)reader, nf);
                segInfoStat.docValuesStatus = this.testDocValues(info, fieldInfos, (SegmentReader)reader);
                if (segInfoStat.fieldNormStatus.error != null) {
                    throw new RuntimeException("Field Norm test failed");
                }
                if (segInfoStat.termIndexStatus.error != null) {
                    throw new RuntimeException("Term Index test failed");
                }
                if (segInfoStat.storedFieldStatus.error != null) {
                    throw new RuntimeException("Stored Field test failed");
                }
                if (segInfoStat.termVectorStatus.error != null) {
                    throw new RuntimeException("Term Vector test failed");
                }
                if (segInfoStat.docValuesStatus.error != null) {
                    throw new RuntimeException("DocValues test failed");
                }
                this.msg("");
            }
            catch (Throwable t) {
                this.msg("FAILED");
                String comment = "fixIndex() would remove reference to this segment";
                this.msg("    WARNING: " + comment + "; full exception:");
                if (this.infoStream != null) {
                    t.printStackTrace(this.infoStream);
                }
                this.msg("");
                result.totLoseDocCount += toLoseDocCount;
                ++result.numBadSegments;
                continue;
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            result.newSegments.add(info.clone());
        }
        if (0 == result.numBadSegments) {
            result.clean = true;
        } else {
            this.msg("WARNING: " + result.numBadSegments + " broken segments (containing " + result.totLoseDocCount + " documents) detected");
        }
        if (!(result.validCounter = result.maxSegmentName < sis.counter)) {
            result.clean = false;
            result.newSegments.counter = result.maxSegmentName + 1;
            this.msg("ERROR: Next segment name counter " + sis.counter + " is not greater than max segment name " + result.maxSegmentName);
        }
        if (result.clean) {
            this.msg("No problems were detected with this index.\n");
        }
        return result;
    }

    private Status.FieldNormStatus testFieldNorms(FieldInfos fieldInfos, SegmentReader reader) {
        Status.FieldNormStatus status;
        block7: {
            status = new Status.FieldNormStatus();
            try {
                if (this.infoStream != null) {
                    this.infoStream.print("    test: field norms.........");
                }
                for (FieldInfo info : fieldInfos) {
                    if (info.hasNorms()) {
                        assert (reader.hasNorms(info.name));
                        DocValues dv = reader.normValues(info.name);
                        this.checkDocValues(dv, info.name, info.getNormType(), reader.maxDoc());
                        ++status.totFields;
                        continue;
                    }
                    assert (!reader.hasNorms(info.name));
                    if (reader.normValues(info.name) == null) continue;
                    throw new RuntimeException("field: " + info.name + " should omit norms but has them!");
                }
                this.msg("OK [" + status.totFields + " fields]");
            }
            catch (Throwable e) {
                this.msg("ERROR [" + String.valueOf(e.getMessage()) + "]");
                status.error = e;
                if (this.infoStream == null) break block7;
                e.printStackTrace(this.infoStream);
            }
        }
        return status;
    }

    private Status.TermIndexStatus checkFields(Fields fields, Bits liveDocs, int maxDoc, FieldInfos fieldInfos, boolean doPrint, boolean isVectors) throws IOException {
        long uniqueTermCountAllFields;
        String field;
        Status.TermIndexStatus status = new Status.TermIndexStatus();
        int computedFieldCount = 0;
        if (fields == null) {
            this.msg("OK [no fields/terms]");
            return status;
        }
        DocsEnum docs = null;
        DocsEnum docsAndFreqs = null;
        DocsAndPositionsEnum postings = null;
        String lastField = null;
        FieldsEnum fieldsEnum = fields.iterator();
        while ((field = fieldsEnum.next()) != null) {
            int seekCount;
            long v;
            BytesRef term;
            if (lastField != null && field.compareTo(lastField) <= 0) {
                throw new RuntimeException("fields out of order: lastField=" + lastField + " field=" + field);
            }
            lastField = field;
            FieldInfo fieldInfo = fieldInfos.fieldInfo(field);
            if (fieldInfo == null) {
                throw new RuntimeException("fieldsEnum inconsistent with fieldInfos, no fieldInfos for: " + field);
            }
            if (!fieldInfo.isIndexed()) {
                throw new RuntimeException("fieldsEnum inconsistent with fieldInfos, isIndexed == false for: " + field);
            }
            ++computedFieldCount;
            Terms terms = fieldsEnum.terms();
            if (terms == null) continue;
            TermsEnum termsEnum = terms.iterator(null);
            boolean hasOrd = true;
            long termCountStart = status.termCount;
            BytesRef lastTerm = null;
            Comparator<BytesRef> termComp = terms.getComparator();
            long sumTotalTermFreq = 0L;
            long sumDocFreq = 0L;
            FixedBitSet visitedDocs = new FixedBitSet(maxDoc);
            block3: while ((term = termsEnum.next()) != null) {
                int docID;
                int skipDocID;
                int idx;
                boolean hasTotalTermFreq;
                int doc;
                boolean hasPositions;
                DocsEnum docs2;
                boolean hasOffsets;
                if (lastTerm == null) {
                    lastTerm = BytesRef.deepCopyOf(term);
                } else {
                    if (termComp.compare(lastTerm, term) >= 0) {
                        throw new RuntimeException("terms out of order: lastTerm=" + lastTerm + " term=" + term);
                    }
                    lastTerm.copyBytes(term);
                }
                int docFreq = termsEnum.docFreq();
                if (docFreq <= 0) {
                    throw new RuntimeException("docfreq: " + docFreq + " is out of bounds");
                }
                status.totFreq += (long)docFreq;
                sumDocFreq += (long)docFreq;
                docs = termsEnum.docs(liveDocs, docs);
                postings = termsEnum.docsAndPositions(liveDocs, postings);
                if (hasOrd) {
                    long ordExpected;
                    long ord = -1L;
                    try {
                        ord = termsEnum.ord();
                    }
                    catch (UnsupportedOperationException uoe) {
                        hasOrd = false;
                    }
                    if (hasOrd && ord != (ordExpected = status.termCount - termCountStart)) {
                        throw new RuntimeException("ord mismatch: TermsEnum has ord=" + ord + " vs actual=" + ordExpected);
                    }
                }
                ++status.termCount;
                boolean hasFreqs = isVectors || fieldInfo.getIndexOptions().compareTo(FieldInfo.IndexOptions.DOCS_AND_FREQS) >= 0;
                boolean bl = hasOffsets = isVectors || fieldInfo.getIndexOptions().compareTo(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
                if (postings != null) {
                    docs2 = postings;
                    hasPositions = true;
                } else {
                    docs2 = docs;
                    hasPositions = false;
                }
                int lastDoc = -1;
                int docCount = 0;
                long totalTermFreq = 0L;
                while ((doc = docs2.nextDoc()) != Integer.MAX_VALUE) {
                    visitedDocs.set(doc);
                    int freq = -1;
                    if (hasFreqs) {
                        freq = docs2.freq();
                        if (freq <= 0) {
                            throw new RuntimeException("term " + term + ": doc " + doc + ": freq " + freq + " is out of bounds");
                        }
                        status.totPos += (long)freq;
                        totalTermFreq += (long)freq;
                    }
                    ++docCount;
                    if (doc <= lastDoc) {
                        throw new RuntimeException("term " + term + ": doc " + doc + " <= lastDoc " + lastDoc);
                    }
                    if (doc >= maxDoc) {
                        throw new RuntimeException("term " + term + ": doc " + doc + " >= maxDoc " + maxDoc);
                    }
                    lastDoc = doc;
                    int lastPos = -1;
                    int lastOffset = 0;
                    if (!hasPositions) continue;
                    for (int j = 0; j < freq; ++j) {
                        int pos = postings.nextPosition();
                        if (pos < -1) {
                            throw new RuntimeException("term " + term + ": doc " + doc + ": pos " + pos + " is out of bounds");
                        }
                        if (pos < lastPos) {
                            throw new RuntimeException("term " + term + ": doc " + doc + ": pos " + pos + " < lastPos " + lastPos);
                        }
                        lastPos = pos;
                        if (postings.hasPayload()) {
                            postings.getPayload();
                        }
                        if (!hasOffsets) continue;
                        int startOffset = postings.startOffset();
                        int endOffset = postings.endOffset();
                        if (!isVectors) {
                            if (startOffset < 0) {
                                throw new RuntimeException("term " + term + ": doc " + doc + ": pos " + pos + ": startOffset " + startOffset + " is out of bounds");
                            }
                            if (startOffset < lastOffset) {
                                throw new RuntimeException("term " + term + ": doc " + doc + ": pos " + pos + ": startOffset " + startOffset + " < lastStartOffset " + lastOffset);
                            }
                            if (endOffset < 0) {
                                throw new RuntimeException("term " + term + ": doc " + doc + ": pos " + pos + ": endOffset " + endOffset + " is out of bounds");
                            }
                            if (endOffset < startOffset) {
                                throw new RuntimeException("term " + term + ": doc " + doc + ": pos " + pos + ": endOffset " + endOffset + " < startOffset " + startOffset);
                            }
                        }
                        lastOffset = startOffset;
                    }
                }
                long totalTermFreq2 = termsEnum.totalTermFreq();
                boolean bl2 = hasTotalTermFreq = hasFreqs && totalTermFreq2 != -1L;
                if (liveDocs != null) {
                    if (hasFreqs) {
                        DocsEnum docsNoDel = termsEnum.docs(null, docsAndFreqs);
                        docCount = 0;
                        totalTermFreq = 0L;
                        while (docsNoDel.nextDoc() != Integer.MAX_VALUE) {
                            visitedDocs.set(docsNoDel.docID());
                            ++docCount;
                            totalTermFreq += (long)docsNoDel.freq();
                        }
                    } else {
                        DocsEnum docsNoDel = termsEnum.docs(null, docs, 0);
                        docCount = 0;
                        totalTermFreq = -1L;
                        while (docsNoDel.nextDoc() != Integer.MAX_VALUE) {
                            visitedDocs.set(docsNoDel.docID());
                            ++docCount;
                        }
                    }
                }
                if (docCount != docFreq) {
                    throw new RuntimeException("term " + term + " docFreq=" + docFreq + " != tot docs w/o deletions " + docCount);
                }
                if (hasTotalTermFreq) {
                    if (totalTermFreq2 <= 0L) {
                        throw new RuntimeException("totalTermFreq: " + totalTermFreq2 + " is out of bounds");
                    }
                    sumTotalTermFreq += totalTermFreq;
                    if (totalTermFreq != totalTermFreq2) {
                        throw new RuntimeException("term " + term + " totalTermFreq=" + totalTermFreq2 + " != recomputed totalTermFreq=" + totalTermFreq);
                    }
                }
                if (hasPositions) {
                    for (idx = 0; idx < 7; ++idx) {
                        skipDocID = (int)((long)(idx + 1) * (long)maxDoc / 8L);
                        docID = (postings = termsEnum.docsAndPositions(liveDocs, postings)).advance(skipDocID);
                        if (docID == Integer.MAX_VALUE) continue block3;
                        if (docID < skipDocID) {
                            throw new RuntimeException("term " + term + ": advance(docID=" + skipDocID + ") returned docID=" + docID);
                        }
                        int freq = postings.freq();
                        if (freq <= 0) {
                            throw new RuntimeException("termFreq " + freq + " is out of bounds");
                        }
                        int lastPosition = -1;
                        int lastOffset = 0;
                        for (int posUpto = 0; posUpto < freq; ++posUpto) {
                            int pos = postings.nextPosition();
                            if (pos < -1) {
                                throw new RuntimeException("position " + pos + " is out of bounds");
                            }
                            if (pos < lastPosition) {
                                throw new RuntimeException("position " + pos + " is < lastPosition " + lastPosition);
                            }
                            lastPosition = pos;
                            if (!hasOffsets) continue;
                            int startOffset = postings.startOffset();
                            int endOffset = postings.endOffset();
                            if (!isVectors) {
                                if (startOffset < 0) {
                                    throw new RuntimeException("term " + term + ": doc " + docID + ": pos " + pos + ": startOffset " + startOffset + " is out of bounds");
                                }
                                if (startOffset < lastOffset) {
                                    throw new RuntimeException("term " + term + ": doc " + docID + ": pos " + pos + ": startOffset " + startOffset + " < lastStartOffset " + lastOffset);
                                }
                                if (endOffset < 0) {
                                    throw new RuntimeException("term " + term + ": doc " + docID + ": pos " + pos + ": endOffset " + endOffset + " is out of bounds");
                                }
                                if (endOffset < startOffset) {
                                    throw new RuntimeException("term " + term + ": doc " + docID + ": pos " + pos + ": endOffset " + endOffset + " < startOffset " + startOffset);
                                }
                            }
                            lastOffset = startOffset;
                        }
                        int nextDocID = postings.nextDoc();
                        if (nextDocID == Integer.MAX_VALUE) continue block3;
                        if (nextDocID > docID) continue;
                        throw new RuntimeException("term " + term + ": advance(docID=" + skipDocID + "), then .next() returned docID=" + nextDocID + " vs prev docID=" + docID);
                    }
                    continue;
                }
                for (idx = 0; idx < 7; ++idx) {
                    skipDocID = (int)((long)(idx + 1) * (long)maxDoc / 8L);
                    docID = (docs = termsEnum.docs(liveDocs, docs, 0)).advance(skipDocID);
                    if (docID == Integer.MAX_VALUE) continue block3;
                    if (docID < skipDocID) {
                        throw new RuntimeException("term " + term + ": advance(docID=" + skipDocID + ") returned docID=" + docID);
                    }
                    int nextDocID = docs.nextDoc();
                    if (nextDocID == Integer.MAX_VALUE) continue block3;
                    if (nextDocID > docID) continue;
                    throw new RuntimeException("term " + term + ": advance(docID=" + skipDocID + "), then .next() returned docID=" + nextDocID + " vs prev docID=" + docID);
                }
            }
            Terms fieldTerms = fields.terms(field);
            if (fieldTerms == null) {
                Terms fieldTerms2 = fieldsEnum.terms();
                if (fieldTerms2 == null || fieldTerms2.iterator(null).next() == null) continue;
                throw new RuntimeException("Fields.terms(field=" + field + ") returned null yet the field appears to have terms");
            }
            if (fieldTerms instanceof BlockTreeTermsReader.FieldReader) {
                BlockTreeTermsReader.Stats stats = ((BlockTreeTermsReader.FieldReader)fieldTerms).computeStats();
                assert (stats != null);
                if (status.blockTreeStats == null) {
                    status.blockTreeStats = new HashMap<String, BlockTreeTermsReader.Stats>();
                }
                status.blockTreeStats.put(field, stats);
            }
            if (sumTotalTermFreq != 0L && (v = fields.terms(field).getSumTotalTermFreq()) != -1L && sumTotalTermFreq != v) {
                throw new RuntimeException("sumTotalTermFreq for field " + field + "=" + v + " != recomputed sumTotalTermFreq=" + sumTotalTermFreq);
            }
            if (sumDocFreq != 0L && (v = fields.terms(field).getSumDocFreq()) != -1L && sumDocFreq != v) {
                throw new RuntimeException("sumDocFreq for field " + field + "=" + v + " != recomputed sumDocFreq=" + sumDocFreq);
            }
            if (fieldTerms != null && (v = fieldTerms.getDocCount()) != -1 && visitedDocs.cardinality() != v) {
                throw new RuntimeException("docCount for field " + field + "=" + v + " != recomputed docCount=" + visitedDocs.cardinality());
            }
            if (lastTerm != null) {
                if (termsEnum.seekCeil(lastTerm) != TermsEnum.SeekStatus.FOUND) {
                    throw new RuntimeException("seek to last term " + lastTerm + " failed");
                }
                int expectedDocFreq = termsEnum.docFreq();
                DocsEnum d = termsEnum.docs(null, null, 0);
                int docFreq = 0;
                while (d.nextDoc() != Integer.MAX_VALUE) {
                    ++docFreq;
                }
                if (docFreq != expectedDocFreq) {
                    throw new RuntimeException("docFreq for last term " + lastTerm + "=" + expectedDocFreq + " != recomputed docFreq=" + docFreq);
                }
            }
            long termCount = -1L;
            if (status.termCount - termCountStart > 0L && (termCount = fields.terms(field).size()) != -1L && termCount != status.termCount - termCountStart) {
                throw new RuntimeException("termCount mismatch " + termCount + " vs " + (status.termCount - termCountStart));
            }
            if (!hasOrd || status.termCount - termCountStart <= 0L || (seekCount = (int)Math.min(10000L, termCount)) <= 0) continue;
            BytesRef[] seekTerms = new BytesRef[seekCount];
            for (int i = seekCount - 1; i >= 0; --i) {
                long ord = (long)i * (termCount / (long)seekCount);
                termsEnum.seekExact(ord);
                seekTerms[i] = BytesRef.deepCopyOf(termsEnum.term());
            }
            long totDocCount = 0L;
            for (int i = seekCount - 1; i >= 0; --i) {
                if (termsEnum.seekCeil(seekTerms[i]) != TermsEnum.SeekStatus.FOUND) {
                    throw new RuntimeException("seek to existing term " + seekTerms[i] + " failed");
                }
                if ((docs = termsEnum.docs(liveDocs, docs, 0)) == null) {
                    throw new RuntimeException("null DocsEnum from to existing term " + seekTerms[i]);
                }
                while (docs.nextDoc() != Integer.MAX_VALUE) {
                    ++totDocCount;
                }
            }
            long totDocCountNoDeletes = 0L;
            long totDocFreq = 0L;
            for (int i = 0; i < seekCount; ++i) {
                if (!termsEnum.seekExact(seekTerms[i], true)) {
                    throw new RuntimeException("seek to existing term " + seekTerms[i] + " failed");
                }
                totDocFreq += (long)termsEnum.docFreq();
                if ((docs = termsEnum.docs(null, docs, 0)) == null) {
                    throw new RuntimeException("null DocsEnum from to existing term " + seekTerms[i]);
                }
                while (docs.nextDoc() != Integer.MAX_VALUE) {
                    ++totDocCountNoDeletes;
                }
            }
            if (totDocCount > totDocCountNoDeletes) {
                throw new RuntimeException("more postings with deletes=" + totDocCount + " than without=" + totDocCountNoDeletes);
            }
            if (totDocCountNoDeletes == totDocFreq) continue;
            throw new RuntimeException("docfreqs=" + totDocFreq + " != recomputed docfreqs=" + totDocCountNoDeletes);
        }
        int fieldCount = fields.size();
        if (fieldCount != -1) {
            if (fieldCount < 0) {
                throw new RuntimeException("invalid fieldCount: " + fieldCount);
            }
            if (fieldCount != computedFieldCount) {
                throw new RuntimeException("fieldCount mismatch " + fieldCount + " vs recomputed field count " + computedFieldCount);
            }
        }
        if ((uniqueTermCountAllFields = fields.getUniqueTermCount()) == -1L) {
            throw new RuntimeException("invalid termCount: -1");
        }
        if (status.termCount != uniqueTermCountAllFields) {
            throw new RuntimeException("termCount mismatch " + uniqueTermCountAllFields + " vs " + status.termCount);
        }
        if (doPrint) {
            this.msg("OK [" + status.termCount + " terms; " + status.totFreq + " terms/docs pairs; " + status.totPos + " tokens]");
        }
        if (this.verbose && status.blockTreeStats != null && this.infoStream != null && status.termCount > 0L) {
            for (Map.Entry<String, BlockTreeTermsReader.Stats> ent : status.blockTreeStats.entrySet()) {
                this.infoStream.println("      field \"" + ent.getKey() + "\":");
                this.infoStream.println("      " + ent.getValue().toString().replace("\n", "\n      "));
            }
        }
        return status;
    }

    private Status.TermIndexStatus testPostings(FieldInfos fieldInfos, SegmentReader reader) {
        Status.TermIndexStatus status;
        block5: {
            int maxDoc = reader.maxDoc();
            Bits liveDocs = reader.getLiveDocs();
            try {
                if (this.infoStream != null) {
                    this.infoStream.print("    test: terms, freq, prox...");
                }
                Fields fields = reader.fields();
                status = this.checkFields(fields, liveDocs, maxDoc, fieldInfos, true, false);
                if (liveDocs != null) {
                    if (this.infoStream != null) {
                        this.infoStream.print("    test (ignoring deletes): terms, freq, prox...");
                    }
                    this.checkFields(fields, null, maxDoc, fieldInfos, true, false);
                }
            }
            catch (Throwable e) {
                this.msg("ERROR: " + e);
                status = new Status.TermIndexStatus();
                status.error = e;
                if (this.infoStream == null) break block5;
                e.printStackTrace(this.infoStream);
            }
        }
        return status;
    }

    private Status.StoredFieldStatus testStoredFields(SegmentInfoPerCommit info, SegmentReader reader, NumberFormat format) {
        Status.StoredFieldStatus status;
        block5: {
            status = new Status.StoredFieldStatus();
            try {
                if (this.infoStream != null) {
                    this.infoStream.print("    test: stored fields.......");
                }
                Bits liveDocs = reader.getLiveDocs();
                for (int j = 0; j < info.info.getDocCount(); ++j) {
                    Document doc = reader.document(j);
                    if (liveDocs != null && !liveDocs.get(j)) continue;
                    ++status.docCount;
                    status.totFields += (long)doc.getFields().size();
                }
                if (status.docCount != reader.numDocs()) {
                    throw new RuntimeException("docCount=" + status.docCount + " but saw " + status.docCount + " undeleted docs");
                }
                this.msg("OK [" + status.totFields + " total field count; avg " + format.format((float)status.totFields / (float)status.docCount) + " fields per doc]");
            }
            catch (Throwable e) {
                this.msg("ERROR [" + String.valueOf(e.getMessage()) + "]");
                status.error = e;
                if (this.infoStream == null) break block5;
                e.printStackTrace(this.infoStream);
            }
        }
        return status;
    }

    private void checkDocValues(DocValues docValues, String fieldName, DocValues.Type expectedType, int expectedDocs) throws IOException {
        if (docValues == null) {
            throw new RuntimeException("field: " + fieldName + " omits docvalues but should have them!");
        }
        DocValues.Type type = docValues.getType();
        if (type != expectedType) {
            throw new RuntimeException("field: " + fieldName + " has type: " + (Object)((Object)type) + " but fieldInfos says:" + (Object)((Object)expectedType));
        }
        DocValues.Source values = docValues.getDirectSource();
        int size = docValues.getValueSize();
        block10: for (int i = 0; i < expectedDocs; ++i) {
            switch (type) {
                case BYTES_FIXED_SORTED: 
                case BYTES_VAR_SORTED: 
                case BYTES_FIXED_DEREF: 
                case BYTES_FIXED_STRAIGHT: 
                case BYTES_VAR_DEREF: 
                case BYTES_VAR_STRAIGHT: {
                    BytesRef bytes = new BytesRef();
                    values.getBytes(i, bytes);
                    if (size == -1 || size == bytes.length) continue block10;
                    throw new RuntimeException("field: " + fieldName + " returned wrongly sized bytes, was: " + bytes.length + " should be: " + size);
                }
                case FLOAT_32: {
                    assert (size == 4);
                    values.getFloat(i);
                    continue block10;
                }
                case FLOAT_64: {
                    assert (size == 8);
                    values.getFloat(i);
                    continue block10;
                }
                case VAR_INTS: {
                    assert (size == -1);
                    values.getInt(i);
                    continue block10;
                }
                case FIXED_INTS_16: {
                    assert (size == 2);
                    values.getInt(i);
                    continue block10;
                }
                case FIXED_INTS_32: {
                    assert (size == 4);
                    values.getInt(i);
                    continue block10;
                }
                case FIXED_INTS_64: {
                    assert (size == 8);
                    values.getInt(i);
                    continue block10;
                }
                case FIXED_INTS_8: {
                    assert (size == 1);
                    values.getInt(i);
                    continue block10;
                }
                default: {
                    throw new IllegalArgumentException("Field: " + fieldName + " - no such DocValues type: " + (Object)((Object)type));
                }
            }
        }
        if (type == DocValues.Type.BYTES_FIXED_SORTED || type == DocValues.Type.BYTES_VAR_SORTED) {
            DocValues.SortedSource sortedValues = values.asSortedSource();
            Comparator<BytesRef> comparator = sortedValues.getComparator();
            int lastOrd = -1;
            BytesRef lastBytes = new BytesRef();
            for (int i = 0; i < expectedDocs; ++i) {
                int bytesComp;
                int ordComp;
                int ord = sortedValues.ord(i);
                if (ord < 0 || ord > expectedDocs) {
                    throw new RuntimeException("field: " + fieldName + " ord is out of bounds: " + ord);
                }
                BytesRef bytes = new BytesRef();
                sortedValues.getByOrd(ord, bytes);
                if (lastOrd != -1 && (ordComp = Integer.signum(new Integer(ord).compareTo(new Integer(lastOrd)))) != (bytesComp = Integer.signum(comparator.compare(bytes, lastBytes)))) {
                    throw new RuntimeException("field: " + fieldName + " ord comparison is wrong: " + ordComp + " comparator claims: " + bytesComp);
                }
                lastOrd = ord;
                lastBytes = bytes;
            }
        }
    }

    private Status.DocValuesStatus testDocValues(SegmentInfoPerCommit info, FieldInfos fieldInfos, SegmentReader reader) {
        Status.DocValuesStatus status;
        block5: {
            status = new Status.DocValuesStatus();
            try {
                if (this.infoStream != null) {
                    this.infoStream.print("    test: DocValues........");
                }
                for (FieldInfo fieldInfo : fieldInfos) {
                    if (fieldInfo.hasDocValues()) {
                        ++status.totalValueFields;
                        DocValues docValues = reader.docValues(fieldInfo.name);
                        this.checkDocValues(docValues, fieldInfo.name, fieldInfo.getDocValuesType(), reader.maxDoc());
                        continue;
                    }
                    if (reader.docValues(fieldInfo.name) == null) continue;
                    throw new RuntimeException("field: " + fieldInfo.name + " has docvalues but should omit them!");
                }
                this.msg("OK [" + status.docCount + " total doc Count; Num DocValues Fields " + status.totalValueFields);
            }
            catch (Throwable e) {
                this.msg("ERROR [" + String.valueOf(e.getMessage()) + "]");
                status.error = e;
                if (this.infoStream == null) break block5;
                e.printStackTrace(this.infoStream);
            }
        }
        return status;
    }

    private Status.TermVectorStatus testTermVectors(FieldInfos fieldInfos, SegmentInfoPerCommit info, SegmentReader reader, NumberFormat format) {
        Status.TermVectorStatus status;
        block25: {
            status = new Status.TermVectorStatus();
            FixedBitSet onlyDocIsDeleted = new FixedBitSet(1);
            try {
                if (this.infoStream != null) {
                    this.infoStream.print("    test: term vectors........");
                }
                DocsEnum docs = null;
                DocsAndPositionsEnum postings = null;
                DocsEnum postingsDocs = null;
                DocsAndPositionsEnum postingsPostings = null;
                Bits liveDocs = reader.getLiveDocs();
                Fields postingsFields = this.crossCheckTermVectors ? reader.fields() : null;
                TermsEnum termsEnum = null;
                TermsEnum postingsTermsEnum = null;
                for (int j = 0; j < info.info.getDocCount(); ++j) {
                    boolean doStats;
                    Fields tfv = reader.getTermVectors(j);
                    if (tfv == null) continue;
                    this.checkFields(tfv, null, 1, fieldInfos, false, true);
                    this.checkFields(tfv, onlyDocIsDeleted, 1, fieldInfos, false, true);
                    boolean bl = doStats = liveDocs == null || liveDocs.get(j);
                    if (doStats) {
                        ++status.docCount;
                    }
                    FieldsEnum fieldsEnum = tfv.iterator();
                    String field = null;
                    while ((field = fieldsEnum.next()) != null) {
                        FieldInfo fieldInfo;
                        if (doStats) {
                            ++status.totVectors;
                        }
                        if (!(fieldInfo = fieldInfos.fieldInfo(field)).hasVectors()) {
                            throw new RuntimeException("docID=" + j + " has term vectors for field=" + field + " but FieldInfo has storeTermVector=false");
                        }
                        if (!this.crossCheckTermVectors) continue;
                        Terms terms = tfv.terms(field);
                        termsEnum = terms.iterator(termsEnum);
                        boolean postingsHasFreq = fieldInfo.getIndexOptions().compareTo(FieldInfo.IndexOptions.DOCS_AND_FREQS) >= 0;
                        Terms postingsTerms = postingsFields.terms(field);
                        if (postingsTerms == null) {
                            throw new RuntimeException("vector field=" + field + " does not exist in postings; doc=" + j);
                        }
                        postingsTermsEnum = postingsTerms.iterator(postingsTermsEnum);
                        BytesRef term = null;
                        while ((term = termsEnum.next()) != null) {
                            DocsEnum docs2;
                            boolean hasProx;
                            if ((postings = termsEnum.docsAndPositions(null, postings)) == null) {
                                hasProx = false;
                                docs = termsEnum.docs(null, docs);
                            } else {
                                hasProx = true;
                            }
                            if (hasProx) {
                                assert (postings != null);
                                docs2 = postings;
                            } else {
                                assert (docs != null);
                                docs2 = docs;
                            }
                            if (!postingsTermsEnum.seekExact(term, true)) {
                                throw new RuntimeException("vector term=" + term + " field=" + field + " does not exist in postings; doc=" + j);
                            }
                            if ((postingsPostings = postingsTermsEnum.docsAndPositions(null, postingsPostings)) == null && (postingsDocs = postingsTermsEnum.docs(null, postingsDocs)) == null) {
                                throw new RuntimeException("vector term=" + term + " field=" + field + " does not exist in postings; doc=" + j);
                            }
                            DocsEnum postingsDocs2 = postingsPostings != null ? postingsPostings : postingsDocs;
                            int advanceDoc = postingsDocs2.advance(j);
                            if (advanceDoc != j) {
                                throw new RuntimeException("vector term=" + term + " field=" + field + ": doc=" + j + " was not found in postings (got: " + advanceDoc + ")");
                            }
                            int doc = docs2.nextDoc();
                            if (doc != 0) {
                                throw new RuntimeException("vector for doc " + j + " didn't return docID=0: got docID=" + doc);
                            }
                            if (!postingsHasFreq) continue;
                            int tf = docs2.freq();
                            if (postingsHasFreq && postingsDocs2.freq() != tf) {
                                throw new RuntimeException("vector term=" + term + " field=" + field + " doc=" + j + ": freq=" + tf + " differs from postings freq=" + postingsDocs2.freq());
                            }
                            if (!hasProx) continue;
                            for (int i = 0; i < tf; ++i) {
                                int pos = postings.nextPosition();
                                if (postingsPostings != null) {
                                    int postingsPos = postingsPostings.nextPosition();
                                    if (pos != -1 && postingsPos != -1 && pos != postingsPos) {
                                        throw new RuntimeException("vector term=" + term + " field=" + field + " doc=" + j + ": pos=" + pos + " differs from postings pos=" + postingsPos);
                                    }
                                }
                                int startOffset = postings.startOffset();
                                int endOffset = postings.endOffset();
                                if (postingsPostings == null) continue;
                                int postingsStartOffset = postingsPostings.startOffset();
                                int postingsEndOffset = postingsPostings.endOffset();
                                if (startOffset != -1 && postingsStartOffset != -1 && startOffset != postingsStartOffset) {
                                    throw new RuntimeException("vector term=" + term + " field=" + field + " doc=" + j + ": startOffset=" + startOffset + " differs from postings startOffset=" + postingsStartOffset);
                                }
                                if (endOffset == -1 || postingsEndOffset == -1 || endOffset == postingsEndOffset) continue;
                                throw new RuntimeException("vector term=" + term + " field=" + field + " doc=" + j + ": endOffset=" + endOffset + " differs from postings endOffset=" + postingsEndOffset);
                            }
                        }
                    }
                }
                float vectorAvg = status.docCount == 0 ? 0.0f : (float)status.totVectors / (float)status.docCount;
                this.msg("OK [" + status.totVectors + " total vector count; avg " + format.format(vectorAvg) + " term/freq vector fields per doc]");
            }
            catch (Throwable e) {
                this.msg("ERROR [" + String.valueOf(e.getMessage()) + "]");
                status.error = e;
                if (this.infoStream == null) break block25;
                e.printStackTrace(this.infoStream);
            }
        }
        return status;
    }

    public void fixIndex(Status result, Codec codec) throws IOException {
        if (result.partial) {
            throw new IllegalArgumentException("can only fix an index that was fully checked (this status checked a subset of segments)");
        }
        result.newSegments.changed();
        result.newSegments.commit(result.dir);
    }

    private static boolean testAsserts() {
        assertsOn = true;
        return true;
    }

    private static boolean assertsOn() {
        assert (CheckIndex.testAsserts());
        return assertsOn;
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        boolean doFix = false;
        boolean doCrossCheckTermVectors = false;
        Codec codec = Codec.getDefault();
        boolean verbose = false;
        ArrayList<String> onlySegments = new ArrayList<String>();
        String indexPath = null;
        String dirImpl = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-fix".equals(arg)) {
                doFix = true;
                continue;
            }
            if ("-crossCheckTermVectors".equals(arg)) {
                doCrossCheckTermVectors = true;
                continue;
            }
            if ("-codec".equals(arg)) {
                if (i == args.length - 1) {
                    System.out.println("ERROR: missing name for -codec option");
                    System.exit(1);
                }
                codec = Codec.forName(args[++i]);
                continue;
            }
            if (arg.equals("-verbose")) {
                verbose = true;
                continue;
            }
            if (arg.equals("-segment")) {
                if (i == args.length - 1) {
                    System.out.println("ERROR: missing name for -segment option");
                    System.exit(1);
                }
                onlySegments.add(args[++i]);
                continue;
            }
            if ("-dir-impl".equals(arg)) {
                if (i == args.length - 1) {
                    System.out.println("ERROR: missing value for -dir-impl option");
                    System.exit(1);
                }
                dirImpl = args[++i];
                continue;
            }
            if (indexPath != null) {
                System.out.println("ERROR: unexpected extra argument '" + args[i] + "'");
                System.exit(1);
            }
            indexPath = args[i];
        }
        if (indexPath == null) {
            System.out.println("\nERROR: index path not specified");
            System.out.println("\nUsage: java org.apache.lucene.index.CheckIndex pathToIndex [-fix] [-crossCheckTermVectors] [-segment X] [-segment Y] [-dir-impl X]\n\n  -fix: actually write a new segments_N file, removing any problematic segments\n  -crossCheckTermVectors: verifies that term vectors match postings; THIS IS VERY SLOW!\n  -codec X: when fixing, codec to write the new segments_N file with\n  -verbose: print additional details\n  -segment X: only check the specified segments.  This can be specified multiple\n              times, to check more than one segment, eg '-segment _2 -segment _a'.\n              You can't use this with the -fix option\n  -dir-impl X: use a specific " + FSDirectory.class.getSimpleName() + " implementation. " + "If no package is specified the " + FSDirectory.class.getPackage().getName() + " package will be used.\n" + "\n" + "**WARNING**: -fix should only be used on an emergency basis as it will cause\n" + "documents (perhaps many) to be permanently removed from the index.  Always make\n" + "a backup copy of your index before running this!  Do not run this tool on an index\n" + "that is actively being written to.  You have been warned!\n" + "\n" + "Run without -fix, this tool will open the index, report version information\n" + "and report any exceptions it hits and what action it would take if -fix were\n" + "specified.  With -fix, this tool will remove any segments that have issues and\n" + "write a new segments_N file.  This means all documents contained in the affected\n" + "segments will be removed.\n" + "\n" + "This tool exits with exit code 1 if the index cannot be opened or has any\n" + "corruption, else 0.\n");
            System.exit(1);
        }
        if (!CheckIndex.assertsOn()) {
            System.out.println("\nNOTE: testing will be more thorough if you run java with '-ea:org.apache.lucene...', so assertions are enabled");
        }
        if (onlySegments.size() == 0) {
            onlySegments = null;
        } else if (doFix) {
            System.out.println("ERROR: cannot specify both -fix and -segment");
            System.exit(1);
        }
        System.out.println("\nOpening index @ " + indexPath + "\n");
        FSDirectory dir = null;
        try {
            dir = dirImpl == null ? FSDirectory.open(new File(indexPath)) : CommandLineUtil.newFSDirectory(dirImpl, new File(indexPath));
        }
        catch (Throwable t) {
            System.out.println("ERROR: could not open directory \"" + indexPath + "\"; exiting");
            t.printStackTrace(System.out);
            System.exit(1);
        }
        CheckIndex checker = new CheckIndex(dir);
        checker.setCrossCheckTermVectors(doCrossCheckTermVectors);
        checker.setInfoStream(System.out, verbose);
        Status result = checker.checkIndex(onlySegments);
        if (result.missingSegments) {
            System.exit(1);
        }
        if (!result.clean) {
            if (!doFix) {
                System.out.println("WARNING: would write new segments file, and " + result.totLoseDocCount + " documents would be lost, if -fix were specified\n");
            } else {
                System.out.println("WARNING: " + result.totLoseDocCount + " documents will be lost\n");
                System.out.println("NOTE: will write new segments file in 5 seconds; this will remove " + result.totLoseDocCount + " docs from the index. THIS IS YOUR LAST CHANCE TO CTRL+C!");
                for (int s = 0; s < 5; ++s) {
                    Thread.sleep(1000L);
                    System.out.println("  " + (5 - s) + "...");
                }
                System.out.println("Writing...");
                checker.fixIndex(result, codec);
                System.out.println("OK");
                System.out.println("Wrote new segments file \"" + result.newSegments.getSegmentsFileName() + "\"");
            }
        }
        System.out.println("");
        int exitCode = result.clean ? 0 : 1;
        System.exit(exitCode);
    }

    public static class Status {
        public boolean clean;
        public boolean missingSegments;
        public boolean cantOpenSegments;
        public boolean missingSegmentVersion;
        public String segmentsFileName;
        public int numSegments;
        public List<String> segmentsChecked = new ArrayList<String>();
        public boolean toolOutOfDate;
        public List<SegmentInfoStatus> segmentInfos = new ArrayList<SegmentInfoStatus>();
        public Directory dir;
        SegmentInfos newSegments;
        public int totLoseDocCount;
        public int numBadSegments;
        public boolean partial;
        public int maxSegmentName;
        public boolean validCounter;
        public Map<String, String> userData;

        public static final class DocValuesStatus {
            public int docCount;
            public long totalValueFields;
            public Throwable error = null;
        }

        public static final class TermVectorStatus {
            public int docCount = 0;
            public long totVectors = 0L;
            public Throwable error = null;
        }

        public static final class StoredFieldStatus {
            public int docCount = 0;
            public long totFields = 0L;
            public Throwable error = null;
        }

        public static final class TermIndexStatus {
            public long termCount = 0L;
            public long totFreq = 0L;
            public long totPos = 0L;
            public Throwable error = null;
            public Map<String, BlockTreeTermsReader.Stats> blockTreeStats = null;
        }

        public static final class FieldNormStatus {
            public long totFields = 0L;
            public Throwable error = null;
        }

        public static class SegmentInfoStatus {
            public String name;
            public Codec codec;
            public int docCount;
            public boolean compound;
            public int numFiles;
            public double sizeMB;
            public int docStoreOffset = -1;
            public String docStoreSegment;
            public boolean docStoreCompoundFile;
            public boolean hasDeletions;
            public long deletionsGen;
            public int numDeleted;
            public boolean openReaderPassed;
            int numFields;
            public Map<String, String> diagnostics;
            public FieldNormStatus fieldNormStatus;
            public TermIndexStatus termIndexStatus;
            public StoredFieldStatus storedFieldStatus;
            public TermVectorStatus termVectorStatus;
            public DocValuesStatus docValuesStatus;
        }
    }
}

