/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;

public abstract class AtomicReader
extends IndexReader {
    private final AtomicReaderContext readerContext = new AtomicReaderContext(this);

    protected AtomicReader() {
    }

    @Override
    public final AtomicReaderContext getTopReaderContext() {
        this.ensureOpen();
        return this.readerContext;
    }

    @Deprecated
    public final boolean hasNorms(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        return fi != null && fi.hasNorms();
    }

    public abstract Fields fields() throws IOException;

    @Override
    public final int docFreq(String field, BytesRef term) throws IOException {
        Fields fields = this.fields();
        if (fields == null) {
            return 0;
        }
        Terms terms = fields.terms(field);
        if (terms == null) {
            return 0;
        }
        TermsEnum termsEnum = terms.iterator(null);
        if (termsEnum.seekExact(term, true)) {
            return termsEnum.docFreq();
        }
        return 0;
    }

    public final long totalTermFreq(String field, BytesRef term) throws IOException {
        Fields fields = this.fields();
        if (fields == null) {
            return 0L;
        }
        Terms terms = fields.terms(field);
        if (terms == null) {
            return 0L;
        }
        TermsEnum termsEnum = terms.iterator(null);
        if (termsEnum.seekExact(term, true)) {
            return termsEnum.totalTermFreq();
        }
        return 0L;
    }

    public final Terms terms(String field) throws IOException {
        Fields fields = this.fields();
        if (fields == null) {
            return null;
        }
        return fields.terms(field);
    }

    public final DocsEnum termDocsEnum(Bits liveDocs, String field, BytesRef term) throws IOException {
        return this.termDocsEnum(liveDocs, field, term, 1);
    }

    public final DocsEnum termDocsEnum(Bits liveDocs, String field, BytesRef term, int flags) throws IOException {
        TermsEnum termsEnum;
        Terms terms;
        assert (field != null);
        assert (term != null);
        Fields fields = this.fields();
        if (fields != null && (terms = fields.terms(field)) != null && (termsEnum = terms.iterator(null)).seekExact(term, true)) {
            return termsEnum.docs(liveDocs, null, flags);
        }
        return null;
    }

    public final DocsAndPositionsEnum termPositionsEnum(Bits liveDocs, String field, BytesRef term) throws IOException {
        return this.termPositionsEnum(liveDocs, field, term, 3);
    }

    public final DocsAndPositionsEnum termPositionsEnum(Bits liveDocs, String field, BytesRef term, int flags) throws IOException {
        TermsEnum termsEnum;
        Terms terms;
        assert (field != null);
        assert (term != null);
        Fields fields = this.fields();
        if (fields != null && (terms = fields.terms(field)) != null && (termsEnum = terms.iterator(null)).seekExact(term, true)) {
            return termsEnum.docsAndPositions(liveDocs, null, flags);
        }
        return null;
    }

    public final long getUniqueTermCount() throws IOException {
        Fields fields = this.fields();
        if (fields == null) {
            return 0L;
        }
        return fields.getUniqueTermCount();
    }

    public abstract DocValues docValues(String var1) throws IOException;

    public abstract DocValues normValues(String var1) throws IOException;

    public abstract FieldInfos getFieldInfos();

    public abstract Bits getLiveDocs();
}

