/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.util.BitSet;
import java.util.Collection;
import org.apache.lucene.codecs.LiveDocsFormat;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfoPerCommit;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.MutableBits;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.UnicodeUtil;

public class SimpleTextLiveDocsFormat
extends LiveDocsFormat {
    static final String LIVEDOCS_EXTENSION = "liv";
    static final BytesRef SIZE = new BytesRef("size ");
    static final BytesRef DOC = new BytesRef("  doc ");
    static final BytesRef END = new BytesRef("END");

    @Override
    public MutableBits newLiveDocs(int size) throws IOException {
        return new SimpleTextMutableBits(size);
    }

    @Override
    public MutableBits newLiveDocs(Bits existing) throws IOException {
        SimpleTextBits bits = (SimpleTextBits)existing;
        return new SimpleTextMutableBits((BitSet)bits.bits.clone(), bits.size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bits readLiveDocs(Directory dir, SegmentInfoPerCommit info, IOContext context) throws IOException {
        SimpleTextBits simpleTextBits;
        block9: {
            IndexInput in;
            block8: {
                assert (info.hasDeletions());
                BytesRef scratch = new BytesRef();
                CharsRef scratchUTF16 = new CharsRef();
                String fileName = IndexFileNames.fileNameFromGeneration(info.info.name, LIVEDOCS_EXTENSION, info.getDelGen());
                in = null;
                boolean success = false;
                try {
                    in = dir.openInput(fileName, context);
                    SimpleTextUtil.readLine(in, scratch);
                    assert (StringHelper.startsWith(scratch, SIZE));
                    int size = this.parseIntAt(scratch, SimpleTextLiveDocsFormat.SIZE.length, scratchUTF16);
                    BitSet bits = new BitSet(size);
                    SimpleTextUtil.readLine(in, scratch);
                    while (!scratch.equals(END)) {
                        assert (StringHelper.startsWith(scratch, DOC));
                        int docid = this.parseIntAt(scratch, SimpleTextLiveDocsFormat.DOC.length, scratchUTF16);
                        bits.set(docid);
                        SimpleTextUtil.readLine(in, scratch);
                    }
                    success = true;
                    simpleTextBits = new SimpleTextBits(bits, size);
                    if (!success) break block8;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(in);
                    } else {
                        IOUtils.closeWhileHandlingException(in);
                    }
                    throw throwable;
                }
                IOUtils.close(in);
                break block9;
            }
            IOUtils.closeWhileHandlingException(in);
        }
        return simpleTextBits;
    }

    private int parseIntAt(BytesRef bytes, int offset, CharsRef scratch) {
        UnicodeUtil.UTF8toUTF16(bytes.bytes, bytes.offset + offset, bytes.length - offset, scratch);
        return ArrayUtil.parseInt(scratch.chars, 0, scratch.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeLiveDocs(MutableBits bits, Directory dir, SegmentInfoPerCommit info, int newDelCount, IOContext context) throws IOException {
        block6: {
            IndexOutput out;
            block5: {
                BitSet set = ((SimpleTextBits)((Object)bits)).bits;
                int size = bits.length();
                BytesRef scratch = new BytesRef();
                String fileName = IndexFileNames.fileNameFromGeneration(info.info.name, LIVEDOCS_EXTENSION, info.getNextDelGen());
                out = null;
                boolean success = false;
                try {
                    out = dir.createOutput(fileName, context);
                    SimpleTextUtil.write(out, SIZE);
                    SimpleTextUtil.write(out, Integer.toString(size), scratch);
                    SimpleTextUtil.writeNewline(out);
                    int i = set.nextSetBit(0);
                    while (i >= 0) {
                        SimpleTextUtil.write(out, DOC);
                        SimpleTextUtil.write(out, Integer.toString(i), scratch);
                        SimpleTextUtil.writeNewline(out);
                        i = set.nextSetBit(i + 1);
                    }
                    SimpleTextUtil.write(out, END);
                    SimpleTextUtil.writeNewline(out);
                    success = true;
                    if (!success) break block5;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(out);
                    } else {
                        IOUtils.closeWhileHandlingException(out);
                    }
                    throw throwable;
                }
                IOUtils.close(out);
                break block6;
            }
            IOUtils.closeWhileHandlingException(out);
        }
    }

    @Override
    public void files(SegmentInfoPerCommit info, Collection<String> files) throws IOException {
        if (info.hasDeletions()) {
            files.add(IndexFileNames.fileNameFromGeneration(info.info.name, LIVEDOCS_EXTENSION, info.getDelGen()));
        }
    }

    static class SimpleTextMutableBits
    extends SimpleTextBits
    implements MutableBits {
        SimpleTextMutableBits(int size) {
            this(new BitSet(size), size);
            this.bits.set(0, size);
        }

        SimpleTextMutableBits(BitSet bits, int size) {
            super(bits, size);
        }

        @Override
        public void clear(int bit) {
            this.bits.clear(bit);
        }
    }

    static class SimpleTextBits
    implements Bits {
        final BitSet bits;
        final int size;

        SimpleTextBits(BitSet bits, int size) {
            this.bits = bits;
            this.size = size;
        }

        @Override
        public boolean get(int index) {
            return this.bits.get(index);
        }

        @Override
        public int length() {
            return this.size;
        }
    }
}

