/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene40.values;

import java.io.IOException;
import org.apache.lucene.codecs.DocValuesArraySource;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.lucene40.values.FixedStraightBytesImpl;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.IOUtils;

public class Floats {
    protected static final String CODEC_NAME = "Floats";
    protected static final int VERSION_START = 0;
    protected static final int VERSION_CURRENT = 0;

    public static DocValuesConsumer getWriter(Directory dir, String id, Counter bytesUsed, IOContext context, DocValues.Type type) {
        return new FloatsWriter(dir, id, bytesUsed, context, type);
    }

    public static DocValues getValues(Directory dir, String id, int maxDoc, IOContext context, DocValues.Type type) throws IOException {
        return new FloatsReader(dir, id, maxDoc, context, type);
    }

    private static int typeToSize(DocValues.Type type) {
        switch (type) {
            case FLOAT_32: {
                return 4;
            }
            case FLOAT_64: {
                return 8;
            }
        }
        throw new IllegalStateException("illegal type " + (Object)((Object)type));
    }

    static final class FloatsReader
    extends FixedStraightBytesImpl.FixedStraightReader {
        final DocValuesArraySource arrayTemplate;

        FloatsReader(Directory dir, String id, int maxDoc, IOContext context, DocValues.Type type) throws IOException {
            super(dir, id, Floats.CODEC_NAME, 0, maxDoc, context, type);
            this.arrayTemplate = DocValuesArraySource.forType(type);
            assert (this.size == 4 || this.size == 8) : "wrong size=" + this.size + " type=" + (Object)((Object)type) + " id=" + id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DocValues.Source load() throws IOException {
            DocValuesArraySource docValuesArraySource;
            IndexInput indexInput = this.cloneData();
            try {
                docValuesArraySource = this.arrayTemplate.newFromInput(indexInput, this.maxDoc);
            }
            catch (Throwable throwable) {
                IOUtils.close(indexInput);
                throw throwable;
            }
            IOUtils.close(indexInput);
            return docValuesArraySource;
        }
    }

    static final class FloatsWriter
    extends FixedStraightBytesImpl.Writer {
        private final int size;
        private final DocValuesArraySource template;

        public FloatsWriter(Directory dir, String id, Counter bytesUsed, IOContext context, DocValues.Type type) {
            super(dir, id, Floats.CODEC_NAME, 0, bytesUsed, context);
            this.size = Floats.typeToSize(type);
            this.bytesRef = new BytesRef(this.size);
            this.bytesRef.length = this.size;
            this.template = DocValuesArraySource.forType(type);
            assert (this.template != null);
        }

        @Override
        protected boolean tryBulkMerge(DocValues docValues) {
            return super.tryBulkMerge(docValues) && docValues.getType() == this.template.getType();
        }

        @Override
        public void add(int docID, IndexableField value) throws IOException {
            this.template.toBytes(value.numericValue().doubleValue(), this.bytesRef);
            this.bytesSpareField.setBytesValue(this.bytesRef);
            super.add(docID, this.bytesSpareField);
        }

        @Override
        protected void setMergeBytes(DocValues.Source source, int sourceDoc) {
            double value = source.getFloat(sourceDoc);
            this.template.toBytes(value, this.bytesRef);
        }
    }
}

