/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene40;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldInfosReader;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;

public class Lucene40FieldInfosReader
extends FieldInfosReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldInfos read(Directory directory, String segmentName, IOContext iocontext) throws IOException {
        String fileName = IndexFileNames.segmentFileName(segmentName, "", "fnm");
        IndexInput input = directory.openInput(fileName, iocontext);
        try {
            CodecUtil.checkHeader(input, "Lucene40FieldInfos", 0, 0);
            int size = input.readVInt();
            FieldInfo[] infos = new FieldInfo[size];
            for (int i = 0; i < size; ++i) {
                boolean storePayloads;
                String name = input.readString();
                int fieldNumber = input.readVInt();
                byte bits = input.readByte();
                boolean isIndexed = (bits & 1) != 0;
                boolean storeTermVector = (bits & 2) != 0;
                boolean omitNorms = (bits & 0x10) != 0;
                boolean bl = storePayloads = (bits & 0x20) != 0;
                FieldInfo.IndexOptions indexOptions = !isIndexed ? null : ((bits & 0x40) != 0 ? FieldInfo.IndexOptions.DOCS_ONLY : ((bits & 0xFFFFFF80) != 0 ? FieldInfo.IndexOptions.DOCS_AND_FREQS : ((bits & 4) != 0 ? FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS : FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS)));
                if (isIndexed && indexOptions.compareTo(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) {
                    storePayloads = false;
                }
                byte val = input.readByte();
                DocValues.Type docValuesType = this.getDocValuesType((byte)(val & 0xF));
                DocValues.Type normsType = this.getDocValuesType((byte)(val >>> 4 & 0xF));
                Map<String, String> attributes = input.readStringStringMap();
                infos[i] = new FieldInfo(name, isIndexed, fieldNumber, storeTermVector, omitNorms, storePayloads, indexOptions, docValuesType, normsType, Collections.unmodifiableMap(attributes));
            }
            if (input.getFilePointer() != input.length()) {
                throw new CorruptIndexException("did not read all bytes from file \"" + fileName + "\": read " + input.getFilePointer() + " vs size " + input.length() + " (resource: " + input + ")");
            }
            FieldInfos fieldInfos = new FieldInfos(infos);
            return fieldInfos;
        }
        finally {
            input.close();
        }
    }

    public DocValues.Type getDocValuesType(byte b) {
        switch (b) {
            case 0: {
                return null;
            }
            case 1: {
                return DocValues.Type.VAR_INTS;
            }
            case 2: {
                return DocValues.Type.FLOAT_32;
            }
            case 3: {
                return DocValues.Type.FLOAT_64;
            }
            case 4: {
                return DocValues.Type.BYTES_FIXED_STRAIGHT;
            }
            case 5: {
                return DocValues.Type.BYTES_FIXED_DEREF;
            }
            case 6: {
                return DocValues.Type.BYTES_VAR_STRAIGHT;
            }
            case 7: {
                return DocValues.Type.BYTES_VAR_DEREF;
            }
            case 8: {
                return DocValues.Type.FIXED_INTS_16;
            }
            case 9: {
                return DocValues.Type.FIXED_INTS_32;
            }
            case 10: {
                return DocValues.Type.FIXED_INTS_64;
            }
            case 11: {
                return DocValues.Type.FIXED_INTS_8;
            }
            case 12: {
                return DocValues.Type.BYTES_FIXED_SORTED;
            }
            case 13: {
                return DocValues.Type.BYTES_VAR_SORTED;
            }
        }
        throw new IllegalStateException("unhandled indexValues type " + b);
    }
}

