/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import java.io.Closeable;
import java.io.IOException;
import java.util.Comparator;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FieldsEnum;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;

public abstract class TermVectorsWriter
implements Closeable {
    public abstract void startDocument(int var1) throws IOException;

    public abstract void startField(FieldInfo var1, int var2, boolean var3, boolean var4) throws IOException;

    public abstract void startTerm(BytesRef var1, int var2) throws IOException;

    public abstract void addPosition(int var1, int var2, int var3) throws IOException;

    public abstract void abort();

    public abstract void finish(FieldInfos var1, int var2) throws IOException;

    public void addProx(int numProx, DataInput positions, DataInput offsets) throws IOException {
        int position = 0;
        int lastOffset = 0;
        for (int i = 0; i < numProx; ++i) {
            int startOffset;
            int endOffset;
            position = positions == null ? -1 : (position += positions.readVInt());
            if (offsets == null) {
                endOffset = -1;
                startOffset = -1;
            } else {
                startOffset = lastOffset + offsets.readVInt();
                lastOffset = endOffset = startOffset + offsets.readVInt();
            }
            this.addPosition(position, startOffset, endOffset);
        }
    }

    public int merge(MergeState mergeState) throws IOException {
        int docCount = 0;
        for (AtomicReader reader : mergeState.readers) {
            int maxDoc = reader.maxDoc();
            Bits liveDocs = reader.getLiveDocs();
            for (int docID = 0; docID < maxDoc; ++docID) {
                if (liveDocs != null && !liveDocs.get(docID)) continue;
                Fields vectors = reader.getTermVectors(docID);
                this.addAllDocVectors(vectors, mergeState.fieldInfos);
                ++docCount;
                mergeState.checkAbort.work(300.0);
            }
        }
        this.finish(mergeState.fieldInfos, docCount);
        return docCount;
    }

    protected final void addAllDocVectors(Fields vectors, FieldInfos fieldInfos) throws IOException {
        String fieldName;
        if (vectors == null) {
            this.startDocument(0);
            return;
        }
        int numFields = vectors.size();
        if (numFields == -1) {
            throw new IllegalStateException("vectors.size() must be implemented (it returned -1)");
        }
        this.startDocument(numFields);
        FieldsEnum fieldsEnum = vectors.iterator();
        String lastFieldName = null;
        while ((fieldName = fieldsEnum.next()) != null) {
            FieldInfo fieldInfo = fieldInfos.fieldInfo(fieldName);
            assert (lastFieldName == null || fieldName.compareTo(lastFieldName) > 0) : "lastFieldName=" + lastFieldName + " fieldName=" + fieldName;
            lastFieldName = fieldName;
            Terms terms = fieldsEnum.terms();
            if (terms == null) continue;
            int numTerms = (int)terms.size();
            if (numTerms == -1) {
                throw new IllegalStateException("terms.size() must be implemented (it returned -1)");
            }
            TermsEnum termsEnum = terms.iterator(null);
            DocsAndPositionsEnum docsAndPositionsEnum = null;
            boolean startedField = false;
            int termCount = 0;
            while (termsEnum.next() != null) {
                ++termCount;
                int freq = (int)termsEnum.totalTermFreq();
                if (startedField) {
                    this.startTerm(termsEnum.term(), freq);
                }
                docsAndPositionsEnum = termsEnum.docsAndPositions(null, null);
                boolean hasOffsets = false;
                boolean hasPositions = false;
                if (docsAndPositionsEnum != null) {
                    int docID = docsAndPositionsEnum.nextDoc();
                    assert (docID != Integer.MAX_VALUE);
                    assert (docsAndPositionsEnum.freq() == freq);
                    for (int posUpto = 0; posUpto < freq; ++posUpto) {
                        int pos = docsAndPositionsEnum.nextPosition();
                        int startOffset = docsAndPositionsEnum.startOffset();
                        int endOffset = docsAndPositionsEnum.endOffset();
                        if (!startedField) {
                            assert (numTerms > 0);
                            hasPositions = pos != -1;
                            hasOffsets = startOffset != -1;
                            this.startField(fieldInfo, numTerms, hasPositions, hasOffsets);
                            this.startTerm(termsEnum.term(), freq);
                            startedField = true;
                        }
                        if (hasOffsets) {
                            assert (startOffset != -1);
                            assert (endOffset != -1);
                        }
                        assert (!hasPositions || pos >= 0);
                        this.addPosition(pos, startOffset, endOffset);
                    }
                    continue;
                }
                if (startedField) continue;
                assert (numTerms > 0);
                this.startField(fieldInfo, numTerms, hasPositions, hasOffsets);
                this.startTerm(termsEnum.term(), freq);
                startedField = true;
            }
            assert (termCount == numTerms);
        }
    }

    public abstract Comparator<BytesRef> getComparator() throws IOException;
}

