/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.TermsIndexReaderBase;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.packed.PackedInts;

public class FixedGapTermsIndexReader
extends TermsIndexReaderBase {
    private long totalIndexInterval;
    private int indexDivisor;
    private final int indexInterval;
    private IndexInput in;
    private volatile boolean indexLoaded;
    private final Comparator<BytesRef> termComp;
    private static final int PAGED_BYTES_BITS = 15;
    private final PagedBytes termBytes;
    private PagedBytes.Reader termBytesReader;
    final HashMap<FieldInfo, FieldIndexData> fields;
    protected long dirOffset;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FixedGapTermsIndexReader(Directory dir, FieldInfos fieldInfos, String segment, int indexDivisor, Comparator<BytesRef> termComp, String segmentSuffix, IOContext context) throws IOException {
        boolean success;
        block11: {
            this.termBytes = new PagedBytes(15);
            this.fields = new HashMap();
            this.termComp = termComp;
            assert (indexDivisor == -1 || indexDivisor > 0);
            this.in = dir.openInput(IndexFileNames.segmentFileName(segment, segmentSuffix, "tii"), context);
            success = false;
            try {
                this.readHeader(this.in);
                this.indexInterval = this.in.readInt();
                this.indexDivisor = indexDivisor;
                this.totalIndexInterval = indexDivisor < 0 ? (long)this.indexInterval : (long)(this.indexInterval * indexDivisor);
                assert (this.totalIndexInterval > 0L);
                this.seekDir(this.in, this.dirOffset);
                int numFields = this.in.readVInt();
                for (int i = 0; i < numFields; ++i) {
                    int field = this.in.readVInt();
                    int numIndexTerms = this.in.readVInt();
                    long termsStart = this.in.readVLong();
                    long indexStart = this.in.readVLong();
                    long packedIndexStart = this.in.readVLong();
                    long packedOffsetsStart = this.in.readVLong();
                    assert (packedIndexStart >= indexStart) : "packedStart=" + packedIndexStart + " indexStart=" + indexStart + " numIndexTerms=" + numIndexTerms + " seg=" + segment;
                    FieldInfo fieldInfo = fieldInfos.fieldInfo(field);
                    this.fields.put(fieldInfo, new FieldIndexData(fieldInfo, numIndexTerms, indexStart, termsStart, packedIndexStart, packedOffsetsStart));
                }
                success = true;
                if (success) break block11;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(this.in);
                }
                if (indexDivisor > 0) {
                    this.in.close();
                    this.in = null;
                    if (success) {
                        this.indexLoaded = true;
                    }
                    this.termBytesReader = this.termBytes.freeze(true);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(this.in);
        }
        if (indexDivisor > 0) {
            this.in.close();
            this.in = null;
            if (success) {
                this.indexLoaded = true;
            }
            this.termBytesReader = this.termBytes.freeze(true);
        }
    }

    @Override
    public int getDivisor() {
        return this.indexDivisor;
    }

    protected void readHeader(IndexInput input) throws IOException {
        CodecUtil.checkHeader(input, "SIMPLE_STANDARD_TERMS_INDEX", 0, 0);
        this.dirOffset = input.readLong();
    }

    @Override
    public boolean supportsOrd() {
        return true;
    }

    @Override
    public TermsIndexReaderBase.FieldIndexEnum getFieldEnum(FieldInfo fieldInfo) {
        FieldIndexData fieldData = this.fields.get(fieldInfo);
        if (fieldData.coreIndex == null) {
            return null;
        }
        return new IndexEnum(fieldData.coreIndex);
    }

    @Override
    public void close() throws IOException {
        if (this.in != null && !this.indexLoaded) {
            this.in.close();
        }
    }

    protected void seekDir(IndexInput input, long dirOffset) throws IOException {
        input.seek(dirOffset);
    }

    private final class FieldIndexData {
        volatile CoreFieldIndex coreIndex;
        private final long indexStart;
        private final long termsStart;
        private final long packedIndexStart;
        private final long packedOffsetsStart;
        private final int numIndexTerms;

        public FieldIndexData(FieldInfo fieldInfo, int numIndexTerms, long indexStart, long termsStart, long packedIndexStart, long packedOffsetsStart) throws IOException {
            this.termsStart = termsStart;
            this.indexStart = indexStart;
            this.packedIndexStart = packedIndexStart;
            this.packedOffsetsStart = packedOffsetsStart;
            this.numIndexTerms = numIndexTerms;
            if (FixedGapTermsIndexReader.this.indexDivisor > 0) {
                this.loadTermsIndex();
            }
        }

        private void loadTermsIndex() throws IOException {
            if (this.coreIndex == null) {
                this.coreIndex = new CoreFieldIndex(this.indexStart, this.termsStart, this.packedIndexStart, this.packedOffsetsStart, this.numIndexTerms);
            }
        }

        private final class CoreFieldIndex {
            final long termBytesStart;
            final PackedInts.Reader termOffsets;
            final PackedInts.Reader termsDictOffsets;
            final int numIndexTerms;
            final long termsStart;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public CoreFieldIndex(long indexStart, long termsStart, long packedIndexStart, long packedOffsetsStart, int numIndexTerms) throws IOException {
                block15: {
                    this.termsStart = termsStart;
                    this.termBytesStart = FixedGapTermsIndexReader.this.termBytes.getPointer();
                    IndexInput clone = (IndexInput)FixedGapTermsIndexReader.this.in.clone();
                    clone.seek(indexStart);
                    assert (FixedGapTermsIndexReader.this.indexDivisor > 0);
                    this.numIndexTerms = 1 + (numIndexTerms - 1) / FixedGapTermsIndexReader.this.indexDivisor;
                    assert (this.numIndexTerms > 0) : "numIndexTerms=" + numIndexTerms + " indexDivisor=" + FixedGapTermsIndexReader.access$300(fieldIndexData.FixedGapTermsIndexReader.this);
                    if (FixedGapTermsIndexReader.this.indexDivisor == 1) {
                        try {
                            long numTermBytes = packedIndexStart - indexStart;
                            FixedGapTermsIndexReader.this.termBytes.copy(clone, numTermBytes);
                            this.termsDictOffsets = PackedInts.getReader(clone);
                            assert (this.termsDictOffsets.size() == numIndexTerms);
                            this.termOffsets = PackedInts.getReader(clone);
                            assert (this.termOffsets.size() == 1 + numIndexTerms);
                            break block15;
                        }
                        finally {
                            clone.close();
                        }
                    }
                    IndexInput clone1 = (IndexInput)FixedGapTermsIndexReader.this.in.clone();
                    IndexInput clone2 = (IndexInput)FixedGapTermsIndexReader.this.in.clone();
                    try {
                        clone1.seek(packedIndexStart);
                        PackedInts.ReaderIterator termsDictOffsetsIter = PackedInts.getReaderIterator(clone1, 1024);
                        clone2.seek(packedOffsetsStart);
                        PackedInts.ReaderIterator termOffsetsIter = PackedInts.getReaderIterator(clone2, 1024);
                        PackedInts.Mutable termsDictOffsetsM = PackedInts.getMutable(this.numIndexTerms, termsDictOffsetsIter.getBitsPerValue(), 0.2f);
                        PackedInts.Mutable termOffsetsM = PackedInts.getMutable(this.numIndexTerms + 1, termOffsetsIter.getBitsPerValue(), 0.2f);
                        this.termsDictOffsets = termsDictOffsetsM;
                        this.termOffsets = termOffsetsM;
                        int upto = 0;
                        long termOffsetUpto = 0L;
                        while (upto < this.numIndexTerms) {
                            termsDictOffsetsM.set(upto, termsDictOffsetsIter.next());
                            termOffsetsM.set(upto, termOffsetUpto);
                            long termOffset = termOffsetsIter.next();
                            long nextTermOffset = termOffsetsIter.next();
                            int numTermBytes = (int)(nextTermOffset - termOffset);
                            clone.seek(indexStart + termOffset);
                            assert (indexStart + termOffset < clone.length()) : "indexStart=" + indexStart + " termOffset=" + termOffset + " len=" + clone.length();
                            assert (indexStart + termOffset + (long)numTermBytes < clone.length());
                            FixedGapTermsIndexReader.this.termBytes.copy(clone, numTermBytes);
                            termOffsetUpto += (long)numTermBytes;
                            if (++upto == this.numIndexTerms) break;
                            termsDictOffsetsIter.next();
                            for (int i = 0; i < FixedGapTermsIndexReader.this.indexDivisor - 2; ++i) {
                                termOffsetsIter.next();
                                termsDictOffsetsIter.next();
                            }
                        }
                        termOffsetsM.set(upto, termOffsetUpto);
                    }
                    finally {
                        clone1.close();
                        clone2.close();
                        clone.close();
                    }
                }
            }
        }
    }

    private class IndexEnum
    extends TermsIndexReaderBase.FieldIndexEnum {
        private final FieldIndexData.CoreFieldIndex fieldIndex;
        private final BytesRef term = new BytesRef();
        private long ord;

        public IndexEnum(FieldIndexData.CoreFieldIndex fieldIndex) {
            this.fieldIndex = fieldIndex;
        }

        @Override
        public BytesRef term() {
            return this.term;
        }

        @Override
        public long seek(BytesRef target) {
            int lo = 0;
            int hi = this.fieldIndex.numIndexTerms - 1;
            assert (FixedGapTermsIndexReader.this.totalIndexInterval > 0L) : "totalIndexInterval=" + FixedGapTermsIndexReader.access$000(FixedGapTermsIndexReader.this);
            while (hi >= lo) {
                int mid = lo + hi >>> 1;
                long offset = this.fieldIndex.termOffsets.get(mid);
                int length = (int)(this.fieldIndex.termOffsets.get(1 + mid) - offset);
                FixedGapTermsIndexReader.this.termBytesReader.fillSlice(this.term, this.fieldIndex.termBytesStart + offset, length);
                int delta = FixedGapTermsIndexReader.this.termComp.compare(target, this.term);
                if (delta < 0) {
                    hi = mid - 1;
                    continue;
                }
                if (delta > 0) {
                    lo = mid + 1;
                    continue;
                }
                assert (mid >= 0);
                this.ord = (long)mid * FixedGapTermsIndexReader.this.totalIndexInterval;
                return this.fieldIndex.termsStart + this.fieldIndex.termsDictOffsets.get(mid);
            }
            if (hi < 0) {
                assert (hi == -1);
                hi = 0;
            }
            long offset = this.fieldIndex.termOffsets.get(hi);
            int length = (int)(this.fieldIndex.termOffsets.get(1 + hi) - offset);
            FixedGapTermsIndexReader.this.termBytesReader.fillSlice(this.term, this.fieldIndex.termBytesStart + offset, length);
            this.ord = (long)hi * FixedGapTermsIndexReader.this.totalIndexInterval;
            return this.fieldIndex.termsStart + this.fieldIndex.termsDictOffsets.get(hi);
        }

        @Override
        public long next() {
            int idx = 1 + (int)(this.ord / FixedGapTermsIndexReader.this.totalIndexInterval);
            if (idx >= this.fieldIndex.numIndexTerms) {
                return -1L;
            }
            this.ord += FixedGapTermsIndexReader.this.totalIndexInterval;
            long offset = this.fieldIndex.termOffsets.get(idx);
            int length = (int)(this.fieldIndex.termOffsets.get(1 + idx) - offset);
            FixedGapTermsIndexReader.this.termBytesReader.fillSlice(this.term, this.fieldIndex.termBytesStart + offset, length);
            return this.fieldIndex.termsStart + this.fieldIndex.termsDictOffsets.get(idx);
        }

        @Override
        public long ord() {
            return this.ord;
        }

        @Override
        public long seek(long ord) {
            int idx = (int)(ord / FixedGapTermsIndexReader.this.totalIndexInterval);
            assert (idx < this.fieldIndex.numIndexTerms);
            long offset = this.fieldIndex.termOffsets.get(idx);
            int length = (int)(this.fieldIndex.termOffsets.get(1 + idx) - offset);
            FixedGapTermsIndexReader.this.termBytesReader.fillSlice(this.term, this.fieldIndex.termBytesStart + offset, length);
            this.ord = (long)idx * FixedGapTermsIndexReader.this.totalIndexInterval;
            return this.fieldIndex.termsStart + this.fieldIndex.termsDictOffsets.get(idx);
        }
    }
}

