/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.packed.PackedInts;

final class Packed64SingleBlockReaderIterator
extends PackedInts.ReaderIteratorImpl {
    private long pending = 0L;
    private int shift = 64;
    private final long mask;
    private int position;

    Packed64SingleBlockReaderIterator(int valueCount, int bitsPerValue, IndexInput in) throws IOException {
        super(valueCount, bitsPerValue, in);
        this.mask = -1L << bitsPerValue ^ 0xFFFFFFFFFFFFFFFFL;
        this.position = -1;
    }

    @Override
    public long next() throws IOException {
        if (this.shift + this.bitsPerValue > 64) {
            this.pending = this.in.readLong();
            this.shift = 0;
        }
        long next = this.pending >>> this.shift & this.mask;
        this.shift += this.bitsPerValue;
        ++this.position;
        return next;
    }

    @Override
    public int ord() {
        return this.position;
    }

    @Override
    public long advance(int ord) throws IOException {
        assert (ord < this.valueCount) : "ord must be less than valueCount";
        assert (ord > this.position) : "ord must be greater than the current position";
        int valuesPerBlock = 64 / this.bitsPerValue;
        long targetBlock = ord / valuesPerBlock;
        long nextBlock = (this.position + valuesPerBlock) / valuesPerBlock;
        long blocksToSkip = targetBlock - nextBlock;
        if (blocksToSkip > 0L) {
            long skip = blocksToSkip << 3;
            long filePointer = this.in.getFilePointer();
            this.in.seek(filePointer + skip);
            this.shift = 64;
            int offsetInBlock = ord % valuesPerBlock;
            for (int i = 0; i < offsetInBlock; ++i) {
                this.next();
            }
        } else {
            for (int i = this.position; i < ord - 1; ++i) {
                this.next();
            }
        }
        this.position = ord - 1;
        return this.next();
    }
}

