/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;

public final class NamedSPILoader<S extends NamedSPI>
implements Iterable<S> {
    private final Map<String, S> services;
    @Deprecated
    private final Map<String, S> modifiableServices;
    private final Class<S> clazz;

    public NamedSPILoader(Class<S> clazz) {
        this.clazz = clazz;
        ServiceLoader<NamedSPI> loader = ServiceLoader.load(clazz);
        LinkedHashMap<String, S> services = new LinkedHashMap<String, S>();
        for (NamedSPI service : loader) {
            String name = service.getName();
            if (services.containsKey(name)) continue;
            assert (NamedSPILoader.checkServiceName(name));
            services.put(name, service);
        }
        this.modifiableServices = services;
        this.services = Collections.unmodifiableMap(services);
    }

    public static boolean checkServiceName(String name) {
        if (name.length() >= 128) {
            throw new IllegalArgumentException("Illegal service name: '" + name + "' is too long (must be < 128 chars).");
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (NamedSPILoader.isLetter(c) || NamedSPILoader.isDigit(c)) continue;
            throw new IllegalArgumentException("Illegal service name: '" + name + "' must be simple ascii alphanumeric.");
        }
        return true;
    }

    private static boolean isLetter(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z';
    }

    private static boolean isDigit(char c) {
        return '0' <= c && c <= '9';
    }

    public S lookup(String name) {
        NamedSPI service = (NamedSPI)this.services.get(name);
        if (service != null) {
            return (S)service;
        }
        throw new IllegalArgumentException("A SPI class of type " + this.clazz.getName() + " with name '" + name + "' does not exist. " + "You need to add the corresponding JAR file supporting this SPI to your classpath." + "The current classpath supports the following names: " + this.availableServices());
    }

    public Set<String> availableServices() {
        return this.services.keySet();
    }

    @Override
    public Iterator<S> iterator() {
        return this.services.values().iterator();
    }

    public static interface NamedSPI {
        public String getName();
    }
}

