/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Weight;

public abstract class Scorer
extends DocIdSetIterator {
    protected final Weight weight;

    protected Scorer(Weight weight) {
        this.weight = weight;
    }

    public void score(Collector collector) throws IOException {
        int doc;
        collector.setScorer(this);
        while ((doc = this.nextDoc()) != Integer.MAX_VALUE) {
            collector.collect(doc);
        }
    }

    public boolean score(Collector collector, int max, int firstDocID) throws IOException {
        collector.setScorer(this);
        int doc = firstDocID;
        while (doc < max) {
            collector.collect(doc);
            doc = this.nextDoc();
        }
        return doc != Integer.MAX_VALUE;
    }

    public abstract float score() throws IOException;

    public float freq() throws IOException {
        throw new UnsupportedOperationException(this + " does not implement freq()");
    }

    public Weight getWeight() {
        return this.weight;
    }

    public Collection<ChildScorer> getChildren() {
        return Collections.emptyList();
    }

    public static class ChildScorer {
        public final Scorer child;
        public final String relationship;

        public ChildScorer(Scorer child, String relationship) {
            this.child = child;
            this.relationship = relationship;
        }
    }
}

