/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;

final class MatchOnlyTermScorer
extends Scorer {
    private final DocsEnum docsEnum;
    private final Similarity.ExactSimScorer docScorer;

    MatchOnlyTermScorer(Weight weight, DocsEnum td, Similarity.ExactSimScorer docScorer) throws IOException {
        super(weight);
        this.docScorer = docScorer;
        this.docsEnum = td;
    }

    @Override
    public int docID() {
        return this.docsEnum.docID();
    }

    @Override
    public float freq() {
        return 1.0f;
    }

    @Override
    public int nextDoc() throws IOException {
        return this.docsEnum.nextDoc();
    }

    @Override
    public float score() {
        assert (this.docID() != Integer.MAX_VALUE);
        return this.docScorer.score(this.docsEnum.docID(), 1);
    }

    @Override
    public int advance(int target) throws IOException {
        return this.docsEnum.advance(target);
    }

    public String toString() {
        return "scorer(" + this.weight + ")";
    }
}

