/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.sep;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.IntsRef;

public abstract class IntIndexInput
implements Closeable {
    public abstract Reader reader() throws IOException;

    @Override
    public abstract void close() throws IOException;

    public abstract Index index() throws IOException;

    public static abstract class Reader {
        private IntsRef bulkResult;

        public abstract int next() throws IOException;

        public IntsRef read(int count) throws IOException {
            if (this.bulkResult == null) {
                this.bulkResult = new IntsRef();
                this.bulkResult.ints = new int[count];
            } else {
                this.bulkResult.grow(count);
            }
            for (int i = 0; i < count; ++i) {
                this.bulkResult.ints[i] = this.next();
            }
            this.bulkResult.length = count;
            return this.bulkResult;
        }
    }

    public static abstract class Index {
        public abstract void read(DataInput var1, boolean var2) throws IOException;

        public abstract void seek(Reader var1) throws IOException;

        public abstract void set(Index var1);

        public abstract Index clone();
    }
}

