/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.pulsing;

import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.TermState;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Attribute;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;

public class PulsingPostingsReader
extends PostingsReaderBase {
    final PostingsReaderBase wrappedPostingsReader;
    int maxPositions;

    public PulsingPostingsReader(PostingsReaderBase wrappedPostingsReader) throws IOException {
        this.wrappedPostingsReader = wrappedPostingsReader;
    }

    @Override
    public void init(IndexInput termsIn) throws IOException {
        CodecUtil.checkHeader(termsIn, "PulsedPostingsWriter", 0, 0);
        this.maxPositions = termsIn.readVInt();
        this.wrappedPostingsReader.init(termsIn);
    }

    @Override
    public void readTermsBlock(IndexInput termsIn, FieldInfo fieldInfo, BlockTermState _termState) throws IOException {
        PulsingTermState termState = (PulsingTermState)_termState;
        if (termState.inlinedBytes == null) {
            PulsingTermState.access$002(termState, new byte[128]);
            termState.inlinedBytesReader = new ByteArrayDataInput();
        }
        int len = termsIn.readVInt();
        if (termState.inlinedBytes.length < len) {
            PulsingTermState.access$002(termState, new byte[ArrayUtil.oversize(len, 1)]);
        }
        termsIn.readBytes(termState.inlinedBytes, 0, len);
        termState.inlinedBytesReader.reset(termState.inlinedBytes);
        ((PulsingTermState)termState).wrappedTermState.termBlockOrd = 0;
        this.wrappedPostingsReader.readTermsBlock(termsIn, fieldInfo, termState.wrappedTermState);
    }

    @Override
    public BlockTermState newTermState() throws IOException {
        PulsingTermState state = new PulsingTermState();
        state.wrappedTermState = this.wrappedPostingsReader.newTermState();
        return state;
    }

    @Override
    public void nextTerm(FieldInfo fieldInfo, BlockTermState _termState) throws IOException {
        long count;
        PulsingTermState termState = (PulsingTermState)_termState;
        long l = count = fieldInfo.getIndexOptions().compareTo(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0 ? termState.totalTermFreq : (long)termState.docFreq;
        if (count <= (long)this.maxPositions) {
            termState.postingsSize = termState.inlinedBytesReader.readVInt();
            if (termState.postings == null || termState.postings.length < termState.postingsSize) {
                PulsingTermState.access$402(termState, new byte[ArrayUtil.oversize(termState.postingsSize, 1)]);
            }
            termState.inlinedBytesReader.readBytes(termState.postings, 0, termState.postingsSize);
        } else {
            termState.postingsSize = -1;
            ((PulsingTermState)termState).wrappedTermState.docFreq = termState.docFreq;
            ((PulsingTermState)termState).wrappedTermState.totalTermFreq = termState.totalTermFreq;
            this.wrappedPostingsReader.nextTerm(fieldInfo, termState.wrappedTermState);
            ++((PulsingTermState)termState).wrappedTermState.termBlockOrd;
        }
    }

    @Override
    public DocsEnum docs(FieldInfo field, BlockTermState _termState, Bits liveDocs, DocsEnum reuse, boolean needsFreqs) throws IOException {
        PulsingTermState termState = (PulsingTermState)_termState;
        if (termState.postingsSize != -1) {
            PulsingDocsEnum postings;
            if (reuse instanceof PulsingDocsEnum) {
                postings = (PulsingDocsEnum)reuse;
                if (!postings.canReuse(field)) {
                    postings = new PulsingDocsEnum(field);
                }
            } else {
                PulsingDocsEnum previous = (PulsingDocsEnum)this.getOther(reuse);
                postings = previous != null && previous.canReuse(field) ? previous : new PulsingDocsEnum(field);
            }
            if (reuse != postings) {
                this.setOther(postings, reuse);
            }
            return postings.reset(liveDocs, termState);
        }
        if (reuse instanceof PulsingDocsEnum) {
            DocsEnum wrapped = this.wrappedPostingsReader.docs(field, termState.wrappedTermState, liveDocs, this.getOther(reuse), needsFreqs);
            this.setOther(wrapped, reuse);
            return wrapped;
        }
        return this.wrappedPostingsReader.docs(field, termState.wrappedTermState, liveDocs, reuse, needsFreqs);
    }

    @Override
    public DocsAndPositionsEnum docsAndPositions(FieldInfo field, BlockTermState _termState, Bits liveDocs, DocsAndPositionsEnum reuse, boolean needsOffsets) throws IOException {
        PulsingTermState termState = (PulsingTermState)_termState;
        if (termState.postingsSize != -1) {
            PulsingDocsAndPositionsEnum postings;
            if (reuse instanceof PulsingDocsAndPositionsEnum) {
                postings = (PulsingDocsAndPositionsEnum)reuse;
                if (!postings.canReuse(field)) {
                    postings = new PulsingDocsAndPositionsEnum(field);
                }
            } else {
                PulsingDocsAndPositionsEnum previous = (PulsingDocsAndPositionsEnum)this.getOther(reuse);
                postings = previous != null && previous.canReuse(field) ? previous : new PulsingDocsAndPositionsEnum(field);
            }
            if (reuse != postings) {
                this.setOther(postings, reuse);
            }
            return postings.reset(liveDocs, termState);
        }
        if (reuse instanceof PulsingDocsAndPositionsEnum) {
            DocsAndPositionsEnum wrapped = this.wrappedPostingsReader.docsAndPositions(field, termState.wrappedTermState, liveDocs, (DocsAndPositionsEnum)this.getOther(reuse), needsOffsets);
            this.setOther(wrapped, reuse);
            return wrapped;
        }
        return this.wrappedPostingsReader.docsAndPositions(field, termState.wrappedTermState, liveDocs, reuse, needsOffsets);
    }

    @Override
    public void close() throws IOException {
        this.wrappedPostingsReader.close();
    }

    private DocsEnum getOther(DocsEnum de) {
        if (de == null) {
            return null;
        }
        AttributeSource atts = de.attributes();
        return atts.addAttribute(PulsingEnumAttribute.class).enums().get(this);
    }

    private DocsEnum setOther(DocsEnum de, DocsEnum other) {
        AttributeSource atts = de.attributes();
        return atts.addAttribute(PulsingEnumAttribute.class).enums().put(this, other);
    }

    public static final class PulsingEnumAttributeImpl
    extends AttributeImpl
    implements PulsingEnumAttribute {
        private final Map<PulsingPostingsReader, DocsEnum> enums = new IdentityHashMap<PulsingPostingsReader, DocsEnum>();

        @Override
        public Map<PulsingPostingsReader, DocsEnum> enums() {
            return this.enums;
        }

        @Override
        public void clear() {
        }

        @Override
        public void copyTo(AttributeImpl target) {
        }
    }

    public static interface PulsingEnumAttribute
    extends Attribute {
        public Map<PulsingPostingsReader, DocsEnum> enums();
    }

    private static class PulsingDocsAndPositionsEnum
    extends DocsAndPositionsEnum {
        private byte[] postingsBytes;
        private final ByteArrayDataInput postings = new ByteArrayDataInput();
        private final boolean storePayloads;
        private final boolean storeOffsets;
        private final FieldInfo.IndexOptions indexOptions;
        private Bits liveDocs;
        private int docID = -1;
        private int accum;
        private int freq;
        private int posPending;
        private int position;
        private int payloadLength;
        private BytesRef payload;
        private int startOffset;
        private int offsetLength;
        private boolean payloadRetrieved;

        public PulsingDocsAndPositionsEnum(FieldInfo fieldInfo) {
            this.indexOptions = fieldInfo.getIndexOptions();
            this.storePayloads = fieldInfo.hasPayloads();
            this.storeOffsets = this.indexOptions.compareTo(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
        }

        boolean canReuse(FieldInfo fieldInfo) {
            return this.indexOptions == fieldInfo.getIndexOptions() && this.storePayloads == fieldInfo.hasPayloads();
        }

        public PulsingDocsAndPositionsEnum reset(Bits liveDocs, PulsingTermState termState) {
            assert (termState.postingsSize != -1);
            if (this.postingsBytes == null) {
                this.postingsBytes = new byte[termState.postingsSize];
            } else if (this.postingsBytes.length < termState.postingsSize) {
                this.postingsBytes = ArrayUtil.grow(this.postingsBytes, termState.postingsSize);
            }
            System.arraycopy(termState.postings, 0, this.postingsBytes, 0, termState.postingsSize);
            this.postings.reset(this.postingsBytes, 0, termState.postingsSize);
            this.liveDocs = liveDocs;
            this.payloadLength = 0;
            this.posPending = 0;
            this.docID = -1;
            this.accum = 0;
            this.startOffset = this.storeOffsets ? 0 : -1;
            this.offsetLength = 0;
            return this;
        }

        @Override
        public int nextDoc() throws IOException {
            do {
                this.skipPositions();
                if (this.postings.eof()) {
                    this.docID = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                int code = this.postings.readVInt();
                this.accum += code >>> 1;
                this.freq = (code & 1) != 0 ? 1 : this.postings.readVInt();
                this.posPending = this.freq;
                int n = this.startOffset = this.storeOffsets ? 0 : -1;
            } while (this.liveDocs != null && !this.liveDocs.get(this.accum));
            this.position = 0;
            this.docID = this.accum;
            return this.docID;
        }

        @Override
        public int freq() throws IOException {
            return this.freq;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int advance(int target) throws IOException {
            int doc;
            while ((doc = this.nextDoc()) != Integer.MAX_VALUE) {
                if (doc < target) continue;
                this.docID = doc;
                return this.docID;
            }
            this.docID = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        @Override
        public int nextPosition() throws IOException {
            assert (this.posPending > 0);
            --this.posPending;
            if (this.storePayloads) {
                int code;
                if (!this.payloadRetrieved) {
                    this.postings.skipBytes(this.payloadLength);
                }
                if (((code = this.postings.readVInt()) & 1) != 0) {
                    this.payloadLength = this.postings.readVInt();
                }
                this.position += code >>> 1;
                this.payloadRetrieved = false;
            } else {
                this.position += this.postings.readVInt();
            }
            if (this.storeOffsets) {
                int offsetCode = this.postings.readVInt();
                if ((offsetCode & 1) != 0) {
                    this.offsetLength = this.postings.readVInt();
                }
                this.startOffset += offsetCode >>> 1;
            }
            return this.position;
        }

        @Override
        public int startOffset() {
            return this.startOffset;
        }

        @Override
        public int endOffset() {
            return this.startOffset + this.offsetLength;
        }

        private void skipPositions() throws IOException {
            while (this.posPending != 0) {
                this.nextPosition();
            }
            if (this.storePayloads && !this.payloadRetrieved) {
                this.postings.skipBytes(this.payloadLength);
                this.payloadRetrieved = true;
            }
        }

        @Override
        public boolean hasPayload() {
            return this.storePayloads && !this.payloadRetrieved && this.payloadLength > 0;
        }

        @Override
        public BytesRef getPayload() throws IOException {
            if (this.payloadRetrieved) {
                throw new IOException("Either no payload exists at this term position or an attempt was made to load it more than once.");
            }
            this.payloadRetrieved = true;
            if (this.payloadLength > 0) {
                if (this.payload == null) {
                    this.payload = new BytesRef(this.payloadLength);
                } else {
                    this.payload.grow(this.payloadLength);
                }
                this.postings.readBytes(this.payload.bytes, 0, this.payloadLength);
                this.payload.length = this.payloadLength;
                return this.payload;
            }
            return null;
        }
    }

    private static class PulsingDocsEnum
    extends DocsEnum {
        private byte[] postingsBytes;
        private final ByteArrayDataInput postings = new ByteArrayDataInput();
        private final FieldInfo.IndexOptions indexOptions;
        private final boolean storePayloads;
        private final boolean storeOffsets;
        private Bits liveDocs;
        private int docID = -1;
        private int accum;
        private int freq;
        private int payloadLength;

        public PulsingDocsEnum(FieldInfo fieldInfo) {
            this.indexOptions = fieldInfo.getIndexOptions();
            this.storePayloads = fieldInfo.hasPayloads();
            this.storeOffsets = this.indexOptions.compareTo(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
        }

        public PulsingDocsEnum reset(Bits liveDocs, PulsingTermState termState) {
            assert (termState.postingsSize != -1);
            if (this.postingsBytes == null) {
                this.postingsBytes = new byte[termState.postingsSize];
            } else if (this.postingsBytes.length < termState.postingsSize) {
                this.postingsBytes = ArrayUtil.grow(this.postingsBytes, termState.postingsSize);
            }
            System.arraycopy(termState.postings, 0, this.postingsBytes, 0, termState.postingsSize);
            this.postings.reset(this.postingsBytes, 0, termState.postingsSize);
            this.docID = -1;
            this.accum = 0;
            this.payloadLength = 0;
            this.liveDocs = liveDocs;
            return this;
        }

        boolean canReuse(FieldInfo fieldInfo) {
            return this.indexOptions == fieldInfo.getIndexOptions() && this.storePayloads == fieldInfo.hasPayloads();
        }

        @Override
        public int nextDoc() throws IOException {
            do {
                int pos;
                if (this.postings.eof()) {
                    this.docID = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                int code = this.postings.readVInt();
                if (this.indexOptions == FieldInfo.IndexOptions.DOCS_ONLY) {
                    this.accum += code;
                    continue;
                }
                this.accum += code >>> 1;
                this.freq = (code & 1) != 0 ? 1 : this.postings.readVInt();
                if (this.indexOptions.compareTo(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) continue;
                if (this.storePayloads) {
                    for (pos = 0; pos < this.freq; ++pos) {
                        int posCode = this.postings.readVInt();
                        if ((posCode & 1) != 0) {
                            this.payloadLength = this.postings.readVInt();
                        }
                        if (this.storeOffsets && (this.postings.readVInt() & 1) != 0) {
                            this.postings.readVInt();
                        }
                        if (this.payloadLength == 0) continue;
                        this.postings.skipBytes(this.payloadLength);
                    }
                } else {
                    for (pos = 0; pos < this.freq; ++pos) {
                        this.postings.readVInt();
                        if (!this.storeOffsets || (this.postings.readVInt() & 1) == 0) continue;
                        this.postings.readVInt();
                    }
                }
            } while (this.liveDocs != null && !this.liveDocs.get(this.accum));
            this.docID = this.accum;
            return this.docID;
        }

        @Override
        public int freq() throws IOException {
            assert (this.indexOptions != FieldInfo.IndexOptions.DOCS_ONLY);
            return this.freq;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int advance(int target) throws IOException {
            int doc;
            while ((doc = this.nextDoc()) != Integer.MAX_VALUE) {
                if (doc < target) continue;
                return doc;
            }
            this.docID = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
    }

    private static class PulsingTermState
    extends BlockTermState {
        private byte[] postings;
        private int postingsSize;
        private BlockTermState wrappedTermState;
        ByteArrayDataInput inlinedBytesReader;
        private byte[] inlinedBytes;

        private PulsingTermState() {
        }

        @Override
        public PulsingTermState clone() {
            PulsingTermState clone = (PulsingTermState)super.clone();
            if (this.postingsSize != -1) {
                clone.postings = new byte[this.postingsSize];
                System.arraycopy(this.postings, 0, clone.postings, 0, this.postingsSize);
            } else {
                assert (this.wrappedTermState != null);
                clone.wrappedTermState = (BlockTermState)this.wrappedTermState.clone();
            }
            return clone;
        }

        @Override
        public void copyFrom(TermState _other) {
            super.copyFrom(_other);
            PulsingTermState other = (PulsingTermState)_other;
            this.postingsSize = other.postingsSize;
            if (other.postingsSize != -1) {
                if (this.postings == null || this.postings.length < other.postingsSize) {
                    this.postings = new byte[ArrayUtil.oversize(other.postingsSize, 1)];
                }
                System.arraycopy(other.postings, 0, this.postings, 0, other.postingsSize);
            } else {
                this.wrappedTermState.copyFrom(other.wrappedTermState);
            }
        }

        @Override
        public String toString() {
            if (this.postingsSize == -1) {
                return "PulsingTermState: not inlined: wrapped=" + this.wrappedTermState;
            }
            return "PulsingTermState: inlined size=" + this.postingsSize + " " + super.toString();
        }

        static /* synthetic */ byte[] access$002(PulsingTermState x0, byte[] x1) {
            x0.inlinedBytes = x1;
            return x1;
        }

        static /* synthetic */ byte[] access$402(PulsingTermState x0, byte[] x1) {
            x0.postings = x1;
            return x1;
        }
    }
}

