/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene40.values;

import java.io.IOException;
import org.apache.lucene.codecs.lucene40.values.Bytes;
import org.apache.lucene.codecs.lucene40.values.DirectSource;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.packed.PackedInts;

class VarDerefBytesImpl {
    static final String CODEC_NAME_IDX = "VarDerefBytesIdx";
    static final String CODEC_NAME_DAT = "VarDerefBytesDat";
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;

    VarDerefBytesImpl() {
    }

    static final class DirectVarDerefSource
    extends DirectSource {
        private final PackedInts.Reader index;

        DirectVarDerefSource(IndexInput data, IndexInput index, DocValues.Type type) throws IOException {
            super(data, type);
            this.index = PackedInts.getDirectReader(index);
        }

        @Override
        protected int position(int docID) throws IOException {
            this.data.seek(this.baseOffset + this.index.get(docID));
            byte sizeByte = this.data.readByte();
            if ((sizeByte & 0x80) == 0) {
                return sizeByte;
            }
            return (sizeByte & 0x7F) << 8 | this.data.readByte() & 0xFF;
        }
    }

    static final class VarDerefSource
    extends Bytes.BytesSourceBase {
        private final PackedInts.Reader addresses;

        public VarDerefSource(IndexInput datIn, IndexInput idxIn, long totalBytes) throws IOException {
            super(datIn, idxIn, new PagedBytes(15), totalBytes, DocValues.Type.BYTES_VAR_DEREF);
            this.addresses = PackedInts.getReader(idxIn);
        }

        @Override
        public BytesRef getBytes(int docID, BytesRef bytesRef) {
            return this.data.fillSliceWithPrefix(bytesRef, this.addresses.get(docID));
        }
    }

    public static class VarDerefReader
    extends Bytes.BytesReaderBase {
        private final long totalBytes;

        VarDerefReader(Directory dir, String id, int maxDoc, IOContext context) throws IOException {
            super(dir, id, VarDerefBytesImpl.CODEC_NAME_IDX, VarDerefBytesImpl.CODEC_NAME_DAT, 0, true, context, DocValues.Type.BYTES_VAR_DEREF);
            this.totalBytes = this.idxIn.readLong();
        }

        @Override
        public DocValues.Source load() throws IOException {
            return new VarDerefSource(this.cloneData(), this.cloneIndex(), this.totalBytes);
        }

        @Override
        public DocValues.Source getDirectSource() throws IOException {
            return new DirectVarDerefSource(this.cloneData(), this.cloneIndex(), this.getType());
        }
    }

    static class Writer
    extends Bytes.DerefBytesWriterBase {
        public Writer(Directory dir, String id, Counter bytesUsed, IOContext context) throws IOException {
            super(dir, id, VarDerefBytesImpl.CODEC_NAME_IDX, VarDerefBytesImpl.CODEC_NAME_DAT, 0, bytesUsed, context, DocValues.Type.BYTES_VAR_DEREF);
            this.size = 0;
        }

        @Override
        protected void checkSize(BytesRef bytes) {
        }

        @Override
        public void finishInternal(int docCount) throws IOException {
            this.fillDefault(docCount);
            int size = this.hash.size();
            long[] addresses = new long[size];
            IndexOutput datOut = this.getOrCreateDataOut();
            int addr = 0;
            BytesRef bytesRef = new BytesRef();
            for (int i = 0; i < size; ++i) {
                this.hash.get(i, bytesRef);
                addresses[i] = addr;
                addr += Writer.writePrefixLength(datOut, bytesRef) + bytesRef.length;
                datOut.writeBytes(bytesRef.bytes, bytesRef.offset, bytesRef.length);
            }
            IndexOutput idxOut = this.getOrCreateIndexOut();
            idxOut.writeLong(addr);
            this.writeIndex(idxOut, docCount, addresses[addresses.length - 1], addresses, this.docToEntry);
        }
    }
}

