/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene40.values;

import java.io.IOException;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesArraySource;
import org.apache.lucene.codecs.lucene40.values.FixedStraightBytesImpl;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.packed.PackedInts;

class PackedIntValues {
    private static final String CODEC_NAME = "PackedInts";
    private static final byte PACKED = 0;
    private static final byte FIXED_64 = 1;
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;

    PackedIntValues() {
    }

    static class PackedIntsSource
    extends DocValues.Source {
        private final long minValue;
        private final long defaultValue;
        private final PackedInts.Reader values;

        public PackedIntsSource(IndexInput dataIn, boolean direct) throws IOException {
            super(DocValues.Type.VAR_INTS);
            this.minValue = dataIn.readLong();
            this.defaultValue = dataIn.readLong();
            this.values = direct ? PackedInts.getDirectReader(dataIn) : PackedInts.getReader(dataIn);
        }

        @Override
        public BytesRef getBytes(int docID, BytesRef ref) {
            ref.grow(8);
            DocValuesArraySource.copyLong(ref, this.getInt(docID));
            return ref;
        }

        @Override
        public long getInt(int docID) {
            assert (docID >= 0);
            long value = this.values.get(docID);
            return value == this.defaultValue ? 0L : this.minValue + value;
        }
    }

    static class PackedIntsReader
    extends DocValues {
        private final IndexInput datIn;
        private final byte type;
        private final int numDocs;
        private final DocValuesArraySource values;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected PackedIntsReader(Directory dir, String id, int numDocs, IOContext context) throws IOException {
            this.datIn = dir.openInput(IndexFileNames.segmentFileName(id, "dv", "dat"), context);
            this.numDocs = numDocs;
            boolean success = false;
            try {
                CodecUtil.checkHeader(this.datIn, PackedIntValues.CODEC_NAME, 0, 0);
                this.type = this.datIn.readByte();
                this.values = this.type == 1 ? DocValuesArraySource.forType(DocValues.Type.FIXED_INTS_64) : null;
                return;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                IOUtils.closeWhileHandlingException(this.datIn);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DocValues.Source load() throws IOException {
            DocValues.Source source;
            block3: {
                boolean success = false;
                IndexInput input = null;
                try {
                    input = (IndexInput)this.datIn.clone();
                    DocValues.Source source2 = this.values == null ? new PackedIntsSource(input, false) : this.values.newFromInput(input, this.numDocs);
                    success = true;
                    source = source2;
                    if (success) break block3;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        IOUtils.closeWhileHandlingException(input, this.datIn);
                    }
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException(input, this.datIn);
            }
            return source;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.datIn.close();
        }

        @Override
        public DocValues.Type getType() {
            return DocValues.Type.VAR_INTS;
        }

        @Override
        public DocValues.Source getDirectSource() throws IOException {
            return this.values != null ? new FixedStraightBytesImpl.DirectFixedStraightSource((IndexInput)this.datIn.clone(), 8, DocValues.Type.FIXED_INTS_64) : new PackedIntsSource((IndexInput)this.datIn.clone(), true);
        }
    }

    static class PackedIntsWriter
    extends FixedStraightBytesImpl.FixedBytesWriterBase {
        private long minValue;
        private long maxValue;
        private boolean started;
        private int lastDocId = -1;

        protected PackedIntsWriter(Directory dir, String id, Counter bytesUsed, IOContext context) throws IOException {
            super(dir, id, PackedIntValues.CODEC_NAME, 0, bytesUsed, context, DocValues.Type.VAR_INTS);
            this.bytesRef = new BytesRef(8);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finish(int docCount) throws IOException {
            IndexOutput dataOut;
            boolean success;
            block10: {
                success = false;
                dataOut = this.getOrCreateDataOut();
                try {
                    long delta;
                    if (!this.started) {
                        this.maxValue = 0L;
                        this.minValue = 0L;
                    }
                    if ((delta = this.maxValue - this.minValue) > (this.maxValue >= 0L && this.minValue <= 0L ? Long.MAX_VALUE : 0x7FFFFFFFFFFFFFFEL) || delta < 0L) break block10;
                    dataOut.writeByte((byte)0);
                    this.writePackedInts(dataOut, docCount);
                }
                catch (Throwable throwable) {
                    this.resetPool();
                    if (success) {
                        IOUtils.close(dataOut);
                    } else {
                        IOUtils.closeWhileHandlingException(dataOut);
                    }
                    throw throwable;
                }
                this.resetPool();
                if (success) {
                    IOUtils.close(dataOut);
                } else {
                    IOUtils.closeWhileHandlingException(dataOut);
                }
                return;
            }
            dataOut.writeByte((byte)1);
            this.writeData(dataOut);
            this.writeZeros(docCount - (this.lastDocID + 1), dataOut);
            success = true;
            this.resetPool();
            if (success) {
                IOUtils.close(dataOut);
            } else {
                IOUtils.closeWhileHandlingException(dataOut);
            }
        }

        private void writePackedInts(IndexOutput datOut, int docCount) throws IOException {
            int i;
            datOut.writeLong(this.minValue);
            long defaultValue = this.maxValue >= 0L && this.minValue <= 0L ? 0L - this.minValue : ++this.maxValue - this.minValue;
            datOut.writeLong(defaultValue);
            PackedInts.Writer w = PackedInts.getWriter(datOut, docCount, PackedInts.bitsRequired(this.maxValue - this.minValue), 0.2f);
            for (i = 0; i < this.lastDocID + 1; ++i) {
                this.set(this.bytesRef, i);
                byte[] bytes = this.bytesRef.bytes;
                int offset = this.bytesRef.offset;
                long asLong = (long)(bytes[offset + 0] & 0xFF) << 56 | (long)(bytes[offset + 1] & 0xFF) << 48 | (long)(bytes[offset + 2] & 0xFF) << 40 | (long)(bytes[offset + 3] & 0xFF) << 32 | (long)(bytes[offset + 4] & 0xFF) << 24 | (long)(bytes[offset + 5] & 0xFF) << 16 | (long)(bytes[offset + 6] & 0xFF) << 8 | (long)(bytes[offset + 7] & 0xFF);
                w.add(asLong == 0L ? defaultValue : asLong - this.minValue);
            }
            for (i = this.lastDocID + 1; i < docCount; ++i) {
                w.add(defaultValue);
            }
            w.finish();
        }

        @Override
        public void add(int docID, IndexableField docValue) throws IOException {
            long v = docValue.numericValue().longValue();
            assert (this.lastDocId < docID);
            if (!this.started) {
                this.started = true;
                this.minValue = this.maxValue = v;
            } else if (v < this.minValue) {
                this.minValue = v;
            } else if (v > this.maxValue) {
                this.maxValue = v;
            }
            this.lastDocId = docID;
            DocValuesArraySource.copyLong(this.bytesRef, v);
            this.bytesSpareField.setBytesValue(this.bytesRef);
            super.add(docID, this.bytesSpareField);
        }
    }
}

