/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene40.values;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.codecs.lucene40.values.Bytes;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SortedBytesMergeUtils;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.packed.PackedInts;

class FixedSortedBytesImpl {
    static final String CODEC_NAME_IDX = "FixedSortedBytesIdx";
    static final String CODEC_NAME_DAT = "FixedSortedBytesDat";
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;

    FixedSortedBytesImpl() {
    }

    static final class DirectFixedSortedSource
    extends DocValues.SortedSource {
        final PackedInts.Reader docToOrdIndex;
        private final IndexInput datIn;
        private final long basePointer;
        private final int size;
        private final int valueCount;

        DirectFixedSortedSource(IndexInput datIn, IndexInput idxIn, int size, int valueCount, Comparator<BytesRef> comp, DocValues.Type type) throws IOException {
            super(type, comp);
            this.docToOrdIndex = PackedInts.getDirectReader(idxIn);
            this.basePointer = datIn.getFilePointer();
            this.datIn = datIn;
            this.size = size;
            this.valueCount = valueCount;
        }

        @Override
        public int ord(int docID) {
            return (int)this.docToOrdIndex.get(docID);
        }

        @Override
        public boolean hasPackedDocToOrd() {
            return true;
        }

        @Override
        public PackedInts.Reader getDocToOrd() {
            return this.docToOrdIndex;
        }

        @Override
        public BytesRef getByOrd(int ord, BytesRef bytesRef) {
            try {
                this.datIn.seek(this.basePointer + (long)(this.size * ord));
                bytesRef.offset = 0;
                bytesRef.grow(this.size);
                this.datIn.readBytes(bytesRef.bytes, 0, this.size);
                bytesRef.length = this.size;
                return bytesRef;
            }
            catch (IOException ex) {
                throw new IllegalStateException("failed to getByOrd", ex);
            }
        }

        @Override
        public int getValueCount() {
            return this.valueCount;
        }
    }

    static final class FixedSortedSource
    extends Bytes.BytesSortedSourceBase {
        private final int valueCount;
        private final int size;

        FixedSortedSource(IndexInput datIn, IndexInput idxIn, int size, int numValues, Comparator<BytesRef> comp) throws IOException {
            super(datIn, idxIn, comp, size * numValues, DocValues.Type.BYTES_FIXED_SORTED, false);
            this.size = size;
            this.valueCount = numValues;
            this.closeIndexInput();
        }

        @Override
        public int getValueCount() {
            return this.valueCount;
        }

        @Override
        public BytesRef getByOrd(int ord, BytesRef bytesRef) {
            return this.data.fillSlice(bytesRef, ord * this.size, this.size);
        }
    }

    static final class Reader
    extends Bytes.BytesReaderBase {
        private final int size;
        private final int valueCount;
        private final Comparator<BytesRef> comparator;

        public Reader(Directory dir, String id, int maxDoc, IOContext context, DocValues.Type type, Comparator<BytesRef> comparator) throws IOException {
            super(dir, id, FixedSortedBytesImpl.CODEC_NAME_IDX, FixedSortedBytesImpl.CODEC_NAME_DAT, 0, true, context, type);
            this.size = this.datIn.readInt();
            this.valueCount = this.idxIn.readInt();
            this.comparator = comparator;
        }

        @Override
        public DocValues.Source load() throws IOException {
            return new FixedSortedSource(this.cloneData(), this.cloneIndex(), this.size, this.valueCount, this.comparator);
        }

        @Override
        public DocValues.Source getDirectSource() throws IOException {
            return new DirectFixedSortedSource(this.cloneData(), this.cloneIndex(), this.size, this.valueCount, this.comparator, this.type);
        }

        @Override
        public int getValueSize() {
            return this.size;
        }
    }

    static final class Writer
    extends Bytes.DerefBytesWriterBase {
        private final Comparator<BytesRef> comp;

        public Writer(Directory dir, String id, Comparator<BytesRef> comp, Counter bytesUsed, IOContext context, float acceptableOverheadRatio) throws IOException {
            super(dir, id, FixedSortedBytesImpl.CODEC_NAME_IDX, FixedSortedBytesImpl.CODEC_NAME_DAT, 0, bytesUsed, context, acceptableOverheadRatio, DocValues.Type.BYTES_FIXED_SORTED);
            this.comp = comp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void merge(MergeState mergeState, DocValues[] docValues) throws IOException {
            boolean success = false;
            try {
                SortedBytesMergeUtils.MergeContext ctx = SortedBytesMergeUtils.init(DocValues.Type.BYTES_FIXED_SORTED, docValues, this.comp, mergeState.segmentInfo.getDocCount());
                List<SortedBytesMergeUtils.SortedSourceSlice> slices = SortedBytesMergeUtils.buildSlices(mergeState.docBase, mergeState.docMaps, docValues, ctx);
                IndexOutput datOut = this.getOrCreateDataOut();
                datOut.writeInt(ctx.sizePerValues);
                int maxOrd = SortedBytesMergeUtils.mergeRecords(ctx, new SortedBytesMergeUtils.IndexOutputBytesRefConsumer(datOut), slices);
                IndexOutput idxOut = this.getOrCreateIndexOut();
                idxOut.writeInt(maxOrd);
                PackedInts.Writer ordsWriter = PackedInts.getWriter(idxOut, ctx.docToEntry.length, PackedInts.bitsRequired(maxOrd), 0.2f);
                for (SortedBytesMergeUtils.SortedSourceSlice slice : slices) {
                    slice.writeOrds(ordsWriter);
                }
                ordsWriter.finish();
                success = true;
            }
            catch (Throwable throwable) {
                this.releaseResources();
                if (success) {
                    IOUtils.close(this.getIndexOut(), this.getDataOut());
                } else {
                    IOUtils.closeWhileHandlingException(this.getIndexOut(), this.getDataOut());
                }
                throw throwable;
            }
            this.releaseResources();
            if (success) {
                IOUtils.close(this.getIndexOut(), this.getDataOut());
            } else {
                IOUtils.closeWhileHandlingException(this.getIndexOut(), this.getDataOut());
            }
        }

        @Override
        public void finishInternal(int docCount) throws IOException {
            this.fillDefault(docCount);
            IndexOutput datOut = this.getOrCreateDataOut();
            int count = this.hash.size();
            int[] address = new int[count];
            datOut.writeInt(this.size);
            if (this.size != -1) {
                int[] sortedEntries = this.hash.sort(this.comp);
                BytesRef spare = new BytesRef(this.size);
                int i = 0;
                while (i < count) {
                    int e = sortedEntries[i];
                    BytesRef bytes = this.hash.get(e, spare);
                    assert (bytes.length == this.size);
                    datOut.writeBytes(bytes.bytes, bytes.offset, bytes.length);
                    address[e] = i++;
                }
            }
            IndexOutput idxOut = this.getOrCreateIndexOut();
            idxOut.writeInt(count);
            this.writeIndex(idxOut, docCount, (long)count, address, this.docToEntry);
        }
    }
}

