/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.lucene.codecs.DocValuesArraySource;
import org.apache.lucene.codecs.PerDocProducerBase;
import org.apache.lucene.codecs.simpletext.SimpleTextDocValuesConsumer;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.packed.PackedInts;

public class SimpleTextPerDocProducer
extends PerDocProducerBase {
    protected final TreeMap<String, DocValues> docValues;
    private Comparator<BytesRef> comp;
    private final String segmentSuffix;

    public SimpleTextPerDocProducer(SegmentReadState state, Comparator<BytesRef> comp, String segmentSuffix) throws IOException {
        this.comp = comp;
        this.segmentSuffix = segmentSuffix;
        this.docValues = this.anyDocValuesFields(state.fieldInfos) ? this.load(state.fieldInfos, state.segmentInfo.name, state.segmentInfo.getDocCount(), state.dir, state.context) : new TreeMap();
    }

    protected Map<String, DocValues> docValues() {
        return this.docValues;
    }

    protected DocValues loadDocValues(int docCount, Directory dir, String id, DocValues.Type type, IOContext context) throws IOException {
        return new SimpleTextDocValues(dir, context, type, id, docCount, this.comp, this.segmentSuffix);
    }

    protected void closeInternal(Collection<? extends Closeable> closeables) throws IOException {
        IOUtils.close(closeables);
    }

    public static String readString(int offset, BytesRef scratch) {
        return new String(scratch.bytes, scratch.offset + offset, scratch.length - offset, IOUtils.CHARSET_UTF_8);
    }

    private static class VarIntsArraySource
    extends DocValues.Source {
        private final long[] array;

        protected VarIntsArraySource(DocValues.Type type, long[] array) {
            super(type);
            this.array = array;
        }

        public long getInt(int docID) {
            return this.array[docID];
        }

        public BytesRef getBytes(int docID, BytesRef ref) {
            DocValuesArraySource.copyLong((BytesRef)ref, (long)this.getInt(docID));
            return ref;
        }
    }

    private static final class BytesSource
    extends DocValues.SortedSource {
        private final BytesRefHash hash;
        int[] docIdToEntry;
        int[] sortedEntries;
        int[] adresses;
        private final boolean isSorted;

        protected BytesSource(DocValues.Type type, Comparator<BytesRef> comp, int maxDoc, BytesRefHash hash) {
            super(type, comp);
            this.docIdToEntry = new int[maxDoc];
            this.hash = hash;
            this.isSorted = type == DocValues.Type.BYTES_FIXED_SORTED || type == DocValues.Type.BYTES_VAR_SORTED;
        }

        void maybeSort() {
            if (this.isSorted) {
                this.adresses = new int[this.hash.size()];
                this.sortedEntries = this.hash.sort(this.getComparator());
                int i = 0;
                while (i < this.adresses.length) {
                    int entry = this.sortedEntries[i];
                    this.adresses[entry] = i++;
                }
            }
        }

        public BytesRef getBytes(int docID, BytesRef ref) {
            if (this.isSorted) {
                return this.hash.get(this.sortedEntries[this.ord(docID)], ref);
            }
            return this.hash.get(this.docIdToEntry[docID], ref);
        }

        public DocValues.SortedSource asSortedSource() {
            if (this.isSorted) {
                return this;
            }
            return null;
        }

        public int ord(int docID) {
            assert (this.isSorted);
            try {
                return this.adresses[this.docIdToEntry[docID]];
            }
            catch (Exception e) {
                return 0;
            }
        }

        public BytesRef getByOrd(int ord, BytesRef bytesRef) {
            assert (this.isSorted);
            return this.hash.get(this.sortedEntries[ord], bytesRef);
        }

        public PackedInts.Reader getDocToOrd() {
            return null;
        }

        public int getValueCount() {
            return this.hash.size();
        }
    }

    private static final class ValueReader {
        private final DocValues.Type type;
        private byte[] bytes;
        private short[] shorts;
        private int[] ints;
        private long[] longs;
        private float[] floats;
        private double[] doubles;
        private DocValues.Source source;
        private BytesRefHash hash;
        private BytesRef scratch;

        public ValueReader(DocValues.Type type, int maxDocs, Comparator<BytesRef> comp) {
            this.type = type;
            Object docValuesArray = null;
            switch (type) {
                case FIXED_INTS_16: {
                    this.shorts = new short[maxDocs];
                    docValuesArray = DocValuesArraySource.forType((DocValues.Type)type).newFromArray((Object)this.shorts);
                    break;
                }
                case FIXED_INTS_32: {
                    this.ints = new int[maxDocs];
                    docValuesArray = DocValuesArraySource.forType((DocValues.Type)type).newFromArray((Object)this.ints);
                    break;
                }
                case FIXED_INTS_64: {
                    this.longs = new long[maxDocs];
                    docValuesArray = DocValuesArraySource.forType((DocValues.Type)type).newFromArray((Object)this.longs);
                    break;
                }
                case VAR_INTS: {
                    this.longs = new long[maxDocs];
                    docValuesArray = new VarIntsArraySource(type, this.longs);
                    break;
                }
                case FIXED_INTS_8: {
                    this.bytes = new byte[maxDocs];
                    docValuesArray = DocValuesArraySource.forType((DocValues.Type)type).newFromArray((Object)this.bytes);
                    break;
                }
                case FLOAT_32: {
                    this.floats = new float[maxDocs];
                    docValuesArray = DocValuesArraySource.forType((DocValues.Type)type).newFromArray((Object)this.floats);
                    break;
                }
                case FLOAT_64: {
                    this.doubles = new double[maxDocs];
                    docValuesArray = DocValuesArraySource.forType((DocValues.Type)type).newFromArray((Object)this.doubles);
                    break;
                }
                case BYTES_FIXED_DEREF: 
                case BYTES_FIXED_SORTED: 
                case BYTES_FIXED_STRAIGHT: 
                case BYTES_VAR_DEREF: 
                case BYTES_VAR_SORTED: 
                case BYTES_VAR_STRAIGHT: {
                    assert (comp != null);
                    this.hash = new BytesRefHash();
                    BytesSource bytesSource = new BytesSource(type, comp, maxDocs, this.hash);
                    this.ints = bytesSource.docIdToEntry;
                    this.source = bytesSource;
                    this.scratch = new BytesRef();
                }
            }
            if (docValuesArray != null) {
                assert (this.source == null);
                this.source = docValuesArray;
            }
        }

        public void fromString(int ord, BytesRef ref, int offset) {
            switch (this.type) {
                case FIXED_INTS_16: {
                    assert (this.shorts != null);
                    this.shorts[ord] = Short.parseShort(SimpleTextPerDocProducer.readString(offset, ref));
                    break;
                }
                case FIXED_INTS_32: {
                    assert (this.ints != null);
                    this.ints[ord] = Integer.parseInt(SimpleTextPerDocProducer.readString(offset, ref));
                    break;
                }
                case VAR_INTS: 
                case FIXED_INTS_64: {
                    assert (this.longs != null);
                    this.longs[ord] = Long.parseLong(SimpleTextPerDocProducer.readString(offset, ref));
                    break;
                }
                case FIXED_INTS_8: {
                    assert (this.bytes != null);
                    this.bytes[ord] = (byte)Integer.parseInt(SimpleTextPerDocProducer.readString(offset, ref));
                    break;
                }
                case FLOAT_32: {
                    assert (this.floats != null);
                    this.floats[ord] = Float.parseFloat(SimpleTextPerDocProducer.readString(offset, ref));
                    break;
                }
                case FLOAT_64: {
                    assert (this.doubles != null);
                    this.doubles[ord] = Double.parseDouble(SimpleTextPerDocProducer.readString(offset, ref));
                    break;
                }
                case BYTES_FIXED_DEREF: 
                case BYTES_FIXED_SORTED: 
                case BYTES_FIXED_STRAIGHT: 
                case BYTES_VAR_DEREF: 
                case BYTES_VAR_SORTED: 
                case BYTES_VAR_STRAIGHT: {
                    this.scratch.bytes = ref.bytes;
                    this.scratch.length = ref.length - offset;
                    this.scratch.offset = ref.offset + offset;
                    int key = this.hash.add(this.scratch);
                    this.ints[ord] = key < 0 ? -key - 1 : key;
                }
            }
        }

        public DocValues.Source getSource() {
            if (this.source instanceof BytesSource) {
                ((BytesSource)this.source).maybeSort();
            }
            return this.source;
        }
    }

    private static class SimpleTextDocValues
    extends DocValues {
        private int docCount;
        private DocValues.Type type;
        private Comparator<BytesRef> comp;
        private int valueSize;
        private final IndexInput input;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            block5: {
                block4: {
                    boolean success = false;
                    try {
                        super.close();
                        success = true;
                        if (!success) break block4;
                    }
                    catch (Throwable throwable) {
                        if (success) {
                            IOUtils.close((Closeable[])new Closeable[]{this.input});
                        } else {
                            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.input});
                        }
                        throw throwable;
                    }
                    IOUtils.close((Closeable[])new Closeable[]{this.input});
                    break block5;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.input});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public SimpleTextDocValues(Directory dir, IOContext ctx, DocValues.Type type, String id, int docCount, Comparator<BytesRef> comp, String segmentSuffix) throws IOException {
            IndexInput in;
            block3: {
                this.type = type;
                this.docCount = docCount;
                this.comp = comp;
                String fileName = IndexFileNames.segmentFileName((String)id, (String)"", (String)segmentSuffix);
                boolean success = false;
                in = null;
                try {
                    in = dir.openInput(fileName, ctx);
                    this.valueSize = this.readHeader(in);
                    success = true;
                    if (success) break block3;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
                    }
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
            }
            this.input = in;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected DocValues.Source loadSource() throws IOException {
            DocValues.Source source;
            block10: {
                IndexInput in;
                block9: {
                    boolean success = false;
                    in = this.input.clone();
                    try {
                        DocValues.Source source2 = null;
                        switch (this.type) {
                            case BYTES_FIXED_DEREF: 
                            case BYTES_FIXED_SORTED: 
                            case BYTES_FIXED_STRAIGHT: 
                            case BYTES_VAR_DEREF: 
                            case BYTES_VAR_SORTED: 
                            case BYTES_VAR_STRAIGHT: {
                                source2 = this.read(in, new ValueReader(this.type, this.docCount, this.comp));
                                break;
                            }
                            case FIXED_INTS_16: 
                            case FIXED_INTS_32: 
                            case VAR_INTS: 
                            case FIXED_INTS_64: 
                            case FIXED_INTS_8: 
                            case FLOAT_32: 
                            case FLOAT_64: {
                                source2 = this.read(in, new ValueReader(this.type, this.docCount, null));
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("unknown type: " + this.type);
                            }
                        }
                        assert (source2 != null);
                        success = true;
                        source = source2;
                        if (success) break block9;
                    }
                    catch (Throwable throwable) {
                        if (!success) {
                            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
                        } else {
                            IOUtils.close((Closeable[])new Closeable[]{in});
                        }
                        throw throwable;
                    }
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
                    break block10;
                }
                IOUtils.close((Closeable[])new Closeable[]{in});
            }
            return source;
        }

        private int readHeader(IndexInput in) throws IOException {
            BytesRef scratch = new BytesRef();
            SimpleTextUtil.readLine((DataInput)in, scratch);
            assert (StringHelper.startsWith((BytesRef)scratch, (BytesRef)SimpleTextDocValuesConsumer.HEADER));
            SimpleTextUtil.readLine((DataInput)in, scratch);
            assert (StringHelper.startsWith((BytesRef)scratch, (BytesRef)SimpleTextDocValuesConsumer.VALUE_SIZE));
            return Integer.parseInt(SimpleTextPerDocProducer.readString(scratch.offset + SimpleTextDocValuesConsumer.VALUE_SIZE.length, scratch));
        }

        private DocValues.Source read(IndexInput in, ValueReader reader) throws IOException {
            BytesRef scratch = new BytesRef();
            for (int i = 0; i < this.docCount; ++i) {
                SimpleTextUtil.readLine((DataInput)in, scratch);
                assert (StringHelper.startsWith((BytesRef)scratch, (BytesRef)SimpleTextDocValuesConsumer.DOC)) : scratch.utf8ToString();
                SimpleTextUtil.readLine((DataInput)in, scratch);
                assert (StringHelper.startsWith((BytesRef)scratch, (BytesRef)SimpleTextDocValuesConsumer.VALUE));
                reader.fromString(i, scratch, scratch.offset + SimpleTextDocValuesConsumer.VALUE.length);
            }
            SimpleTextUtil.readLine((DataInput)in, scratch);
            assert (scratch.equals((Object)SimpleTextDocValuesConsumer.END));
            return reader.getSource();
        }

        public DocValues.Source getDirectSource() throws IOException {
            return this.getSource();
        }

        protected DocValues.Source loadDirectSource() throws IOException {
            return this.getSource();
        }

        public int getValueSize() {
            return this.valueSize;
        }

        public DocValues.Type getType() {
            return this.type;
        }
    }
}

