/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.util.FilteringTokenFilter;

public final class LengthFilter
extends FilteringTokenFilter {
    private final int min;
    private final int max;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);

    public LengthFilter(boolean enablePositionIncrements, TokenStream in, int min, int max) {
        super(enablePositionIncrements, in);
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean accept() throws IOException {
        int len = this.termAtt.length();
        return len >= this.min && len <= this.max;
    }
}

