/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.fr;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.util.Version;

public final class ElisionFilter
extends TokenFilter {
    private CharArraySet articles = CharArraySet.EMPTY_SET;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private static final CharArraySet DEFAULT_ARTICLES = CharArraySet.unmodifiableSet(new CharArraySet(Version.LUCENE_CURRENT, Arrays.asList("l", "m", "t", "qu", "n", "s", "j"), true));
    private static char[] apostrophes = new char[]{'\'', '\u2019'};

    public ElisionFilter(Version matchVersion, TokenStream input) {
        this(matchVersion, input, DEFAULT_ARTICLES);
    }

    public ElisionFilter(Version matchVersion, TokenStream input, CharArraySet articles) {
        super(input);
        this.articles = CharArraySet.unmodifiableSet(new CharArraySet(matchVersion, articles, true));
    }

    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            char[] termBuffer = this.termAtt.buffer();
            int termLength = this.termAtt.length();
            int minPoz = Integer.MAX_VALUE;
            block0: for (int i = 0; i < apostrophes.length; ++i) {
                char apos = apostrophes[i];
                for (int poz = 0; poz < termLength; ++poz) {
                    if (termBuffer[poz] != apos) continue;
                    minPoz = Math.min(poz, minPoz);
                    continue block0;
                }
            }
            if (minPoz != Integer.MAX_VALUE && this.articles.contains(this.termAtt.buffer(), 0, minPoz)) {
                this.termAtt.copyBuffer(this.termAtt.buffer(), minPoz + 1, this.termAtt.length() - (minPoz + 1));
            }
            return true;
        }
        return false;
    }
}

