/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.cli.table;

import org.apache.lens.api.metastore.XJoinChain;
import org.apache.lens.api.metastore.XJoinChains;
import org.apache.lens.api.metastore.XJoinEdge;
import org.apache.lens.api.metastore.XJoinPath;
import org.apache.lens.cli.table.CollectionTable;
import org.apache.lens.cli.table.CollectionTableFactory;

public class XJoinChainTable {
    private XJoinChains xJoinChains;

    public XJoinChainTable(XJoinChains xJoinChains) {
        this.xJoinChains = xJoinChains;
    }

    public String toString() {
        return new CollectionTable<XJoinChain>(this.xJoinChains.getJoinChain(), new CollectionTable.RowProvider<XJoinChain>(){

            @Override
            public String[][] getRows(XJoinChain element) {
                int size = element.getPaths().getPath().size();
                String[][] ret = new String[size][5];
                for (int i = 0; i < size; ++i) {
                    if (i == 0) {
                        ret[i][0] = CollectionTableFactory.nulltoBlank(element.getName());
                        ret[i][1] = CollectionTableFactory.nulltoBlank(element.getDisplayString());
                        ret[i][2] = CollectionTableFactory.nulltoBlank(element.getDescription());
                        ret[i][3] = CollectionTableFactory.nulltoBlank(element.getDestTable());
                    } else {
                        ret[i][0] = "";
                        ret[i][1] = "";
                        ret[i][2] = "";
                        ret[i][3] = "";
                    }
                    ret[i][4] = this.pathAsString((XJoinPath)element.getPaths().getPath().get(i));
                }
                return ret;
            }

            private String pathAsString(XJoinPath path) {
                StringBuilder sb = new StringBuilder();
                String sep1 = "";
                for (XJoinEdge edge : path.getEdges().getEdge()) {
                    sb.append(sep1).append(edge.getFrom().getTable()).append(".").append(edge.getFrom().getColumn()).append("=").append(edge.getTo().getTable()).append(".").append(edge.getTo().getColumn());
                    sep1 = "->";
                }
                return sb.toString();
            }
        }, "Name", "Display String", "Description", "Destination Table", "Path").toString();
    }
}

