/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.cli.table;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlType;
import org.apache.lens.api.metastore.XField;
import org.apache.lens.api.metastore.XFlattenedColumn;
import org.apache.lens.api.metastore.XFlattenedColumns;
import org.apache.lens.cli.table.CollectionTable;
import org.apache.lens.cli.table.CollectionTableFactory;

public class XFlattenedColumnTable {
    private final String table;
    Map<Class<? extends XField>, CollectionTable<XFlattenedColumn>> tables = Maps.newLinkedHashMap();
    List<String> chainNames = Lists.newArrayList();
    List<String> tableNames = Lists.newArrayList();

    public XFlattenedColumnTable(XFlattenedColumns flattenedColumns, String table) {
        this.table = table;
        for (XFlattenedColumn column : flattenedColumns.getFlattenedColumn()) {
            XField field = XFlattenedColumnTable.firstNonNull(column.getDimAttribute(), column.getMeasure(), column.getExpression());
            if (field != null) {
                if (!this.tables.containsKey(field.getClass())) {
                    this.tables.put(field.getClass(), CollectionTableFactory.getCollectionTable(field.getClass(), table));
                }
                this.tables.get(field.getClass()).getCollection().add(column);
                continue;
            }
            if (column.getChainName() != null) {
                this.chainNames.add(column.getChainName());
            }
            if (column.getTableName() == null) continue;
            this.tableNames.add(column.getTableName());
        }
    }

    public static <T> T firstNonNull(T ... args) {
        for (T arg : args) {
            if (arg == null) continue;
            return arg;
        }
        return null;
    }

    public String toString() {
        String sep = "=============================";
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Class<? extends XField>, CollectionTable<XFlattenedColumn>> entry : this.tables.entrySet()) {
            String title = entry.getKey().getAnnotation(XmlType.class).name().replaceAll("^x_", "").replaceAll("_", " ") + "s";
            sb.append(title).append("\n").append(sep).append("\n").append(entry.getValue()).append("\n");
        }
        String sep1 = "";
        if (!this.chainNames.isEmpty()) {
            sb.append("Accessible Join Chains\n").append(sep).append("\n");
            for (String chain : this.chainNames) {
                sb.append(sep1).append(chain);
                sep1 = "\n";
            }
        }
        sep1 = "";
        if (!this.tableNames.isEmpty()) {
            sb.append("Accessible Tables\n").append(sep).append("\n");
            for (String table : this.tableNames) {
                sb.append(sep1).append(table);
                sep1 = "\n";
            }
        }
        return sb.toString();
    }
}

