/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.cli.table;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.lens.api.metastore.XDimAttribute;
import org.apache.lens.api.metastore.XExprColumn;
import org.apache.lens.api.metastore.XExprSpec;
import org.apache.lens.api.metastore.XField;
import org.apache.lens.api.metastore.XFlattenedColumn;
import org.apache.lens.api.metastore.XMeasure;
import org.apache.lens.cli.table.CollectionTable;
import org.apache.lens.cli.table.XFlattenedColumnTable;

public class CollectionTableFactory {
    private CollectionTableFactory() {
    }

    public static CollectionTable<XFlattenedColumn> getCollectionTable(Class<? extends XField> claz, final String table) {
        if (claz == XExprColumn.class) {
            return new CollectionTable<XFlattenedColumn>(Sets.newTreeSet((Comparator)new Comparator<XFlattenedColumn>(){

                @Override
                public int compare(XFlattenedColumn o1, XFlattenedColumn o2) {
                    return o1.getExpression().getName().compareTo(o2.getExpression().getName());
                }
            }), new CollectionTable.RowProvider<XFlattenedColumn>(){

                @Override
                public String[][] getRows(XFlattenedColumn element) {
                    return new String[][]{{CollectionTableFactory.nulltoBlank(element.getExpression().getName()), CollectionTableFactory.nulltoBlank(element.getExpression().getDisplayString()), CollectionTableFactory.nulltoBlank(element.getExpression().getDescription()), this.expressionsAsString(element.getExpression().getExprSpec())}};
                }

                private String expressionsAsString(List<XExprSpec> exprSpec) {
                    StringBuilder sb = new StringBuilder();
                    String sep = "";
                    for (XExprSpec spec : exprSpec) {
                        sb.append(sep);
                        sep = ", ";
                        ArrayList clauses = Lists.newArrayList();
                        if (spec.getStartTime() != null) {
                            clauses.add("after " + spec.getStartTime());
                        }
                        if (spec.getEndTime() != null) {
                            clauses.add("before " + spec.getEndTime());
                        }
                        String sep1 = "";
                        if (clauses.isEmpty()) {
                            clauses.add("always valid");
                        }
                        for (String clause : clauses) {
                            sb.append(sep1).append(clause);
                            sep1 = " and ";
                        }
                        sb.append(": ");
                        sb.append(spec.getExpr());
                    }
                    return sb.toString();
                }
            }, "Name", "Display String", "Description", "Expr Specs");
        }
        if (claz == XDimAttribute.class) {
            return new CollectionTable<XFlattenedColumn>(Sets.newTreeSet((Comparator)new Comparator<XFlattenedColumn>(){

                @Override
                public int compare(XFlattenedColumn o1, XFlattenedColumn o2) {
                    int cmp;
                    if (o1 == null || o1.getDimAttribute() == null) {
                        return -1;
                    }
                    if (o2 == null || o2.getDimAttribute() == null) {
                        return 1;
                    }
                    if (table.equals(o1.getTableName()) && !table.equals(o2.getTableName())) {
                        return -1;
                    }
                    if (table.equals(o2.getTableName()) && !table.equals(o1.getTableName())) {
                        return 1;
                    }
                    if (o1.getTableName() == null) {
                        o1.setTableName("");
                    }
                    if (o2.getTableName() == null) {
                        o2.setTableName("");
                    }
                    if (o1.getChainName() == null) {
                        o1.setChainName("");
                    }
                    if (o2.getChainName() == null) {
                        o2.setChainName("");
                    }
                    if ((cmp = o1.getTableName().compareTo(o2.getTableName())) != 0) {
                        return cmp;
                    }
                    cmp = o1.getChainName().compareTo(o2.getChainName());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return o1.getDimAttribute().getName().compareTo(o2.getDimAttribute().getName());
                }
            }), new CollectionTable.RowProvider<XFlattenedColumn>(){

                @Override
                public String[][] getRows(XFlattenedColumn element) {
                    String prefix = XFlattenedColumnTable.firstNonNull(element.getChainName(), element.getTableName());
                    return new String[][]{{(prefix == null || prefix.isEmpty() || prefix.equalsIgnoreCase(table) ? "" : prefix + ".") + CollectionTableFactory.nulltoBlank(element.getDimAttribute().getName()), CollectionTableFactory.nulltoBlank(element.getDimAttribute().getDisplayString()), CollectionTableFactory.nulltoBlank(element.getDimAttribute().getDescription())}};
                }
            }, "Name", "Display String", "Description");
        }
        if (claz == XMeasure.class) {
            return new CollectionTable<XFlattenedColumn>(Sets.newTreeSet((Comparator)new Comparator<XFlattenedColumn>(){

                @Override
                public int compare(XFlattenedColumn o1, XFlattenedColumn o2) {
                    return o1.getMeasure().getName().compareTo(o2.getMeasure().getName());
                }
            }), new CollectionTable.RowProvider<XFlattenedColumn>(){

                @Override
                public String[][] getRows(XFlattenedColumn element) {
                    return new String[][]{{CollectionTableFactory.nulltoBlank(element.getMeasure().getName()), CollectionTableFactory.nulltoBlank(element.getMeasure().getDisplayString()), CollectionTableFactory.nulltoBlank(element.getMeasure().getDescription())}};
                }
            }, "Name", "Display String", "Description");
        }
        return null;
    }

    public static String nulltoBlank(String s) {
        return s == null ? "" : s;
    }
}

