/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.cli.table;

import java.util.Arrays;
import java.util.Collection;
import org.springframework.shell.support.table.Table;
import org.springframework.shell.support.table.TableHeader;
import org.springframework.shell.support.table.TableRenderer;

public class CollectionTable<T> {
    private final Collection<T> collection;
    private final RowProvider<T> provider;
    private final String[] header;

    public CollectionTable(Collection<T> collection, RowProvider<T> provider, String ... header) {
        this.collection = collection;
        this.provider = provider;
        this.header = header;
    }

    public String toString() {
        Table table = new Table();
        for (int i = 0; i < this.header.length; ++i) {
            table.addHeader(Integer.valueOf(i + 1), new TableHeader(this.header[i]));
        }
        for (T element : this.collection) {
            for (String[] row : this.provider.getRows(element)) {
                table.addRow(row);
            }
        }
        return TableRenderer.renderTextTable((Table)table);
    }

    public Collection<T> getCollection() {
        return this.collection;
    }

    public RowProvider<T> getProvider() {
        return this.provider;
    }

    public String[] getHeader() {
        return this.header;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CollectionTable)) {
            return false;
        }
        CollectionTable other = (CollectionTable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Collection<T> this$collection = this.getCollection();
        Collection<T> other$collection = other.getCollection();
        if (this$collection == null ? other$collection != null : !((Object)this$collection).equals(other$collection)) {
            return false;
        }
        RowProvider<T> this$provider = this.getProvider();
        RowProvider<T> other$provider = other.getProvider();
        if (this$provider == null ? other$provider != null : !this$provider.equals(other$provider)) {
            return false;
        }
        return Arrays.deepEquals(this.getHeader(), other.getHeader());
    }

    protected boolean canEqual(Object other) {
        return other instanceof CollectionTable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Collection<T> $collection = this.getCollection();
        result = result * 59 + ($collection == null ? 43 : ((Object)$collection).hashCode());
        RowProvider<T> $provider = this.getProvider();
        result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getHeader());
        return result;
    }

    static interface RowProvider<T> {
        public String[][] getRows(T var1);
    }
}

