/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.cli.commands;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.lens.api.APIResult;
import org.apache.lens.api.metastore.XPartition;
import org.apache.lens.api.metastore.XStorageTableElement;
import org.apache.lens.cli.commands.LensCRUDCommand;
import org.codehaus.jackson.PrettyPrinter;

public abstract class LogicalTableCrudCommand<T>
extends LensCRUDCommand<T> {
    public String showAll(String filter) {
        List<String> all = this.getAll(filter);
        if (all == null || all.isEmpty()) {
            return "No " + this.getSingleObjectName() + " found" + (filter == null ? "" : " for " + filter);
        }
        return Joiner.on((String)"\n").join(all);
    }

    public String showAllStorages(String tableName) {
        String ret;
        String sep = "";
        StringBuilder sb = new StringBuilder();
        List<String> storages = this.getAllStorages(tableName);
        if (storages != null) {
            for (String storage : storages) {
                if (storage.isEmpty()) continue;
                sb.append(sep).append(storage);
                sep = "\n";
            }
        }
        return (ret = sb.toString()).isEmpty() ? "No storage found for " + tableName : ret;
    }

    public String addStorage(String tableName, File path) {
        return this.doAddStorage(tableName, this.getValidPath(path, false, true)).toString().toLowerCase();
    }

    public String getStorage(String tableName, String storage) {
        try {
            return this.formatJson(this.mapper.writer((PrettyPrinter)this.pp).writeValueAsString((Object)this.readStorage(tableName, storage)));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String dropStorage(String tableName, String storageName) {
        return this.doDropStorage(tableName, storageName).toString().toLowerCase();
    }

    public String dropAllStorages(String tableName) {
        return this.doDropAllStorages(tableName).toString();
    }

    public String getAllPartitions(String tableName, String storageName, String filter) {
        try {
            return this.formatJson(this.mapper.writer((PrettyPrinter)this.pp).writeValueAsString(this.readAllPartitions(tableName, storageName, filter)));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String addPartition(String tableName, String storageName, File path) {
        return this.doAddPartition(tableName, storageName, this.getValidPath(path, false, true)).toString().toLowerCase();
    }

    public String updatePartition(String tableName, String storageName, File path) {
        return this.doUpdatePartition(tableName, storageName, this.getValidPath(path, false, true)).toString().toLowerCase();
    }

    public String addPartitions(String tableName, String storageName, String path) {
        return this.doAddPartitions(tableName, storageName, this.getValidPath(new File(path), false, true)).toString().toLowerCase();
    }

    public String updatePartitions(String tableName, String storageName, String path) {
        return this.doUpdatePartitions(tableName, storageName, this.getValidPath(new File(path), false, true)).toString().toLowerCase();
    }

    public String dropPartitions(String tableName, String storageName, String filter) {
        return this.doDropPartitions(tableName, storageName, filter).toString().toLowerCase();
    }

    protected abstract List<String> getAll(String var1);

    public abstract List<String> getAllStorages(String var1);

    public abstract APIResult doAddStorage(String var1, String var2);

    protected abstract XStorageTableElement readStorage(String var1, String var2);

    public abstract APIResult doDropStorage(String var1, String var2);

    public abstract APIResult doDropAllStorages(String var1);

    protected abstract List<XPartition> readAllPartitions(String var1, String var2, String var3);

    protected abstract APIResult doAddPartition(String var1, String var2, String var3);

    protected abstract APIResult doAddPartitions(String var1, String var2, String var3);

    protected abstract APIResult doDropPartitions(String var1, String var2, String var3);

    protected abstract APIResult doUpdatePartition(String var1, String var2, String var3);

    protected abstract APIResult doUpdatePartitions(String var1, String var2, String var3);
}

