/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.cli.commands;

import java.io.File;
import java.util.List;
import lombok.NonNull;
import org.apache.lens.api.APIResult;
import org.apache.lens.api.metastore.XDimensionTable;
import org.apache.lens.api.metastore.XPartition;
import org.apache.lens.api.metastore.XStorageTableElement;
import org.apache.lens.cli.commands.LogicalTableCrudCommand;
import org.apache.lens.cli.commands.annotations.UserDocumentation;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
@UserDocumentation(title="Commands for Dimension Tables Management", description="These commands provide CRUD for dimension tables, associated storages, and fact partitions")
public class LensDimensionTableCommands
extends LogicalTableCrudCommand<XDimensionTable>
implements CommandMarker {
    @CliCommand(value={"show dimtables"}, help="display list of dimtables in current database. If optional <dimension_name> is supplied, only facts belonging to dimension <dimension_name> will be displayed")
    public String showDimensionTables(@CliOption(key={"", "dimension_name"}, mandatory=false, help="<dimension_name>") String dimensionName) {
        return this.showAll(dimensionName);
    }

    @CliCommand(value={"create dimtable"}, help="Create a new dimension table taking spec from <path-to-dimtable-spec-file>")
    public String createDimensionTable(@CliOption(key={"", "path"}, mandatory=true, help="<path-to-dimtable-spec-file>") @NonNull File path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        return this.create(path, false);
    }

    @CliCommand(value={"describe dimtable"}, help="describe dimtable <dimtable_name>")
    public String describeDimensionTable(@CliOption(key={"", "dimtable_name"}, mandatory=true, help="<dimtable_name>") String name) {
        return this.describe(name);
    }

    @CliCommand(value={"update dimtable"}, help="update dimtable <dimtable_name> taking spec from <path-to-dimtable-spec>")
    public String updateDimensionTable(@CliOption(key={"", "dimtable_name"}, mandatory=true, help="<dimtable_name>") String name, @CliOption(key={"", "path"}, mandatory=true, help="<path-to-dimtable-spec>") @NonNull File path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        return this.update(name, path);
    }

    @CliCommand(value={"drop dimtable"}, help="drop dimtable <dimtable_name>.  If <cascade> is true, all the storage tables associated with the dimtable <dimtable_name> are also dropped. By default <cascade> is false")
    public String dropDimensionTable(@CliOption(key={"", "dimtable_name"}, mandatory=true, help="<dimtable_name>") String name, @CliOption(key={"cascade"}, mandatory=false, unspecifiedDefaultValue="false", help="<cascade>") boolean cascade) {
        return this.drop(name, cascade);
    }

    @CliCommand(value={"dimtable list storages"}, help="display list of storage associated to dimtable <dimtable_name>")
    public String getDimStorages(@CliOption(key={"", "dimtable_name"}, mandatory=true, help="<dimtable_name>") String table) {
        return this.showAllStorages(table);
    }

    @CliCommand(value={"dimtable add storage"}, help="adds a new storage to dimtable <dimtable_name>, taking storage spec from <path-to-storage-spec>")
    public String addNewDimStorage(@CliOption(key={"", "dimtable_name"}, mandatory=true, help="<dimtable_name>") String tableName, @CliOption(key={"", "path"}, mandatory=true, help="<path-to-storage-spec>") @NonNull File path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        return this.addStorage(tableName, path);
    }

    @CliCommand(value={"dimtable get storage"}, help="describe storage <storage_name> of dimtable <dimtable_name>")
    public String getStorageFromDim(@CliOption(key={"", "dimtable_name"}, mandatory=true, help="<dimtable_name>") String tableName, @CliOption(key={"", "storage_name"}, mandatory=true, help="<storage_name>") String storage) {
        return this.getStorage(tableName, storage);
    }

    @CliCommand(value={"dimtable drop storage"}, help="drop storage <storage_name> from dimtable <dimtable_name>")
    public String dropStorageFromDim(@CliOption(key={"", "dimtable_name"}, mandatory=true, help="<dimtable_name>") String tableName, @CliOption(key={"", "storage_name"}, mandatory=true, help="<storage_name>") String storageName) {
        return this.dropStorage(tableName, storageName);
    }

    @CliCommand(value={"dimtable drop all storages"}, help="drop all storages associated to dimension table")
    public String dropAllDimStorages(@CliOption(key={"", "dimtable_name"}, mandatory=true, help="<dimtable_name>") String tableName) {
        return this.dropAllStorages(tableName);
    }

    @CliCommand(value={"dimtable list partitions"}, help="get all partitions associated with dimtable <dimtable_name>, storage <storage_name> filtered by <partition-filter>")
    public String getAllPartitionsOfDimtable(@CliOption(key={"", "dimtable_name"}, mandatory=true, help="<dimtable_name>") String tableName, @CliOption(key={"", "storage_name"}, mandatory=true, help="<storage_name>") String storageName, @CliOption(key={"", "filter"}, mandatory=false, help="<partition-filter>") String filter) {
        return this.getAllPartitions(tableName, storageName, filter);
    }

    @CliCommand(value={"dimtable drop partitions"}, help="drop all partitions associated with dimtable <dimtable_name>, storage <storage_name> filtered by <partition-filter>")
    public String dropAllPartitionsOfDim(@CliOption(key={"", "dimtable_name"}, mandatory=true, help="<dimtable_name>") String tableName, @CliOption(key={"", "storage_name"}, mandatory=true, help="<storage_name>") String storageName, @CliOption(key={"", "filter"}, mandatory=false, help="<partition-filter>") String filter) {
        return this.dropPartitions(tableName, storageName, filter);
    }

    @CliCommand(value={"dimtable add single-partition"}, help="add single partition to dimtable <dimtable_name>'s storage <storage_name>, reading spec from <partition-spec-path>")
    public String addPartitionToDimtable(@CliOption(key={"", "dimtable_name"}, mandatory=true, help="<dimtable_name>") String tableName, @CliOption(key={"", "storage_name"}, mandatory=true, help="<storage_name>") String storageName, @CliOption(key={"", "path"}, mandatory=true, help="<partition-spec-path>") @NonNull File path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        return this.addPartition(tableName, storageName, path);
    }

    @CliCommand(value={"dimtable update single-partition"}, help="update single partition to dimtable <dimtable_name>'s storage <storage_name>, reading spec from <partition-spec-path> The partition has to exist to be eligible for updation.")
    public String updatePartitionOfDimtable(@CliOption(key={"", "dimtable_name"}, mandatory=true, help="<dimtable_name>") String tableName, @CliOption(key={"", "storage_name"}, mandatory=true, help="<storage_name>") String storageName, @CliOption(key={"", "path"}, mandatory=true, help="<partition-spec-path>") @NonNull File path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        return this.updatePartition(tableName, storageName, path);
    }

    @CliCommand(value={"dimtable add partitions"}, help="add multiple partition to dimtable <dimtable_name>'s storage <storage_name>, reading partition list spec from <partition-list-spec-path>")
    public String addPartitionsToDimtable(@CliOption(key={"", "dimtable_name"}, mandatory=true, help="<dimtable_name>") String tableName, @CliOption(key={"", "storage_name"}, mandatory=true, help="<storage_name>") String storageName, @CliOption(key={"", "path"}, mandatory=true, help="<partition-list-spec-path>") @NonNull File path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        return this.addPartitions(tableName, storageName, path.getPath());
    }

    @CliCommand(value={"dimtable update partitions"}, help="update multiple partition to dimtable <dimtable_name>'s storage <storage_name>, reading partition list spec from <partition-list-spec-path> The partitions have to exist to be eligible for updation.")
    public String updatePartitionsOfDimtable(@CliOption(key={"", "dimtable_name"}, mandatory=true, help="<dimtable_name>") String tableName, @CliOption(key={"", "storage_name"}, mandatory=true, help="<storage_name>") String storageName, @CliOption(key={"", "path"}, mandatory=true, help="<partition-list-spec-path>") String path) {
        return this.updatePartitions(tableName, storageName, path);
    }

    @Override
    protected XStorageTableElement readStorage(String tableName, String storage) {
        return this.getClient().getStorageFromDim(tableName, storage);
    }

    @Override
    public APIResult doDropStorage(String tableName, String storageName) {
        return this.getClient().dropStorageFromDim(tableName, storageName);
    }

    @Override
    public List<String> getAllStorages(String name) {
        return this.getClient().getDimStorages(name);
    }

    @Override
    public APIResult doAddStorage(String name, String path) {
        return this.getClient().addStorageToDim(name, path);
    }

    @Override
    public APIResult doDropAllStorages(String name) {
        return this.getClient().dropAllStoragesOfDim(name);
    }

    @Override
    protected List<XPartition> readAllPartitions(String tableName, String storageName, String filter) {
        return this.getClient().getAllPartitionsOfDim(tableName, storageName, filter);
    }

    @Override
    protected APIResult doAddPartition(String tableName, String storageName, String path) {
        return this.getClient().addPartitionToDim(tableName, storageName, path);
    }

    @Override
    protected APIResult doAddPartitions(String tableName, String storageName, String path) {
        return this.getClient().addPartitionsToDim(tableName, storageName, path);
    }

    @Override
    protected APIResult doDropPartitions(String tableName, String storageName, String filter) {
        return this.getClient().dropAllPartitionsOfDim(tableName, storageName, filter);
    }

    @Override
    protected APIResult doUpdatePartition(String tableName, String storageName, String validPath) {
        return this.getClient().updatePartitionOfDim(tableName, storageName, validPath);
    }

    @Override
    protected APIResult doUpdatePartitions(String tableName, String storageName, String validPath) {
        return this.getClient().updatePartitionsOfDim(tableName, storageName, validPath);
    }

    @Override
    public List<String> getAll() {
        return this.getClient().getAllDimensionTables();
    }

    @Override
    public List<String> getAll(String dimesionName) {
        return this.getClient().getAllDimensionTables(dimesionName);
    }

    @Override
    protected APIResult doCreate(String path, boolean ignoreIfExists) {
        return this.getClient().createDimensionTable(path);
    }

    @Override
    protected XDimensionTable doRead(String name) {
        return this.getClient().getDimensionTable(name);
    }

    @Override
    public APIResult doUpdate(String name, String path) {
        return this.getClient().updateDimensionTable(name, path);
    }

    @Override
    protected APIResult doDelete(String name, boolean cascade) {
        return this.getClient().dropDimensionTable(name, cascade);
    }
}

