/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.cli.commands;

import java.io.File;
import java.io.IOException;
import java.util.List;
import lombok.NonNull;
import org.apache.lens.api.APIResult;
import org.apache.lens.api.metastore.XDimension;
import org.apache.lens.cli.commands.ConceptualTableCrudCommand;
import org.apache.lens.cli.commands.annotations.UserDocumentation;
import org.codehaus.jackson.PrettyPrinter;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
@UserDocumentation(title="Commands for Dimension Management", description="These commands provide CRUD for Dimensions")
public class LensDimensionCommands
extends ConceptualTableCrudCommand<XDimension> {
    @CliCommand(value={"show dimensions"}, help="show list of all dimensions in current database")
    public String showDimensions() {
        return this.showAll();
    }

    @CliCommand(value={"create dimension"}, help="Create a new Dimension, taking spec from <path-to-dimension-spec file>")
    public String createDimension(@CliOption(key={"", "path"}, mandatory=true, help="<path-to-dimension-spec file>") @NonNull File path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        return this.create(path, false);
    }

    @CliCommand(value={"describe dimension"}, help="describe dimension <dimension_name>")
    public String describeDimension(@CliOption(key={"", "name"}, mandatory=true, help="<dimension_name>") String name) {
        try {
            return this.formatJson(this.mapper.writer((PrettyPrinter)this.pp).writeValueAsString((Object)this.getClient().getDimension(name)));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @CliCommand(value={"update dimension"}, help="update dimension <dimension_name>, taking spec from <path-to-dimension-spec file>")
    public String updateDimension(@CliOption(key={"", "name"}, mandatory=true, help="<dimension_name>") String name, @CliOption(key={"", "path"}, mandatory=true, help="<path-to-dimension-spec-file>") @NonNull File path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        return this.update(name, path);
    }

    @CliCommand(value={"drop dimension"}, help="drop dimension <dimension_name>")
    public String dropDimension(@CliOption(key={"", "name"}, mandatory=true, help="<dimension_name>") String name) {
        return this.drop(name, false);
    }

    @CliCommand(value={"dimension show fields"}, help="Show queryable fields of the given dimension <dimension_name>. Optionally specify <flattened> to include chained fields")
    public String showQueryableFields(@CliOption(key={"", "name"}, mandatory=true, help="<dimension_name>") String table, @CliOption(key={"flattened"}, mandatory=false, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="<flattened>") boolean flattened) {
        return this.getAllFields(table, flattened);
    }

    @CliCommand(value={"dimension show joinchains"}, help="Show joinchains of the given dimension <dimension_name>. ")
    public String showJoinChains(@CliOption(key={"", "name"}, mandatory=true, help="<dimension_name>") String table) {
        return this.getAllJoinChains(table);
    }

    @Override
    public List<String> getAll() {
        return this.getClient().getAllDimensions();
    }

    @Override
    protected APIResult doCreate(String path, boolean ignoreIfExists) {
        return this.getClient().createDimension(path);
    }

    @Override
    protected XDimension doRead(String name) {
        return this.getClient().getDimension(name);
    }

    @Override
    public APIResult doUpdate(String name, String path) {
        return this.getClient().updateDimension(name, path);
    }

    @Override
    protected APIResult doDelete(String name, boolean cascade) {
        return this.getClient().dropDimension(name);
    }
}

