/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.cli.commands;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import com.google.common.base.Joiner;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.ProcessingException;
import lombok.NonNull;
import org.apache.lens.api.APIResult;
import org.apache.lens.api.LensSessionHandle;
import org.apache.lens.cli.commands.BaseLensCommand;
import org.apache.lens.cli.commands.annotations.UserDocumentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.shell.core.ExitShellRequest;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
@UserDocumentation(title="Commands for Session Management", description="Opening the lens CLI shell is equivalent to open a session with lens server.This section provides all the commands available for in shell which are applicable for the full session.")
public class LensConnectionCommands
extends BaseLensCommand {
    private static final Logger log = LoggerFactory.getLogger(LensConnectionCommands.class);

    @CliCommand(value={"set"}, help="Assign <value> to session parameter specified with <key> on lens server")
    public String setParam(@CliOption(key={""}, mandatory=true, help="<key>=<value>") String keyval) {
        String[] pair = keyval.split("=");
        if (pair.length != 2) {
            return "Error: Pass parameter as <key>=<value>";
        }
        APIResult result = this.getClient().setConnectionParam(pair[0], pair[1]);
        return result.getMessage();
    }

    @CliCommand(value={"get"}, help="Fetches and prints session parameter specified with name <key> from lens server")
    public String getParam(@CliOption(key={"", "key"}, mandatory=true, help="<key>") String param) {
        return Joiner.on((String)"\n").skipNulls().join((Iterable)this.getClient().getConnectionParam(param));
    }

    @CliCommand(value={"show params"}, help="Fetches and prints all session parameter from lens server")
    public String showParameters() {
        List params = this.getClient().getConnectionParam();
        return Joiner.on((String)"\n").skipNulls().join((Iterable)params);
    }

    @CliCommand(value={"add jar"}, help="Adds jar resource to the session")
    public String addJar(@CliOption(key={"", "path"}, mandatory=true, help="<path-to-jar-on-server-side>") @NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        APIResult result = this.getClient().addJarResource(path);
        return result.getMessage();
    }

    @CliCommand(value={"remove jar"}, help="Removes a jar resource from session")
    public String removeJar(@CliOption(key={"", "path"}, mandatory=true, help="<path-to-jar-on-server-side>") @NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        APIResult result = this.getClient().removeJarResource(path);
        return result.getMessage();
    }

    @CliCommand(value={"add file"}, help="Adds a file resource to session")
    public String addFile(@CliOption(key={"", "path"}, mandatory=true, help="<path-to-file-on-server-side>") @NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        APIResult result = this.getClient().addFileResource(path);
        return result.getMessage();
    }

    @CliCommand(value={"remove file"}, help="removes a file resource from session")
    public String removeFile(@CliOption(key={"", "path"}, mandatory=true, help="<path-to-file-on-server-side>") @NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        APIResult result = this.getClient().removeFileResource(path);
        return result.getMessage();
    }

    @CliCommand(value={"list resources"}, help="list all resources from session. If type is provided,  lists resources of type <resource-type>. Valid values for type are jar and file.")
    public String listResources(@CliOption(key={"", "type"}, mandatory=false, help="<resource-type>") String type) {
        List resources = this.getClient().listResources(type);
        if (resources == null) {
            return "No resources found";
        }
        return Joiner.on((String)"\n").skipNulls().join((Iterable)resources);
    }

    @CliCommand(value={"session"}, help="Print the current session handle")
    public String getSessionHandle() {
        LensSessionHandle sessionHandle = this.getClient().getConnection().getSessionHandle();
        if (sessionHandle != null) {
            return "Session Handle: " + sessionHandle.getPublicId();
        }
        return "Session not established";
    }

    @CliCommand(value={"debug"}, help="prints all class level logs and verbose logs on cli for debugging purpose. 'debug false' to turn off all class level logging and verbose level logging ")
    public void debug(@CliOption(key={"", "enable"}, mandatory=false, unspecifiedDefaultValue="true") boolean enable) {
        ch.qos.logback.classic.Logger logger = LoggerUtil.getRootLogger();
        ch.qos.logback.classic.Logger cliLogger = LoggerUtil.getCliLogger();
        if (enable) {
            LoggerUtil.addConsoleAppenderIfNotPresent(logger);
            LoggerUtil.addConsoleAppenderIfNotPresent(cliLogger);
        } else {
            LoggerUtil.removeConsoleAppender(logger);
            LoggerUtil.removeConsoleAppender(cliLogger);
        }
    }

    @CliCommand(value={"verbose"}, help="Show cliLogger logs on cli. 'verbose false'  turns off the cliLogger logs on console")
    public void verbose(@CliOption(key={"", "enable"}, mandatory=false, unspecifiedDefaultValue="true") boolean enable) {
        ch.qos.logback.classic.Logger cliLogger = LoggerUtil.getCliLogger();
        if (enable) {
            LoggerUtil.addConsoleAppenderIfNotPresent(cliLogger);
        } else {
            LoggerUtil.removeConsoleAppender(cliLogger);
        }
    }

    @CliCommand(value={"close", "bye"}, help="Releases all resources of the server session and exits the shell")
    public ExitShellRequest quitShell() {
        try {
            LensConnectionCommands.closeClientConnection();
            return ExitShellRequest.NORMAL_EXIT;
        }
        catch (ProcessingException e) {
            log.error("Error while closing client connection.", (Throwable)e);
            return ExitShellRequest.FATAL_EXIT;
        }
    }

    private static class LoggerUtil {
        private static ch.qos.logback.classic.Logger logger;
        private static ch.qos.logback.classic.Logger cliLogger;

        private LoggerUtil() {
        }

        public static ch.qos.logback.classic.Logger getRootLogger() {
            if (logger == null) {
                logger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
            }
            return logger;
        }

        public static ch.qos.logback.classic.Logger getCliLogger() {
            if (cliLogger == null) {
                cliLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"cliLogger");
            }
            return cliLogger;
        }

        public static ConsoleAppender<ILoggingEvent> getConsoleAppender(PatternLayout layout, Context context) {
            ConsoleAppender consoleAppender = new ConsoleAppender();
            consoleAppender.setContext(context);
            consoleAppender.setLayout((Layout)layout);
            consoleAppender.start();
            return consoleAppender;
        }

        public static PatternLayout getPatternLayout(LoggerContext context) {
            String conversionPattern = "%d [%t] %F %-7p - %m%n";
            return LoggerUtil.getPatternLayout(conversionPattern, (Context)context);
        }

        public static PatternLayout getPatternLayout(String conversionPattern, Context context) {
            PatternLayout layout = new PatternLayout();
            layout.setPattern(conversionPattern);
            layout.setContext(context);
            layout.start();
            return layout;
        }

        public static void addConsoleAppenderIfNotPresent(ch.qos.logback.classic.Logger logger) {
            boolean isConsoleAppenderAdded = false;
            PatternLayout layout = null;
            Iterator appenderSeries = logger.iteratorForAppenders();
            while (appenderSeries.hasNext()) {
                Appender appender = (Appender)appenderSeries.next();
                if (!(appender instanceof ConsoleAppender)) continue;
                isConsoleAppenderAdded = true;
                break;
            }
            if (!isConsoleAppenderAdded) {
                if (layout == null) {
                    layout = LoggerUtil.getPatternLayout(logger.getLoggerContext());
                }
                if (logger.getLevel() == null) {
                    logger.setLevel(Level.DEBUG);
                }
                ConsoleAppender<ILoggingEvent> consoleAppender = LoggerUtil.getConsoleAppender(layout, (Context)logger.getLoggerContext());
                logger.addAppender(consoleAppender);
            }
        }

        public static void removeConsoleAppender(ch.qos.logback.classic.Logger logger) {
            Iterator appenderSeries = logger.iteratorForAppenders();
            while (appenderSeries.hasNext()) {
                Appender appender = (Appender)appenderSeries.next();
                if (!(appender instanceof ConsoleAppender)) continue;
                logger.detachAppender(appender);
            }
        }
    }
}

