/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.cli.commands;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.lens.api.APIResult;
import org.apache.lens.cli.commands.BaseLensCommand;
import org.codehaus.jackson.PrettyPrinter;

public abstract class LensCRUDCommand<T>
extends BaseLensCommand {
    public String showAll() {
        List<String> all = this.getAll();
        if (all == null || all.isEmpty()) {
            return "No " + this.getSingleObjectName() + " found";
        }
        return Joiner.on((String)"\n").join(all);
    }

    public String create(File path, boolean ignoreIfExists) {
        return this.doCreate(this.getValidPath(path, false, true), ignoreIfExists).getStatus().toString().toLowerCase();
    }

    public String describe(String name) {
        try {
            return this.formatJson(this.mapper.writer((PrettyPrinter)this.pp).writeValueAsString(this.doRead(name)));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String update(String entity, File path) {
        return this.doUpdate(entity, this.getValidPath(path, false, true)).getStatus().toString().toLowerCase();
    }

    public String drop(String name, boolean cascade) {
        return this.doDelete(name, cascade).getStatus().toString().toLowerCase();
    }

    public String getSingleObjectName() {
        return this.getClass().getSimpleName().substring(4, this.getClass().getSimpleName().indexOf("Command")).toLowerCase();
    }

    public abstract List<String> getAll();

    protected abstract APIResult doCreate(String var1, boolean var2);

    protected abstract T doRead(String var1);

    public abstract APIResult doUpdate(String var1, String var2);

    protected abstract APIResult doDelete(String var1, boolean var2);
}

