/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.cli.commands;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.lens.api.util.PathValidator;
import org.apache.lens.client.LensClient;
import org.apache.lens.client.LensClientSingletonWrapper;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.impl.Indenter;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.util.DefaultPrettyPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.shell.core.ExecutionProcessor;
import org.springframework.shell.event.ParseResult;

public class BaseLensCommand
implements ExecutionProcessor {
    private static final Logger log = LoggerFactory.getLogger(BaseLensCommand.class);
    protected ObjectMapper mapper = new ObjectMapper();
    protected DefaultPrettyPrinter pp;
    protected static boolean isConnectionActive;
    public static final String DATE_FMT = "yyyy-MM-dd'T'HH:mm:ss:SSS";
    private LensClient lensClient = null;
    public static final ThreadLocal<DateFormat> DATE_PARSER;

    public static String formatDate(Date dt) {
        return DATE_PARSER.get().format(dt);
    }

    protected static synchronized void closeClientConnection() {
        if (isConnectionActive) {
            log.debug("Request for stopping lens cli received");
            BaseLensCommand.getClientWrapper().getClient().closeConnection();
            isConnectionActive = false;
        }
    }

    public BaseLensCommand() {
        this.mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        this.mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_DEFAULT);
        this.pp = new DefaultPrettyPrinter();
        this.pp.indentObjectsWith(new Indenter(){

            public void writeIndentation(JsonGenerator jg, int level) throws IOException, JsonGenerationException {
                if (level > 2) {
                    jg.writeRaw("  ");
                } else {
                    jg.writeRaw("\n");
                }
            }

            public boolean isInline() {
                return false;
            }
        });
    }

    public void setClient(LensClient client) {
        this.lensClient = client;
    }

    public LensClient getClient() {
        if (this.lensClient == null) {
            this.setClient(BaseLensCommand.getClientWrapper().getClient());
            isConnectionActive = true;
        }
        return this.lensClient;
    }

    public static LensClientSingletonWrapper getClientWrapper() {
        return LensClientSingletonWrapper.instance();
    }

    public String formatJson(String json) {
        return json.replaceAll("\\[ \\{", "\n\n ").replaceAll("\\{", "").replaceAll("}", "").replaceAll("\\[", "").replaceAll("]", "\n").replaceAll(",", "").replaceAll("\"", "").replaceAll("\n\n", "\n");
    }

    public ParseResult beforeInvocation(ParseResult parseResult) {
        Object[] args = parseResult.getArguments();
        if (args != null && Sets.newHashSet((Object[])args).size() == 1 && args[0] instanceof String) {
            String[] split = ((String)args[0]).split("\\s+");
            Object[] newArgs = new String[args.length];
            System.arraycopy(split, 0, newArgs, 0, split.length);
            parseResult = new ParseResult(parseResult.getMethod(), parseResult.getInstance(), newArgs);
        }
        return parseResult;
    }

    public void afterReturningInvocation(ParseResult parseResult, Object o) {
    }

    public void afterThrowingInvocation(ParseResult parseResult, Throwable throwable) {
    }

    public String getValidPath(File path, boolean shouldBeDirectory, boolean shouldExist) {
        PathValidator pathValidator = this.getClient().getPathValidator();
        return pathValidator.getValidPath(path, shouldBeDirectory, shouldExist);
    }

    public String removePrefixBeforeURI(String path) {
        PathValidator pathValidator = this.getClient().getPathValidator();
        return pathValidator.removePrefixBeforeURI(path);
    }

    public String getOrDefaultQueryHandleString(String queryHandleString) {
        if (queryHandleString != null) {
            return queryHandleString;
        }
        if (this.getClient().getStatement().getQuery() != null) {
            return this.getClient().getStatement().getQueryHandleString();
        }
        throw new IllegalArgumentException("Query handle not provided and no queries interacted with in the session.");
    }

    static {
        DATE_PARSER = new ThreadLocal<DateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat(BaseLensCommand.DATE_FMT);
            }
        };
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                BaseLensCommand.closeClientConnection();
            }
        });
    }
}

