/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.api.result;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.apache.commons.lang.StringUtils;
import org.apache.lens.api.result.NoErrorPayload;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class LensErrorTO<PAYLOAD>
implements Serializable {
    @XmlElement
    private int code;
    @XmlElement
    private String message;
    @XmlElement
    private String stackTrace;
    @XmlElement
    private PAYLOAD payload;
    @XmlElementWrapper(name="childErrors")
    @XmlElement(name="error")
    private List<LensErrorTO> childErrors;

    public static <PAYLOAD> LensErrorTO<PAYLOAD> composedOf(int code, String message, String stackTrace, PAYLOAD payload, List<LensErrorTO> childErrors) {
        return new LensErrorTO<PAYLOAD>(code, message, stackTrace, payload, childErrors);
    }

    public static <PAYLOAD> LensErrorTO<PAYLOAD> composedOf(int code, String message, String stackTrace, PAYLOAD payload) {
        return new LensErrorTO<PAYLOAD>(code, message, stackTrace, payload, null);
    }

    public static LensErrorTO<NoErrorPayload> composedOf(int code, String message, String stackTrace) {
        return new LensErrorTO<Object>(code, message, stackTrace, null, null);
    }

    public static LensErrorTO<NoErrorPayload> composedOf(int code, String message, String stackTrace, List<LensErrorTO> childErrors) {
        return new LensErrorTO<Object>(code, message, stackTrace, null, childErrors);
    }

    private LensErrorTO(int code, String message, String stackTrace, PAYLOAD errorPayload, List<LensErrorTO> childErrors) {
        Preconditions.checkArgument((code > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)message));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)stackTrace));
        this.code = code;
        this.message = message;
        this.stackTrace = stackTrace;
        this.payload = errorPayload;
        this.childErrors = childErrors;
    }

    public boolean areValidStackTracesPresent() {
        if (StringUtils.isBlank((String)this.stackTrace)) {
            return false;
        }
        if (this.childErrors != null) {
            for (LensErrorTO childError : this.childErrors) {
                if (childError.areValidStackTracesPresent()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LensErrorTO)) {
            return false;
        }
        LensErrorTO other = (LensErrorTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        PAYLOAD this$payload = this.getPayload();
        PAYLOAD other$payload = other.getPayload();
        if (this$payload == null ? other$payload != null : !this$payload.equals(other$payload)) {
            return false;
        }
        List<LensErrorTO> this$childErrors = this.getChildErrors();
        List<LensErrorTO> other$childErrors = other.getChildErrors();
        return !(this$childErrors == null ? other$childErrors != null : !((Object)this$childErrors).equals(other$childErrors));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LensErrorTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        PAYLOAD $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
        List<LensErrorTO> $childErrors = this.getChildErrors();
        result = result * 59 + ($childErrors == null ? 43 : ((Object)$childErrors).hashCode());
        return result;
    }

    public String toString() {
        return "LensErrorTO(code=" + this.getCode() + ", message=" + this.getMessage() + ", stackTrace=" + this.stackTrace + ", payload=" + this.getPayload() + ", childErrors=" + this.getChildErrors() + ")";
    }

    LensErrorTO() {
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public PAYLOAD getPayload() {
        return this.payload;
    }

    public List<LensErrorTO> getChildErrors() {
        return this.childErrors;
    }
}

