/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.api.query.save;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.Validate;
import org.apache.lens.api.query.save.ParameterCollectionType;
import org.apache.lens.api.query.save.ParameterDataType;

@XmlRootElement
public class Parameter {
    private String name;
    private String displayName;
    private String[] defaultValue;
    private ParameterDataType dataType;
    private ParameterCollectionType collectionType;

    public Parameter(String name) {
        this.name = name;
    }

    void afterUnmarshal(Unmarshaller u, Object parent) {
        Validate.notNull((Object)this.name);
        Validate.notNull((Object)this.displayName);
        Validate.notNull((Object)((Object)this.dataType));
        Validate.notNull((Object)((Object)this.collectionType));
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String[] getDefaultValue() {
        return this.defaultValue;
    }

    public ParameterDataType getDataType() {
        return this.dataType;
    }

    public ParameterCollectionType getCollectionType() {
        return this.collectionType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setDefaultValue(String[] defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setDataType(ParameterDataType dataType) {
        this.dataType = dataType;
    }

    public void setCollectionType(ParameterCollectionType collectionType) {
        this.collectionType = collectionType;
    }

    public String toString() {
        return "Parameter(name=" + this.getName() + ", displayName=" + this.getDisplayName() + ", defaultValue=" + Arrays.deepToString(this.getDefaultValue()) + ", dataType=" + (Object)((Object)this.getDataType()) + ", collectionType=" + (Object)((Object)this.getCollectionType()) + ")";
    }

    @ConstructorProperties(value={"name", "displayName", "defaultValue", "dataType", "collectionType"})
    public Parameter(String name, String displayName, String[] defaultValue, ParameterDataType dataType, ParameterCollectionType collectionType) {
        this.name = name;
        this.displayName = displayName;
        this.defaultValue = defaultValue;
        this.dataType = dataType;
        this.collectionType = collectionType;
    }

    public Parameter() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Parameter)) {
            return false;
        }
        Parameter other = (Parameter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getDefaultValue(), other.getDefaultValue())) {
            return false;
        }
        ParameterDataType this$dataType = this.getDataType();
        ParameterDataType other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !((Object)((Object)this$dataType)).equals((Object)other$dataType)) {
            return false;
        }
        ParameterCollectionType this$collectionType = this.getCollectionType();
        ParameterCollectionType other$collectionType = other.getCollectionType();
        return !(this$collectionType == null ? other$collectionType != null : !((Object)((Object)this$collectionType)).equals((Object)other$collectionType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Parameter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getDefaultValue());
        ParameterDataType $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : ((Object)((Object)$dataType)).hashCode());
        ParameterCollectionType $collectionType = this.getCollectionType();
        result = result * 59 + ($collectionType == null ? 43 : ((Object)((Object)$collectionType)).hashCode());
        return result;
    }
}

