/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.api.query;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;
import org.apache.lens.api.query.SubmitOp;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SupportedQuerySubmitOperations
implements Serializable {
    private static final String SEP = ", ";
    @XmlElementWrapper(name="supportedOperations")
    @XmlElement(name="operation")
    private List<String> supportedOps = new LinkedList<String>();

    public SupportedQuerySubmitOperations() {
        ImmutableSet supportedOps = Sets.immutableEnumSet((Enum)SubmitOp.ESTIMATE, (Enum[])new SubmitOp[]{SubmitOp.EXECUTE, SubmitOp.EXPLAIN, SubmitOp.EXECUTE_WITH_TIMEOUT});
        for (SubmitOp supportedOp : supportedOps) {
            this.supportedOps.add(supportedOp.toString().toLowerCase());
        }
    }

    public String getSupportedOperationsAsString() {
        return StringUtils.join(this.supportedOps, (String)SEP);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SupportedQuerySubmitOperations)) {
            return false;
        }
        SupportedQuerySubmitOperations other = (SupportedQuerySubmitOperations)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$supportedOps = this.supportedOps;
        List<String> other$supportedOps = other.supportedOps;
        return !(this$supportedOps == null ? other$supportedOps != null : !((Object)this$supportedOps).equals(other$supportedOps));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SupportedQuerySubmitOperations;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $supportedOps = this.supportedOps;
        result = result * 59 + ($supportedOps == null ? 43 : ((Object)$supportedOps).hashCode());
        return result;
    }

    public String toString() {
        return "SupportedQuerySubmitOperations(supportedOps=" + this.supportedOps + ")";
    }
}

