/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.api.query;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.lens.api.query.QueryResult;
import org.apache.lens.api.query.ResultRow;

@XmlRootElement
public class InMemoryQueryResult
extends QueryResult {
    public static final String DECLARATION = "Result available in memory, attaching here: \n\n";
    @XmlElementWrapper
    private List<ResultRow> rows = new ArrayList<ResultRow>();

    @Override
    public String toPrettyString() {
        StringBuilder b = new StringBuilder();
        b.append(DECLARATION);
        int numRows = 0;
        for (ResultRow row : this.getRows()) {
            for (Object col : row.getValues()) {
                b.append(col).append("\t");
            }
            ++numRows;
            b.append("\n");
        }
        b.append(numRows).append(" rows ");
        return b.toString();
    }

    @ConstructorProperties(value={"rows"})
    public InMemoryQueryResult(List<ResultRow> rows) {
        this.rows = rows;
    }

    protected InMemoryQueryResult() {
    }

    public List<ResultRow> getRows() {
        return this.rows;
    }
}

